/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.jaxb.JAXBBeanInfo;
import org.apache.cxf.common.jaxb.JAXBContextProxy;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XmlSchemaPrimitiveUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.ResponseStatus;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.cxf.jaxrs.model.wadl.ElementQNameResolver;
import org.apache.cxf.jaxrs.model.wadl.ResourceIdGenerator;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WadlGenerator
implements ContainerRequestFilter {
    public static final String WADL_QUERY = "_wadl";
    public static final MediaType WADL_TYPE = JAXRSUtils.toMediaType((String)"application/vnd.sun.wadl+xml");
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    public static final String DEFAULT_WADL_SCHEMA_LOC = "http://www.w3.org/Submission/wadl/wadl.xsd";
    private static final Logger LOG = LogUtils.getL7dLogger(WadlGenerator.class);
    private static final String CONVERT_WADL_RESOURCES_TO_DOM = "convert.wadl.resources.to.dom";
    private static final String XLS_NS = "http://www.w3.org/1999/XSL/Transform";
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String DEFAULT_NS_PREFIX = "prefix";
    private static final Map<ParameterType, Class<? extends Annotation>> PARAMETER_TYPE_MAP = new HashMap<ParameterType, Class<? extends Annotation>>();
    private String wadlNamespace;
    private boolean singleResourceMultipleMethods;
    private boolean useSingleSlashResource;
    private boolean ignoreForwardSlash;
    private boolean linkAnyMediaTypeToXmlSchema;
    private boolean useJaxbContextForQnames;
    private boolean supportCollections;
    private boolean supportJaxbXmlType;
    private boolean supportJaxbSubstitutions;
    private boolean ignoreOverloadedMethods;
    private boolean checkAbsolutePathSlash;
    private boolean keepRelativeDocLinks;
    private boolean usePathParamsToCompareOperations;
    private boolean incrementNamespacePrefix;
    private boolean ignoreMessageWriters;
    private boolean ignoreRequests;
    private boolean convertResourcesToDOM;
    private String wadlSchemaLocation;
    private List<String> externalSchemasCache;
    private List<URI> externalSchemaLinks;
    private Map<String, List<String>> externalQnamesMap;
    private final ConcurrentHashMap<String, String> docLocationMap;
    private ElementQNameResolver resolver;
    private List<String> privateAddresses;
    private List<String> allowList;
    private String applicationTitle;
    private String nsPrefix;
    private MediaType defaultWadlResponseMediaType;
    private final MediaType defaultRepMediaType;
    private String stylesheetReference;
    private boolean applyStylesheetLocally;
    private Bus bus;
    private final List<DocumentationProvider> docProviders;
    private ResourceIdGenerator idGenerator;
    private Map<String, Object> jaxbContextProperties;
    static final long serialVersionUID = 3770684551268515058L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WadlGenerator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "<init>", new Object[0]);
        }
        this.singleResourceMultipleMethods = true;
        this.useJaxbContextForQnames = true;
        this.supportCollections = true;
        this.supportJaxbXmlType = true;
        this.supportJaxbSubstitutions = true;
        this.usePathParamsToCompareOperations = true;
        this.incrementNamespacePrefix = true;
        this.ignoreMessageWriters = true;
        this.convertResourcesToDOM = true;
        this.docLocationMap = new ConcurrentHashMap();
        this.nsPrefix = DEFAULT_NS_PREFIX;
        this.defaultWadlResponseMediaType = MediaType.APPLICATION_XML_TYPE;
        this.defaultRepMediaType = MediaType.WILDCARD_TYPE;
        this.docProviders = new LinkedList<DocumentationProvider>();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WadlGenerator(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "<init>", new Object[]{bus});
        }
        this.singleResourceMultipleMethods = true;
        this.useJaxbContextForQnames = true;
        this.supportCollections = true;
        this.supportJaxbXmlType = true;
        this.supportJaxbSubstitutions = true;
        this.usePathParamsToCompareOperations = true;
        this.incrementNamespacePrefix = true;
        this.ignoreMessageWriters = true;
        this.convertResourcesToDOM = true;
        this.docLocationMap = new ConcurrentHashMap();
        this.nsPrefix = DEFAULT_NS_PREFIX;
        this.defaultWadlResponseMediaType = MediaType.APPLICATION_XML_TYPE;
        this.defaultRepMediaType = MediaType.WILDCARD_TYPE;
        this.docProviders = new LinkedList<DocumentationProvider>();
        this.bus = bus;
        this.bus.setProperty("wadl.service.description.available", (Object)"true");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void filter(ContainerRequestContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "filter", new Object[]{context});
        }
        Message m = JAXRSUtils.getCurrentMessage();
        if (m == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "filter");
            }
            return;
        }
        this.doFilter(context, m);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "filter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doFilter(ContainerRequestContext context, Message m) {
        HttpHeadersImpl headers;
        List accepts;
        MediaType type;
        Response response;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter", new Object[]{context, m});
        }
        if (!"GET".equals(((MessageImpl)m).getHttpRequestMethod())) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
            }
            return;
        }
        UriInfo ui = context.getUriInfo();
        if (!ui.getQueryParameters().containsKey((Object)WADL_QUERY)) {
            if (this.stylesheetReference != null || !this.docLocationMap.isEmpty()) {
                String path = ui.getPath(false);
                if (path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (this.stylesheetReference != null && path.endsWith(".xsl") || this.docLocationMap.containsKey(path)) {
                    context.abortWith(this.getExistingResource(m, ui, path));
                }
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
            }
            return;
        }
        if (this.ignoreRequests) {
            context.abortWith(Response.status((int)404).build());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
            }
            return;
        }
        if (this.allowList != null && !this.allowList.isEmpty()) {
            ServletRequest servletRequest = (ServletRequest)m.getContextualProperty("HTTP.REQUEST");
            String remoteAddress = null;
            remoteAddress = servletRequest != null ? servletRequest.getRemoteAddr() : "";
            boolean foundMatch = false;
            for (String addr : this.allowList) {
                if (!addr.equals(remoteAddress)) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                context.abortWith(Response.status((int)404).build());
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
                }
                return;
            }
        }
        if ((response = this.getExistingWadl(m, ui, type = (accepts = (headers = new HttpHeadersImpl(m)).getAcceptableMediaTypes()).contains(WADL_TYPE) ? WADL_TYPE : (accepts.contains(MediaType.APPLICATION_JSON_TYPE) ? MediaType.APPLICATION_JSON_TYPE : this.defaultWadlResponseMediaType))) != null) {
            context.abortWith(response);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
            }
            return;
        }
        boolean isJson = this.isJson(type);
        StringBuilder sbMain = this.generateWADL(this.getBaseURI(m, ui), this.getResourcesList(m, ui), isJson, m, ui);
        m.getExchange().put((Object)"ignore.message.writers", (Object)(!isJson && this.ignoreMessageWriters ? 1 : 0));
        Response r = Response.ok().type(type).entity(this.createResponseEntity(m, ui, sbMain.toString(), isJson)).build();
        context.abortWith(r);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doFilter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isJson(MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isJson", new Object[]{mt});
        }
        boolean bl = mt == MediaType.APPLICATION_JSON_TYPE;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isJson", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getStylesheetInstructionData(String baseURI) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getStylesheetInstructionData", new Object[]{baseURI});
        }
        String theStylesheetReference = this.stylesheetReference;
        if (!this.keepRelativeDocLinks) {
            theStylesheetReference = UriBuilder.fromUri((String)baseURI).path(theStylesheetReference).build(new Object[0]).toString();
        }
        String string = "type=\"text/xsl\" href=\"" + theStylesheetReference + "\"";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getStylesheetInstructionData", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StringBuilder generateWADL(String baseURI, List<ClassResourceInfo> cris, boolean isJson, Message m, UriInfo ui) {
        SchemaWriter schemaWriter;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "generateWADL", new Object[]{baseURI, cris, isJson, m, ui});
        }
        StringBuilder sbMain = new StringBuilder(64);
        if (!isJson && this.stylesheetReference != null && !this.applyStylesheetLocally) {
            sbMain.append("<?xml-stylesheet ").append(this.getStylesheetInstructionData(baseURI)).append("?>");
        }
        sbMain.append("<application");
        if (!isJson) {
            sbMain.append(" xmlns=\"").append(this.getNamespace()).append("\" xmlns:xs=\"").append("http://www.w3.org/2001/XMLSchema").append('\"');
        }
        StringBuilder sbGrammars = new StringBuilder(32);
        sbGrammars.append("<grammars>");
        StringBuilder sbResources = new StringBuilder(64);
        sbResources.append("<resources base=\"").append(baseURI).append("\">");
        MessageBodyWriter jaxbWriter = m != null && this.useJaxbContextForQnames ? ServerProviderFactory.getInstance((Message)m).getDefaultJaxbWriter() : null;
        ResourceTypes resourceTypes = ResourceUtils.getAllRequestResponseTypes(cris, (boolean)this.useJaxbContextForQnames, (MessageBodyWriter)jaxbWriter);
        this.checkXmlSeeAlso(resourceTypes);
        Set<Class<?>> allTypes = resourceTypes.getAllTypes().keySet();
        JAXBContext jaxbContext = null;
        if (this.useJaxbContextForQnames && !allTypes.isEmpty() && (jaxbContext = org.apache.cxf.jaxrs.utils.JAXBUtils.createJaxbContext(new HashSet(allTypes), null, this.jaxbContextProperties)) == null) {
            LOG.warning("JAXB Context is null: possibly due to one of input classes being not accepted");
        }
        ElementQNameResolver qnameResolver = (schemaWriter = this.createSchemaWriter(resourceTypes, jaxbContext, ui)) == null ? null : this.createElementQNameResolver(jaxbContext);
        IdentityHashMap clsMap = new IdentityHashMap();
        LinkedHashSet<ClassResourceInfo> visitedResources = new LinkedHashSet<ClassResourceInfo>();
        for (ClassResourceInfo cri : cris) {
            this.startResourceTag(sbResources, cri, cri.getURITemplate().getValue());
            Annotation description = AnnotationUtils.getClassAnnotation((Class)cri.getServiceClass(), Description.class);
            if (description == null) {
                description = AnnotationUtils.getClassAnnotation((Class)cri.getServiceClass(), Descriptions.class);
            }
            if (description != null) {
                this.handleDocs(new Annotation[]{description}, sbResources, "resource", true, isJson);
            } else {
                this.handleClassJavaDocs(cri, sbResources);
            }
            this.handleResource(sbResources, allTypes, qnameResolver, clsMap, cri, visitedResources, isJson);
            sbResources.append("</resource>");
        }
        sbResources.append("</resources>");
        this.handleGrammars(sbMain, sbGrammars, schemaWriter, clsMap);
        sbGrammars.append("</grammars>");
        sbMain.append('>');
        this.handleApplicationDocs(sbMain);
        sbMain.append(sbGrammars.toString());
        sbMain.append(sbResources.toString());
        sbMain.append("</application>");
        StringBuilder stringBuilder = sbMain;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            stringBuilder = stringBuilder;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "generateWADL", stringBuilder);
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object createResponseEntity(Message m, UriInfo ui, String entity, boolean isJson) {
        Document document;
        block9: {
            block5: {
                String string;
                block8: {
                    block6: {
                        String string2;
                        block7: {
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createResponseEntity", new Object[]{m, ui, entity, isJson});
                            }
                            try {
                                if (isJson) break block5;
                                if (this.stylesheetReference == null || !this.applyStylesheetLocally) break block6;
                                string2 = this.transformLocally(m, ui, new StreamSource(new StringReader(entity)));
                                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
                            }
                            catch (Exception exception) {
                                void ex;
                                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"383", (Object)this, (Object[])new Object[]{m, ui, entity, isJson});
                                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
                            }
                            string2 = string2;
                            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createResponseEntity", string2);
                        }
                        return string2;
                    }
                    string = entity;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
                    string = string;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createResponseEntity", string);
                }
                return string;
            }
            document = StaxUtils.read((Reader)new StringReader(entity));
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            document = document;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createResponseEntity", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getBaseURI(Message m, UriInfo ui) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBaseURI", new Object[]{m, ui});
        }
        EndpointInfo ei = m.getExchange().getEndpoint().getEndpointInfo();
        String publishedEndpointUrl = (String)ei.getProperty("publishedEndpointUrl");
        if (publishedEndpointUrl == null) {
            String string = ui.getBaseUri().toString();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBaseURI", string);
            }
            return string;
        }
        String string = publishedEndpointUrl;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBaseURI", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleGrammars(StringBuilder sbApp, StringBuilder sbGrammars, SchemaWriter writer, Map<Class<?>, QName> clsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleGrammars", new Object[]{sbApp, sbGrammars, writer, clsMap});
        }
        if (writer == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleGrammars");
            }
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (QName qName : clsMap.values()) {
            map.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        for (Map.Entry entry : map.entrySet()) {
            sbApp.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append('\"');
        }
        if (this.wadlSchemaLocation != null) {
            sbApp.append(" xmlns:xsi=\"").append("http://www.w3.org/2001/XMLSchema-instance").append('\"');
            sbApp.append(" xsi:schemaLocation=\"").append(this.getNamespace()).append(' ').append(this.wadlSchemaLocation).append('\"');
        }
        writer.write(sbGrammars);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleGrammars");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleResource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, ClassResourceInfo cri, Set<ClassResourceInfo> visitedResources, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleResource", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, cri, visitedResources, isJson});
        }
        visitedResources.add(cri);
        Map<Parameter, Object> classParams = this.getClassParameters(cri);
        List<OperationResourceInfo> sortedOps = this.sortOperationsByPath(cri.getMethodDispatcher().getOperationResourceInfos());
        boolean resourceTagOpened = false;
        for (int i = 0; i < sortedOps.size(); ++i) {
            OperationResourceInfo ori = sortedOps.get(i);
            if (i > 0 && this.ignoreOverloadedMethods && ori.getMethodToInvoke().getName().equals(sortedOps.get(i - 1).getMethodToInvoke().getName())) continue;
            if (ori.getHttpMethod() == null) {
                Class<?> cls = this.getMethod(ori).getReturnType();
                ClassResourceInfo subcri = cri.findResource(cls, cls);
                if (subcri != null && !visitedResources.contains(subcri)) {
                    this.startResourceTag(sb, subcri, ori.getURITemplate().getValue());
                    this.handleDocs(subcri.getServiceClass().getAnnotations(), sb, "resource", true, isJson);
                    this.handlePathAndMatrixParams(sb, ori, isJson);
                    this.handleResource(sb, jaxbTypes, qnameResolver, clsMap, subcri, visitedResources, isJson);
                    sb.append("</resource>");
                    continue;
                }
                this.handleDynamicSubresource(sb, jaxbTypes, qnameResolver, clsMap, ori, subcri, isJson);
                continue;
            }
            OperationResourceInfo nextOp = i + 1 < sortedOps.size() ? sortedOps.get(i + 1) : null;
            resourceTagOpened = this.handleOperation(sb, jaxbTypes, qnameResolver, clsMap, ori, classParams, nextOp, resourceTagOpened, isJson, i);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleResource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<Parameter, Object> getClassParameters(ClassResourceInfo cri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getClassParameters", new Object[]{cri});
        }
        LinkedHashMap<Parameter, Object> classParams = new LinkedHashMap<Parameter, Object>();
        List paramMethods = cri.getParameterMethods();
        for (Method m : paramMethods) {
            classParams.put(ResourceUtils.getParameter((int)0, (Annotation[])m.getAnnotations(), m.getParameterTypes()[0]), m);
        }
        List fieldParams = cri.getParameterFields();
        for (Field f : fieldParams) {
            classParams.put(ResourceUtils.getParameter((int)0, (Annotation[])f.getAnnotations(), f.getType()), f);
        }
        LinkedHashMap<Parameter, Object> linkedHashMap = classParams;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedHashMap = linkedHashMap;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getClassParameters", linkedHashMap);
        }
        return linkedHashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startResourceTag(StringBuilder sb, ClassResourceInfo cri, String path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startResourceTag", new Object[]{sb, cri, path});
        }
        sb.append("<resource path=\"").append(this.getPath(path)).append('\"');
        if (this.idGenerator != null) {
            String id = this.idGenerator.getClassResourceId(cri);
            sb.append(" id=\"").append(id).append('\"');
        }
        sb.append('>');
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startResourceTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getPath(String path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPath", new Object[]{path});
        }
        String thePath = this.ignoreForwardSlash && path.startsWith("/") && path.length() > 0 ? path.substring(1) : path;
        String string = this.xmlEncodeIfNeeded(thePath);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkXmlSeeAlso(ResourceTypes resourceTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "checkXmlSeeAlso", new Object[]{resourceTypes});
        }
        if (!this.useJaxbContextForQnames) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "checkXmlSeeAlso");
            }
            return;
        }
        LinkedList extraClasses = new LinkedList();
        for (Class cls : resourceTypes.getAllTypes().keySet()) {
            XmlSeeAlso seeAlsoAnn;
            if (this.isXmlRoot(cls) && !Modifier.isAbstract(cls.getModifiers()) || (seeAlsoAnn = cls.getAnnotation(XmlSeeAlso.class)) == null) continue;
            List seeAlsoList = CastUtils.cast(Arrays.asList(seeAlsoAnn.value()));
            if (this.supportJaxbSubstitutions) {
                for (Class seeAlsoCls : seeAlsoList) {
                    resourceTypes.getSubstitutions().put(seeAlsoCls, cls);
                }
            }
            extraClasses.addAll(seeAlsoList);
        }
        for (Class cls : extraClasses) {
            resourceTypes.getAllTypes().put(cls, cls);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "checkXmlSeeAlso");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String xmlEncodeIfNeeded(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "xmlEncodeIfNeeded", new Object[]{value});
        }
        StringBuilder builder = new StringBuilder(value.length());
        boolean change = false;
        for (int x = 0; x < value.length(); ++x) {
            char ch = value.charAt(x);
            String ap = null;
            switch (ch) {
                case '\"': {
                    ap = "&quot;";
                    break;
                }
                case '\'': {
                    ap = "&apos;";
                    break;
                }
                case '<': {
                    ap = "&lt;";
                    break;
                }
                case '>': {
                    ap = "&gt;";
                    break;
                }
                case '&': {
                    ap = "&amp;";
                    break;
                }
                default: {
                    ap = null;
                }
            }
            if (ap != null) {
                change = true;
                builder.append(ap);
                continue;
            }
            builder.append(ch);
        }
        String string = change ? builder.toString() : value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "xmlEncodeIfNeeded", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodTag", new Object[]{sb, ori});
        }
        sb.append("<method name=\"").append(ori.getHttpMethod()).append('\"');
        if (this.idGenerator != null) {
            String id = this.idGenerator.getMethodResourceId(ori);
            sb.append(" id=\"").append(id).append('\"');
        }
        sb.append('>');
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodTag", new Object[]{sb, ori});
        }
        sb.append("</method>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startMethodRequestTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodRequestTag", new Object[]{sb, ori});
        }
        sb.append("<request>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodRequestTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startMethodResponseTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodResponseTag", new Object[]{sb, ori});
        }
        sb.append("<response");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startMethodResponseTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endMethodRequestTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodRequestTag", new Object[]{sb, ori});
        }
        sb.append("</request>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodRequestTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endMethodResponseTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodResponseTag", new Object[]{sb, ori});
        }
        sb.append("</response>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endMethodResponseTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startResourceTag(StringBuilder sb, OperationResourceInfo ori, String path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startResourceTag", new Object[]{sb, ori, path});
        }
        sb.append("<resource path=\"").append(path).append("\">");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "startResourceTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endResourceTag(StringBuilder sb, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endResourceTag", new Object[]{sb, ori});
        }
        sb.append("</resource>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "endResourceTag");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean handleOperation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Map<Parameter, Object> classParams, OperationResourceInfo nextOp, boolean resourceTagOpened, boolean isJson, int index) {
        int numOfParams;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperation", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, ori, classParams, nextOp, resourceTagOpened, isJson, index});
        }
        Annotation[] anns = this.getMethod(ori).getAnnotations();
        boolean samePathOperationFollows = this.singleResourceMultipleMethods && this.compareOperations(ori, nextOp);
        String path = ori.getURITemplate().getValue();
        if (!resourceTagOpened && this.openResource(path)) {
            String parentPath;
            resourceTagOpened = true;
            URITemplate template = ori.getClassResourceInfo().getURITemplate();
            if (template != null && (parentPath = template.getValue()).endsWith("/") && path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            this.startResourceTag(sb, ori, this.getPath(path));
            this.handleDocs(anns, sb, "resource", false, isJson);
            this.handlePathAndMatrixClassParams(ori, sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        } else if (index == 0) {
            this.handlePathAndMatrixClassParams(ori, sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        }
        this.startMethodTag(sb, ori);
        if (!this.handleDocs(anns, sb, "method", true, isJson)) {
            this.handleOperJavaDocs(ori, sb);
        }
        if ((numOfParams = this.getMethod(ori).getParameterTypes().length) > 1 || numOfParams == 1 && !ori.isAsync() || !classParams.isEmpty()) {
            this.startMethodRequestTag(sb, ori);
            this.handleDocs(anns, sb, "request", false, isJson);
            boolean isForm = this.isFormRequest(ori);
            this.doHandleClassParams(ori, sb, classParams, isJson, ParameterType.QUERY, ParameterType.HEADER);
            this.doHandleJaxrsBeanParamClassParams(ori, sb, classParams, isJson, ParameterType.QUERY, ParameterType.HEADER);
            for (Parameter p : ori.getParameters()) {
                if (isForm && p.getType() == ParameterType.REQUEST_BODY) continue;
                this.handleParameter(sb, jaxbTypes, qnameResolver, clsMap, ori, p, isJson);
            }
            if (isForm) {
                this.handleFormRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, this.getFormClass(ori), isJson);
            }
            this.endMethodRequestTag(sb, ori);
        }
        this.startMethodResponseTag(sb, ori);
        Class<?> returnType = this.getMethod(ori).getReturnType();
        boolean isVoid = Void.TYPE == returnType && !ori.isAsync();
        ResponseStatus responseStatus = this.getMethod(ori).getAnnotation(ResponseStatus.class);
        if (responseStatus != null) {
            this.setResponseStatus(sb, responseStatus.value());
        } else if (isVoid) {
            boolean oneway = this.getMethod(ori).getAnnotation(Oneway.class) != null;
            this.setResponseStatus(sb, oneway ? Response.Status.ACCEPTED : Response.Status.NO_CONTENT);
        }
        sb.append('>');
        this.handleDocs(anns, sb, "response", false, isJson);
        if (!isVoid) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, returnType, isJson, false);
        }
        this.endMethodResponseTag(sb, ori);
        this.endMethodTag(sb, ori);
        if (resourceTagOpened && !samePathOperationFollows) {
            this.endResourceTag(sb, ori);
            resourceTagOpened = false;
        }
        boolean bl = resourceTagOpened;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setResponseStatus(StringBuilder sb, Response.Status ... statuses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResponseStatus", new Object[]{sb, statuses});
        }
        sb.append(" status=\"");
        for (int i = 0; i < statuses.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(statuses[i].getStatusCode());
        }
        sb.append('\"');
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResponseStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean compareOperations(OperationResourceInfo ori1, OperationResourceInfo ori2) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "compareOperations", new Object[]{ori1, ori2});
        }
        if (ori1 == null || ori2 == null || !ori1.getURITemplate().getValue().equals(ori2.getURITemplate().getValue()) || ori1.getHttpMethod() != null && ori2.getHttpMethod() == null || ori2.getHttpMethod() != null && ori1.getHttpMethod() == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "compareOperations", bl);
            }
            return bl;
        }
        if (this.usePathParamsToCompareOperations) {
            int ori1PathParams = 0;
            int ori1MatrixParams = 0;
            for (Parameter p : ori1.getParameters()) {
                if (p.getType() == ParameterType.PATH) {
                    ++ori1PathParams;
                    continue;
                }
                if (p.getType() != ParameterType.MATRIX) continue;
                ++ori1MatrixParams;
            }
            int ori2PathParams = 0;
            int ori2MatrixParams = 0;
            for (Parameter p : ori2.getParameters()) {
                if (p.getType() == ParameterType.PATH) {
                    ++ori2PathParams;
                    continue;
                }
                if (p.getType() != ParameterType.MATRIX) continue;
                ++ori2MatrixParams;
            }
            boolean bl = ori1PathParams == ori2PathParams && ori1MatrixParams == ori2MatrixParams;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "compareOperations", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "compareOperations", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean openResource(String path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "openResource", new Object[]{path});
        }
        if ("/".equals(path)) {
            boolean bl = this.useSingleSlashResource;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "openResource", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "openResource", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleDynamicSubresource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, ClassResourceInfo subcri, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleDynamicSubresource", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, ori, subcri, isJson});
        }
        if (!isJson) {
            if (subcri != null) {
                sb.append("<!-- Recursive subresource -->");
            } else {
                sb.append("<!-- Dynamic subresource -->");
            }
        }
        this.startResourceTag(sb, subcri, ori.getURITemplate().getValue());
        this.handlePathAndMatrixParams(sb, ori, isJson);
        sb.append("</resource>");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleDynamicSubresource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handlePathAndMatrixClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handlePathAndMatrixClassParams", new Object[]{ori, sb, params, isJson});
        }
        this.doHandleClassParams(ori, sb, params, isJson, ParameterType.PATH);
        this.doHandleClassParams(ori, sb, params, isJson, ParameterType.MATRIX);
        this.doHandleJaxrsBeanParamClassParams(ori, sb, params, isJson, ParameterType.PATH, ParameterType.MATRIX);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handlePathAndMatrixClassParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doHandleClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson, ParameterType ... pType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doHandleClassParams", new Object[]{ori, sb, params, isJson, pType});
        }
        LinkedHashSet<ParameterType> pTypes = new LinkedHashSet<ParameterType>(Arrays.asList(pType));
        for (Map.Entry<Parameter, Object> entry : params.entrySet()) {
            Parameter pm = entry.getKey();
            Object obj = entry.getValue();
            if (!pTypes.contains(pm.getType())) continue;
            Class<?> cls = obj instanceof Method ? ((Method)obj).getParameterTypes()[0] : ((Field)obj).getType();
            Type type = obj instanceof Method ? ((Method)obj).getGenericParameterTypes()[0] : ((Field)obj).getGenericType();
            Annotation[] ann = obj instanceof Method ? ((Method)obj).getParameterAnnotations()[0] : ((Field)obj).getAnnotations();
            this.doWriteParam(ori, sb, pm, cls, type, pm.getName(), ann, isJson);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doHandleClassParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doHandleJaxrsBeanParamClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson, ParameterType ... pType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doHandleJaxrsBeanParamClassParams", new Object[]{ori, sb, params, isJson, pType});
        }
        for (Map.Entry<Parameter, Object> entry : params.entrySet()) {
            Parameter pm = entry.getKey();
            Object obj = entry.getValue();
            if (pm.getType() != ParameterType.BEAN) continue;
            Class<?> cls = obj instanceof Method ? ((Method)obj).getParameterTypes()[0] : ((Field)obj).getType();
            this.doWriteJaxrsBeanParam(sb, ori, cls, isJson, pType);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doHandleJaxrsBeanParamClassParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handlePathAndMatrixParams(StringBuilder sb, OperationResourceInfo ori, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handlePathAndMatrixParams", new Object[]{sb, ori, isJson});
        }
        this.handleParams(sb, ori, ParameterType.PATH, isJson);
        this.handleParams(sb, ori, ParameterType.MATRIX, isJson);
        this.doWriteJaxrsBeanParams(sb, ori, isJson, ParameterType.PATH, ParameterType.MATRIX);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handlePathAndMatrixParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleParameter(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Parameter pm, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParameter", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, ori, pm, isJson});
        }
        Class<?> cls = this.getMethod(ori).getParameterTypes()[pm.getIndex()];
        if (pm.getType() == ParameterType.REQUEST_BODY && cls != AsyncResponse.class) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, cls, isJson, true);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParameter");
            }
            return;
        }
        if (pm.getType() == ParameterType.PATH || pm.getType() == ParameterType.MATRIX) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParameter");
            }
            return;
        }
        if (pm.getType() == ParameterType.HEADER || pm.getType() == ParameterType.QUERY) {
            this.writeParam(sb, pm, ori, isJson);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParameter");
            }
            return;
        }
        if (pm.getType() == ParameterType.BEAN) {
            this.doWriteJaxrsBeanParams(sb, ori, isJson, ParameterType.HEADER, ParameterType.QUERY);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParameter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleParams(StringBuilder sb, OperationResourceInfo ori, ParameterType type, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParams", new Object[]{sb, ori, type, isJson});
        }
        for (Parameter pm : ori.getParameters()) {
            if (pm.getType() != type) continue;
            this.writeParam(sb, pm, ori, isJson);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Annotation[] getBodyAnnotations(OperationResourceInfo ori, boolean inbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBodyAnnotations", new Object[]{ori, inbound});
        }
        Method opMethod = this.getMethod(ori);
        if (inbound) {
            for (Parameter pm : ori.getParameters()) {
                if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                Annotation[] annotationArray = opMethod.getParameterAnnotations()[pm.getIndex()];
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    annotationArray = annotationArray;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBodyAnnotations", annotationArray);
                }
                return annotationArray;
            }
            Annotation[] annotationArray = new Annotation[]{};
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                annotationArray = annotationArray;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBodyAnnotations", annotationArray);
            }
            return annotationArray;
        }
        Annotation[] annotationArray = opMethod.getDeclaredAnnotations();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getBodyAnnotations", annotationArray);
        }
        return annotationArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeParam(StringBuilder sb, Parameter pm, OperationResourceInfo ori, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "writeParam", new Object[]{sb, pm, ori, isJson});
        }
        Method method = this.getMethod(ori);
        Class<?> type = method.getParameterTypes()[pm.getIndex()];
        if (!"".equals(pm.getName())) {
            this.doWriteParam(ori, sb, pm, type, method.getGenericParameterTypes()[pm.getIndex()], pm.getName(), method.getParameterAnnotations()[pm.getIndex()], isJson);
        } else {
            LinkedList parentBeanClasses = new LinkedList();
            parentBeanClasses.add(type);
            this.doWriteBeanParam(ori, sb, type, pm, null, parentBeanClasses, isJson);
            parentBeanClasses.remove(type);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "writeParam");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doWriteJaxrsBeanParams(StringBuilder sb, OperationResourceInfo ori, boolean isJson, ParameterType ... parameterTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteJaxrsBeanParams", new Object[]{sb, ori, isJson, parameterTypes});
        }
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.BEAN) continue;
            Method method = this.getMethod(ori);
            Class<?> type = method.getParameterTypes()[p.getIndex()];
            this.doWriteJaxrsBeanParam(sb, ori, type, isJson, parameterTypes);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteJaxrsBeanParams");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doWriteJaxrsBeanParam(StringBuilder sb, OperationResourceInfo ori, Class<?> beanType, boolean isJson, ParameterType ... parameterTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteJaxrsBeanParam", new Object[]{sb, ori, beanType, isJson, parameterTypes});
        }
        for (Method m : beanType.getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            String propertyName = StringUtils.uncapitalize((String)m.getName().substring(3));
            Field f = InjectionUtils.getDeclaredField(beanType, (String)propertyName);
            for (ParameterType parameterType : parameterTypes) {
                DefaultValue dv;
                Parameter pm;
                Class<? extends Annotation> annClass = this.getAnnotationFromParamType(parameterType);
                Annotation annotation = m.getAnnotation(annClass);
                if (annotation != null) {
                    pm = new Parameter(parameterType, propertyName);
                    pm.setEncoded(m.getAnnotation(Encoded.class) != null);
                    dv = m.getAnnotation(DefaultValue.class);
                    if (dv != null) {
                        pm.setDefaultValue(dv.value());
                    }
                    this.doWriteParam(ori, sb, pm, m.getParameterTypes()[0], m.getGenericParameterTypes()[0], propertyName, new Annotation[0], isJson);
                    continue;
                }
                if (f == null || (annotation = f.getAnnotation(annClass)) == null) continue;
                pm = new Parameter(parameterType, propertyName);
                pm.setEncoded(f.getAnnotation(Encoded.class) != null);
                dv = f.getAnnotation(DefaultValue.class);
                if (dv != null) {
                    pm.setDefaultValue(dv.value());
                }
                this.doWriteParam(ori, sb, pm, f.getType(), f.getGenericType(), propertyName, new Annotation[0], isJson);
            }
            if (m.getAnnotation(BeanParam.class) != null) {
                this.doWriteJaxrsBeanParam(sb, ori, m.getParameterTypes()[0], isJson, parameterTypes);
                continue;
            }
            if (f == null || f.getAnnotation(BeanParam.class) == null) continue;
            this.doWriteJaxrsBeanParam(sb, ori, f.getType(), isJson, parameterTypes);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteJaxrsBeanParam");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class<? extends Annotation> getAnnotationFromParamType(ParameterType pt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getAnnotationFromParamType", new Object[]{pt});
        }
        Class<? extends Annotation> clazz = PARAMETER_TYPE_MAP.get(pt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getAnnotationFromParamType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doWriteBeanParam(OperationResourceInfo ori, StringBuilder sb, Class<?> type, Parameter pm, String parentName, List<Class<?>> parentBeanClasses, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteBeanParam", new Object[]{ori, sb, type, pm, parentName, parentBeanClasses, isJson});
        }
        Map pms = InjectionUtils.getParametersFromBeanClass(type, (ParameterType)pm.getType(), (boolean)true);
        for (Map.Entry entry : pms.entrySet()) {
            Class paramCls;
            boolean isPrimitive;
            String name = ((Parameter)entry.getKey()).getName();
            if (parentName != null) {
                name = parentName + "." + name;
            }
            boolean bl = isPrimitive = InjectionUtils.isPrimitive((Class)(paramCls = (Class)entry.getValue())) || paramCls.isEnum();
            if (isPrimitive || Date.class.isAssignableFrom(paramCls) || XMLGregorianCalendar.class.isAssignableFrom(paramCls) || InjectionUtils.isSupportedCollectionOrArray((Class)paramCls)) {
                this.doWriteParam(ori, sb, (Parameter)entry.getKey(), paramCls, paramCls, name, new Annotation[0], isJson);
                continue;
            }
            if (parentBeanClasses.contains(paramCls)) continue;
            parentBeanClasses.add(paramCls);
            this.doWriteBeanParam(ori, sb, paramCls, (Parameter)entry.getKey(), name, parentBeanClasses, isJson);
            parentBeanClasses.remove(paramCls);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteBeanParam");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doWriteParam(OperationResourceInfo ori, StringBuilder sb, Parameter pm, Class<?> type, Type genericType, String paramName, Annotation[] anns, boolean isJson) {
        String value;
        Multipart m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteParam", new Object[]{ori, sb, pm, type, genericType, paramName, anns, isJson});
        }
        ParameterType pType = pm.getType();
        boolean isForm = this.isFormParameter(pm, type, anns);
        if (paramName == null && isForm && (m = (Multipart)AnnotationUtils.getAnnotation((Annotation[])anns, Multipart.class)) != null) {
            paramName = m.value();
        }
        sb.append("<param name=\"").append(paramName).append("\" ");
        String style = ParameterType.PATH == pType ? "template" : (isForm ? "query" : (ParameterType.REQUEST_BODY == pType ? "plain" : pType.toString().toLowerCase()));
        sb.append("style=\"").append(style).append('\"');
        if (pm.getDefaultValue() != null) {
            sb.append(" default=\"").append(this.xmlEncodeIfNeeded(pm.getDefaultValue())).append('\"');
        }
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType((Type)genericType);
            sb.append(" repeating=\"true\"");
        }
        if ((value = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type)) == null) {
            if (type.isEnum()) {
                value = "xs:string";
            } else if (type == InputStream.class) {
                value = "xs:anyType";
            }
        }
        if (value != null) {
            if (isJson) {
                value = value.substring(3);
            }
            sb.append(" type=\"").append(value).append('\"');
        }
        if (type.isEnum()) {
            sb.append('>');
            this.handleDocs(anns, sb, "param", true, isJson);
            this.setEnumOptions(sb, type);
            sb.append("</param>");
        } else {
            this.addDocsAndCloseElement(ori, pm.getIndex(), sb, anns, "param", "param", true, isJson);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doWriteParam");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setEnumOptions(StringBuilder sb, Class<?> enumClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setEnumOptions", new Object[]{sb, enumClass});
        }
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            Object[] values = (Object[])m.invoke(null, new Object[0]);
            m = enumClass.getMethod("toString", new Class[0]);
            for (Object o : values) {
                String str = (String)m.invoke(o, new Object[0]);
                sb.append("<option value=\"").append(str).append("\"/>");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1013", (Object)this, (Object[])new Object[]{sb, enumClass});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setEnumOptions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addDocsAndCloseElement(OperationResourceInfo ori, int paramIndex, StringBuilder sb, Annotation[] anns, String elementName, String category, boolean allowDefault, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addDocsAndCloseElement", new Object[]{ori, paramIndex, sb, anns, elementName, category, allowDefault, isJson});
        }
        boolean docAnnAvailable = this.isDocAvailable(anns);
        if (docAnnAvailable || ori != null && !this.docProviders.isEmpty()) {
            sb.append('>');
            if (docAnnAvailable) {
                this.handleDocs(anns, sb, category, allowDefault, isJson);
            } else if ("return".equals(category)) {
                this.handleOperResponseJavaDocs(ori, sb);
            } else if ("param".equals(category)) {
                this.handleOperParamJavaDocs(ori, paramIndex, sb);
            }
            sb.append("</").append(elementName).append('>');
        } else {
            sb.append("/>");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addDocsAndCloseElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isDocAvailable(Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isDocAvailable", new Object[]{anns});
        }
        boolean bl = AnnotationUtils.getAnnotation((Annotation[])anns, Description.class) != null || AnnotationUtils.getAnnotation((Annotation[])anns, Descriptions.class) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isDocAvailable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson, boolean inbound) {
        List<MediaType> types;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleRepresentation", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, ori, type, isJson, inbound});
        }
        List<Object> list = types = inbound ? ori.getConsumeTypes() : ori.getProduceTypes();
        if (MultivaluedMap.class.isAssignableFrom(type)) {
            types = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else if (this.isWildcard(types)) {
            types = Collections.singletonList(this.defaultRepMediaType);
        }
        Method opMethod = this.getMethod(ori);
        boolean isPrimitive = InjectionUtils.isPrimitive(type) && !ori.isAsync();
        for (MediaType mt : types) {
            Type genericType;
            String docCategory;
            Annotation[] anns;
            sb.append("<representation");
            sb.append(" mediaType=\"").append(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0])).append('\"');
            if (isJson && !mt.getSubtype().contains("json")) {
                sb.append("/>");
                continue;
            }
            boolean allowDefault = true;
            int inParamIndex = -1;
            if (inbound) {
                inParamIndex = this.getRequestBodyParam(ori).getIndex();
                anns = opMethod.getParameterAnnotations()[inParamIndex];
                if (!this.isDocAvailable(anns)) {
                    anns = opMethod.getAnnotations();
                }
                docCategory = "param";
                genericType = opMethod.getGenericParameterTypes()[inParamIndex];
            } else {
                anns = opMethod.getAnnotations();
                docCategory = "return";
                allowDefault = false;
                genericType = opMethod.getGenericReturnType();
            }
            if (isPrimitive) {
                sb.append('>');
                Parameter p = inbound ? this.getRequestBodyParam(ori) : new Parameter(ParameterType.REQUEST_BODY, 0, "result");
                this.doWriteParam(ori, sb, p, type, type, p.getName() == null ? "request" : p.getName(), anns, isJson);
                sb.append("</representation>");
                continue;
            }
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            Class theActualType = isCollection ? InjectionUtils.getActualType((Type)genericType) : ResourceUtils.getActualJaxbType(type, (Method)opMethod, (boolean)inbound);
            if (theActualType == Object.class && !(genericType instanceof Class) || genericType instanceof TypeVariable) {
                Type theType = InjectionUtils.processGenericTypeIfNeeded((Class)ori.getClassResourceInfo().getServiceClass(), Object.class, (Type)genericType);
                theActualType = InjectionUtils.getActualType((Type)theType);
            }
            if (isJson) {
                sb.append(" element=\"").append(theActualType.getSimpleName()).append('\"');
            } else if (qnameResolver != null && (this.linkAnyMediaTypeToXmlSchema || mt.getSubtype().contains("xml")) && jaxbTypes.contains(theActualType)) {
                this.generateQName(sb, qnameResolver, clsMap, theActualType, isCollection, this.getBodyAnnotations(ori, inbound));
            }
            this.addDocsAndCloseElement(ori, inParamIndex, sb, anns, "representation", docCategory, allowDefault, isJson);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleRepresentation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Parameter getRequestBodyParam(OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getRequestBodyParam", new Object[]{ori});
        }
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.REQUEST_BODY) continue;
            Parameter parameter = p;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getRequestBodyParam", parameter);
            }
            return parameter;
        }
        throw new IllegalStateException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isWildcard(List<MediaType> types) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isWildcard", new Object[]{types});
        }
        boolean bl = types.size() == 1 && types.get(0).equals((Object)MediaType.WILDCARD_TYPE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isWildcard", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleFormRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleFormRepresentation", new Object[]{sb, jaxbTypes, qnameResolver, clsMap, ori, type, isJson});
        }
        if (type != null) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, type, false, true);
        } else {
            List types = ori.getConsumeTypes();
            MediaType formType = this.isWildcard(types) ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (MediaType)types.get(0);
            sb.append("<representation");
            sb.append(" mediaType=\"").append(formType).append('\"');
            if (isJson) {
                sb.append("/>");
            } else {
                sb.append('>');
                List params = ori.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    if (!this.isFormParameter((Parameter)params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
                    this.writeParam(sb, (Parameter)params.get(i), ori, isJson);
                }
                sb.append("</representation>");
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleFormRepresentation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<OperationResourceInfo> sortOperationsByPath(Set<OperationResourceInfo> ops) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "sortOperationsByPath", new Object[]{ops});
        }
        LinkedList<OperationResourceInfo> opsWithSamePath = new LinkedList<OperationResourceInfo>(ops);
        Collections.sort(opsWithSamePath, new Comparator<OperationResourceInfo>(){
            static final long serialVersionUID = 8212337650998325031L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(OperationResourceInfo op1, OperationResourceInfo op2) {
                boolean sub2;
                boolean sub1 = op1.getHttpMethod() == null;
                boolean bl = sub2 = op2.getHttpMethod() == null;
                if (sub1 && !sub2) {
                    return 1;
                }
                if (!sub1 && sub2) {
                    return -1;
                }
                URITemplate ut1 = op1.getURITemplate();
                URITemplate ut2 = op2.getURITemplate();
                int result = ut1.getValue().compareTo(ut2.getValue());
                if (!(result != 0 || sub1 && sub2)) {
                    result = op1.getHttpMethod().compareTo(op2.getHttpMethod());
                }
                if (result == 0 && WadlGenerator.this.ignoreOverloadedMethods && op1.getMethodToInvoke().getName().equals(op2.getMethodToInvoke().getName())) {
                    Integer paramLen1 = op1.getMethodToInvoke().getParameterTypes().length;
                    Integer paramLen2 = op2.getMethodToInvoke().getParameterTypes().length;
                    result = paramLen1.compareTo(paramLen2) * -1;
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$1", 1.class, null, null);
            }
        });
        LinkedList<OperationResourceInfo> linkedList = opsWithSamePath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "sortOperationsByPath", linkedList);
        }
        return linkedList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassResourceInfo> getResourcesList(Message m, UriInfo ui) {
        boolean absolutePathSlashOn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getResourcesList", new Object[]{m, ui});
        }
        String slash = "/";
        String path = ui.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        List all = ((JAXRSServiceImpl)m.getExchange().getService()).getClassResourceInfos();
        boolean bl = absolutePathSlashOn = this.checkAbsolutePathSlash && ui.getAbsolutePath().getPath().endsWith("/");
        if ("/".equals(path) && !absolutePathSlashOn) {
            List list = all;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getResourcesList", list);
            }
            return list;
        }
        LinkedList<ClassResourceInfo> cris = new LinkedList<ClassResourceInfo>();
        for (ClassResourceInfo cri : all) {
            MetadataMap map = new MetadataMap();
            if (!cri.getURITemplate().match(path, (MultivaluedMap)map) || !"/".equals(map.getFirst((Object)"FINAL_MATCH_GROUP"))) continue;
            cris.add(cri);
        }
        LinkedList<ClassResourceInfo> linkedList = cris;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getResourcesList", linkedList);
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Response getExistingWadl(Message m, UriInfo ui, MediaType mt) {
        block7: {
            String loc;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingWadl", new Object[]{m, ui, mt});
            }
            Endpoint ep = m.getExchange().getEndpoint();
            if (ep != null && (loc = (String)ep.get((Object)"wadl.location")) != null) {
                Response response;
                block10: {
                    List resourcesEls;
                    InputStream is2;
                    block8: {
                        Response response2;
                        block9: {
                            try {
                                boolean doConvertResourcesToDOM;
                                is2 = ResourceUtils.getResourceStream((String)loc, (Bus)((Bus)ep.get((Object)Bus.class.getName())));
                                if (is2 == null) break block7;
                                Object contextProp = m.getContextualProperty(CONVERT_WADL_RESOURCES_TO_DOM);
                                boolean bl = doConvertResourcesToDOM = contextProp == null ? this.convertResourcesToDOM : PropertyUtils.isTrue((Object)contextProp);
                                if (doConvertResourcesToDOM && !this.isJson(mt)) break block8;
                                response2 = Response.ok((Object)is2, (MediaType)mt).build();
                                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                            }
                            catch (Exception is2) {
                                void ex;
                                FFDCFilter.processException((Throwable)is2, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1263", (Object)this, (Object[])new Object[]{m, ui, mt});
                                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
                            }
                            response2 = response2;
                            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingWadl", response2);
                        }
                        return response2;
                    }
                    Document wadlDoc = StaxUtils.read((InputStream)is2);
                    Element appEl = wadlDoc.getDocumentElement();
                    List grammarEls = DOMUtils.getChildrenWithName((Element)appEl, (String)WADL_NS, (String)"grammars");
                    if (grammarEls.size() == 1) {
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)((Element)grammarEls.get(0)), (String)WADL_NS, (String)"include"), "href", loc, "", m, ui);
                    }
                    if ((resourcesEls = DOMUtils.getChildrenWithName((Element)appEl, (String)WADL_NS, (String)"resources")).size() != 1) break block7;
                    DOMUtils.setAttribute((Node)((Node)resourcesEls.get(0)), (String)"base", (String)this.getBaseURI(m, ui));
                    List resourceEls = DOMUtils.getChildrenWithName((Element)((Element)resourcesEls.get(0)), (String)WADL_NS, (String)"resource");
                    this.handleExistingDocRefs(resourceEls, "type", loc, "", m, ui);
                    response = this.finalizeExistingWadlResponse(wadlDoc, m, ui, mt);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
                    response = response;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingWadl", response);
                }
                return response;
            }
        }
        Response response = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            response = response;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingWadl", response);
        }
        return response;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Response finalizeExistingWadlResponse(Document wadlDoc, Message m, UriInfo ui, MediaType mt) throws Exception {
        Object entity;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "finalizeExistingWadlResponse", new Object[]{wadlDoc, m, ui, mt});
        }
        if (this.stylesheetReference != null) {
            if (!this.applyStylesheetLocally) {
                ProcessingInstruction pi = wadlDoc.createProcessingInstruction("xml-stylesheet", this.getStylesheetInstructionData(this.getBaseURI(m, ui)));
                wadlDoc.insertBefore(pi, wadlDoc.getDocumentElement());
                entity = this.copyDOMToString(wadlDoc);
            } else {
                entity = this.transformLocally(m, ui, new DOMSource(wadlDoc));
            }
        } else {
            entity = new DOMSource(wadlDoc);
        }
        Response response = Response.ok((Object)entity, (MediaType)mt).build();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            response = response;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "finalizeExistingWadlResponse", response);
        }
        return response;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String copyDOMToString(Document wadlDoc) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "copyDOMToString", new Object[]{wadlDoc});
        }
        DOMSource domSource = new DOMSource(wadlDoc);
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, new StreamResult(stringWriter));
        String string = stringWriter.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "copyDOMToString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String transformLocally(Message m, UriInfo ui, Source source) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "transformLocally", new Object[]{m, ui, source});
        }
        InputStream is = ResourceUtils.getResourceStream((String)this.stylesheetReference, (Bus)m.getExchange().getBus());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = transformerFactory.newTemplates(new StreamSource(is)).newTransformer();
        t.setParameter("base.path", m.get((Object)"http.base.path"));
        StringWriter stringWriter = new StringWriter();
        t.transform(source, new StreamResult(stringWriter));
        String string = stringWriter.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "transformLocally", string);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Response getExistingResource(Message m, UriInfo ui, String href) {
        block13: {
            block14: {
                block11: {
                    block12: {
                        if (WadlGenerator.LOG != null && WadlGenerator.LOG.isLoggable(Level.FINER)) {
                            WadlGenerator.LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingResource", new Object[]{m, ui, href});
                        }
                        try {
                            loc = this.docLocationMap.get(href);
                            if (loc == null) ** GOTO lbl37
                            fragmentIndex = loc.lastIndexOf(35);
                            if (fragmentIndex != -1) {
                                loc = loc.substring(0, fragmentIndex);
                            }
                            if ((is = ResourceUtils.getResourceStream((String)loc, (Bus)m.getExchange().getBus())) == null) break block11;
                            docEl = StaxUtils.read((InputStream)is).getDocumentElement();
                            if (href.endsWith(".xsl")) {
                                xslImports = DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/1999/XSL/Transform", (String)"import");
                                this.handleExistingDocRefs(xslImports, "href", loc, href, m, ui);
                                xslIncludes = DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/1999/XSL/Transform", (String)"include");
                                this.handleExistingDocRefs(xslIncludes, "href", loc, href, m, ui);
                            } else if (fragmentIndex != -1) {
                                grammarEls = DOMUtils.getChildrenWithName((Element)docEl, (String)"http://wadl.dev.java.net/2009/02", (String)"grammars");
                                if (grammarEls.size() == 1) {
                                    this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)((Element)grammarEls.get(0)), (String)"http://wadl.dev.java.net/2009/02", (String)"include"), "href", loc, href, m, ui);
                                }
                            } else {
                                this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/2001/XMLSchema", (String)"import"), "schemaLocation", loc, href, m, ui);
                                this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/2001/XMLSchema", (String)"include"), "schemaLocation", loc, href, m, ui);
                            }
                            v0 = Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)new DOMSource(docEl)).build();
                            if (WadlGenerator.LOG == null || !WadlGenerator.LOG.isLoggable(Level.FINER)) break block12;
                        }
                        catch (Exception loc) {
                            FFDCFilter.processException((Throwable)loc, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1355", (Object)this, (Object[])new Object[]{m, ui, href});
                            throw ExceptionUtils.toBadRequestException(null, null);
                        }
                        v0 = v0;
                        WadlGenerator.LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingResource", v0);
                    }
                    return v0;
                }
                break block13;
lbl37:
                // 1 sources

                if (this.stylesheetReference == null || !href.endsWith(".xsl")) break block13;
                is = ResourceUtils.getResourceStream((String)href, (Bus)m.getExchange().getBus());
                v1 = Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)is).build();
                if (WadlGenerator.LOG == null || !WadlGenerator.LOG.isLoggable(Level.FINER)) break block14;
                v1 = v1;
                WadlGenerator.LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingResource", v1);
            }
            return v1;
        }
        v2 = null;
        if (WadlGenerator.LOG != null && WadlGenerator.LOG.isLoggable(Level.FINER)) {
            v2 = v2;
            WadlGenerator.LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getExistingResource", v2);
        }
        return v2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleExistingDocRefs(List<Element> elements, String attrName, String parentDocLoc, String parentRef, Message m, UriInfo ui) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleExistingDocRefs", new Object[]{elements, attrName, parentDocLoc, parentRef, m, ui});
        }
        if (this.keepRelativeDocLinks) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleExistingDocRefs");
            }
            return;
        }
        int index = parentDocLoc.lastIndexOf(47);
        parentDocLoc = index == -1 ? parentDocLoc : parentDocLoc.substring(0, index + 1);
        index = parentRef.lastIndexOf(47);
        parentRef = index == -1 ? "" : parentRef.substring(0, index + 1);
        for (Element element : elements) {
            String href;
            String originalRef = href = element.getAttribute(attrName);
            if (StringUtils.isEmpty((String)href) || href.startsWith("#")) continue;
            int fragmentIndex = href.lastIndexOf(35);
            String fragment = null;
            if (fragmentIndex != -1) {
                fragment = href.substring(fragmentIndex + 1);
                href = href.substring(0, fragmentIndex);
            }
            String actualRef = parentRef + href;
            this.docLocationMap.put(actualRef, parentDocLoc + originalRef);
            UriBuilder ub = UriBuilder.fromUri((String)this.getBaseURI(m, ui)).path(actualRef).fragment(fragment);
            URI schemaURI = ub.build(new Object[0]);
            DOMUtils.setAttribute((Node)element, (String)attrName, (String)schemaURI.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleExistingDocRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void generateQName(StringBuilder sb, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, Class<?> type, boolean isCollection, Annotation[] annotations) {
        QName typeQName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "generateQName", new Object[]{sb, qnameResolver, clsMap, type, isCollection, annotations});
        }
        if (!isCollection && (typeQName = clsMap.get(type)) != null) {
            this.writeQName(sb, typeQName);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "generateQName");
            }
            return;
        }
        QName qname = qnameResolver.resolve(type, annotations, Collections.unmodifiableMap(clsMap));
        if (qname != null) {
            if (!isCollection) {
                this.writeQName(sb, qname);
                clsMap.put(type, qname);
            } else {
                XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
                String localPart = name != null ? JAXRSUtils.convertStringToQName((String)name.value()).getLocalPart() : qname.getLocalPart() + "s";
                QName collectionName = new QName(qname.getNamespaceURI(), localPart, qname.getPrefix());
                this.writeQName(sb, collectionName);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "generateQName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeQName(StringBuilder sb, QName qname) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "writeQName", new Object[]{sb, qname});
        }
        sb.append(" element=\"").append(qname.getPrefix()).append(':').append(qname.getLocalPart()).append('\"');
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "writeQName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isXmlRoot(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isXmlRoot", new Object[]{cls});
        }
        boolean bl = cls.getAnnotation(XmlRootElement.class) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isXmlRoot", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SchemaCollection getSchemaCollection(ResourceTypes resourceTypes, JAXBContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getSchemaCollection", new Object[]{resourceTypes, context});
        }
        if (context == null) {
            SchemaCollection schemaCollection = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaCollection = schemaCollection;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getSchemaCollection", schemaCollection);
            }
            return schemaCollection;
        }
        SchemaCollection xmlSchemaCollection = new SchemaCollection();
        HashSet<DOMSource> schemas = new HashSet<DOMSource>();
        ArrayList<String> targetNamespaces = new ArrayList<String>();
        try {
            for (DOMResult r : JAXBUtils.generateJaxbSchemas((JAXBContext)context, (Map)CastUtils.cast(Collections.emptyMap(), String.class, DOMResult.class))) {
                Map.Entry entry;
                Object typeName;
                Iterator tnsDecl;
                Document doc = (Document)r.getNode();
                ElementQNameResolver theResolver = this.createElementQNameResolver(context);
                String tns = doc.getDocumentElement().getAttribute("targetNamespace");
                String tnsPrefix = doc.getDocumentElement().lookupPrefix(tns);
                tnsPrefix = tnsPrefix == null ? ((tnsDecl = doc.getDocumentElement().getAttribute("xmlns:tns")) != null && ((String)((Object)tnsDecl)).equals(tns) ? "tns:" : "") : tnsPrefix + ":";
                if (this.supportJaxbXmlType) {
                    tnsDecl = resourceTypes.getAllTypes().keySet().iterator();
                    while (tnsDecl.hasNext()) {
                        XmlType root;
                        Class cls = (Class)tnsDecl.next();
                        if (this.isXmlRoot(cls) || (root = cls.getAnnotation(XmlType.class)) == null || (typeName = theResolver.resolve(cls, new Annotation[0], Collections.emptyMap())) == null || !tns.equals(((QName)typeName).getNamespaceURI())) continue;
                        Object elementName = (QName)resourceTypes.getXmlNameMap().get(cls);
                        if (elementName == null) {
                            elementName = typeName;
                        }
                        Element newElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        newElement.setAttribute("name", ((QName)elementName).getLocalPart());
                        newElement.setAttribute("type", tnsPrefix + ((QName)typeName).getLocalPart());
                        if (Modifier.isAbstract(cls.getModifiers()) && resourceTypes.getSubstitutions().values().contains(cls)) {
                            newElement.setAttribute("abstract", "true");
                        }
                        doc.getDocumentElement().appendChild(newElement);
                    }
                    if (this.supportJaxbSubstitutions) {
                        tnsDecl = resourceTypes.getSubstitutions().entrySet().iterator();
                        while (tnsDecl.hasNext()) {
                            entry = tnsDecl.next();
                            QName typeName2 = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap());
                            typeName = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"element").iterator();
                            while (typeName.hasNext()) {
                                QName groupName;
                                Element element = (Element)typeName.next();
                                if (!element.getAttribute("name").equals(typeName2.getLocalPart()) || (groupName = theResolver.resolve((Class)entry.getValue(), new Annotation[0], Collections.emptyMap())) == null) continue;
                                element.setAttribute("substitutionGroup", tnsPrefix + groupName.getLocalPart());
                            }
                        }
                    }
                }
                if (this.supportCollections && !resourceTypes.getCollectionMap().isEmpty()) {
                    tnsDecl = resourceTypes.getCollectionMap().entrySet().iterator();
                    while (tnsDecl.hasNext()) {
                        entry = tnsDecl.next();
                        QName colQName = (QName)entry.getValue();
                        if (colQName == null && (colQName = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap())) != null) {
                            colQName = new QName(colQName.getNamespaceURI(), colQName.getLocalPart() + "s", colQName.getPrefix());
                        }
                        if (colQName == null || !tns.equals(colQName.getNamespaceURI()) || (typeName = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap())) == null) continue;
                        Element newElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        newElement.setAttribute("name", colQName.getLocalPart());
                        Element ctElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                        newElement.appendChild(ctElement);
                        Element seqElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                        ctElement.appendChild(seqElement);
                        Element xsElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        seqElement.appendChild(xsElement);
                        xsElement.setAttribute("ref", tnsPrefix + ((QName)typeName).getLocalPart());
                        xsElement.setAttribute("minOccurs", "0");
                        xsElement.setAttribute("maxOccurs", "unbounded");
                        doc.getDocumentElement().appendChild(newElement);
                    }
                }
                DOMSource source = new DOMSource(doc, r.getSystemId());
                schemas.add(source);
                if (StringUtils.isEmpty((String)tns)) continue;
                targetNamespaces.add(tns);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1547", (Object)this, (Object[])new Object[]{resourceTypes, context});
            LOG.fine("No schema can be generated");
            SchemaCollection schemaCollection = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaCollection = schemaCollection;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getSchemaCollection", schemaCollection);
            }
            return schemaCollection;
        }
        boolean hackAroundEmptyNamespaceIssue = false;
        for (DOMSource r : schemas) {
            hackAroundEmptyNamespaceIssue = this.addSchemaDocument(xmlSchemaCollection, targetNamespaces, (Document)r.getNode(), r.getSystemId(), hackAroundEmptyNamespaceIssue);
        }
        SchemaCollection schemaCollection = xmlSchemaCollection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            schemaCollection = schemaCollection;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getSchemaCollection", schemaCollection);
        }
        return schemaCollection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getJaxbQName(String name, String namespace, Class<?> type, Map<Class<?>, QName> clsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", new Object[]{name, namespace, type, clsMap});
        }
        QName qname = this.getQNameFromParts(name, namespace, type, clsMap);
        if (qname != null) {
            QName qName = qname;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName);
            }
            return qName;
        }
        String ns = JAXBUtils.getPackageNamespace(type);
        if (ns != null) {
            QName qName = this.getQNameFromParts(name, ns, type, clsMap);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName);
            }
            return qName;
        }
        QName qName = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getJaxbQName(JAXBContextProxy jaxbProxy, Class<?> type, Map<Class<?>, QName> clsMap) {
        QName qName;
        block9: {
            JAXBBeanInfo jaxbInfo;
            block7: {
                QName qName2;
                block8: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", new Object[]{jaxbProxy, type, clsMap});
                    }
                    XmlRootElement root = type.getAnnotation(XmlRootElement.class);
                    if (root != null) {
                        QName qName3 = this.getJaxbQName(root.name(), root.namespace(), type, clsMap);
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            qName3 = qName3;
                            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName3);
                        }
                        return qName3;
                    }
                    try {
                        JAXBBeanInfo jAXBBeanInfo = jaxbInfo = jaxbProxy == null ? null : JAXBUtils.getBeanInfo((JAXBContextProxy)jaxbProxy, type);
                        if (jaxbInfo != null) break block7;
                        qName2 = null;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1588", (Object)this, (Object[])new Object[]{jaxbProxy, type, clsMap});
                        QName qName4 = null;
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            qName4 = qName4;
                            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName4);
                        }
                        return qName4;
                    }
                    qName2 = qName2;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName2);
                }
                return qName2;
            }
            Object instance = type.newInstance();
            qName = this.getQNameFromParts(jaxbInfo.getElementLocalName(instance), jaxbInfo.getElementNamespaceURI(instance), type, clsMap);
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getJaxbQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPrefix(String ns, Map<Class<?>, QName> clsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPrefix", new Object[]{ns, clsMap});
        }
        String prefix = null;
        int index = 0;
        for (QName name : clsMap.values()) {
            String currentPrefix = name.getPrefix();
            if (currentPrefix.startsWith(this.nsPrefix)) {
                int currentIndex;
                int n = currentIndex = currentPrefix.equals(this.nsPrefix) ? 0 : Integer.parseInt(currentPrefix.substring(this.nsPrefix.length()));
                if (currentIndex > index) {
                    index = currentIndex;
                }
            }
            if (!name.getNamespaceURI().equals(ns)) continue;
            prefix = currentPrefix;
            break;
        }
        if (StringUtils.isEmpty(prefix)) {
            prefix = index == 0 && !this.incrementNamespacePrefix ? this.nsPrefix : this.nsPrefix + (index + 1);
        }
        String string = prefix;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isFormRequest(OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isFormRequest", new Object[]{ori});
        }
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.FORM && (p.getType() != ParameterType.REQUEST_BODY || this.getMethod(ori).getParameterTypes()[p.getIndex()] != MultivaluedMap.class && AnnotationUtils.getAnnotation((Annotation[])this.getMethod(ori).getParameterAnnotations()[p.getIndex()], Multipart.class) == null)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isFormRequest", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isFormRequest", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class<?> getFormClass(OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getFormClass", new Object[]{ori});
        }
        List params = ori.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            if (!this.isFormParameter((Parameter)params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getFormClass", clazz);
            }
            return clazz;
        }
        Class<MultivaluedMap> clazz = MultivaluedMap.class;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getFormClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isFormParameter(Parameter pm, Class<?> type, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isFormParameter", new Object[]{pm, type, anns});
        }
        boolean bl = ParameterType.FORM == pm.getType() || ParameterType.REQUEST_BODY == pm.getType() && AnnotationUtils.getAnnotation((Annotation[])anns, Multipart.class) != null && (InjectionUtils.isPrimitive(type) || type == InputStream.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "isFormParameter", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean addSchemaDocument(SchemaCollection col, List<String> tnsList, Document d, String systemId, boolean hackAroundEmptyNamespaceIssue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addSchemaDocument", new Object[]{col, tnsList, d, systemId, hackAroundEmptyNamespaceIssue});
        }
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty((String)ns)) {
            if (DOMUtils.getFirstElement((Node)d.getDocumentElement()) == null) {
                boolean bl = hackAroundEmptyNamespaceIssue = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addSchemaDocument", bl);
                }
                return bl;
            }
            d = this.copy(d);
            ns = tnsList.isEmpty() ? "" : tnsList.get(0);
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        if (hackAroundEmptyNamespaceIssue) {
            d = this.doEmptyNamespaceHack(d);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !"import".equals((e = (Element)n).getLocalName())) continue;
            e.removeAttribute("schemaLocation");
        }
        Document document = d;
        synchronized (document) {
            col.read(d, systemId);
        }
        boolean bl = hackAroundEmptyNamespaceIssue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addSchemaDocument", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Document doEmptyNamespaceHack(Document d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doEmptyNamespaceHack", new Object[]{d});
        }
        boolean hasStuffToRemove = false;
        Element el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
        while (el != null) {
            if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                hasStuffToRemove = true;
                break;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        if (hasStuffToRemove) {
            d = this.copy(d);
            el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
            while (el != null) {
                if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                    d.getDocumentElement().removeChild(el);
                    el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
                    continue;
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        Document document = d;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "doEmptyNamespaceHack", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Document copy(Document doc) {
        Document document;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "copy", new Object[]{doc});
            }
            try {
                document = StaxUtils.copy((Document)doc);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (ParserConfigurationException | XMLStreamException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1716", (Object)this, (Object[])new Object[]{doc});
                Document document2 = doc;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    document2 = document2;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "copy", document2);
                }
                return document2;
            }
            document = document;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "copy", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getQNameFromParts(String name, String namespace, Class<?> type, Map<Class<?>, QName> clsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getQNameFromParts", new Object[]{name, namespace, type, clsMap});
        }
        if (namespace == null || "##default".equals(namespace) || namespace.length() == 0) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getQNameFromParts", qName);
            }
            return qName;
        }
        if (name == null || name.length() == 0) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getQNameFromParts", qName);
            }
            return qName;
        }
        if ("##default".equals(name)) {
            name = StringUtils.uncapitalize((String)type.getSimpleName());
        }
        String prefix = this.getPrefix(namespace, clsMap);
        QName qName = new QName(namespace, name, prefix);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getQNameFromParts", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreMessageWriters(boolean ignoreMessageWriters) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreMessageWriters", new Object[]{ignoreMessageWriters});
        }
        this.ignoreMessageWriters = ignoreMessageWriters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreMessageWriters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleApplicationDocs(StringBuilder sbApp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleApplicationDocs", new Object[]{sbApp});
        }
        if (this.applicationTitle != null) {
            sbApp.append("<doc title=\"").append(this.xmlEncodeIfNeeded(this.applicationTitle)).append("\"/>");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleApplicationDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleClassJavaDocs(ClassResourceInfo cri, StringBuilder sb) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleClassJavaDocs", new Object[]{cri, sb});
        }
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getClassDoc(cri));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleClassJavaDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleOperJavaDocs(OperationResourceInfo ori, StringBuilder sb) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperJavaDocs", new Object[]{ori, sb});
        }
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodDoc(ori));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperJavaDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleOperResponseJavaDocs(OperationResourceInfo ori, StringBuilder sb) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperResponseJavaDocs", new Object[]{ori, sb});
        }
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodResponseDoc(ori));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperResponseJavaDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleOperParamJavaDocs(OperationResourceInfo ori, int paramIndex, StringBuilder sb) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperParamJavaDocs", new Object[]{ori, paramIndex, sb});
        }
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodParameterDoc(ori, paramIndex));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleOperParamJavaDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addProvidedDocs(StringBuilder sb, String text) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addProvidedDocs", new Object[]{sb, text});
        }
        if (!StringUtils.isEmpty((String)text)) {
            sb.append("<doc>");
            sb.append(this.xmlEncodeIfNeeded(text));
            sb.append("</doc>");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "addProvidedDocs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean handleDocs(Annotation[] anns, StringBuilder sb, String category, boolean allowDefault, boolean isJson) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleDocs", new Object[]{anns, sb, category, allowDefault, isJson});
        }
        boolean found = false;
        for (Annotation a : anns) {
            String path;
            InputStream is;
            Description d;
            if (a.annotationType() == Descriptions.class) {
                Descriptions ds = (Descriptions)a;
                boolean bl = this.handleDocs(ds.value(), sb, category, allowDefault, isJson);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleDocs", bl);
                }
                return bl;
            }
            if (a.annotationType() != Description.class || (d = (Description)a).target().length() == 0 && !allowDefault || d.target().length() > 0 && !d.target().equals(category)) continue;
            sb.append("<doc");
            if (!isJson && d.lang().length() > 0) {
                sb.append(" xml:lang=\"").append(d.lang()).append('\"');
            }
            if (d.title().length() > 0) {
                sb.append(" title=\"").append(this.xmlEncodeIfNeeded(d.title())).append('\"');
            }
            sb.append('>');
            if (d.value().length() > 0) {
                sb.append(this.xmlEncodeIfNeeded(d.value()));
            } else if (d.docuri().length() > 0 && d.docuri().startsWith(CLASSPATH_PREFIX) && (is = ResourceUtils.getClasspathResourceStream((String)(path = d.docuri().substring(CLASSPATH_PREFIX.length())), SchemaHandler.class, (Bus)(this.bus == null ? BusFactory.getDefaultBus() : this.bus))) != null) {
                try {
                    sb.append(IOUtils.toString((InputStream)is));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1817", (Object)this, (Object[])new Object[]{anns, sb, category, allowDefault, isJson});
                }
            }
            sb.append("</doc>");
            found = true;
        }
        boolean bl = found;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "handleDocs", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getNamespace() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getNamespace", new Object[0]);
        }
        String string = this.wadlNamespace != null ? this.wadlNamespace : WADL_NS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getNamespace", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWadlNamespace(String namespace) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setWadlNamespace", new Object[]{namespace});
        }
        this.wadlNamespace = namespace;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setWadlNamespace");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSingleResourceMultipleMethods(boolean singleResourceMultipleMethods) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSingleResourceMultipleMethods", new Object[]{singleResourceMultipleMethods});
        }
        this.singleResourceMultipleMethods = singleResourceMultipleMethods;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSingleResourceMultipleMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUseSingleSlashResource(boolean useSingleSlashResource) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUseSingleSlashResource", new Object[]{useSingleSlashResource});
        }
        this.useSingleSlashResource = useSingleSlashResource;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUseSingleSlashResource");
        }
    }

    @Deprecated
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLinkJsonToXmlSchema(boolean link) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setLinkJsonToXmlSchema", new Object[]{link});
        }
        this.setLinkAnyMediaTypeToXmlSchema(link);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setLinkJsonToXmlSchema");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLinkAnyMediaTypeToXmlSchema(boolean link) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setLinkAnyMediaTypeToXmlSchema", new Object[]{link});
        }
        this.linkAnyMediaTypeToXmlSchema = link;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setLinkAnyMediaTypeToXmlSchema");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSchemaLocations(List<String> locations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSchemaLocations", new Object[]{locations});
        }
        this.externalQnamesMap = new HashMap<String, List<String>>();
        this.externalSchemasCache = new ArrayList<String>(locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            String loc = locations.get(i);
            try {
                this.loadSchemasIntoCache(loc);
                continue;
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1861", (Object)this, (Object[])new Object[]{locations});
                LOG.warning("No schema resource " + loc + " can be loaded : " + ex.getMessage());
                this.externalSchemasCache = null;
                this.externalQnamesMap = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSchemaLocations");
                }
                return;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSchemaLocations");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void loadSchemasIntoCache(String loc) throws Exception {
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "loadSchemasIntoCache", new Object[]{loc});
            }
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)(this.bus == null ? BusFactory.getDefaultBus() : this.bus));
            if (is == null) {
                if (LOG == null) return;
                if (!LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "loadSchemasIntoCache");
                return;
            }
            ByteArrayInputStream bis = IOUtils.loadIntoBAIS((InputStream)is);
            try {
                XMLSource source = new XMLSource((InputStream)bis);
                source.setBuffering();
                String targetNs = source.getValue("/*/@targetNamespace");
                Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
                String[] elementNames = source.getValues("/*/xs:element/@name", nsMap);
                this.externalQnamesMap.put(targetNs, Arrays.asList(elementNames));
                String schemaValue = (String)source.getNode("/xs:schema", nsMap, String.class);
                this.externalSchemasCache.add(schemaValue);
                if (bis == null) break block6;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1876", (Object)this, (Object[])new Object[]{loc});
                if (bis == null) throw throwable;
                try {
                    bis.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1876", (Object)this, (Object[])new Object[]{loc});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            bis.close();
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "loadSchemasIntoCache");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUseJaxbContextForQnames(boolean checkJaxbOnly) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUseJaxbContextForQnames", new Object[]{checkJaxbOnly});
        }
        this.useJaxbContextForQnames = checkJaxbOnly;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUseJaxbContextForQnames");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ElementQNameResolver createElementQNameResolver(JAXBContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", new Object[]{context});
        }
        if (this.resolver != null) {
            ElementQNameResolver elementQNameResolver = this.resolver;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                elementQNameResolver = elementQNameResolver;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", elementQNameResolver);
            }
            return elementQNameResolver;
        }
        if (this.useJaxbContextForQnames) {
            if (context != null) {
                JAXBContextProxy proxy = JAXBUtils.createJAXBContextProxy((JAXBContext)context);
                JaxbContextQNameResolver jaxbContextQNameResolver = new JaxbContextQNameResolver(proxy);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    jaxbContextQNameResolver = jaxbContextQNameResolver;
                    LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", jaxbContextQNameResolver);
                }
                return jaxbContextQNameResolver;
            }
            ElementQNameResolver elementQNameResolver = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                elementQNameResolver = elementQNameResolver;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", elementQNameResolver);
            }
            return elementQNameResolver;
        }
        if (this.externalQnamesMap != null) {
            SchemaQNameResolver schemaQNameResolver = new SchemaQNameResolver(this.externalQnamesMap);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaQNameResolver = schemaQNameResolver;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", schemaQNameResolver);
            }
            return schemaQNameResolver;
        }
        XMLNameQNameResolver xMLNameQNameResolver = new XMLNameQNameResolver();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLNameQNameResolver = xMLNameQNameResolver;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createElementQNameResolver", xMLNameQNameResolver);
        }
        return xMLNameQNameResolver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SchemaWriter createSchemaWriter(ResourceTypes resourceTypes, JAXBContext context, UriInfo ui) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createSchemaWriter", new Object[]{resourceTypes, context, ui});
        }
        if (this.externalSchemaLinks != null && this.externalSchemasCache == null) {
            ExternalSchemaWriter externalSchemaWriter = new ExternalSchemaWriter(this.externalSchemaLinks, ui);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                externalSchemaWriter = externalSchemaWriter;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createSchemaWriter", externalSchemaWriter);
            }
            return externalSchemaWriter;
        }
        if (this.externalSchemasCache != null) {
            StringSchemaWriter stringSchemaWriter = new StringSchemaWriter(this.externalSchemasCache, this.externalSchemaLinks, ui);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                stringSchemaWriter = stringSchemaWriter;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createSchemaWriter", stringSchemaWriter);
            }
            return stringSchemaWriter;
        }
        SchemaCollection coll = this.getSchemaCollection(resourceTypes, context);
        if (coll != null) {
            SchemaCollectionWriter schemaCollectionWriter = new SchemaCollectionWriter(coll);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaCollectionWriter = schemaCollectionWriter;
                LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createSchemaWriter", schemaCollectionWriter);
            }
            return schemaCollectionWriter;
        }
        SchemaWriter schemaWriter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            schemaWriter = schemaWriter;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "createSchemaWriter", schemaWriter);
        }
        return schemaWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExternalLinks(List<String> externalLinks) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setExternalLinks", new Object[]{externalLinks});
        }
        this.externalSchemaLinks = new LinkedList<URI>();
        for (String s : externalLinks) {
            try {
                String href = s;
                if (href.startsWith(CLASSPATH_PREFIX)) {
                    int index = href.lastIndexOf(47);
                    href = index == -1 ? href.substring(9) : href.substring(index + 1);
                    this.docLocationMap.put(href, s);
                }
                this.externalSchemaLinks.add(URI.create(href));
            }
            catch (Exception href) {
                FFDCFilter.processException((Throwable)href, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator", (String)"1937", (Object)this, (Object[])new Object[]{externalLinks});
                LOG.warning("Not a valid URI : " + s);
                this.externalSchemaLinks = null;
                break;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setExternalLinks");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setResolver(ElementQNameResolver resolver) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResolver", new Object[]{resolver});
        }
        this.resolver = resolver;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResolver");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPrivateAddresses(List<String> privateAddresses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setPrivateAddresses", new Object[]{privateAddresses});
        }
        this.privateAddresses = privateAddresses;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setPrivateAddresses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getPrivateAddresses() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPrivateAddresses", new Object[0]);
        }
        List<String> list = this.privateAddresses;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getPrivateAddresses", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAddResourceAndMethodIds(boolean addResourceAndMethodIds) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setAddResourceAndMethodIds", new Object[]{addResourceAndMethodIds});
        }
        ResourceIdGeneratorImpl idGen = addResourceAndMethodIds ? new ResourceIdGeneratorImpl() : null;
        this.setResourceIdGenerator(idGen);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setAddResourceAndMethodIds");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setResourceIdGenerator(ResourceIdGenerator idGen) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResourceIdGenerator", new Object[]{idGen});
        }
        this.idGenerator = idGen;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setResourceIdGenerator");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Method getMethod(OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getMethod", new Object[]{ori});
        }
        Method annMethod = ori.getAnnotatedMethod();
        Method method = annMethod != null ? annMethod : ori.getMethodToInvoke();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setApplicationTitle(String applicationTitle) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setApplicationTitle", new Object[]{applicationTitle});
        }
        this.applicationTitle = applicationTitle;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setApplicationTitle");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setNamespacePrefix(String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setNamespacePrefix", new Object[]{prefix});
        }
        this.nsPrefix = prefix;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setNamespacePrefix");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreForwardSlash(boolean ignoreForwardSlash) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreForwardSlash", new Object[]{ignoreForwardSlash});
        }
        this.ignoreForwardSlash = ignoreForwardSlash;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreForwardSlash");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreRequests(boolean ignoreRequests) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreRequests", new Object[]{ignoreRequests});
        }
        this.ignoreRequests = ignoreRequests;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreRequests");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSupportCollections(boolean support) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportCollections", new Object[]{support});
        }
        this.supportCollections = support;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportCollections");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDefaultMediaType(String mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDefaultMediaType", new Object[]{mt});
        }
        this.defaultWadlResponseMediaType = JAXRSUtils.toMediaType((String)mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDefaultMediaType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDefaultRepresentationMediaType(String mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDefaultRepresentationMediaType", new Object[]{mt});
        }
        this.defaultWadlResponseMediaType = JAXRSUtils.toMediaType((String)mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDefaultRepresentationMediaType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSupportJaxbXmlType(boolean supportJaxbXmlType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportJaxbXmlType", new Object[]{supportJaxbXmlType});
        }
        this.supportJaxbXmlType = supportJaxbXmlType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportJaxbXmlType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSupportJaxbSubstitutions(boolean supportJaxbSubstitutions) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportJaxbSubstitutions", new Object[]{supportJaxbSubstitutions});
        }
        this.supportJaxbSubstitutions = supportJaxbSubstitutions;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setSupportJaxbSubstitutions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setCheckAbsolutePathSlash(boolean checkAbsolutePathSlash) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setCheckAbsolutePathSlash", new Object[]{checkAbsolutePathSlash});
        }
        this.checkAbsolutePathSlash = checkAbsolutePathSlash;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setCheckAbsolutePathSlash");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJavaDocPath(String path) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocPath", new Object[]{path});
        }
        this.setDocumentationProvider((DocumentationProvider)new JavaDocProvider(this.bus == null ? BusFactory.getDefaultBus() : this.bus, new String[]{path}));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocPath");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJavaDocPaths(String ... paths) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocPaths", new Object[]{paths});
        }
        this.setDocumentationProvider((DocumentationProvider)new JavaDocProvider(this.bus == null ? BusFactory.getDefaultBus() : this.bus, paths));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocPaths");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJavaDocURLs(URL[] javaDocURLs) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocURLs", new Object[]{javaDocURLs});
        }
        this.setDocumentationProvider((DocumentationProvider)new JavaDocProvider(javaDocURLs));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJavaDocURLs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDocumentationProvider(DocumentationProvider p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDocumentationProvider", new Object[]{p});
        }
        this.docProviders.add(p);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDocumentationProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDocumentationProvider(List<DocumentationProvider> ps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDocumentationProvider", new Object[]{ps});
        }
        this.docProviders.addAll(ps);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setDocumentationProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setStylesheetReference(String stylesheetReference) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setStylesheetReference", new Object[]{stylesheetReference});
        }
        this.stylesheetReference = stylesheetReference;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setStylesheetReference");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWadlSchemaLocation(String loc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setWadlSchemaLocation", new Object[]{loc});
        }
        this.wadlSchemaLocation = loc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setWadlSchemaLocation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIncludeDefaultWadlSchemaLocation(boolean inc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIncludeDefaultWadlSchemaLocation", new Object[]{inc});
        }
        if (inc) {
            this.setWadlSchemaLocation(DEFAULT_WADL_SCHEMA_LOC);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIncludeDefaultWadlSchemaLocation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreOverloadedMethods(boolean ignore) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreOverloadedMethods", new Object[]{ignore});
        }
        this.ignoreOverloadedMethods = ignore;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIgnoreOverloadedMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setKeepRelativeDocLinks(boolean keepRelativeDocLinks) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setKeepRelativeDocLinks", new Object[]{keepRelativeDocLinks});
        }
        this.keepRelativeDocLinks = keepRelativeDocLinks;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setKeepRelativeDocLinks");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setApplyStylesheetLocally(boolean applyStylesheetLocally) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setApplyStylesheetLocally", new Object[]{applyStylesheetLocally});
        }
        this.applyStylesheetLocally = applyStylesheetLocally;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setApplyStylesheetLocally");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUsePathParamsToCompareOperations(boolean usePathParamsToCompareOperations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUsePathParamsToCompareOperations", new Object[]{usePathParamsToCompareOperations});
        }
        this.usePathParamsToCompareOperations = usePathParamsToCompareOperations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setUsePathParamsToCompareOperations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setConvertResourcesToDOM(boolean convertResourcesToDOM) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setConvertResourcesToDOM", new Object[]{convertResourcesToDOM});
        }
        this.convertResourcesToDOM = convertResourcesToDOM;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setConvertResourcesToDOM");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIncrementNamespacePrefix(boolean incrementNamespacePrefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIncrementNamespacePrefix", new Object[]{incrementNamespacePrefix});
        }
        this.incrementNamespacePrefix = incrementNamespacePrefix;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setIncrementNamespacePrefix");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJaxbContextProperties(Map<String, Object> jaxbContextProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJaxbContextProperties", new Object[]{jaxbContextProperties});
        }
        this.jaxbContextProperties = jaxbContextProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setJaxbContextProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getAllowList() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getAllowList", new Object[0]);
        }
        List<String> list = this.allowList;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "getAllowList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAllowList(List<String> allowList) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setAllowList", new Object[]{allowList});
        }
        this.allowList = allowList;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", "setAllowList");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        PARAMETER_TYPE_MAP.put(ParameterType.FORM, FormParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.QUERY, QueryParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.HEADER, HeaderParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.PATH, PathParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.MATRIX, MatrixParam.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ResourceIdGeneratorImpl
    implements ResourceIdGenerator {
        static final long serialVersionUID = -376097843667002009L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ResourceIdGeneratorImpl() {
        }

        @Override
        public String getClassResourceId(ClassResourceInfo cri) {
            Class serviceClass = cri != null ? cri.getServiceClass() : Object.class;
            QName jaxbQname = null;
            if (WadlGenerator.this.useJaxbContextForQnames) {
                jaxbQname = WadlGenerator.this.getJaxbQName(null, serviceClass, new HashMap(0));
            }
            String pName = jaxbQname == null ? PackageUtils.getPackageName((Class)serviceClass) : null;
            String localName = jaxbQname == null ? serviceClass.getSimpleName() : jaxbQname.getLocalPart();
            String nsName = jaxbQname == null ? pName + "." : "";
            return nsName + localName;
        }

        @Override
        public String getMethodResourceId(OperationResourceInfo ori) {
            return WadlGenerator.this.getMethod(ori).getName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$ResourceIdGeneratorImpl", ResourceIdGeneratorImpl.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SchemaConverter
    extends DelegatingXMLStreamWriter {
        private static final String SCHEMA_LOCATION = "schemaLocation";
        private final Map<String, String> locsMap;
        static final long serialVersionUID = 7184255330055625977L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SchemaConverter(XMLStreamWriter writer, Map<String, String> locsMap) {
            super(writer);
            this.locsMap = locsMap;
        }

        public void writeAttribute(String local, String value) throws XMLStreamException {
            if (SCHEMA_LOCATION.equals(local) && this.locsMap.containsKey(value)) {
                value = this.locsMap.get(value);
            }
            super.writeAttribute(local, value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$SchemaConverter", SchemaConverter.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class SchemaQNameResolver
    implements ElementQNameResolver {
        private final Map<String, List<String>> map;
        static final long serialVersionUID = -556204580679485020L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SchemaQNameResolver(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            String name = type.getSimpleName();
            for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
                String elementName = null;
                if (entry.getValue().contains(name)) {
                    elementName = name;
                } else if (entry.getValue().contains(name.toLowerCase())) {
                    elementName = name.toLowerCase();
                }
                if (elementName == null) continue;
                return WadlGenerator.this.getQNameFromParts(elementName, entry.getKey(), type, clsMap);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$SchemaQNameResolver", SchemaQNameResolver.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class XMLNameQNameResolver
    implements ElementQNameResolver {
        static final long serialVersionUID = 6878512228821296215L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private XMLNameQNameResolver() {
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
            if (name == null) {
                name = type.getAnnotation(XMLName.class);
            }
            if (name != null) {
                QName qname = DOMUtils.convertStringToQName((String)name.value(), (String)name.prefix());
                if (qname.getPrefix().length() > 0) {
                    return qname;
                }
                return WadlGenerator.this.getQNameFromParts(qname.getLocalPart(), qname.getNamespaceURI(), type, clsMap);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$XMLNameQNameResolver", XMLNameQNameResolver.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JaxbContextQNameResolver
    implements ElementQNameResolver {
        private final JAXBContextProxy proxy;
        static final long serialVersionUID = 950642659820253547L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JaxbContextQNameResolver(JAXBContextProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XmlType root;
            QName qname = WadlGenerator.this.getJaxbQName(this.proxy, type, clsMap);
            if (qname == null && WadlGenerator.this.supportJaxbXmlType && (root = type.getAnnotation(XmlType.class)) != null) {
                XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
                if (name == null) {
                    qname = WadlGenerator.this.getJaxbQName(root.name(), root.namespace(), type, clsMap);
                } else {
                    QName tempQName = JAXRSUtils.convertStringToQName((String)name.value());
                    qname = new QName(tempQName.getNamespaceURI(), tempQName.getLocalPart(), WadlGenerator.this.getPrefix(tempQName.getNamespaceURI(), clsMap));
                }
            }
            return qname;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$JaxbContextQNameResolver", JaxbContextQNameResolver.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ExternalSchemaWriter
    implements SchemaWriter {
        private final List<URI> links;
        private final UriInfo uriInfo;
        static final long serialVersionUID = 6415019477475764761L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ExternalSchemaWriter(List<URI> links, UriInfo ui) {
            this.links = links;
            this.uriInfo = ui;
        }

        @Override
        public void write(StringBuilder sb) {
            for (URI link : this.links) {
                try {
                    URI value = link.isAbsolute() ? link : this.uriInfo.getBaseUriBuilder().path(link.toString()).build(new Object[0]);
                    sb.append("<include href=\"").append(value.toString()).append("\"/>");
                }
                catch (Exception value) {
                    FFDCFilter.processException((Throwable)value, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$ExternalSchemaWriter", (String)"2063", (Object)this, (Object[])new Object[]{sb});
                    LOG.warning("WADL grammar section will be incomplete, this link is not a valid URI : " + link.toString());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$ExternalSchemaWriter", ExternalSchemaWriter.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class SchemaCollectionWriter
    implements SchemaWriter {
        private final SchemaCollection coll;
        static final long serialVersionUID = 8850541760990532107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SchemaCollectionWriter(SchemaCollection coll) {
            this.coll = coll;
        }

        @Override
        public void write(StringBuilder sb) {
            for (XmlSchema xs : this.coll.getXmlSchemas()) {
                if (xs.getItems().isEmpty() || "http://www.w3.org/2001/XMLSchema".equals(xs.getTargetNamespace())) continue;
                StringWriter writer = new StringWriter();
                xs.write((Writer)writer);
                sb.append(writer.toString());
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$SchemaCollectionWriter", SchemaCollectionWriter.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StringSchemaWriter
    implements SchemaWriter {
        private final List<String> theSchemas = new LinkedList<String>();
        static final long serialVersionUID = 1974926171322156664L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        StringSchemaWriter(List<String> schemas, List<URI> links, UriInfo ui) {
            for (String s : schemas) {
                XMLSource source = new XMLSource((InputStream)new ByteArrayInputStream(s.getBytes()));
                source.setBuffering();
                Map<String, String> locs = this.getLocationsMap(source, "import", links, ui);
                locs.putAll(this.getLocationsMap(source, "include", links, ui));
                String actualSchema = !locs.isEmpty() ? this.transformSchema(s, locs) : s;
                this.theSchemas.add(actualSchema);
            }
        }

        private Map<String, String> getLocationsMap(XMLSource source, String elementName, List<URI> links, UriInfo ui) {
            Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
            String[] locations = source.getValues("/*/xs:" + elementName + "/@schemaLocation", nsMap);
            HashMap<String, String> locs = new HashMap<String, String>();
            if (locations == null) {
                return locs;
            }
            for (String loc : locations) {
                try {
                    URI uri = URI.create(loc);
                    if (uri.isAbsolute()) continue;
                    if (links != null) {
                        for (URI overwriteURI : links) {
                            if (!overwriteURI.toString().endsWith(loc)) continue;
                            if (overwriteURI.isAbsolute()) {
                                locs.put(loc, overwriteURI.toString());
                                break;
                            }
                            locs.put(loc, ui.getBaseUriBuilder().path(overwriteURI.toString()).build(new Object[0]).toString());
                            break;
                        }
                    }
                    if (locs.containsKey(loc)) continue;
                    locs.put(loc, ui.getBaseUriBuilder().path(loc).build(new Object[0]).toString());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$StringSchemaWriter", (String)"1997", (Object)this, (Object[])new Object[]{source, elementName, links, ui});
                }
            }
            return locs;
        }

        private String transformSchema(String schema, Map<String, String> locs) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SchemaConverter sc = new SchemaConverter(StaxUtils.createXMLStreamWriter((OutputStream)bos), locs);
            try {
                StaxUtils.copy((Source)new StreamSource(new StringReader(schema)), (XMLStreamWriter)((Object)sc));
                sc.flush();
                sc.close();
                return bos.toString();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$StringSchemaWriter", (String)"2012", (Object)this, (Object[])new Object[]{schema, locs});
                return schema;
            }
        }

        @Override
        public void write(StringBuilder sb) {
            for (String s : this.theSchemas) {
                sb.append(s);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.wadl.WadlGenerator$StringSchemaWriter", StringSchemaWriter.class, null, null);
        }
    }

    protected static interface SchemaWriter {
        public void write(StringBuilder var1);
    }
}

