/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.common.http.AuthUtils;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.utils.MicroProfileJwtTaiRequest;
import com.ibm.ws.security.mp.jwt.tai.MicroProfileJwtTAI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIRequestHelper {
    private static TraceComponent tc = Tr.register(TAIRequestHelper.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    public static final String ATTRIBUTE_TAI_REQUEST = "MPJwtTaiRequest";
    private static final String Authorization_Header = "Authorization";
    private static final String APPLICATION_AUTH_METHOD = "com.ibm.ws.security.tai.appAuthType";
    public static final String REQ_METHOD_POST = "POST";
    public static final String REQ_CONTENT_TYPE_NAME = "Content-Type";
    public static final String REQ_CONTENT_TYPE_APP_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTHN_TYPE = "MP-JWT";
    public static final String KEY_AUTHORIZATION_HEADER_SCHEME = "authorizationHeaderScheme";
    private final AuthUtils authUtils = new AuthUtils();
    private Map<String, String> mpConfigProps = null;
    static final long serialVersionUID = 5699309533885708761L;

    public void setMpConfigProperties(Map<String, String> mpConfigProps) {
        if (mpConfigProps != null) {
            this.mpConfigProps = new HashMap<String, String>(mpConfigProps);
        }
    }

    @ManualTrace
    public MicroProfileJwtTaiRequest createMicroProfileJwtTaiRequestAndSetRequestAttribute(HttpServletRequest request) {
        String methodName = "createMicroProfileJwtTaiRequestAndSetRequestAttribute";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request});
        }
        MicroProfileJwtTaiRequest mpJwtTaiRequest = new MicroProfileJwtTaiRequest(request);
        request.setAttribute(ATTRIBUTE_TAI_REQUEST, (Object)mpJwtTaiRequest);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
        }
        return mpJwtTaiRequest;
    }

    @ManualTrace
    public boolean requestShouldBeHandledByTAI(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String methodName = "requestShouldBeHandledByTAI";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        mpJwtTaiRequest = this.setTaiRequestConfigInfo(request, mpJwtTaiRequest, this.isNewMpJwtAndMpConfig());
        boolean result = false;
        boolean ignoreAppAuthMethod = true;
        MicroProfileJwtConfig mpJwtConfig = null;
        try {
            mpJwtConfig = mpJwtTaiRequest.getOnlyMatchingConfig();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            FFDCFilter.processException((Throwable)mpJwtProcessingException, (String)"com.ibm.ws.security.mp.jwt.tai.TAIRequestHelper", (String)"97", (Object)this, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        if (mpJwtConfig != null) {
            if (this.shouldDeferToJwtSso(request, mpJwtConfig, mpJwtTaiRequest.getJwtSsoConfig())) {
                return false;
            }
            ignoreAppAuthMethod = mpJwtConfig.ignoreApplicationAuthMethod();
            result = ignoreAppAuthMethod ? mpJwtTaiRequest.hasServices() : this.isMpJwtSpecifiedInLoginConfig(request);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        if (result) {
            request.setAttribute(KEY_AUTHORIZATION_HEADER_SCHEME, (Object)mpJwtConfig.getAuthorizationHeaderScheme());
        }
        return result;
    }

    private boolean isNewMpJwtAndMpConfig() {
        boolean newMpjwtAndMpConfig = false;
        if (this.mpConfigProps != null && !this.mpConfigProps.isEmpty()) {
            newMpjwtAndMpConfig = true;
        }
        return newMpjwtAndMpConfig;
    }

    private boolean shouldDeferToJwtSso(HttpServletRequest req, MicroProfileJwtConfig config, MicroProfileJwtConfig jwtssoConfig) {
        if (!this.isJwtSsoFeatureActive(config) && jwtssoConfig == null) {
            return false;
        }
        String hdrValue = req.getHeader(Authorization_Header);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authorization header=", (Object[])new Object[]{hdrValue});
        }
        boolean haveValidBearerHeader = hdrValue != null && hdrValue.startsWith("Bearer ");
        return !haveValidBearerHeader;
    }

    public boolean isJwtSsoFeatureActive(MicroProfileJwtConfig config) {
        return config.toString().contains("com.ibm.ws.security.jwtsso.internal.JwtSsoComponent");
    }

    private boolean isMpJwtSpecifiedInLoginConfig(HttpServletRequest request) {
        if (request.getAttribute(APPLICATION_AUTH_METHOD) != null) {
            String loginCfg = (String)request.getAttribute(APPLICATION_AUTH_METHOD);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Auth method = ", (Object[])new Object[]{loginCfg});
                Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{AUTHN_TYPE.equals(loginCfg)});
            }
            if (!AUTHN_TYPE.equals(loginCfg)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NOT_FOUND_IN_APPLICATION", (Object[])new Object[]{AUTHN_TYPE, loginCfg, "ignoreApplicationAuthMethod", "false"});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{msg});
                }
            }
            return AUTHN_TYPE.equals(loginCfg);
        }
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NOT_FOUND_IN_APPLICATION", (Object[])new Object[]{AUTHN_TYPE, "null", "ignoreApplicationAuthMethod", "false"});
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{msg});
        }
        return false;
    }

    @ManualTrace
    public String getBearerToken(HttpServletRequest req, MicroProfileJwtConfig clientConfig) {
        String token;
        String methodName = "getBearerToken";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req, clientConfig});
        }
        if ((token = this.getBearerTokenFromHeader(req, clientConfig)) == null) {
            token = this.getBearerTokenFromParameter(req);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }

    @ManualTrace
    String getBearerTokenFromHeader(HttpServletRequest req, MicroProfileJwtConfig clientConfig) {
        String methodName = "getBearerTokenFromHeader";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req});
        }
        String token = null;
        String tokenHeaderName = this.getTokenHeaderName(clientConfig);
        token = "Cookie".equals(tokenHeaderName) ? this.getTokenFromCookie(req, clientConfig) : this.getTokenFromHeader(tokenHeaderName, req);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }

    String getTokenHeaderName(MicroProfileJwtConfig clientConfig) {
        String serverConfigTokenHeader = clientConfig.getTokenHeader();
        if (serverConfigTokenHeader != null) {
            return serverConfigTokenHeader;
        }
        String defaultValue = Authorization_Header;
        String tokenHeaderName = this.getValueFromMpConfigProps("mp.jwt.token.header", defaultValue);
        if (!this.isSupportedTokenHeaderName(tokenHeaderName)) {
            Tr.warning((TraceComponent)tc, (String)"MP_CONFIG_VALUE_NOT_SUPPORTED", (Object[])new Object[]{tokenHeaderName, "mp.jwt.token.header", this.getSupportedTokenHeaderNames(), defaultValue});
            return defaultValue;
        }
        return tokenHeaderName;
    }

    String getValueFromMpConfigProps(String propName, String defaultValue) {
        if (this.mpConfigProps == null) {
            return defaultValue;
        }
        String mpConfigPropValue = this.mpConfigProps.get(propName);
        if (mpConfigPropValue == null || mpConfigPropValue.isEmpty()) {
            return defaultValue;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Obtained " + propName + " from MP Config properties: [" + mpConfigPropValue + "]"), (Object[])new Object[0]);
        }
        return mpConfigPropValue;
    }

    boolean isSupportedTokenHeaderName(String tokenHeader) {
        List<String> supportedNames = this.getSupportedTokenHeaderNames();
        return supportedNames.contains(tokenHeader);
    }

    List<String> getSupportedTokenHeaderNames() {
        ArrayList<String> supportedNames = new ArrayList<String>();
        supportedNames.add(Authorization_Header);
        supportedNames.add("Cookie");
        return supportedNames;
    }

    @Sensitive
    String getTokenFromCookie(HttpServletRequest req, MicroProfileJwtConfig clientConfig) {
        String tokenCookieName = this.getTokenCookieName(clientConfig);
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equals(tokenCookieName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a " + tokenCookieName + " cookie as expected"), (Object[])new Object[0]);
                }
                return cookie.getValue();
            }
        }
        return null;
    }

    String getTokenCookieName(MicroProfileJwtConfig clientConfig) {
        String serverConfigCookieName = clientConfig.getCookieName();
        if (serverConfigCookieName != null) {
            return serverConfigCookieName;
        }
        return this.getValueFromMpConfigProps("mp.jwt.token.cookie", "Bearer");
    }

    @Sensitive
    String getTokenFromHeader(String tokenHeaderName, HttpServletRequest req) {
        String hdrValue = req.getHeader(tokenHeaderName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(tokenHeaderName + " header null? "), (Object[])new Object[]{hdrValue == null});
        }
        String expectedHeaderScheme = (String)req.getAttribute(KEY_AUTHORIZATION_HEADER_SCHEME);
        return this.authUtils.getBearerTokenFromHeader(hdrValue, expectedHeaderScheme);
    }

    @ManualTrace
    String getBearerTokenFromParameter(HttpServletRequest req) {
        String methodName = "getBearerTokenFromParameter";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req});
        }
        String param = null;
        String reqMethod = req.getMethod();
        if (REQ_METHOD_POST.equalsIgnoreCase(reqMethod)) {
            String contentType = req.getHeader(REQ_CONTENT_TYPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Request content type: " + contentType), (Object[])new Object[0]);
            }
            if (REQ_CONTENT_TYPE_APP_FORM_URLENCODED.equals(contentType)) {
                param = req.getParameter(ACCESS_TOKEN);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, param);
        }
        return param;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setTaiRequestConfigInfo(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest, boolean defaultConfig) {
        String methodName = "setTaiRequestConfigInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Specific config ID not provided, so will set generic config information for MpJwtTaiRequest object", (Object[])new Object[0]);
        }
        MicroProfileJwtTaiRequest result = this.setGenericAndFilteredConfigTaiRequestInfo(request, mpJwtTaiRequest, defaultConfig);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setGenericAndFilteredConfigTaiRequestInfo(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest, boolean defaultConfig) {
        String methodName = "setGenericAndFilteredConfigTaiRequestInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        if (mpJwtTaiRequest == null) {
            mpJwtTaiRequest = this.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        }
        Iterator<MicroProfileJwtConfig> services = this.getConfigServices();
        MicroProfileJwtTaiRequest result = this.setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(request, mpJwtTaiRequest, services, defaultConfig);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest, Iterator<MicroProfileJwtConfig> services, boolean defaultConfig) {
        String methodName = "setGenericAndFilteredConfigTaiRequestInfoFromConfigServices";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest, services});
        }
        if (services == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
            }
            return mpJwtTaiRequest;
        }
        if (mpJwtTaiRequest == null) {
            mpJwtTaiRequest = this.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        }
        while (services.hasNext()) {
            MicroProfileJwtConfig mpJwtConfig = services.next();
            AuthenticationFilter authFilter = MicroProfileJwtTAI.getAuthFilter(mpJwtConfig.getAuthFilterRef());
            if (authFilter != null) {
                if (!authFilter.isAccepted(request)) continue;
                mpJwtTaiRequest.addFilteredConfig(mpJwtConfig);
                continue;
            }
            if (defaultConfig) {
                mpJwtTaiRequest.addGenericConfig(mpJwtConfig);
                continue;
            }
            if (this.isMpJwtDefaultConfig(mpJwtConfig)) continue;
            mpJwtTaiRequest.addGenericConfig(mpJwtConfig);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
        }
        return mpJwtTaiRequest;
    }

    public boolean isMpJwtDefaultConfig(MicroProfileJwtConfig mpJwtConfig) {
        boolean isDefault = false;
        if ("defaultMpJwt".equals(mpJwtConfig.getUniqueId())) {
            isDefault = true;
        }
        return isDefault;
    }

    MicroProfileJwtTaiRequest handleNoMatchingConfiguration(String configId, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NO_SUCH_PROVIDER", (Object[])new Object[]{configId});
        Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        MpJwtProcessingException mpjwtException = new MpJwtProcessingException(msg);
        mpJwtTaiRequest.setTaiException(mpjwtException);
        return mpJwtTaiRequest;
    }

    @ManualTrace
    MicroProfileJwtConfig getConfigAssociatedWithRequestAndId(HttpServletRequest request, String configId) {
        MicroProfileJwtConfig mpJwtConfig;
        String methodName = "getConfigAssociatedWithRequestAndId";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, configId});
        }
        if (!this.configAuthFilterMatchesRequest(request, mpJwtConfig = this.getConfig(configId))) {
            mpJwtConfig = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtConfig);
        }
        return mpJwtConfig;
    }

    Iterator<MicroProfileJwtConfig> getConfigServices() {
        return MicroProfileJwtTAI.getServices();
    }

    MicroProfileJwtConfig getConfig(String configId) {
        return MicroProfileJwtTAI.getMicroProfileJwtConfig(configId);
    }

    boolean configAuthFilterMatchesRequest(HttpServletRequest request, MicroProfileJwtConfig config) {
        if (config == null) {
            return false;
        }
        AuthenticationFilter authFilter = MicroProfileJwtTAI.getAuthFilter(config.getAuthFilterRef());
        return authFilter == null || authFilter.isAccepted(request);
    }
}

