/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Element;

public class Fault
extends UncheckedException {
    public static final QName FAULT_CODE_CLIENT = new QName("http://cxf.apache.org/faultcode", "client");
    public static final QName FAULT_CODE_SERVER = new QName("http://cxf.apache.org/faultcode", "server");
    public static final String STACKTRACE_NAMESPACE = "http://cxf.apache.org/fault";
    public static final String STACKTRACE = "stackTrace";
    private static final int DEFAULT_HTTP_RESPONSE_CODE = 500;
    private static final long serialVersionUID = -1583932965031558864L;
    private Element detail;
    private String message;
    private QName code;
    private String lang;
    private int statusCode = 500;

    public Fault(Message message, Throwable throwable) {
        super(message, throwable);
        this.message = message.toString();
        this.code = FAULT_CODE_SERVER;
    }

    public Fault(Message message) {
        super(message);
        this.message = message.toString();
        this.code = FAULT_CODE_SERVER;
    }

    public Fault(String message, Logger log) {
        this(new Message(message, log, new Object[0]));
    }

    public Fault(String message, ResourceBundle b) {
        this(new Message(message, b, new Object[0]));
    }

    public Fault(String message, Logger log, Throwable t) {
        this(new Message(message, log, new Object[0]), t);
    }

    public Fault(String message, ResourceBundle b, Throwable t) {
        this(new Message(message, b, new Object[0]), t);
    }

    public Fault(String message, Logger log, Throwable t, Object ... params) {
        this(new Message(message, log, params), t);
    }

    public Fault(String message, ResourceBundle b, Throwable t, Object ... params) {
        this(new Message(message, b, params), t);
    }

    public Fault(Throwable t) {
        super(t);
        this.message = super.getMessage() != null ? super.getMessage() : Fault.getMessage(t);
        this.code = FAULT_CODE_SERVER;
    }

    public Fault(Message message, Throwable throwable, QName fc) {
        super(message, throwable);
        this.message = message.toString();
        this.code = fc;
    }

    public Fault(Message message, QName fc) {
        super(message);
        this.message = message.toString();
        this.code = fc;
    }

    public Fault(Throwable t, QName fc) {
        super(t);
        this.message = super.getMessage() != null ? super.getMessage() : Fault.getMessage(t);
        this.code = fc;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public QName getFaultCode() {
        return this.code;
    }

    public Fault setFaultCode(QName c) {
        this.code = c;
        return this;
    }

    public Element getDetail() {
        return this.detail;
    }

    public void setDetail(Element details) {
        this.detail = details;
    }

    public boolean hasDetails() {
        return this.detail != null;
    }

    public Element getOrCreateDetail() {
        if (this.detail == null) {
            this.detail = DOMUtils.createDocument().createElement("detail");
        }
        return this.detail;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    private static String getMessage(Throwable t) {
        return t == null ? null : (t.getMessage() != null ? t.getMessage() : t.toString());
    }

    public void setLang(String convertedLang) {
        this.lang = convertedLang;
    }

    public String getLang() {
        return this.lang;
    }
}

