/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class MessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageUtils.class);
    static final long serialVersionUID = 9123872615052016988L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MessageUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.message.MessageUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutbound(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isOutbound", new Object[]{message});
        }
        if (message == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "isOutbound", bl);
            }
            return bl;
        }
        Exchange exchange = message.getExchange();
        boolean bl = exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isOutbound", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFault(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isFault", new Object[]{message});
        }
        boolean bl = message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static FaultMode getFaultMode(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getFaultMode", new Object[]{message});
        }
        if (message != null && message.getExchange() != null && message == message.getExchange().getOutFaultMessage()) {
            FaultMode mode = message.get(FaultMode.class);
            if (null != mode) {
                FaultMode faultMode = mode;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    faultMode = faultMode;
                    LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
                }
                return faultMode;
            }
            FaultMode faultMode = FaultMode.RUNTIME_FAULT;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                faultMode = faultMode;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
            }
            return faultMode;
        }
        FaultMode faultMode = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            faultMode = faultMode;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getFaultMode", (Object)faultMode);
        }
        return faultMode;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isRequestor(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isRequestor", new Object[]{message});
        }
        if (message != null) {
            Boolean requestor = (Boolean)((MessageImpl)message).getRequestorRole();
            boolean bl = requestor != null && requestor != false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "isRequestor", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isRequestor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPartialResponse(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isPartialResponse", new Object[]{message});
        }
        boolean bl = message != null && Boolean.TRUE.equals(((MessageImpl)message).getPartialResponse());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isPartialResponse", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isEmptyPartialResponse(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isEmptyPartialResponse", new Object[]{message});
        }
        boolean bl = message != null && Boolean.TRUE.equals(((MessageImpl)message).getEmptyPartialResponse());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isEmptyPartialResponse", bl);
        }
        return bl;
    }

    @Deprecated
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isTrue(Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isTrue", new Object[]{value});
        }
        boolean bl = PropertyUtils.isTrue(value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isTrue", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getContextualBoolean(Message m, String key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getContextualBoolean", new Object[]{m, key});
        }
        boolean bl = MessageUtils.getContextualBoolean(m, key, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualBoolean", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getContextualBoolean(Message m, String key, boolean defaultValue) {
        Object o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getContextualBoolean", new Object[]{m, key, defaultValue});
        }
        if (m != null && (o = m.getContextualProperty(key)) != null) {
            boolean bl = PropertyUtils.isTrue(o);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualBoolean", bl);
            }
            return bl;
        }
        boolean bl = defaultValue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualBoolean", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int getContextualInteger(Message m, String key, int defaultValue) {
        block6: {
            Object o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.message.MessageUtils", "getContextualInteger", new Object[]{m, key, defaultValue});
            }
            if (m != null && (o = m.getContextualProperty(key)) instanceof String) {
                int n;
                try {
                    int i = Integer.parseInt((String)o);
                    if (i <= 0) break block6;
                    n = i;
                }
                catch (NumberFormatException i) {
                    FFDCFilter.processException((Throwable)i, (String)"org.apache.cxf.message.MessageUtils", (String)"169", null, (Object[])new Object[]{m, key, defaultValue});
                    LOG.warning("Incorrect integer value of " + o + " specified for: " + key);
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualInteger", n);
                }
                return n;
            }
        }
        int n = defaultValue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualInteger", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object getContextualProperty(Message m, String propPreferred, String propDefault) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getContextualProperty", new Object[]{m, propPreferred, propDefault});
        }
        Object prop = null;
        if (m != null && (prop = m.getContextualProperty(propPreferred)) == null && propDefault != null) {
            prop = m.getContextualProperty(propDefault);
        }
        Object object = prop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "getContextualProperty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDOMPresent(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "isDOMPresent", new Object[]{m});
        }
        boolean bl = m != null && m.getContent(Node.class) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.message.MessageUtils", "isDOMPresent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method getTargetMethod(Message m, Supplier<RuntimeException> exceptionSupplier) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.message.MessageUtils", "getTargetMethod", new Object[]{m, exceptionSupplier});
        }
        BindingOperationInfo bop = m.getExchange().getBindingOperationInfo();
        if (bop != null) {
            MethodDispatcher md = (MethodDispatcher)m.getExchange().getService().get(MethodDispatcher.class.getName());
            Method method = md.getMethod(bop);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "getTargetMethod", method);
            }
            return method;
        }
        Method method = (Method)((MessageImpl)m).getResourceMethod();
        if (method != null || exceptionSupplier == null) {
            Method method2 = method;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method2 = method2;
                LOG.exiting("org.apache.cxf.message.MessageUtils", "getTargetMethod", method2);
            }
            return method2;
        }
        throw exceptionSupplier.get();
    }
}

