/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.ExtendedHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.HeaderCreator;
import com.ibm.ws.sip.parser.util.LRUStringCache;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import java.util.Arrays;
import java.util.HashMap;

public class HeaderSeparator {
    private static final LogMgr s_logger = Log.get(HeaderSeparator.class);
    private static final LRUStringCache s_headerNameCache = new LRUStringCache(128);
    private static final ThreadLocal<char[]> s_lowercase = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[32];
        }
    };
    private HashMap<String, HeaderSeparation> m_commaSeparatedHeaders;
    private HeaderSeparation m_default;
    private static final String[] DEFAULT_STRING = new String[]{"Accept", "Accept-Encoding", "Accept-Language", "Allow", "In-Reply-To", "Proxy-Require", "Require", "Supported", "Unsupported"};
    private static final String[] EXCLUDE_HEADER_SEPARATION_HEADERS = new String[]{"IBM-Heartbeat:off", "OutboundIfList:off"};
    private static final HeaderSeparator s_instance = new HeaderSeparator();

    public static HeaderSeparator instance() {
        return s_instance;
    }

    private HeaderSeparator() {
        String[] customCommaSeparatedHeaders = SIPTransactionStack.instance().getConfiguration().getCommaSeparatedHeaders();
        this.changeSetting(customCommaSeparatedHeaders);
    }

    public final void changeSetting(String[] customCommaSeparatedHeaders) {
        HashMap<String, HeaderSeparation> map;
        block10: {
            block9: {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "changeSetting", "Parsing default " + Arrays.toString(DEFAULT_STRING));
                }
                map = new HashMap<String, HeaderSeparation>();
                try {
                    HeaderSeparator.parse(DEFAULT_STRING, map);
                }
                catch (Exception e2) {
                    if (!s_logger.isTraceFailureEnabled()) break block9;
                    s_logger.traceFailure(this, "changeSetting", "Failed parsing default comma separation", e2);
                }
            }
            if (customCommaSeparatedHeaders != null && customCommaSeparatedHeaders.length > 0) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "changeSetting", "Parsing custom " + Arrays.toString(customCommaSeparatedHeaders));
                }
                try {
                    HeaderSeparator.parse(customCommaSeparatedHeaders, map);
                    HeaderSeparator.parse(EXCLUDE_HEADER_SEPARATION_HEADERS, map);
                }
                catch (Exception e3) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "changeSetting", "Failed parsing custom comma separation", e3);
                    }
                    if (!s_logger.isWarnEnabled()) break block10;
                    s_logger.warn("warn.sip.invalid.comma.separated.headers", null);
                }
            }
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "changeSetting", "Map result " + map);
        }
        this.m_commaSeparatedHeaders = map;
        HeaderSeparation star = map.remove("*");
        this.m_default = star == null ? HeaderSeparation.OFF : star;
    }

    private static void parse(String[] commaSeparatedHeaders, HashMap<String, HeaderSeparation> map) {
        for (String headerSeparation : commaSeparatedHeaders) {
            HeaderImpl hdr;
            HeaderSeparation value;
            String key;
            headerSeparation = headerSeparation.trim();
            int length = headerSeparation.length();
            int colon = headerSeparation.indexOf(58);
            if (colon == -1) {
                key = headerSeparation;
                value = HeaderSeparation.ON;
            } else {
                key = headerSeparation.substring(0, colon).trim();
                String separation = headerSeparation.substring(colon + 1, length).trim();
                if (separation.equalsIgnoreCase("on")) {
                    value = HeaderSeparation.ON;
                } else if (separation.equalsIgnoreCase("off")) {
                    value = HeaderSeparation.OFF;
                } else if (separation.equalsIgnoreCase("in")) {
                    value = HeaderSeparation.IN;
                } else if (separation.equalsIgnoreCase("out")) {
                    value = HeaderSeparation.OUT;
                } else {
                    throw new RuntimeException("Invalid comma separation [" + separation + ']');
                }
            }
            if (key.length() == 0) {
                throw new RuntimeException("Empty header field name");
            }
            if (key.equals("*")) {
                map.clear();
            }
            if (!((hdr = HeaderCreator.createHeader(key)) instanceof ExtendedHeader) && !hdr.isNested() && value != HeaderSeparation.OFF) {
                if (!s_logger.isTraceFailureEnabled()) continue;
                s_logger.traceFailure(HeaderSeparator.class, "parse", "Invalid header: " + hdr.getName() + " in the custom property comma.separated.headers");
                continue;
            }
            key = HeaderSeparator.toLowerCase(key);
            map.put(key, value);
        }
    }

    public boolean isCommaSeparated(CharSequence headerName, boolean in) {
        HeaderSeparation separation;
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "isCommaSeperated", "checking header: " + headerName + " .");
        }
        if ((separation = this.m_commaSeparatedHeaders.get(headerName = HeaderSeparator.toLowerCase(headerName))) == null) {
            separation = this.m_default;
        }
        switch (separation) {
            case OFF: {
                return false;
            }
            case ON: {
                return true;
            }
            case IN: {
                return in;
            }
            case OUT: {
                return !in;
            }
        }
        throw new RuntimeException("Unknown comma-separation [" + (Object)((Object)separation) + ']');
    }

    private static String toLowerCase(CharSequence headerName) {
        int length = headerName.length();
        char[] lowercase = s_lowercase.get();
        if (lowercase.length < length) {
            lowercase = new char[length];
            s_lowercase.set(lowercase);
        }
        for (int i = 0; i < length; ++i) {
            char c = headerName.charAt(i);
            lowercase[i] = c = Character.toLowerCase(c);
        }
        String s = s_headerNameCache.get(lowercase, 0, length);
        return s;
    }

    static enum HeaderSeparation {
        OFF,
        ON,
        IN,
        OUT;

    }
}

