/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.rules;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.rules.LogicalConnector;
import java.util.Iterator;
import java.util.List;
import javax.servlet.sip.SipServletRequest;

public class And
extends LogicalConnector {
    private static final LogMgr c_logger = Log.get(And.class);
    private List m_conditions;

    public And(List conditions) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "And", "Construct New AND Condition, #args: " + conditions.size());
        }
        this.m_conditions = conditions;
    }

    @Override
    public boolean evaluate(SipServletRequest request) {
        if (this.m_conditions == null || this.m_conditions.size() == 0) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{"AND"};
                c_logger.error("error.missing.sub.elements", "Create", args);
            }
            return false;
        }
        boolean rc = true;
        Iterator iter = this.m_conditions.iterator();
        while (iter.hasNext() && rc) {
            Condition condition = (Condition)iter.next();
            rc = rc && condition.evaluate(request);
        }
        return rc;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(16);
        Iterator iter = this.m_conditions.iterator();
        buffer.append('(');
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(" AND ");
        }
        buffer.append(')');
        return buffer.toString();
    }
}

