/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.timer.ExpirationTimer;
import com.ibm.ws.sip.container.timer.ExpirationTimerListener;
import java.util.Iterator;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;

public class AppSessionTimerListener
extends ExpirationTimerListener {
    private static final LogMgr c_logger = Log.get(AppSessionTimerListener.class);
    private ExpirationTimer m_timer;
    private SipApplicationSessionImpl m_appSession;

    public AppSessionTimerListener(SipApplicationSessionImpl appSession, ExpirationTimer timer) {
        this.m_appSession = appSession;
        if (timer == null) {
            this.m_timer = new ExpirationTimer(this, this.m_appSession.getSynchronizer());
        } else {
            this.m_timer = timer;
            this.m_timer.setExpInvoker(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAppSessionTimer() {
        Object object = this.m_appSession.getSynchronizer();
        synchronized (object) {
            if (!this.m_timer.isCancelled()) {
                long expires = this.m_appSession.getExpires();
                long delta = expires - System.currentTimeMillis();
                if (delta < 0L) {
                    delta = 1L;
                }
                SipContainerComponent.getTimerService().schedule(this.m_timer, false, delta);
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer b = new StringBuffer(64);
                    b.append("App Session scheduled to expire in ");
                    b.append(delta);
                    b.append(" ms, App Session: ");
                    b.append(this.m_appSession);
                    c_logger.traceDebug(this, "scheduleAppSessionTimer", b.toString());
                }
            } else {
                c_logger.traceDebug(this, "scheduleAppSessionTimer", "Cannot reschedule expiration timer. Timer already canceled. ApplicationSession might have been invalidated");
            }
        }
    }

    public void rescheduleAppSessionTimer() {
        long expires = this.m_appSession.getExpires();
        long delta = expires - System.currentTimeMillis();
        if (delta < 0L) {
            delta = 1L;
        }
        SipContainerComponent.getTimerService().schedule(this.m_timer, false, delta);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("App Session re-scheduled to expire in ");
            b.append(delta);
            b.append(" ms, App Session: ");
            b.append(this.m_appSession);
            c_logger.traceDebug(this, "reschedualeAppSessionTimer", b.toString());
        }
    }

    private boolean isAppSessionExpired() {
        if (this.m_appSession == null) {
            return true;
        }
        return this.m_appSession.getExpires() < System.currentTimeMillis() + 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessionExpiredEvt() {
        SipAppDesc desc = this.m_appSession.getAppDescriptor();
        if (null != desc) {
            Iterator<SipApplicationSessionListener> iter = desc.getAppSessionListeners().iterator();
            if (!iter.hasNext()) {
                return;
            }
            SipApplicationSessionEvent evt = new SipApplicationSessionEvent(this.m_appSession);
            ContextEstablisher contextEstablisher = desc.getContextEstablisher();
            ClassLoader currentThreadClassLoader = null;
            try {
                if (contextEstablisher != null) {
                    currentThreadClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                    contextEstablisher.establishContext();
                }
                while (iter.hasNext()) {
                    iter.next().sessionExpired(evt);
                }
            }
            finally {
                if (contextEstablisher != null) {
                    contextEstablisher.removeContext(currentThreadClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.m_appSession.getSynchronizer();
        synchronized (object) {
            this.m_timer.cancel();
            this.m_appSession = null;
        }
    }

    @Override
    protected void invokeExpiredTimer() {
        block8: {
            if (this.m_appSession.isValid()) {
                if (this.isAppSessionExpired()) {
                    this.sendSessionExpiredEvt();
                    if (this.isAppSessionExpired()) {
                        try {
                            if (this.m_appSession != null) {
                                this.m_appSession.invalidate();
                            }
                            break block8;
                        }
                        catch (IllegalStateException e2) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug(this, "invoke", "SipApplication session was already invalidated");
                            }
                            break block8;
                        }
                    }
                    this.scheduleAppSessionTimer();
                } else {
                    this.scheduleAppSessionTimer();
                }
            }
        }
    }

    public long getExpires() {
        return this.m_appSession.getExpires();
    }

    @Override
    public String getId() {
        return this.m_appSession.getSharedId();
    }

    @Override
    public void schedule(boolean isPersistent, long delay) {
        SipContainerComponent.getTimerService().schedule(this.m_timer, isPersistent, delay);
    }

    @Override
    public String getApplicationId() {
        return this.getId();
    }

    @Override
    public String getApplicationName() {
        if (this.m_appSession != null && this.m_appSession.getAppDescriptor() != null) {
            return this.m_appSession.getAppDescriptor().getAppName();
        }
        return null;
    }

    @Override
    public Integer getApplicationIdForPMI() {
        if (this.m_appSession != null && this.m_appSession.getAppDescriptor() != null) {
            return this.m_appSession.getAppDescriptor().getAppIndexForPmi();
        }
        return null;
    }

    public long getExpirationTime() {
        return this.m_timer.getStartTime() + this.m_timer.getDelay();
    }

    @Override
    public Object getServiceSynchronizer() {
        return this.m_appSession.getServiceSynchronizer();
    }

    SipApplicationSession getApplicationSession() {
        return this.m_appSession;
    }
}

