/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.stack.transport.chfw.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.sip.SIPConnectionFactoryImplWs;
import com.ibm.ws.sip.stack.transport.sip.SipChannelFactory;
import com.ibm.ws.sip.stack.transport.sip.SipInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.SipTcpInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.SipTlsInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.SipUdpInboundChannel;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryPropertyIgnoredException;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.util.Map;

public class SipInboundChannelFactoryWs
extends SipChannelFactory {
    private static final TraceComponent tc = Tr.register(SipInboundChannelFactoryWs.class);
    public static final String ACCEPTOR_ID = SipInboundChannelFactoryWs.class.getName();
    private static int s_chains = 0;

    public Channel findOrCreateChannel(ChannelData config) throws ChannelException {
        SipInboundChannel channel;
        String outboundChainName;
        ChainData chain;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"findOrCreateChannel", (Object[])new Object[]{config.getName()});
        }
        if ((chain = this.getChain(config)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"findOrCreateChannel", (Object[])new Object[]{"Error: no chain data for channel [" + config.getName() + ']'});
            }
            return null;
        }
        ChannelData[] channels = this.getChannels(chain);
        if (channels == null) {
            return null;
        }
        int nChannels = channels.length;
        ChannelData containerChannel = channels[nChannels - 1];
        String transport = (String)containerChannel.getPropertyBag().get("channelChainProtocolType");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"findOrCreateChannel", (Object[])new Object[]{"transport [" + transport + ']'});
        }
        if (transport == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"findOrCreateChannel", (Object[])new Object[]{"Error: no transport property specified in the container channel [" + containerChannel.getName() + ']'});
            }
            return null;
        }
        ChannelData transportChannel = channels[nChannels - 2];
        ListeningPoint lp = this.createListeningPoint(transportChannel, transport);
        if (lp == null) {
            return null;
        }
        String chainNumber = String.valueOf(s_chains++);
        if (transport.equalsIgnoreCase("udp")) {
            outboundChainName = "UdpOutboundChain_" + chainNumber;
            channel = SipUdpInboundChannel.instance(config, lp, outboundChainName);
            String UDPType = (String)GenericEndpointImpl.getUdpOptions().get("type");
            this.createOutboundChain(GenericEndpointImpl.getChannelFramework(), outboundChainName, new String[]{"SipUdpOutboundChannel_" + chainNumber, "UdpOutboundChannel_" + chainNumber}, new String[]{"SipUdpOutboundChannel", UDPType}, null);
        } else if (transport.equalsIgnoreCase("tcp")) {
            outboundChainName = "TcpOutboundChain_" + chainNumber;
            channel = new SipTcpInboundChannel(config, lp, outboundChainName);
            String tcpType = (String)GenericEndpointImpl.getTcpOptions().get("type");
            this.createOutboundChain(GenericEndpointImpl.getChannelFramework(), outboundChainName, new String[]{"SipTcpOutboundChannel_" + chainNumber, "TcpOutboundChannel_" + chainNumber}, new String[]{"SipTcpOutboundChannel", tcpType}, null);
        } else if (transport.equalsIgnoreCase("tls")) {
            outboundChainName = "TlsOutboundChain_" + chainNumber;
            channel = new SipTlsInboundChannel(config, lp, outboundChainName);
            ChannelData tlsChannel = channels[nChannels - 2];
            String tcpType = (String)GenericEndpointImpl.getTcpOptions().get("type");
            Map props = tlsChannel.getPropertyBag();
            this.createOutboundChain(GenericEndpointImpl.getChannelFramework(), outboundChainName, new String[]{"SipTlsOutboundChannel_" + chainNumber, "TlsOutboundChannel_" + chainNumber, "TcpSecureOutboundChannel_" + chainNumber}, new String[]{"SipTlsOutboundChannel", "SSLChannel", tcpType}, props);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"findOrCreateChannel", (Object[])new Object[]{"unknown transport [" + transport + ']'});
            }
            return null;
        }
        String chainName = chain.getName();
        try {
            SIPConnectionFactoryImplWs.instance().addListeningConnection(lp, channel, chainName);
        }
        catch (IOException e2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed creating a connection", (Object[])new Object[]{e2});
            }
            return null;
        }
        return channel;
    }

    private ListeningPoint createListeningPoint(ChannelData transportChannel, String transport) {
        String portStr;
        Map props = transportChannel.getPropertyBag();
        if (props == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in createListeningPoint: no properties in [" + transportChannel.getName() + ']'), (Object[])new Object[0]);
            }
            return null;
        }
        String host = (String)props.get("hostname");
        if (host == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in createListeningPoint: missing host in channel [" + transportChannel.getName() + ']'), (Object[])new Object[0]);
            }
            return null;
        }
        if (host.equals("*")) {
            host = "0.0.0.0";
        }
        if ((portStr = (String)props.get("port")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in createListeningPoint: missing port in channel [" + transportChannel.getName() + ']'), (Object[])new Object[0]);
            }
            return null;
        }
        int port = Integer.parseInt(portStr);
        ListeningPointImpl lp = new ListeningPointImpl(host, port, transport, transportChannel.getName());
        return lp;
    }

    private ChainData getChain(ChannelData config) {
        ChainData chain = (ChainData)config.getPropertyBag().get("chainData");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getChain " + chain + " config = " + config), (Object[])new Object[0]);
        }
        return chain;
    }

    private ChannelData[] getChannels(ChainData chain) {
        int nChannels;
        ChannelData[] channels = chain.getChannelList();
        int n = nChannels = channels == null ? -1 : channels.length;
        if (nChannels < 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in SipInboundChannelFactoryWs.getChannels: only [" + channels.length + "] channels in chain"), (Object[])new Object[0]);
            }
            return null;
        }
        return channels;
    }

    private void createOutboundChain(ChannelFramework cf, String outboundChainName, String[] outboundChannelNames, String[] outboundChannelFactories, Map properties) {
        block8: {
            int nChannels = outboundChannelNames.length;
            if (outboundChannelFactories.length != nChannels) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"createOutboundChain", (Object[])new Object[]{"Error: outbound channel config mismatch [" + nChannels + "] != [" + outboundChannelFactories.length + ']'});
                }
                return;
            }
            try {
                for (int i = 0; i < nChannels; ++i) {
                    String channelName = outboundChannelNames[i];
                    String channelFactory = outboundChannelFactories[i];
                    if (cf.getChannel(channelName) != null) continue;
                    cf.addChannel(channelName, cf.lookupFactory(channelFactory), properties);
                }
                if (cf.getChain(outboundChainName) == null) {
                    cf.addChain(outboundChainName, FlowType.OUTBOUND, outboundChannelNames);
                }
            }
            catch (ChannelException e2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"createOutboundChain", (Object[])new Object[]{"ChannelException", e2});
                }
            }
            catch (ChainException e3) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createOutboundChain", (Object[])new Object[]{"ChainException", e3});
            }
        }
    }

    public void updateProperties(Map<Object, Object> properties) throws ChannelFactoryPropertyIgnoredException {
    }

    public Map<Object, Object> getProperties() {
        return null;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map<Object, Object> props) {
        return null;
    }
}

