/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.logging.SensitiveIntrospector;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={Introspector.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ConfigVariableIntrospection
extends SensitiveIntrospector {
    ConfigVariables configVariables;
    static final long serialVersionUID = 5342768309453892258L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setVariables(ConfigVariables cv) {
        this.configVariables = cv;
    }

    protected void unsetVariables(ConfigVariables cv) {
        if (cv == this.configVariables) {
            this.configVariables = null;
        }
    }

    public String getIntrospectorName() {
        return "ConfigVariables";
    }

    public String getIntrospectorDescription() {
        return "The User Config Variables";
    }

    public void introspect(PrintWriter writer) {
        writer.println("User Config Variables");
        writer.println("---------------------");
        TreeMap<String, String> env = new TreeMap<String, String>(this.getConfigVariables());
        for (Map.Entry entry : env.entrySet()) {
            writer.print((String)entry.getKey());
            writer.print("=");
            writer.println(this.getObscuredValue((String)entry.getKey(), entry.getValue()).replaceAll("\\\n", "<nl>"));
        }
        writer.println("---------------------");
        writer.flush();
    }

    @Sensitive
    private Map<String, String> getConfigVariables() {
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){
            static final long serialVersionUID = -3036550875261102110L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Map<String, String> run() {
                return ConfigVariableIntrospection.this.configVariables.getUserDefinedVariables();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigVariableIntrospection$1", 1.class, null, null);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigVariableIntrospection", ConfigVariableIntrospection.class, null, null);
    }
}

