/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.TraceFactory;
import com.ibm.ws.objectManager.utils.Utils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TraceImpl
implements Trace {
    private static final Class cclass = TraceImpl.class;
    private static ResourceBundle traceTemplates = null;
    private TraceFactory traceFactory;
    public static final boolean usePrintWriterForTrace = false;
    private TraceComponent traceComponent;
    private static final String ls;
    private static final String DEAD_CHAR = ".";

    public TraceImpl(Class sourceClass, String traceGroup, TraceFactory traceFactory) {
        this.traceFactory = traceFactory;
        this.traceComponent = SibTr.register((Class)sourceClass, (String)traceGroup, (String)traceFactory.nls.getBundleName());
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.traceComponent.isDebugEnabled();
    }

    @Override
    public final boolean isEntryEnabled() {
        return this.traceComponent.isEntryEnabled();
    }

    @Override
    public final boolean isEventEnabled() {
        return this.traceComponent.isEventEnabled();
    }

    @Override
    public final boolean isAnyTracingEnabled() {
        return TraceComponent.isAnyTracingEnabled();
    }

    @Override
    public void bytes(Class sourceClass, byte[] data) {
        this.internalBytes(null, sourceClass, data, 0, 0);
    }

    @Override
    public void bytes(Class sourceClass, byte[] data, int start) {
        this.internalBytes(null, sourceClass, data, start, 0);
    }

    @Override
    public void bytes(Class sourceClass, byte[] data, int start, int count) {
        this.internalBytes(null, sourceClass, data, start, count);
    }

    @Override
    public void bytes(Object source, Class sourceClass, byte[] data) {
        this.internalBytes(source, sourceClass, data, 0, 0);
    }

    @Override
    public void bytes(Object source, Class sourceClass, byte[] data, int start) {
        this.internalBytes(source, sourceClass, data, start, 0);
    }

    @Override
    public void bytes(Object source, Class sourceClass, byte[] data, int start, int count) {
        this.internalBytes(source, sourceClass, data, start, count);
    }

    private void internalBytes(Object source, Class sourceClass, byte[] data, int start, int count) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sourceClass.getName());
        stringBuffer.append(" [");
        if (source != null) {
            stringBuffer.append(source);
        } else {
            stringBuffer.append("Static");
        }
        stringBuffer.append("]");
        stringBuffer.append(ls);
        if (data != null) {
            if (count > 0) {
                stringBuffer.append(TraceImpl.formatBytes(data, start, count, true));
            } else {
                stringBuffer.append(TraceImpl.formatBytes(data, start, data.length, true));
            }
        } else {
            stringBuffer.append("data is null");
        }
        SibTr.debug((TraceComponent)this.traceComponent, (String)stringBuffer.toString());
    }

    @Override
    public final void debug(Class sourceClass, String message) {
        this.internalDebug(null, sourceClass, message, null);
    }

    @Override
    public final void debug(Class sourceClass, String message, Object object) {
        this.internalDebug(null, sourceClass, message, object);
    }

    @Override
    public final void debug(Class sourceClass, String message, Object[] objects) {
        this.internalDebug(null, sourceClass, message, objects);
    }

    @Override
    public final void debug(Object source, Class sourceClass, String message) {
        this.internalDebug(source, sourceClass, message, null);
    }

    @Override
    public final void debug(Object source, Class sourceClass, String message, Object object) {
        this.internalDebug(source, sourceClass, message, object);
    }

    @Override
    public final void debug(Object source, Class sourceClass, String message, Object[] objects) {
        this.internalDebug(source, sourceClass, message, objects);
    }

    private final void internalDebug(Object source, Class sourceClass, String message, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(message);
        stringBuffer.append(" [");
        if (source != null) {
            stringBuffer.append(source);
        } else {
            stringBuffer.append("Static");
        }
        stringBuffer.append("]");
        if (object != null) {
            SibTr.debug((TraceComponent)this.traceComponent, (String)stringBuffer.toString(), (Object)object);
        } else {
            SibTr.debug((TraceComponent)this.traceComponent, (String)stringBuffer.toString());
        }
    }

    @Override
    public final void entry(Class sourceClass, String methodName) {
        this.internalEntry(null, sourceClass, methodName, null);
    }

    @Override
    public final void entry(Class sourceClass, String methodName, Object object) {
        this.internalEntry(null, sourceClass, methodName, object);
    }

    @Override
    public final void entry(Class sourceClass, String methodName, Object[] objects) {
        this.internalEntry(null, sourceClass, methodName, objects);
    }

    @Override
    public final void entry(Object source, Class sourceClass, String methodName) {
        this.entry(source, sourceClass, methodName, null);
    }

    @Override
    public final void entry(Object source, Class sourceClass, String methodName, Object object) {
        this.internalEntry(source, sourceClass, methodName, object);
    }

    @Override
    public final void entry(Object source, Class sourceClass, String methodName, Object[] objects) {
        this.internalEntry(source, sourceClass, methodName, objects);
    }

    private final void internalEntry(Object source, Class sourceClass, String methodName, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(methodName);
        stringBuffer.append(" [");
        if (source != null) {
            stringBuffer.append(source);
        } else {
            stringBuffer.append("Static");
        }
        stringBuffer.append("]");
        if (object != null) {
            SibTr.entry((TraceComponent)this.traceComponent, (String)stringBuffer.toString(), (Object)object);
        } else {
            SibTr.entry((TraceComponent)this.traceComponent, (String)stringBuffer.toString());
        }
    }

    @Override
    public final void exit(Class sourceClass, String methodName) {
        this.internalExit(null, sourceClass, methodName, null);
    }

    @Override
    public final void exit(Class sourceClass, String methodName, Object object) {
        this.internalExit(null, sourceClass, methodName, object);
    }

    @Override
    public final void exit(Class sourceClass, String methodName, Object[] objects) {
        this.internalExit(null, sourceClass, methodName, objects);
    }

    @Override
    public final void exit(Object source, Class sourceClass, String methodName) {
        this.internalExit(source, sourceClass, methodName, null);
    }

    @Override
    public final void exit(Object source, Class sourceClass, String methodName, Object object) {
        this.internalExit(source, sourceClass, methodName, object);
    }

    @Override
    public final void exit(Object source, Class sourceClass, String methodName, Object[] objects) {
        this.internalExit(source, sourceClass, methodName, objects);
    }

    private final void internalExit(Object source, Class sourceClass, String methodName, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(methodName);
        stringBuffer.append(" [");
        if (source != null) {
            stringBuffer.append(source);
        } else {
            stringBuffer.append("Static");
        }
        stringBuffer.append("]");
        if (object != null) {
            SibTr.exit((TraceComponent)this.traceComponent, (String)stringBuffer.toString(), (Object)object);
        } else {
            SibTr.exit((TraceComponent)this.traceComponent, (String)stringBuffer.toString());
        }
    }

    @Override
    public final void event(Class sourceClass, String methodName, Throwable throwable) {
        this.internalEvent(null, sourceClass, methodName, throwable);
    }

    @Override
    public final void event(Object source, Class sourceClass, String methodName, Throwable throwable) {
        this.internalEvent(source, sourceClass, methodName, throwable);
    }

    private final void internalEvent(Object source, Class sourceClass, String methodName, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(methodName);
        stringBuffer.append(" [");
        if (source != null) {
            stringBuffer.append(source);
        } else {
            stringBuffer.append("Static");
        }
        stringBuffer.append("]");
        if (throwable != null) {
            SibTr.event((TraceComponent)this.traceComponent, (String)stringBuffer.toString(), (Object)new Object[]{"Exception caught: ", throwable});
        } else {
            SibTr.event((TraceComponent)this.traceComponent, (String)stringBuffer.toString());
        }
    }

    @Override
    public final void info(Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.internalInfo(null, sourceClass, methodName, messageIdentifier, object);
    }

    @Override
    public final void info(Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        this.internalInfo(null, sourceClass, methodName, messageIdentifier, objects);
    }

    @Override
    public final void info(Object source, Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.internalInfo(source, sourceClass, methodName, messageIdentifier, object);
    }

    @Override
    public final void info(Object source, Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        this.internalInfo(source, sourceClass, methodName, messageIdentifier, objects);
    }

    @Override
    public final void warning(Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.internalWarning(null, sourceClass, methodName, messageIdentifier, object);
    }

    @Override
    public final void warning(Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        this.internalWarning(null, sourceClass, methodName, messageIdentifier, objects);
    }

    @Override
    public final void warning(Object source, Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.internalWarning(source, sourceClass, methodName, messageIdentifier, object);
    }

    @Override
    public final void warning(Object source, Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        this.internalWarning(source, sourceClass, methodName, messageIdentifier, objects);
    }

    private final void internalInfo(Object source, Class sourceClass, String methodName, String messageIdentifier, Object object) {
        if (object != null) {
            SibTr.info((TraceComponent)this.traceComponent, (String)messageIdentifier, (Object)object);
        } else {
            SibTr.info((TraceComponent)this.traceComponent, (String)messageIdentifier);
        }
    }

    private final void internalWarning(Object source, Class sourceClass, String methodName, String messageIdentifier, Object object) {
        if (object != null) {
            SibTr.warning((TraceComponent)this.traceComponent, (String)messageIdentifier, (Object)object);
        } else {
            SibTr.warning((TraceComponent)this.traceComponent, (String)messageIdentifier);
        }
    }

    private static String pad(String s, int l) {
        return TraceImpl.pad(s, l, null);
    }

    private static String pad(String s, int l, String p) {
        String rc;
        if (p == null) {
            p = "0";
        }
        if (s.length() < l) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < l - s.length(); ++i) {
                sb.append(p);
            }
            rc = new String(sb.toString() + s);
        } else {
            rc = s.substring(s.length() - l);
        }
        return rc;
    }

    private static String dup(int i) {
        return new String("                          " + i + " duplicate line(s) suppressed" + ls);
    }

    public static String formatBytes(byte[] data, int start, int count, boolean displayCharRepresentations) {
        StringBuffer sb = new StringBuffer();
        if (data != null) {
            int len = data.length;
            sb.append(ls + "Length = 0x" + Integer.toHexString(len) + " (" + len + ") bytes start=" + start + " count=" + count + ls + ls);
            if (displayCharRepresentations) {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F     0 2 4 6 8 A C E " + ls);
            } else {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F" + ls);
            }
            int suppress = 0;
            int end = start + count;
            String[] c = new String[16];
            String[] p = new String[16];
            String[] str = new String[16];
            for (int j = 0; j < 16; ++j) {
                c[j] = null;
                str[j] = null;
            }
            for (int i = 0; i < len; i += 16) {
                int j;
                boolean skip = true;
                for (j = 0; j < 16; ++j) {
                    int t = i + j;
                    if (t >= start && t < end && t < len) {
                        c[j] = TraceImpl.pad(Integer.toHexString(data[t]), 2);
                        str[j] = c[j].equalsIgnoreCase("00") || c[j].equalsIgnoreCase("09") || c[j].equalsIgnoreCase("0a") || c[j].equalsIgnoreCase("0b") || c[j].equalsIgnoreCase("0c") || c[j].equalsIgnoreCase("0d") || c[j].equalsIgnoreCase("07") ? DEAD_CHAR : new String(data, t, 1);
                        skip = false;
                        continue;
                    }
                    c[j] = "  ";
                    str[j] = DEAD_CHAR;
                }
                if (skip) {
                    if (suppress > 0) {
                        sb.append(TraceImpl.dup(suppress));
                    }
                    suppress = 0;
                    c[0] = null;
                    continue;
                }
                if (c[0].equals(p[0]) && c[1].equals(p[1]) && c[2].equals(p[2]) && c[3].equals(p[3]) && c[4].equals(p[4]) && c[5].equals(p[5]) && c[6].equals(p[6]) && c[7].equals(p[7]) && c[8].equals(p[8]) && c[9].equals(p[9]) && c[10].equals(p[10]) && c[11].equals(p[11]) && c[12].equals(p[12]) && c[13].equals(p[13]) && c[14].equals(p[14]) && c[15].equals(p[15])) {
                    ++suppress;
                    continue;
                }
                if (suppress > 0) {
                    sb.append(TraceImpl.dup(suppress));
                }
                sb.append("0x" + TraceImpl.pad(Integer.toHexString(i), 8) + " (" + TraceImpl.pad(new Integer(i).toString(), 8, " ") + ") : ");
                sb.append(c[0] + c[1] + c[2] + c[3] + " " + c[4] + c[5] + c[6] + c[7] + " " + c[8] + c[9] + c[10] + c[11] + " " + c[12] + c[13] + c[14] + c[15]);
                if (displayCharRepresentations) {
                    sb.append("  | ");
                    sb.append(str[0] + str[1] + str[2] + str[3] + str[4] + str[5] + str[6] + str[7] + str[8] + str[9] + str[10] + str[11] + str[12] + str[13] + str[14] + str[15]);
                }
                sb.append(ls);
                for (j = 0; j < 16; ++j) {
                    p[j] = c[j];
                }
                suppress = 0;
            }
            if (suppress > 0) {
                sb.append(TraceImpl.dup(suppress));
            }
        }
        return sb.toString();
    }

    static {
        String templateName = cclass.getPackage().getName() + ".TraceTemplates";
        try {
            traceTemplates = ResourceBundle.getBundle(templateName);
        }
        catch (MissingResourceException exception) {
            Utils.ffdc.processException(cclass, "<static.init>", exception, "1:50:1.14", new Object[]{templateName});
        }
        ls = System.lineSeparator();
    }
}

