/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.msgstore.expiry.ExpiryIndex;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Expirer
implements AlarmListener,
XmlConstants {
    private static TraceComponent tc = SibTr.register(Expirer.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int BATCH_SIZE = 20;
    private static final int CLEANUP_EVERY_N_CYCLES = 5;
    private static final int MAX_DIAG_LOG = 30;
    private static final int MAX_CONSECUTIVE_FAILURES = 3;
    private final ExpirerLock lockObject = new ExpirerLock();
    private ExpiryIndex expiryIndex = null;
    private Alarm expiryAlarm = null;
    private boolean runEnabled = false;
    private boolean addEnabled = true;
    private boolean alarmScheduled = false;
    private boolean alarming = false;
    private long interval = 0L;
    private byte consecutiveFailures = 0;
    private MessageStoreImpl messageStore = null;
    private JsMessagingEngine messagingEngine = null;
    private Exception lastException = null;
    private long lastExceptionTime = 0L;
    private long expirerStartTime = 0L;
    private long expirerStopTime = 0L;
    private long startTime = 0L;
    private boolean cleanupDeletedItems = false;
    private int diagIndex = 0;
    private long[] alarmTime = new long[30];
    private long[] logIndexSize = new long[30];
    private long[] logProcessed = new long[30];
    private long[] logExpired = new long[30];
    private long[] logRemain = new long[30];
    private long[] logGone = new long[30];
    private long[] logCleaned = new long[30];
    private int countForCleanup = 0;
    private int batchCount = 0;
    private int cleanupLimit = 5;

    public Expirer(MessageStoreImpl ms) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.messageStore = ms;
        this.expiryIndex = new ExpiryIndex();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addExpirable(Expirable expirable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " addEnabled=" + this.addEnabled));
        }
        boolean reply = false;
        if (this.addEnabled && expirable != null) {
            long expiryTime = expirable.expirableGetExpiryTime();
            ExpirableReference expirableRef = new ExpirableReference(expirable);
            expirableRef.setExpiryTime(expiryTime);
            if (expirable.expirableIsInStore()) {
                ExpirerLock expirerLock = this.lockObject;
                synchronized (expirerLock) {
                    reply = this.expiryIndex.put(expirableRef);
                    if (reply) {
                        boolean scheduled = false;
                        if (this.runEnabled && this.expiryIndex.size() == 1) {
                            this.scheduleAlarm(this.interval);
                            scheduled = true;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Added: ET=" + expirableRef.getExpiryTime() + ", objId=" + expirableRef.getID() + ", scheduled=" + scheduled));
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Duplicate expirable: ET=" + expirableRef.getExpiryTime() + ", objId=" + expirableRef.getID()));
                        }
                        this.runEnabled = false;
                        Object[] o = new Object[]{expirableRef.getExpiryTime() + " : " + expirableRef.getID()};
                        SevereMessageStoreException e = new SevereMessageStoreException("DUPLICATE_EXPIRABLE_SIMS2000", o);
                        this.lastException = e;
                        this.lastExceptionTime = Expirer.timeNow();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"addExpirable");
                        }
                        throw e;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addExpirable", (Object)("reply=" + reply));
        }
        return reply;
    }

    public final boolean isRunning() {
        return this.runEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeExpirable(Expirable expirable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " ET=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetExpiryTime())) + " addEnabled=" + this.addEnabled));
        }
        boolean reply = false;
        boolean cancelled = false;
        ExpirerLock expirerLock = this.lockObject;
        synchronized (expirerLock) {
            if (this.addEnabled && expirable != null) {
                long expiryTime = expirable.expirableGetExpiryTime();
                ExpirableReference expirableRef = new ExpirableReference(expirable);
                expirableRef.setExpiryTime(expiryTime);
                reply = this.expiryIndex.remove(expirableRef);
                if (reply && this.expiryIndex.size() <= 0 && this.expiryAlarm != null) {
                    this.expiryAlarm.cancel();
                    this.alarmScheduled = false;
                    cancelled = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeExpirable", (Object)("reply=" + reply + " cancelled=" + cancelled));
        }
        return reply;
    }

    public final int size() {
        int size = this.expiryIndex.size();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(long expiryInterval, JsMessagingEngine jsme) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)("interval=" + expiryInterval + " indexSize=" + this.expiryIndex.size()));
        }
        this.messagingEngine = jsme;
        if (expiryInterval >= 0L) {
            this.interval = expiryInterval;
        } else {
            String value = this.messageStore.getProperty("expiryInterval", "1000");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Value from property=<" + value + ">"));
            }
            try {
                this.interval = Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                this.lastException = e;
                this.lastExceptionTime = Expirer.timeNow();
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Unable to parse property: " + e));
                this.interval = 1000L;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("expiryInterval=" + this.interval));
        }
        ExpirerLock expirerLock = this.lockObject;
        synchronized (expirerLock) {
            if (this.interval < 1L) {
                this.runEnabled = false;
                this.addEnabled = false;
            } else if (this.expiryAlarm == null) {
                this.runEnabled = true;
                this.addEnabled = true;
                this.expirerStartTime = Expirer.timeNow();
                if (this.expiryIndex.size() > 0) {
                    this.scheduleAlarm(this.interval);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Expiry already started");
                }
                SevereMessageStoreException e = new SevereMessageStoreException("EXPIRY_THREAD_ALREADY_RUNNING_SIMS2004");
                this.lastException = e;
                this.lastExceptionTime = Expirer.timeNow();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start");
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)("runEnabled=" + this.runEnabled + " addEnabled=" + this.addEnabled + " interval=" + this.interval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        ExpirerLock expirerLock = this.lockObject;
        synchronized (expirerLock) {
            this.addEnabled = false;
            if (this.runEnabled) {
                this.runEnabled = false;
                this.expirerStopTime = Expirer.timeNow();
            }
            if (this.expiryAlarm != null) {
                this.expiryAlarm.cancel();
                this.expiryAlarm = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object obj) {
        long remain;
        long gone;
        long cleaned;
        long expired;
        long processed;
        block54: {
            if (this.messagingEngine != null) {
                SibTr.push((Object)this.messagingEngine);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("Expiry=" + this.expiryIndex.size()));
            }
            ExpirerLock expirerLock = this.lockObject;
            synchronized (expirerLock) {
                this.alarmScheduled = false;
                while (this.alarming) {
                    try {
                        this.lockObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.alarming = true;
            }
            ExternalLocalTransaction transaction = null;
            int indexUsed = 0;
            processed = 0L;
            expired = 0L;
            cleaned = 0L;
            gone = 0L;
            remain = 0L;
            try {
                Expirable expirable;
                ++this.countForCleanup;
                if (this.countForCleanup >= this.cleanupLimit) {
                    this.countForCleanup = 0;
                    this.cleanupDeletedItems = true;
                } else {
                    this.cleanupDeletedItems = false;
                }
                this.startTime = System.currentTimeMillis();
                indexUsed = this.saveStartTime(this.startTime);
                this.expiryIndex.resetIterator();
                ExpirableReference expirableRef = this.expiryIndex.next();
                while (this.runEnabled && expirableRef != null && expirableRef.getExpiryTime() <= this.startTime) {
                    ++processed;
                    expirable = (Expirable)expirableRef.get();
                    if (expirable != null && expirable.expirableIsInStore()) {
                        if (transaction == null) {
                            transaction = this.messageStore.getTransactionFactory().createLocalTransaction();
                        }
                        if (expirable.expirableExpire((PersistentTransaction)transaction)) {
                            ++expired;
                            this.remove(expirableRef, true);
                            ++this.batchCount;
                            if (this.batchCount >= 20) {
                                transaction.commit();
                                transaction = null;
                                this.batchCount = 0;
                            }
                        } else {
                            ++remain;
                        }
                    } else if (this.remove(expirableRef, false)) {
                        ++gone;
                    }
                    expirableRef = this.expiryIndex.next();
                }
                if (this.cleanupDeletedItems) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Expiry cleanup in progress");
                    }
                    while (this.runEnabled && expirableRef != null) {
                        expirable = (Expirable)expirableRef.get();
                        if ((expirable == null || !expirable.expirableIsInStore()) && this.remove(expirableRef, false)) {
                            ++cleaned;
                        }
                        expirableRef = this.expiryIndex.next();
                    }
                    if (cleaned < 10L && this.cleanupLimit < 100) {
                        this.cleanupLimit += 5;
                    } else if (cleaned > 1000L && this.cleanupLimit > 5) {
                        this.cleanupLimit = 5;
                    } else if (cleaned > 100L && this.cleanupLimit > 5) {
                        this.cleanupLimit -= 5;
                    }
                }
                if (transaction != null) {
                    if (this.batchCount == 0) {
                        transaction.rollback();
                    } else {
                        transaction.commit();
                        this.batchCount = 0;
                    }
                    transaction = null;
                }
                this.consecutiveFailures = 0;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.expiry.Expirer.run", (String)"441", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("Expiry thread exception: " + e));
                }
                this.consecutiveFailures = (byte)(this.consecutiveFailures + 1);
                this.lastException = e;
                this.lastExceptionTime = Expirer.timeNow();
                if (this.consecutiveFailures <= 3) break block54;
                ExpirerLock expirerLock2 = this.lockObject;
                synchronized (expirerLock2) {
                    this.runEnabled = false;
                    this.addEnabled = false;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)e);
                }
                throw new MessageStoreRuntimeException("EXPIRY_DAEMON_TERMINATED_SIMS2001", new Object[]{e}, (Throwable)e);
            }
            finally {
                long currIndexSize = 0L;
                ExpirerLock expirerLock3 = this.lockObject;
                synchronized (expirerLock3) {
                    this.alarming = false;
                    currIndexSize = this.expiryIndex.size();
                    if (this.runEnabled) {
                        if (currIndexSize > 0L) {
                            this.scheduleAlarm(this.interval);
                        }
                    } else {
                        this.addEnabled = false;
                    }
                    this.lockObject.notifyAll();
                }
                this.logIndexSize[indexUsed] = currIndexSize;
                this.logProcessed[indexUsed] = processed;
                this.logExpired[indexUsed] = expired;
                this.logGone[indexUsed] = gone;
                this.logRemain[indexUsed] = remain;
                this.logCleaned[indexUsed] = cleaned;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)(" processed=" + processed + " gone=" + gone + " expired=" + expired + " remain=" + remain + " cleaned=" + cleaned + " expiry=" + this.expiryIndex.size() + " cl=" + this.cleanupLimit + " alarmScheduled=" + this.alarmScheduled));
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    private final boolean remove(ExpirableReference expirableRef, boolean expired) {
        boolean reply = this.expiryIndex.remove();
        if (reply) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removed (" + (expired ? "expired" : "gone") + ") ET=" + expirableRef.getExpiryTime() + " objId=" + expirableRef.getID()));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Unable to remove from index:  ET=" + expirableRef.getExpiryTime() + " objId=" + expirableRef.getID()));
        }
        return reply;
    }

    private int saveStartTime(long time) {
        int indexUsed = this.diagIndex;
        this.alarmTime[this.diagIndex++] = time;
        if (this.diagIndex >= 30) {
            this.diagIndex = 0;
        }
        return indexUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAlarm(long timeOut) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"scheduleAlarm", (Object)("timeOut=" + timeOut));
        }
        ExpirerLock expirerLock = this.lockObject;
        synchronized (expirerLock) {
            if (!this.alarmScheduled && !this.alarming) {
                this.expiryAlarm = AlarmManager.createNonDeferrable((long)timeOut, (AlarmListener)this);
                this.alarmScheduled = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"scheduleAlarm", (Object)this.alarmScheduled);
        }
    }

    public static long timeNow() {
        return System.currentTimeMillis();
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        String timeNow = dateFormat.format(new Date());
        writer.newLine();
        writer.startTag("expirer");
        writer.indent();
        writer.newLine();
        writer.taggedValue("timeNow", (Object)timeNow);
        writer.newLine();
        writer.taggedValue("interval", this.interval);
        writer.newLine();
        writer.taggedValue("addEnabled", (Object)this.addEnabled);
        writer.newLine();
        writer.taggedValue("runEnabled", (Object)this.runEnabled);
        writer.newLine();
        writer.taggedValue("cleanupFlag", (Object)this.cleanupDeletedItems);
        writer.newLine();
        writer.taggedValue("expirerStartTime", (Object)dateFormat.format(new Date(this.expirerStartTime)));
        writer.newLine();
        writer.taggedValue("expirerStopTime", (Object)dateFormat.format(new Date(this.expirerStopTime)));
        writer.newLine();
        writer.taggedValue("nextLogIndex", (long)this.diagIndex);
        writer.newLine();
        for (int i = 0; i < 30; ++i) {
            String str = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + dateFormat.format(new Date(this.alarmTime[i])) + " size=" + this.logIndexSize[i] + " processed=" + this.logProcessed[i] + " expired=" + this.logExpired[i] + " remain=" + this.logRemain[i] + " gone=" + this.logGone[i] + " cleaned=" + this.logCleaned[i];
            writer.taggedValue("info", (Object)str);
            writer.newLine();
        }
        writer.startTag("storedException");
        if (this.lastException == null) {
            writer.write("No exceptions recorded");
        } else {
            writer.indent();
            writer.newLine();
            writer.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            writer.outdent();
            writer.write((Throwable)this.lastException);
            writer.newLine();
        }
        writer.endTag("storedException");
        writer.outdent();
        writer.newLine();
        writer.endTag("expirer");
    }

    private static final class ExpirerLock {
        private ExpirerLock() {
        }
    }
}

