/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.logging.probeExtensionImpl;

import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

public class EventLoggingProbeExtension
implements ProbeExtension {
    private static final TraceComponent tc = Tr.register(EventLoggingProbeExtension.class, (String)"eventLogging", (String)"com.ibm.ws.event.logging.internal.resources.LoggingMessages");
    private static final Logger _logger = Logger.getLogger("EventLogging", "com.ibm.ws.event.logging.internal.resources.LoggingMessages");
    private static int sampleRate = 0;
    private static boolean entryEnabled = false;
    private static boolean exitEnabled = false;
    private static List<String> eventTypes = null;
    private static int minDuration = 0;
    private static boolean includeContextInfo = true;

    @Activate
    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.configureService(configuration);
        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"EVENT_LOGGING_STARTUP_INFO", (Object[])new Object[]{sampleRate, minDuration, eventTypes});
        }
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" Modified", (Object[])new Object[0]);
        }
        this.configureService(configuration);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[]{"reason=" + reason});
        }
    }

    public void processEntryEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processEntryEvent " + event), (Object[])new Object[0]);
        }
        if (_logger.isLoggable(Level.INFO)) {
            try {
                LogRecordContext.addExtension((String)"eventType", (String)event.getType());
                if (includeContextInfo && event.getContextInfo() != null) {
                    LogRecordContext.addExtension((String)"contextInfo", (String)event.getContextInfo().toString());
                }
                if (includeContextInfo && event.getContextInfo() != null) {
                    _logger.info("BEGIN requestID=" + requestContext.getRequestId().getId() + " # " + "eventType=" + event.getType() + " # " + "contextInfo=" + event.getContextInfo());
                } else {
                    _logger.info("BEGIN requestID=" + requestContext.getRequestId().getId() + " # " + "eventType=" + event.getType());
                }
            }
            finally {
                LogRecordContext.removeExtension((String)"eventType");
                if (includeContextInfo && event.getContextInfo() != null) {
                    LogRecordContext.removeExtension((String)"contextInfo");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExitEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processExitEvent " + event), (Object[])new Object[0]);
        }
        if (_logger.isLoggable(Level.INFO)) {
            try {
                double duration = (double)(event.getEndTime() - event.getStartTime()) / 1000000.0;
                if (duration >= (double)EventLoggingProbeExtension.getMinDuration()) {
                    LogRecordContext.addExtension((String)"eventType", (String)event.getType());
                    if (includeContextInfo && event.getContextInfo() != null) {
                        LogRecordContext.addExtension((String)"contextInfo", (String)event.getContextInfo().toString());
                    }
                    if (includeContextInfo && event.getContextInfo() != null) {
                        _logger.info("END requestID=" + requestContext.getRequestId().getId() + " # " + "eventType=" + event.getType() + " # " + "contextInfo=" + event.getContextInfo() + " # " + "duration=" + String.format("%.3f", duration) + "ms");
                    } else {
                        _logger.info("END requestID=" + requestContext.getRequestId().getId() + " # " + "eventType=" + event.getType() + " # " + "duration=" + String.format("%.3f", duration) + "ms");
                    }
                }
            }
            finally {
                LogRecordContext.removeExtension((String)"eventType");
                if (includeContextInfo && event.getContextInfo() != null) {
                    LogRecordContext.removeExtension((String)"contextInfo");
                }
            }
        }
    }

    public void processCounter(Event event) {
    }

    public static int getMinDuration() {
        return minDuration;
    }

    public boolean invokeForRootEventsOnly() {
        return false;
    }

    public int getRequestSampleRate() {
        return sampleRate;
    }

    public int getContextInfoRequirement() {
        if (includeContextInfo) {
            return 1;
        }
        return 2;
    }

    public List<String> invokeForEventTypes() {
        return eventTypes;
    }

    public boolean invokeForEventEntry() {
        return entryEnabled;
    }

    public boolean invokeForEventExit() {
        return exitEnabled;
    }

    public boolean invokeForCounter() {
        return false;
    }

    private void configureService(Map<String, Object> configuration) {
        boolean sampleRateSet = false;
        boolean logModeSet = false;
        boolean minDurationSet = false;
        boolean includeContextInfoSet = false;
        boolean includeTypesSet = false;
        for (Map.Entry<String, Object> configElement : configuration.entrySet()) {
            String configKey = configElement.getKey();
            Object configValue = configElement.getValue();
            if (configKey.compareTo("sampleRate") == 0) {
                sampleRate = Integer.parseInt(configValue.toString());
                if (sampleRate < 1) {
                    sampleRate = 1;
                }
                sampleRateSet = true;
                continue;
            }
            if (configKey.compareTo("logMode") == 0) {
                if (configValue.toString().equals("entry")) {
                    entryEnabled = true;
                    exitEnabled = false;
                } else if (configValue.toString().equals("exit")) {
                    entryEnabled = false;
                    exitEnabled = true;
                } else if (configValue.toString().equals("entryExit")) {
                    entryEnabled = true;
                    exitEnabled = true;
                }
                logModeSet = true;
                continue;
            }
            if (configKey.compareTo("eventTypes") == 0) {
                String includeTypesStr = configValue.toString();
                if (!includeTypesStr.equals("all")) {
                    eventTypes = new ArrayList<String>();
                    for (String eventType : includeTypesStr.split(",")) {
                        eventTypes.add(eventType.trim());
                    }
                } else {
                    eventTypes = null;
                }
                includeTypesSet = true;
                continue;
            }
            if (configKey.compareTo("minDuration") == 0) {
                minDuration = Integer.parseInt(configValue.toString());
                minDurationSet = true;
                continue;
            }
            if (configKey.compareTo("includeContextInfo") != 0) continue;
            includeContextInfo = Boolean.parseBoolean(configValue.toString());
            includeContextInfoSet = true;
        }
        if (!sampleRateSet) {
            sampleRate = 1;
        }
        if (!logModeSet) {
            entryEnabled = false;
            exitEnabled = true;
        }
        if (!minDurationSet) {
            minDuration = 500;
        }
        if (!includeTypesSet) {
            eventTypes = new ArrayList<String>(){
                {
                    this.add("websphere.servlet.service");
                }
            };
        }
        if (!includeContextInfoSet) {
            includeContextInfo = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer eventLoggingCfg = new StringBuffer();
            eventLoggingCfg.append(String.format("%n", new Object[0]));
            eventLoggingCfg.append("-------------------Event Logging Settings-------------------" + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Sample rate: " + sampleRate + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Context info requirement: " + (includeContextInfo ? 1 : 2) + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Entry Enabled: " + entryEnabled + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Exit Enabled: " + exitEnabled + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Minimum duration of request (ms): " + minDuration + String.format("%n", new Object[0]));
            eventLoggingCfg.append("Event Types: " + eventTypes + String.format("%n", new Object[0]));
            eventLoggingCfg.append("-------------------------------------------------------------");
            Tr.debug((TraceComponent)tc, (String)"Event logging configuration", (Object[])new Object[]{eventLoggingCfg});
        }
    }
}

