/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.lang.LocalesModifier;
import com.ibm.ws.security.common.web.JavaScriptUtils;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginWebappConfig;
import com.ibm.ws.security.social.error.ErrorHandlerImpl;
import com.ibm.ws.security.social.internal.utils.SocialTaiRequest;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import com.ibm.ws.security.social.web.utils.ConfigInfoJsonBuilder;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SelectionPageGenerator {
    private static TraceComponent tc = Tr.register(SelectionPageGenerator.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String HTML_CLASS_CONTAINER = "container";
    public static final String HTML_CLASS_SIDE = "side";
    public static final String HTML_CLASS_SIDE_LEFT = "left";
    public static final String HTML_CLASS_SIDE_RIGHT = "right";
    public static final String HTML_CLASS_MAIN_CONTENT = "main";
    public static final String HTML_CLASS_SOCIAL_MEDIA = "social_media";
    public static final String HTML_CLASS_FIELDSET = "fieldset";
    public static final String HTML_CLASS_LEGEND = "legend";
    public static final String HTML_CLASS_MEDIUM = "medium";
    public static final String HTML_CLASS_MID_SECTION = "mid_section";
    public static final String HTML_CLASS_OR = "or";
    public static final String HTML_CLASS_CREDENTIALS = "credentials";
    public static final String HTML_CLASS_BUTTONS = "buttons";
    public static final String HTML_CLASS_BUTTON = "button";
    public static final String HTML_CLASS_SUBMIT = "submit";
    public static final String HTML_CLASS_CRED_INPUTS = "inputs";
    public static final String HTML_CLASS_LABEL = "label";
    public static final String HTML_CLASS_CRED_INPUT = "cred_input";
    public static final String PARAM_ORIGINAL_REQ_URL = "request_url";
    public static final String PARAM_REQUEST_METHOD = "request_method";
    public static final String PARAM_CONFIG_JSON_DATA = "configuration";
    public static final String PARAM_SUBMIT_PARAM_NAME = "submit_param_name";
    public static final String J_SECURITY_CHECK = "j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    private final String createCookieFunctionName = "createHintCookie";
    private HttpServletRequest request = null;
    private Collection<SocialLoginConfig> selectableConfigs = null;
    private String targetUrl = null;
    private String requestMethod = null;
    private Map<String, String[]> parameterMap = null;
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = 121794673249764682L;

    public void displaySelectionPage(HttpServletRequest request, HttpServletResponse response, SocialTaiRequest socialTaiRequest) throws IOException {
        this.setRequestAndConfigInformation(request, response, socialTaiRequest);
        if (this.selectableConfigs == null || this.selectableConfigs.isEmpty()) {
            this.sendDisplayError(response, "SIGN_IN_NO_CONFIGS", new Object[0]);
            return;
        }
        this.generateOrSendToAppropriateSelectionPage(response);
    }

    void setRequestAndConfigInformation(HttpServletRequest request, HttpServletResponse response, SocialTaiRequest socialTaiRequest) {
        this.request = request;
        this.selectableConfigs = this.getSocialLoginConfigs(socialTaiRequest);
        this.targetUrl = this.getRequestUrl(request);
        this.requestMethod = request.getMethod();
        this.parameterMap = request.getParameterMap();
        this.saveRequestUrlAndParametersForLocalAuthentication(request, response);
    }

    Collection<SocialLoginConfig> getSocialLoginConfigs(SocialTaiRequest socialTaiRequest) {
        return socialTaiRequest.getAllMatchingConfigs();
    }

    String getRequestUrl(HttpServletRequest request) {
        StringBuffer reqUrl = request.getRequestURL();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got original request URL: [" + reqUrl.toString() + "]"), (Object[])new Object[0]);
        }
        return reqUrl.toString();
    }

    void saveRequestUrlAndParametersForLocalAuthentication(HttpServletRequest request, HttpServletResponse response) {
        this.webUtils.saveRequestUrlAndParameters(request, response);
    }

    void generateOrSendToAppropriateSelectionPage(HttpServletResponse response) throws IOException {
        if (this.isCustomSelectionPageConfigured()) {
            this.redirectToCustomSelectionPage(response);
        } else {
            this.generateDefaultSelectionPage(response);
        }
    }

    boolean isCustomSelectionPageConfigured() {
        SocialLoginWebappConfig config = this.getSocialLoginWebappConfig();
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No webapp configuration present", (Object[])new Object[0]);
            }
            return false;
        }
        String selectionPageUrl = config.getSocialMediaSelectionPageUrl();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got selection page URL: " + selectionPageUrl), (Object[])new Object[0]);
        }
        return selectionPageUrl != null;
    }

    void redirectToCustomSelectionPage(HttpServletResponse response) throws IOException {
        SocialLoginWebappConfig config = this.getSocialLoginWebappConfig();
        if (config == null) {
            Tr.warning((TraceComponent)tc, (String)"CUSTOM_SELECTION_INITED_MISSING_WEBAPP_CONFIG", (Object[])new Object[0]);
            this.generateDefaultSelectionPage(response);
            return;
        }
        String socialMediaSelectionPageUrl = config.getSocialMediaSelectionPageUrl();
        this.redirectToCustomSelectionPageUrl(response, socialMediaSelectionPageUrl);
    }

    void redirectToCustomSelectionPageUrl(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(url + "?" + this.buildCustomRedirectUriQuery());
    }

    String buildCustomRedirectUriQuery() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ORIGINAL_REQ_URL, this.getOriginalRequestUrlWithRequestParameters());
        params.put(PARAM_REQUEST_METHOD, this.requestMethod);
        params.put(PARAM_SUBMIT_PARAM_NAME, "social_login_hint");
        params.put(PARAM_CONFIG_JSON_DATA, this.getConfigInformationParameterString());
        return this.buildCustomRedirectUriQuery(params);
    }

    String buildCustomRedirectUriQuery(Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        if (params != null) {
            Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                query.append(WebUtils.urlEncode((String)entry.getKey())).append("=").append(WebUtils.urlEncode((String)entry.getValue()));
                if (!iter.hasNext()) continue;
                query.append("&");
            }
        }
        return query.toString();
    }

    String getOriginalRequestUrlWithRequestParameters() {
        StringBuilder url = new StringBuilder();
        if (this.targetUrl != null) {
            url.append(this.targetUrl);
        }
        if (this.parameterMap != null && !this.parameterMap.isEmpty()) {
            url.append("?");
            url.append(this.webUtils.getUrlEncodedQueryStringFromParameterMap(this.parameterMap));
        }
        return url.toString();
    }

    String getConfigInformationParameterString() {
        ConfigInfoJsonBuilder jsonBuilder = new ConfigInfoJsonBuilder(this.selectableConfigs);
        JSONObject configInformation = jsonBuilder.buildJsonResponse();
        return configInformation == null ? "" : configInformation.toString();
    }

    void generateDefaultSelectionPage(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.print(this.createSignInHtml());
        writer.close();
    }

    String createSignInHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html " + this.getHtmlLang() + ">\n");
        html.append(this.createHtmlHead());
        html.append(this.createHtmlBody());
        html.append("</html>");
        return html.toString();
    }

    String getHtmlLang() {
        if (this.request != null) {
            return "lang=\"" + this.request.getLocale() + "\"";
        }
        return "";
    }

    String createHtmlHead() {
        StringBuilder html = new StringBuilder();
        html.append("<head>\n");
        html.append("<meta charset=\"utf-8\">\n");
        html.append("<title>" + WebUtils.htmlEncode((String)this.getHtmlTitle()) + "</title>\n");
        html.append(this.createCssContentString());
        html.append(this.createJavascript());
        html.append("</head>\n");
        return html.toString();
    }

    String createJavascript() {
        StringBuilder html = new StringBuilder();
        html.append("<script>\n");
        html.append("function createHintCookie(value) {\n");
        html.append("document.cookie = \"social_login_hint=\" + value + \";" + this.getJavaScriptCookiePropsString() + "\";\n");
        html.append("}\n");
        html.append("</script>\n");
        return html.toString();
    }

    String getJavaScriptCookiePropsString() {
        JavaScriptUtils jsUtils = new JavaScriptUtils();
        return jsUtils.createHtmlCookiePropertiesString(jsUtils.getWebAppSecurityConfigCookieProperties());
    }

    String getHtmlTitle() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_TITLE", (Object[])new Object[0]);
    }

    String createHtmlBody() {
        StringBuilder html = new StringBuilder();
        html.append("<body>\n");
        html.append("<div class=\"container\">\n");
        html.append("<div class=\"side left\"></div>\n");
        html.append(this.createHtmlMainContent());
        html.append("<div class=\"side right\"></div>\n");
        html.append("</div>\n");
        html.append("</body>\n");
        return html.toString();
    }

    String createHtmlMainContent() {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"main\">\n");
        html.append(this.createHtmlForSocialMediaSelections());
        if (this.isLocalAuthenticationEnabled()) {
            html.append(this.createHtmlForLocalAuthentication());
        }
        html.append("</div>\n");
        return html.toString();
    }

    boolean isLocalAuthenticationEnabled() {
        SocialLoginWebappConfig config = this.getSocialLoginWebappConfig();
        return config != null && config.isLocalAuthenticationEnabled();
    }

    String createHtmlForLocalAuthentication() {
        StringBuilder html = new StringBuilder();
        html.append(this.createHtmlForMiddleSection());
        html.append(this.createHtmlForCredentials());
        return html.toString();
    }

    String createHtmlForSocialMediaSelections() {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"social_media\">\n");
        html.append("<header>" + WebUtils.htmlEncode((String)this.getPageHeader()) + "</header>\n");
        html.append("<div class=\"buttons\">\n");
        html.append(this.createHtmlFormWithButtons());
        html.append("</div>\n");
        html.append("</div>\n");
        return html.toString();
    }

    String getPageHeader() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_HEADER", (Object[])new Object[0]);
    }

    String createHtmlFormWithButtons() {
        StringBuilder html = new StringBuilder();
        html.append("<form action=\"" + WebUtils.htmlEncode((String)this.targetUrl) + "\" method=\"" + this.requestMethod + "\">\n");
        if (this.selectableConfigs != null) {
            for (SocialLoginConfig config : this.selectableConfigs) {
                html.append(this.createButtonHtml(config));
            }
        }
        html.append(this.getHiddenInputHtmlForRequestParameters());
        html.append("</form>\n");
        return html.toString();
    }

    String createButtonHtml(SocialLoginConfig config) {
        if (config == null) {
            return "";
        }
        String uniqueId = config.getUniqueId();
        String displayName = config.getDisplayName();
        String buttonValue = WebUtils.htmlEncode((String)this.getObscuredConfigId(uniqueId));
        StringBuilder buttonHtml = new StringBuilder();
        buttonHtml.append("<button type=\"submit\" ");
        buttonHtml.append("class=\"button medium\" ");
        buttonHtml.append("value=\"" + buttonValue + "\" ");
        buttonHtml.append("onclick=\"createHintCookie(" + buttonValue + ")\" ");
        buttonHtml.append(">");
        if (displayName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"displayName was not configured for this config, will use the id attribute instead", (Object[])new Object[0]);
            }
            displayName = uniqueId;
        }
        buttonHtml.append(WebUtils.htmlEncode((String)displayName));
        buttonHtml.append("</button>\n");
        return buttonHtml.toString();
    }

    String getObscuredConfigId(String configId) {
        return SocialLoginTAI.getObscuredIdFromConfigId(configId);
    }

    String createHtmlForMiddleSection() {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"mid_section\">\n");
        html.append("<header class=\"or\">" + this.getMiddleSectionText() + "</header>\n");
        html.append("</div>\n");
        return html.toString();
    }

    String getMiddleSectionText() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_ALTERNATE_TEXT", (Object[])new Object[0]);
    }

    String createHtmlForCredentials() {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"credentials\">\n");
        html.append(this.createJSecurityCheckForm());
        html.append("</div>\n");
        return html.toString();
    }

    String createJSecurityCheckForm() {
        StringBuilder html = new StringBuilder();
        html.append("<form action=\"j_security_check\" method=\"POST\">\n");
        html.append(this.createCredentialFieldsetHtml());
        html.append("</form>\n");
        return html.toString();
    }

    String createCredentialFieldsetHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<fieldset>\n");
        html.append("<legend>" + this.getLocalAuthenticationLegendText() + "</legend>\n");
        html.append(this.createCredentialInputsDiv());
        html.append("</fieldset>\n");
        return html.toString();
    }

    String getLocalAuthenticationLegendText() {
        return "";
    }

    String createCredentialInputsDiv() {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"inputs\">\n");
        html.append(this.createUsernameInputHtml());
        html.append(this.createPasswordInputHtml());
        html.append(this.createFormSubmitButtonHtml());
        html.append(this.getHiddenInputHtmlForRequestParameters());
        html.append("</div>\n");
        return html.toString();
    }

    String createUsernameInputHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<label for=\"j_username\">" + this.getUsernamePlaceholderText() + "</label>\n");
        html.append("<input id=\"j_username\" name=\"j_username\" class=\"cred_input\" placeholder=\"" + this.getUsernamePlaceholderText() + "\" >\n");
        return html.toString();
    }

    String getUsernamePlaceholderText() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_USERNAME", (Object[])new Object[0]);
    }

    String createPasswordInputHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<label for=\"j_password\">" + this.getPasswordPlaceholderText() + "</label>\n");
        html.append("<input id=\"j_password\" name=\"j_password\" class=\"cred_input\" placeholder=\"" + this.getPasswordPlaceholderText() + " \"type=\"password\" >\n");
        return html.toString();
    }

    String getPasswordPlaceholderText() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_PASSWORD", (Object[])new Object[0]);
    }

    String createFormSubmitButtonHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<input type=\"submit\" class=\"button submit\" value=\"" + this.getSubmitButtonText() + "\" >\n");
        return html.toString();
    }

    String getSubmitButtonText() {
        return Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale((Enumeration)this.request.getLocales()), (String)"SELECTION_PAGE_SUBMIT", (Object[])new Object[0]);
    }

    String getHiddenInputHtmlForRequestParameters() {
        StringBuilder html = new StringBuilder();
        if (this.parameterMap != null) {
            Set<Map.Entry<String, String[]>> entries = this.parameterMap.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                html.append(this.getHiddenInputForRequestParam(entry));
            }
        }
        return html.toString();
    }

    String getHiddenInputForRequestParam(Map.Entry<String, String[]> entry) {
        StringBuilder html = new StringBuilder();
        String key = entry.getKey();
        String[] strs = entry.getValue();
        if (strs != null && strs.length > 0) {
            for (String value : strs) {
                html.append(this.getHiddenInputHtml(key, value));
            }
        }
        return html.toString();
    }

    String getHiddenInputHtml(String paramKey, String paramValue) {
        StringBuilder html = new StringBuilder();
        html.append("<input type=\"hidden\" name=\"" + WebUtils.htmlEncode((String)paramKey, (boolean)false, (boolean)true, (boolean)true) + "\" value=\"" + WebUtils.htmlEncode((String)paramValue, (boolean)false, (boolean)true, (boolean)true) + "\" >\n");
        return html.toString();
    }

    void sendDisplayError(HttpServletResponse response, String msgKey, Object ... args) throws IOException {
        if (msgKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No message key was provided for sub-message, so no sub-message will be included", (Object[])new Object[0]);
            }
            msgKey = "";
        }
        String subMsg = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])args);
        Tr.error((TraceComponent)tc, (String)"ERROR_DISPLAYING_SIGN_IN_PAGE", (Object[])new Object[]{subMsg});
        ErrorHandlerImpl.getInstance().handleErrorResponse(response);
    }

    String createCssContentString() {
        StringBuilder css = new StringBuilder();
        css.append("<style>\n");
        css.append("html, body {");
        css.append("margin: 0;");
        css.append("}\n");
        css.append("body {");
        css.append("background-color: #152935;");
        css.append("font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;");
        css.append("}\n");
        css.append(".container {");
        css.append("display: flex;");
        css.append("min-height: 100vh;");
        css.append("}\n");
        css.append(".side {");
        css.append("max-width: 33%;");
        css.append("flex: 1;");
        css.append("display: flex;");
        css.append("}\n");
        css.append(".main {");
        css.append("background-color: white;");
        css.append("min-width: 300px;");
        css.append("max-width: 40%;");
        css.append("padding: 0px 20px;");
        css.append("}\n");
        css.append(".social_media {");
        css.append("padding-top: 50px;");
        css.append("}\n");
        css.append("header {");
        css.append("color: #152935;");
        css.append("font-size: 1.2em;");
        css.append("font-weight: bold;");
        css.append("text-align: center;");
        css.append("padding-bottom: 10px;");
        css.append("}\n");
        css.append(".buttons {");
        css.append("display: flex;");
        css.append("flex-flow: row wrap;");
        css.append("justify-content: center;");
        css.append("text-align: center;");
        css.append("}\n");
        css.append("fieldset {");
        css.append("border: 0;");
        css.append("padding: 0;");
        css.append("}\n");
        css.append("legend {");
        css.append("color: #152935;");
        css.append("padding-bottom: 10px;");
        css.append("}\n");
        css.append(".button {");
        css.append("background-color: white;");
        css.append("border: 2px solid #2A4E7B;");
        css.append("cursor: pointer;");
        css.append("font-weight: 200;");
        css.append("font-size: 0.9em;");
        css.append("padding: 10px 30px;");
        css.append("text-align: center;");
        css.append("}\n");
        css.append(".button:hover, .button:focus {");
        css.append("background-color: #4178BE;");
        css.append("color: white;");
        css.append("}\n");
        css.append(".medium {");
        css.append("margin: 10px;");
        css.append("width: 250px;");
        css.append("}\n");
        css.append(".mid_section {");
        css.append("padding: 30px 0px;");
        css.append("text-align: center");
        css.append("}\n");
        css.append(".or {");
        css.append("overflow: hidden;");
        css.append("text-align: center;");
        css.append("}\n");
        css.append(".or:before, .or:after {");
        css.append("background-color: #C0C0C0;");
        css.append("content: \"\";");
        css.append("display: inline-block;");
        css.append("height: 1px;");
        css.append("position: relative;");
        css.append("vertical-align: middle;");
        css.append("width: 47%;");
        css.append("}\n");
        css.append(".or:before {");
        css.append("right: 0.5em;");
        css.append("margin-left: -40%;");
        css.append("}\n");
        css.append(".or:after {");
        css.append("left: 0.5em;");
        css.append("margin-right: -40%;");
        css.append("}\n");
        css.append(".credentials .inputs {");
        css.append("padding: 0px 20px;");
        css.append("}\n");
        css.append("label {");
        css.append("font-size: 0.8em;");
        css.append("color: #777;");
        css.append("}\n");
        css.append(".cred_input {");
        css.append("box-sizing: border-box;");
        css.append("margin-bottom: 15px;");
        css.append("padding: 10px;");
        css.append("max-width: none;");
        css.append("width: 100%;");
        css.append("}\n");
        css.append(".submit {");
        css.append("width: 100%;");
        css.append("}\n");
        css.append("</style>\n");
        return css.toString();
    }

    SocialLoginWebappConfig getSocialLoginWebappConfig() {
        return SocialLoginTAI.getSocialLoginWebappConfig();
    }
}

