/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.execution.ExecutionDecorator;
import io.smallrye.graphql.execution.SpanNaming;
import io.smallrye.graphql.spi.OpenTracingService;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class OpenTracingExecutionDecorator
implements ExecutionDecorator {
    private final Map<ExecutionInput, Scope> executionScopes = Collections.synchronizedMap(new IdentityHashMap());
    OpenTracingService openTracingService = OpenTracingService.load();

    @Override
    public void before(ExecutionInput executionInput) {
        Tracer tracer = this.openTracingService.getTracer();
        String operationName = SpanNaming.getOperationName(executionInput);
        Scope scope = tracer.buildSpan(operationName).asChildOf(tracer.activeSpan()).withTag("graphql.executionId", executionInput.getExecutionId().toString()).withTag("graphql.operationName", executionInput.getOperationName()).startActive(true);
        this.executionScopes.put(executionInput, scope);
        ((GraphQLContext)executionInput.getContext()).put(Span.class, (Object)scope.span());
    }

    @Override
    public void after(ExecutionInput executionInput, ExecutionResult executionResult) {
        Scope scope = this.executionScopes.remove(executionInput);
        if (scope != null) {
            scope.close();
        }
    }

    @Override
    public void onError(ExecutionInput executionInput, Throwable throwable) {
        Scope scope = this.executionScopes.remove(executionInput);
        if (scope != null) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("event.object", throwable);
            error.put("event", "error");
            scope.span().log(error);
            scope.close();
        }
    }
}

