/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.datafetcher.ExecutionContext;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import java.lang.reflect.Method;
import java.util.Iterator;

public class ExecutionContextImpl
implements ExecutionContext {
    private final Object target;
    private final Method method;
    private final Object[] arguments;
    private final GraphQLContext newGraphQLContext;
    private final DataFetchingEnvironment dataFetchingEnvironment;
    private final Iterator<DataFetcherDecorator> decoratorIterator;

    public ExecutionContextImpl(Object target, Method method, Object[] arguments, GraphQLContext newGraphQLContext, DataFetchingEnvironment dataFetchingEnvironment, Iterator<DataFetcherDecorator> decoratorIterator) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
        this.newGraphQLContext = newGraphQLContext;
        this.dataFetchingEnvironment = dataFetchingEnvironment;
        this.decoratorIterator = decoratorIterator;
    }

    @Override
    public Object target() {
        return this.target;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public Object[] arguments() {
        return this.arguments;
    }

    @Override
    public GraphQLContext newGraphQLContext() {
        return this.newGraphQLContext;
    }

    @Override
    public DataFetchingEnvironment dataFetchingEnvironment() {
        return this.dataFetchingEnvironment;
    }

    @Override
    public Object proceed() throws Exception {
        if (this.decoratorIterator.hasNext()) {
            return this.decoratorIterator.next().execute(this);
        }
        return this.method.invoke(this.target, this.arguments);
    }
}

