/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.execution.datafetcher.ExecutionContextImpl;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionDataFetcher
extends AbstractDataFetcher<DataFetcherResult<Object>> {
    public ReflectionDataFetcher(Operation operation, Collection<DataFetcherDecorator> decorators) {
        super(operation, decorators);
    }

    @Override
    protected DataFetcherResult<Object> fetch(DataFetchingEnvironment dfe) throws Exception {
        GraphQLContext context = (GraphQLContext)dfe.getContext();
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)context);
        Class<?> operationClass = this.classloadingService.loadClass(this.operation.getClassName());
        Object declaringObject = this.lookupService.getInstance(operationClass);
        Method m = this.getMethod(operationClass);
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            ExecutionContextImpl executionContext = new ExecutionContextImpl(declaringObject, m, transformedArguments, context, dfe, this.decorators.iterator());
            Object resultFromMethodCall = this.execute(executionContext);
            resultBuilder.data(this.fieldHelper.transformResponse(resultFromMethodCall));
        }
        catch (AbstractDataFetcherException pe) {
            pe.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
        }
        catch (GraphQLException graphQLException) {
            this.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, ex);
        }
        return resultBuilder.build();
    }
}

