/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.language.Field;
import graphql.schema.GraphQLType;
import io.smallrye.graphql.execution.MetricNaming;
import io.smallrye.graphql.execution.datafetcher.ExecutionContext;
import io.smallrye.graphql.execution.datafetcher.decorator.AbstractDataFetcherDecorator;
import io.smallrye.graphql.spi.MetricsService;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MetricDecorator
extends AbstractDataFetcherDecorator {
    private final Map<ExecutionContext, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    private final MetricRegistry metricRegistry = MetricsService.load().getMetricRegistry(MetricRegistry.Type.VENDOR);

    @Override
    public void before(ExecutionContext executionContext) {
        this.startTimes.put(executionContext, System.nanoTime());
    }

    @Override
    public void after(ExecutionContext executionContext) {
        GraphQLType parent = executionContext.dataFetchingEnvironment().getParentType();
        Field field = executionContext.dataFetchingEnvironment().getField();
        Long startTime = this.startTimes.remove(executionContext);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            String name = MetricNaming.fromTypeAndName(parent, field.getName());
            this.metricRegistry.simpleTimer(name).update(Duration.ofNanos(duration));
        }
    }
}

