/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArrayCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MappingHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class FieldCreator {
    private final ReferenceCreator referenceCreator;

    public FieldCreator(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    public Optional<Field> createFieldForInterface(MethodInfo methodInfo) {
        Annotations annotationsForMethod = Annotations.getAnnotationsForInterfaceField(methodInfo);
        if (!IgnoreHelper.shouldIgnore(annotationsForMethod)) {
            Type returnType = methodInfo.returnType();
            String name = FieldCreator.getFieldName(Direction.OUT, annotationsForMethod, methodInfo.name());
            Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForMethod, returnType);
            FieldCreator.validateFieldType(Direction.OUT, methodInfo);
            Reference reference = this.referenceCreator.createReferenceForInterfaceField(returnType, annotationsForMethod);
            Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, maybeDescription.orElse(null), reference);
            if (NonNullHelper.markAsNonNull(returnType, annotationsForMethod)) {
                field.setNotNull(true);
            }
            field.setArray(ArrayCreator.createArray(returnType).orElse(null));
            field.setTransformInfo(FormatHelper.getFormat(returnType, annotationsForMethod).orElse(null));
            field.setMappingInfo(MappingHelper.getMapping(field, annotationsForMethod).orElse(null));
            field.setDefaultValue(DefaultValueHelper.getDefaultValue(annotationsForMethod).orElse(null));
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo) {
        Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo, methodInfo);
        if (!IgnoreHelper.shouldIgnore(annotationsForPojo, fieldInfo)) {
            Type methodType = FieldCreator.getMethodType(methodInfo, direction);
            String name = FieldCreator.getFieldName(direction, annotationsForPojo, methodInfo.name());
            Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForPojo, methodType);
            FieldCreator.validateFieldType(direction, methodInfo);
            Type fieldType = FieldCreator.getFieldType(fieldInfo, methodType);
            Reference reference = this.referenceCreator.createReferenceForPojoField(direction, fieldType, methodType, annotationsForPojo);
            Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(direction, methodInfo.name()), name, maybeDescription.orElse(null), reference);
            if (NonNullHelper.markAsNonNull(methodType, annotationsForPojo)) {
                field.setNotNull(true);
            }
            field.setArray(ArrayCreator.createArray(fieldType, methodType).orElse(null));
            field.setTransformInfo(FormatHelper.getFormat(methodType, annotationsForPojo).orElse(null));
            field.setMappingInfo(MappingHelper.getMapping(field, annotationsForPojo).orElse(null));
            field.setDefaultValue(DefaultValueHelper.getDefaultValue(annotationsForPojo).orElse(null));
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo) {
        if (Modifier.isPublic(fieldInfo.flags())) {
            Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo);
            if (!IgnoreHelper.shouldIgnore(annotationsForPojo, fieldInfo)) {
                String name = FieldCreator.getFieldName(direction, annotationsForPojo, fieldInfo.name());
                Type fieldType = fieldInfo.type();
                Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForPojo, fieldType);
                Reference reference = this.referenceCreator.createReferenceForPojoField(direction, fieldType, fieldType, annotationsForPojo);
                Field field = new Field(fieldInfo.name(), MethodHelper.getPropertyName(direction, fieldInfo.name()), name, maybeDescription.orElse(null), reference);
                if (NonNullHelper.markAsNonNull(fieldType, annotationsForPojo)) {
                    field.setNotNull(true);
                }
                field.setArray(ArrayCreator.createArray(fieldType, fieldType).orElse(null));
                field.setTransformInfo(FormatHelper.getFormat(fieldType, annotationsForPojo).orElse(null));
                field.setMappingInfo(MappingHelper.getMapping(field, annotationsForPojo).orElse(null));
                field.setDefaultValue(DefaultValueHelper.getDefaultValue(annotationsForPojo).orElse(null));
                return Optional.of(field);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static void validateFieldType(Direction direction, MethodInfo methodInfo) {
        Type returnType = methodInfo.returnType();
        if (direction.equals((Object)Direction.OUT) && returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return method [" + methodInfo.name() + "] in class [" + methodInfo.declaringClass().name() + "]");
        }
    }

    private static Type getMethodType(MethodInfo method, Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return (Type)method.parameters().get(0);
        }
        return method.returnType();
    }

    private static Type getFieldType(FieldInfo fieldInfo, Type defaultType) {
        if (fieldInfo == null) {
            return defaultType;
        }
        return fieldInfo.type();
    }

    static String getFieldName(Direction direction, Annotations annotationsForThisField, String defaultFieldName) {
        switch (direction) {
            case OUT: {
                return FieldCreator.getOutputNameForField(annotationsForThisField, defaultFieldName);
            }
            case IN: {
                return FieldCreator.getInputNameForField(annotationsForThisField, defaultFieldName);
            }
        }
        return defaultFieldName;
    }

    private static String getOutputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JSONB_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JSONB_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.OUT, fieldName)));
    }

    private static String getInputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.JSONB_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.JSONB_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.IN, fieldName)));
    }
}

