/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.ServiceLoader;

public interface LookupService {
    public static LookupService load() {
        LookupService lookupService;
        try {
            ServiceLoader<LookupService> sl = ServiceLoader.load(LookupService.class);
            lookupService = sl.iterator().next();
        }
        catch (Exception ex) {
            lookupService = new DefaultLookupService();
        }
        SmallRyeGraphQLServerLogging.log.usingLookupService(lookupService.getName());
        return lookupService;
    }

    public String getName();

    public Class<?> getClass(Class<?> var1);

    public Object getInstance(Class<?> var1);

    public static class DefaultLookupService
    implements LookupService {
        @Override
        public String getName() {
            return "Reflection (default)";
        }

        @Override
        public Class<?> getClass(Class<?> declaringClass) {
            return declaringClass;
        }

        @Override
        public Object getInstance(Class<?> declaringClass) {
            try {
                return declaringClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw SmallRyeGraphQLServerMessages.msg.countNotGetInstance(ex);
            }
        }
    }
}

