/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.opensaml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpMetadataBuilder {
    public static final TraceComponent tc = Tr.register(SpMetadataBuilder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    static final String acsStr = "/acs";
    static final String sloStr = "/slo";
    static final long serialVersionUID = 1202343982933229183L;

    public SpMetadataBuilder(SsoSamlService samlService) {
        this.ssoService = samlService;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SPMetadataBuilder(" + samlService.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    public String buildSpMetadata(HttpServletRequest request) throws SamlException {
        EntityDescriptor entityDescriptor = this.buildEntityDescriptor(request);
        String result = this.getEntityDescriptor(entityDescriptor);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" SpMetadataData:" + result), (Object[])new Object[0]);
        }
        return result;
    }

    EntityDescriptor buildEntityDescriptor(HttpServletRequest request) throws SamlException {
        EntityDescriptorBuilder edBuilder = new EntityDescriptorBuilder();
        EntityDescriptor entityDescriptor = edBuilder.buildObject();
        String spURL = RequestUtil.getEntityUrl(request, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        entityDescriptor.setEntityID(spURL);
        SPSSODescriptorBuilder spSSODescriptorBuilder = new SPSSODescriptorBuilder();
        SPSSODescriptor spSSODescriptor = spSSODescriptorBuilder.buildObject();
        spSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SsoConfig samlConfig = this.ssoService.getConfig();
        boolean wantAssertionsSignedAttr = samlConfig.isWantAssertionsSigned();
        boolean authReqSignedAttr = samlConfig.isAuthnRequestsSigned();
        spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(wantAssertionsSignedAttr));
        spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(authReqSignedAttr));
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.ssoService.getSignatureCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder", (String)"199", (Object)this, (Object[])new Object[]{request});
        }
        catch (CertificateException certificateException) {
            FFDCFilter.processException((Throwable)certificateException, (String)"com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder", (String)"203", (Object)this, (Object[])new Object[]{request});
        }
        if (authReqSignedAttr && cert == null) {
            throw new SamlException("SAML20_NO_CERT", null, true, new Object[]{this.ssoService.getProviderId(), this.ssoService.getConfig().getKeyStoreRef()});
        }
        boolean includeX509 = samlConfig.isIncludeX509InSPMetadata();
        if (cert != null && includeX509) {
            KeyDescriptorBuilder keyDescriptorBuilder = new KeyDescriptorBuilder();
            KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder();
            KeyDescriptor keyDescriptor = keyDescriptorBuilder.buildObject();
            keyDescriptor.setUse(UsageType.SIGNING);
            KeyInfo keyInfo = keyInfoBuilder.buildObject();
            try {
                KeyInfoHelper.addCertificate((KeyInfo)keyInfo, (X509Certificate)cert);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                FFDCFilter.processException((Throwable)certificateEncodingException, (String)"com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder", (String)"226", (Object)this, (Object[])new Object[]{request});
            }
            keyDescriptor.setKeyInfo(keyInfo);
            keyDescriptor.setParent((XMLObject)spSSODescriptor);
            spSSODescriptor.getKeyDescriptors().add(0, keyDescriptor);
            KeyDescriptor encKeyDescriptor = keyDescriptorBuilder.buildObject();
            encKeyDescriptor.setUse(UsageType.ENCRYPTION);
            KeyInfo encKeyInfo = keyInfoBuilder.buildObject();
            try {
                KeyInfoHelper.addCertificate((KeyInfo)encKeyInfo, (X509Certificate)cert);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                FFDCFilter.processException((Throwable)certificateEncodingException, (String)"com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder", (String)"241", (Object)this, (Object[])new Object[]{request});
            }
            encKeyDescriptor.setKeyInfo(encKeyInfo);
            encKeyDescriptor.setParent((XMLObject)spSSODescriptor);
            spSSODescriptor.getKeyDescriptors().add(1, encKeyDescriptor);
        }
        AssertionConsumerServiceBuilder assertionConsumerServiceBuilder = new AssertionConsumerServiceBuilder();
        AssertionConsumerService assertionConsumerService = assertionConsumerServiceBuilder.buildObject();
        assertionConsumerService.setIsDefault(Boolean.TRUE);
        assertionConsumerService.setIndex(Integer.valueOf(0));
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        String acsLoc = spURL.concat(acsStr);
        assertionConsumerService.setLocation(acsLoc);
        spSSODescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        entityDescriptor.getRoleDescriptors().add(spSSODescriptor);
        SingleLogoutService s = new SingleLogoutServiceBuilder().buildObject();
        s.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        s.setLocation(spURL + sloStr);
        spSSODescriptor.getSingleLogoutServices().add(s);
        return entityDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    String getEntityDescriptor(EntityDescriptor entityDescriptor) throws SamlException {
        String result = null;
        if (entityDescriptor != null) {
            try {
                EntityDescriptorMarshaller marshaller = new EntityDescriptorMarshaller();
                Element element = marshaller.marshall((XMLObject)entityDescriptor);
                result = XMLHelper.nodeToString((Node)element);
            }
            catch (MarshallingException marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder", (String)"278", (Object)this, (Object[])new Object[]{entityDescriptor});
                throw new SamlException((Exception)e, true);
            }
        }
        return result;
    }
}

