/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sip.util.log;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Arrays;

public class LogMgr {
    private TraceComponent _tc;

    protected LogMgr(TraceComponent tc) {
        this._tc = tc;
    }

    public void traceEntry(Object obj, String method, Object param) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this._tc, (String)method, (Object[])new Object[]{param});
        }
    }

    public void traceEntry(Object obj, String method, Object ... params) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this._tc, (String)method, (Object[])params);
        }
    }

    public void traceEntry(Object obj, String method) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this._tc, (String)method, (Object[])new Object[0]);
        }
    }

    public void traceDebug(Object obj, String method, String msg) {
        if (this._tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this._tc, (String)(method + "  " + msg), (Object[])new Object[0]);
        }
    }

    public void traceDebug(String message, Object ... objs) {
        if (this._tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this._tc, (String)message, (Object[])objs);
        }
    }

    public void event(String message, Object ... objs) {
        if (this._tc.isEventEnabled()) {
            Tr.event((TraceComponent)this._tc, (String)message, (Object[])objs);
        }
    }

    public void traceDebug(String msg) {
        if (this._tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this._tc, (String)msg, (Object[])new Object[0]);
        }
    }

    public void traceDebug(Object obj, String method, String msg, Throwable e2) {
        if (this._tc.isDebugEnabled()) {
            if (e2 != null) {
                Tr.debug((TraceComponent)this._tc, (String)(method + "  " + msg), (Object[])new Object[]{e2.getLocalizedMessage(), Arrays.toString(e2.getStackTrace())});
            } else {
                Tr.debug((TraceComponent)this._tc, (String)(method + "  " + msg), (Object[])new Object[]{"null"});
            }
        }
    }

    public void traceFailure(String msg) {
        if (this._tc.isEventEnabled()) {
            Tr.event((TraceComponent)this._tc, (String)msg, (Object[])new Object[0]);
        }
    }

    public void traceFailure(Object obj, String method, String msg) {
        if (this._tc.isEventEnabled()) {
            Tr.event((TraceComponent)this._tc, (String)(method + "  " + msg), (Object[])new Object[0]);
        }
    }

    public void traceFailure(Object obj, String method, String msg, Throwable e2) {
        if (this._tc.isEventEnabled()) {
            Tr.event((TraceComponent)this._tc, (String)(method + "  " + msg), (Object[])new Object[]{e2.getLocalizedMessage(), Arrays.toString(e2.getStackTrace())});
        }
    }

    public void traceExit(Object obj, String method) {
        if (this._tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this._tc, (String)method);
        }
    }

    public void traceExit(Object obj, String method, Object param) {
        if (this._tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this._tc, (String)method, (Object)param);
        }
    }

    public void traceExit(Object obj, String method, Object[] params) {
        if (this._tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)this._tc, (String)method, (Object)params);
        }
    }

    public void traceEntryExit(Object obj, String method, Object param) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this._tc, (String)method, (Object[])new Object[]{param});
            Tr.exit((TraceComponent)this._tc, (String)method, (Object)param);
        }
    }

    public void traceEntryExit(Object obj, String method, Object[] params) {
        if (this._tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)this._tc, (String)method, (Object[])params);
            Tr.exit((TraceComponent)this._tc, (String)method, (Object)params);
        }
    }

    public void info(String msg, Object situation_start, Object param) {
        Tr.info((TraceComponent)this._tc, (String)msg, (Object[])new Object[]{param});
    }

    public void info(String msg, Object situation_start, Object[] params) {
        Tr.info((TraceComponent)this._tc, (String)msg, (Object[])params);
    }

    public void info(String msg, Object situation_start) {
        Tr.info((TraceComponent)this._tc, (String)msg, (Object[])new Object[0]);
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void error(String msg, String situation_request, Object param, Throwable e2) {
        if (this._tc.isErrorEnabled()) {
            Tr.error((TraceComponent)this._tc, (String)msg, (Object[])new Object[]{param, e2.getLocalizedMessage(), Arrays.toString(e2.getStackTrace())});
        }
    }

    public void error(String msg, String situation_request, Object[] params, Throwable e2) {
        if (this._tc.isErrorEnabled()) {
            Tr.error((TraceComponent)this._tc, (String)msg, (Object[])new Object[]{params, e2.getLocalizedMessage(), Arrays.toString(e2.getStackTrace())});
        }
    }

    public void error(String msg, String situation_request, Object param) {
        if (this._tc.isErrorEnabled()) {
            Tr.error((TraceComponent)this._tc, (String)msg, (Object[])new Object[]{param});
        }
    }

    public void error(String msg, String situation_request, Object[] params) {
        if (this._tc.isErrorEnabled()) {
            Tr.error((TraceComponent)this._tc, (String)msg, (Object[])params);
        }
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, String situation_request) {
        if (this._tc.isErrorEnabled()) {
            Tr.error((TraceComponent)this._tc, (String)msg, (Object[])new Object[0]);
        }
    }

    public void warn(String msg, String situation_request) {
        if (this._tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)this._tc, (String)msg, (Object[])new Object[0]);
        }
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, String situation_request, Object param) {
        if (this._tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)this._tc, (String)msg, (Object[])new Object[]{param});
        }
    }

    public void warn(String msg, String situation_request, Object[] params) {
        if (this._tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)this._tc, (String)msg, (Object[])params);
        }
    }

    public boolean isInfoEnabled() {
        return this._tc.isInfoEnabled();
    }

    public boolean isEventEnabled() {
        return this._tc.isEventEnabled();
    }

    public boolean isErrorEnabled() {
        return this._tc.isErrorEnabled();
    }

    public boolean isTraceEntryExitEnabled() {
        return this._tc.isEntryEnabled();
    }

    public boolean isTraceDebugEnabled() {
        return this._tc.isDebugEnabled();
    }

    public boolean isTraceFailureEnabled() {
        return this._tc.isEventEnabled();
    }

    public boolean isWarnEnabled() {
        return this._tc.isWarningEnabled();
    }
}

