/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.webcontainer.servlet.IServletContextExtended;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletContext;

public class WASContextEstablisher
implements ContextEstablisher {
    private static final LogMgr c_logger = Log.get(WASContextEstablisher.class);
    private IServletContextExtended _webapp;
    private boolean _isJava2SecurityEnabled = false;

    public WASContextEstablisher(IServletContext webapp) {
        this._webapp = (IServletContextExtended)webapp;
        if (System.getSecurityManager() != null) {
            this._isJava2SecurityEnabled = true;
        }
    }

    @Override
    public ServletContext getServletContext() {
        return this._webapp;
    }

    @Override
    public void establishContext() {
        this.establishContext(this._webapp.getClassLoader());
    }

    @Override
    public void establishContext(ClassLoader cl) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "establishContext", new Object[]{cl});
        }
        if (!this._isJava2SecurityEnabled) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            final ClassLoader finalCl = cl;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(finalCl);
                    return null;
                }
            });
        }
        ICollaboratorHelper icollabHlper = this._webapp.getCollaboratorHelper();
        IWebAppNameSpaceCollaborator spcCollab = icollabHlper.getWebAppNameSpaceCollaborator();
        WebAppConfigExtended appcfg = (WebAppConfigExtended)this._webapp.getWebAppConfig();
        if (appcfg == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "establishContext(1)", "Web container is probably down, request ignored");
            }
            return;
        }
        WebModuleMetaData metaData = appcfg.getMetaData();
        spcCollab.preInvoke((Object)metaData.getCollaboratorComponentMetaData());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "establishContext", new Object[]{icollabHlper, spcCollab, appcfg, metaData});
        }
    }

    @Override
    public void removeContext(ClassLoader cl) {
        if (!this._isJava2SecurityEnabled) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            final ClassLoader finalCl = cl;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(finalCl);
                    return null;
                }
            });
        }
        this._webapp.getCollaboratorHelper().getWebAppNameSpaceCollaborator().postInvoke();
    }

    @Override
    public ClassLoader getApplicationClassLoader() {
        return this._webapp.getClassLoader();
    }

    @Override
    public ClassLoader getThreadCurrentClassLoader() {
        if (!this._isJava2SecurityEnabled) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

