/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.api.RemoteOnewayException;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.ExceptionDescriptor;
import org.apache.yoko.rmi.impl.ModelElement;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class MethodDescriptor
extends ModelElement {
    static final Logger logger = Logger.getLogger(MethodDescriptor.class.getName());
    final Method reflected_method;
    Object invocation_block_selector;
    boolean onewayInitialized = false;
    boolean oneway = false;
    int parameter_count;
    TypeDescriptor[] parameter_types;
    TypeDescriptor return_type;
    ExceptionDescriptor[] exception_types;
    boolean copyWithinState;
    static final String UNKNOWN_EXCEPTION_ID = "IDL:omg.org/CORBA/portable/UnknownException:1.0";
    boolean isOverloaded = false;
    boolean isCaseSensitive = false;
    static final String SERVANT = "org.omg.CORBA.portable.ServantObject";
    static final String INPUT = "org.omg.CORBA_2_3.portable.InputStream";
    static final String OUTPUT = "org.omg.CORBA_2_3.portable.OutputStream";
    static final String UTIL = "javax.rmi.CORBA.Util";
    static final Class REMOTE_EXCEPTION = RemoteException.class;

    public boolean responseExpected() {
        if (!this.onewayInitialized) {
            if (!this.reflected_method.getReturnType().equals(Void.TYPE)) {
                this.onewayInitialized = true;
                this.oneway = false;
                return true;
            }
            Class<?>[] exceptions = this.reflected_method.getExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                if (exceptions[i] != RemoteOnewayException.class) continue;
                this.oneway = true;
                break;
            }
            this.onewayInitialized = true;
        }
        return !this.oneway;
    }

    public Method getReflectedMethod() {
        return this.reflected_method;
    }

    MethodDescriptor(Method method, TypeRepository repository) {
        super(repository, method.getName());
        this.reflected_method = method;
    }

    Object[] copyArguments(Object[] args, boolean sameState, ORB orb) throws RemoteException {
        if (!sameState) {
            try {
                OutputStream out = (OutputStream)orb.create_output_stream();
                for (int i = 0; i < args.length; ++i) {
                    if (!this.parameter_types[i].copyBetweenStates()) continue;
                    this.parameter_types[i].write((org.omg.CORBA.portable.OutputStream)out, args[i]);
                }
                InputStream in = (InputStream)out.create_input_stream();
                for (int i = 0; i < args.length; ++i) {
                    if (!this.parameter_types[i].copyBetweenStates()) continue;
                    args[i] = this.parameter_types[i].read((org.omg.CORBA.portable.InputStream)in);
                }
            }
            catch (SystemException ex) {
                logger.log(Level.FINE, "Exception occurred copying arguments", ex);
                throw Util.mapSystemException((SystemException)ex);
            }
        } else if (this.copyWithinState) {
            CopyState state = new CopyState(this.repo);
            for (int i = 0; i < args.length; ++i) {
                if (!this.parameter_types[i].copyWithinState()) continue;
                try {
                    args[i] = state.copy(args[i]);
                    continue;
                }
                catch (CopyRecursionException e) {
                    final int idx = i;
                    final Object[] args_arr = args;
                    state.registerRecursion(new CopyRecursionResolver(args[i]){

                        @Override
                        public void resolve(Object value) {
                            args_arr[idx] = value;
                        }
                    });
                }
            }
        }
        return args;
    }

    Object copyResult(Object result, boolean sameState, ORB orb) throws RemoteException {
        if (result == null) {
            return null;
        }
        if (!sameState) {
            if (this.return_type.copyBetweenStates()) {
                try {
                    OutputStream out = (OutputStream)orb.create_output_stream();
                    this.return_type.write((org.omg.CORBA.portable.OutputStream)out, result);
                    InputStream in = (InputStream)out.create_input_stream();
                    return this.return_type.read((org.omg.CORBA.portable.InputStream)in);
                }
                catch (SystemException ex) {
                    logger.log(Level.FINE, "Exception occurred copying result", ex);
                    throw Util.mapSystemException((SystemException)ex);
                }
            }
        } else if (this.copyWithinState) {
            CopyState state = new CopyState(this.repo);
            try {
                return state.copy(result);
            }
            catch (CopyRecursionException e) {
                throw new MarshalException("cannot copy recursive value?");
            }
        }
        return result;
    }

    public Object[] readArguments(org.omg.CORBA.portable.InputStream in) {
        Object[] args = new Object[this.parameter_count];
        for (int i = 0; i < this.parameter_count; ++i) {
            args[i] = this.parameter_types[i].read(in);
        }
        return args;
    }

    public void writeArguments(org.omg.CORBA.portable.OutputStream out, Object[] args) {
        for (int i = 0; i < this.parameter_count; ++i) {
            this.parameter_types[i].write(out, args[i]);
        }
    }

    public void writeResult(org.omg.CORBA.portable.OutputStream out, Object value) {
        this.return_type.write(out, value);
    }

    public org.omg.CORBA.portable.OutputStream writeException(ResponseHandler response, Throwable ex) {
        for (int i = 0; i < this.exception_types.length; ++i) {
            if (!this.exception_types[i].type.isInstance(ex)) continue;
            org.omg.CORBA.portable.OutputStream out = response.createExceptionReply();
            OutputStream out2 = (OutputStream)out;
            out2.write_string(this.exception_types[i].getExceptionRepositoryID());
            out2.write_value((Serializable)ex);
            return out;
        }
        logger.log(Level.WARNING, "unhandled exception: " + ex.getMessage(), ex);
        throw new UnknownException(ex);
    }

    public void readException(org.omg.CORBA.portable.InputStream in) throws Throwable {
        InputStream in2 = (InputStream)in;
        String ex_id = in.read_string();
        Throwable ex = null;
        for (int i = 0; i < this.exception_types.length; ++i) {
            if (!ex_id.equals(this.exception_types[i].getExceptionRepositoryID())) continue;
            ex = (Throwable)in2.read_value();
            throw ex;
        }
        ex = (Throwable)in2.read_value();
        if (ex instanceof Exception) {
            throw new UnexpectedException(ex.getMessage(), (Exception)ex);
        }
        if (ex instanceof Error) {
            throw ex;
        }
    }

    public Object readResult(org.omg.CORBA.portable.InputStream in) {
        Object result = this.return_type.read(in);
        return result;
    }

    String transformOverloading(String mname) {
        StringBuffer buf = new StringBuffer(mname);
        if (this.parameter_types.length == 0) {
            buf.append("__");
        } else {
            for (int i = 0; i < this.parameter_types.length; ++i) {
                buf.append("__");
                buf.append(this.parameter_types[i].getIDLName());
            }
        }
        return buf.toString();
    }

    protected void setOverloaded(boolean val) {
        this.isOverloaded = val;
    }

    protected void setCaseSensitive(boolean val) {
        this.isCaseSensitive = val;
    }

    @Override
    public void init() {
        Class<?>[] param_types = this.reflected_method.getParameterTypes();
        this.parameter_types = new TypeDescriptor[param_types.length];
        for (int i = 0; i < param_types.length; ++i) {
            this.parameter_types[i] = this.repo.getDescriptor(param_types[i]);
            this.copyWithinState |= this.parameter_types[i].copyWithinState();
            continue;
        }
        Class<?> result_type = this.reflected_method.getReturnType();
        this.return_type = this.repo.getDescriptor(result_type);
        Class<?>[] exc_types = this.reflected_method.getExceptionTypes();
        this.exception_types = new ExceptionDescriptor[exc_types.length];
        for (int i = 0; i < exc_types.length; ++i) {
            this.exception_types[i] = (ExceptionDescriptor)this.repo.getDescriptor(exc_types[i]);
        }
        this.parameter_count = param_types.length;
        super.init();
    }

    @Override
    protected String genIDLName() {
        String idl_name = null;
        idl_name = this.isSetterMethod() ? "_set_" + MethodDescriptor.transformIdentifier(this.attributeName()) : (this.isGetterMethod() ? "_get_" + MethodDescriptor.transformIdentifier(this.attributeName()) : MethodDescriptor.transformIdentifier(this.java_name));
        if (this.isCaseSensitive) {
            idl_name = MethodDescriptor.transformCaseSensitive(idl_name);
        }
        if (this.isOverloaded) {
            idl_name = this.transformOverloading(idl_name);
        }
        return idl_name;
    }

    private String attributeName() {
        int pfxLen;
        String methodName = this.java_name;
        StringBuffer buf = new StringBuffer();
        if (methodName.startsWith("get")) {
            pfxLen = 3;
        } else if (methodName.startsWith("is")) {
            pfxLen = 2;
        } else if (methodName.startsWith("set")) {
            pfxLen = 3;
        } else {
            throw new RuntimeException("methodName " + methodName + " is not attribute");
        }
        if (methodName.length() >= pfxLen + 2 && Character.isUpperCase(methodName.charAt(pfxLen)) && Character.isUpperCase(methodName.charAt(pfxLen + 1))) {
            return methodName.substring(pfxLen);
        }
        buf.append(Character.toLowerCase(methodName.charAt(pfxLen)));
        buf.append(methodName.substring(pfxLen + 1));
        return buf.toString();
    }

    private boolean isSetterMethod() {
        Method m = this.getReflectedMethod();
        String name = m.getName();
        if (!name.startsWith("set")) {
            return false;
        }
        if (name.length() == 3) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(3))) {
            return false;
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        return m.getParameterTypes().length == 1;
    }

    private boolean isGetterMethod() {
        int pfxLen;
        Method m = this.getReflectedMethod();
        String name = m.getName();
        if (name.startsWith("get")) {
            pfxLen = 3;
        } else if (name.startsWith("is") && m.getReturnType().equals(Boolean.TYPE)) {
            pfxLen = 2;
        } else {
            return false;
        }
        if (name.length() == pfxLen) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(pfxLen))) {
            return false;
        }
        if (m.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        return m.getParameterTypes().length == 0;
    }

    static String transformIdentifier(String name) {
        StringBuffer buf = new StringBuffer();
        if (name.charAt(0) == '_') {
            buf.append('J');
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_') {
                buf.append(ch);
                continue;
            }
            if (ch == '.') {
                buf.append('_');
                continue;
            }
            buf.append('U');
            String hex = Integer.toHexString(ch);
            switch (hex.length()) {
                case 1: {
                    buf.append('0');
                }
                case 2: {
                    buf.append('0');
                }
                case 3: {
                    buf.append('0');
                }
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    private static String transformCaseSensitive(String name) {
        StringBuffer buf = new StringBuffer(name);
        buf.append('_');
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            buf.append('_');
            buf.append(i);
        }
        return buf.toString();
    }

    void writeStubMethod(PrintWriter pw) {
        pw.println("\t/**");
        pw.println("\t *");
        pw.println("\t */");
        this.writeMethodHead(pw);
        pw.println("\t{");
        pw.println("\t\tboolean marshal = !javax.rmi.CORBA.Util.isLocal (this);");
        pw.println("\t\tmarshal: while(true) {");
        pw.println("\t\tif(marshal) {");
        this.writeMarshalCall(pw);
        pw.println("\t\t} else {");
        this.writeLocalCall(pw);
        pw.println("\t\t}}");
        pw.println("\t}\n");
    }

    void writeMethodHead(PrintWriter pw) {
        pw.print("\tpublic ");
        MethodDescriptor.writeJavaType(pw, this.reflected_method.getReturnType());
        pw.print(' ');
        pw.print(this.java_name);
        pw.print(" (");
        Class<?>[] args = this.reflected_method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            MethodDescriptor.writeJavaType(pw, args[i]);
            pw.print(" arg");
            pw.print(i);
        }
        pw.println(")");
        Class<?>[] ex = this.reflected_method.getExceptionTypes();
        pw.print("\t\tthrows ");
        for (int i = 0; i < ex.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            MethodDescriptor.writeJavaType(pw, ex[i]);
        }
        pw.println();
    }

    static void writeJavaType(PrintWriter pw, Class type) {
        if (type.isArray()) {
            MethodDescriptor.writeJavaType(pw, type.getComponentType());
            pw.print("[]");
        } else {
            pw.print(type.getName());
        }
    }

    void writeMarshalCall(PrintWriter pw) {
        TypeDescriptor desc;
        pw.println("\t\torg.omg.CORBA_2_3.portable.InputStream in = null;");
        pw.println("\t\ttry {");
        pw.println("\t\t\torg.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream)_request (\"" + this.getIDLName() + "\", true);");
        pw.println("\t\t\ttry{");
        Class<?>[] args = this.reflected_method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            desc = this.repo.getDescriptor(args[i]);
            pw.print("\t\t\t");
            desc.writeMarshalValue(pw, "out", "arg" + i);
            pw.println(";");
        }
        pw.println("\t\t\tin = (org.omg.CORBA_2_3.portable.InputStream)_invoke(out);");
        Class<?> rtype = this.reflected_method.getReturnType();
        if (rtype == Void.TYPE) {
            pw.println("\t\t\treturn;");
        } else {
            pw.print("\t\t\treturn (");
            MethodDescriptor.writeJavaType(pw, rtype);
            pw.print(")");
            desc = this.repo.getDescriptor(rtype);
            desc.writeUnmarshalValue(pw, "in");
            pw.println(";");
        }
        pw.println("\t\t} catch (org.omg.CORBA.portable.ApplicationException ex) {");
        pw.println("\t\t\torg.omg.CORBA_2_3.portable.InputStream exin = (org.omg.CORBA_2_3.portable.InputStream)ex.getInputStream();");
        pw.println("\t\t\tString exname = exin.read_string();");
        Class<?>[] ex = this.reflected_method.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (RemoteException.class.isAssignableFrom(ex[i])) continue;
            ExceptionDescriptor exd = (ExceptionDescriptor)this.repo.getDescriptor(ex[i]);
            pw.println("\t\t\tif (exname.equals(\"" + exd.getExceptionRepositoryID() + "\"))");
            pw.print("\t\t\t\tthrow (");
            MethodDescriptor.writeJavaType(pw, ex[i]);
            pw.print(")exin.read_value(");
            MethodDescriptor.writeJavaType(pw, ex[i]);
            pw.println(".class);");
        }
        pw.println("\t\t\tthrow new java.rmi.UnexpectedException(exname,ex);");
        pw.println("\t\t} catch (org.omg.CORBA.portable.RemarshalException ex) {");
        pw.println("\t\t\tcontinue marshal;");
        pw.println("\t\t} finally {");
        pw.println("\t\t\t if(in != null) _releaseReply(in);");
        pw.println("\t\t}");
        pw.println("\t\t} catch (org.omg.CORBA.SystemException ex) {");
        pw.println("\t\t\t throw javax.rmi.CORBA.Util.mapSystemException(ex);");
        pw.println("\t\t}");
    }

    void writeLocalCall(PrintWriter pw) {
        Class<?> thisClass = this.reflected_method.getDeclaringClass();
        pw.println("\t\t\torg.omg.CORBA.portable.ServantObject so = _servant_preinvoke (");
        pw.println("\t\t\t\t\"" + this.getIDLName() + "\",");
        pw.print("\t\t\t\t");
        MethodDescriptor.writeJavaType(pw, thisClass);
        pw.println(".class);");
        pw.print("\t\t\tif (so==null || so.servant==null || !(so.servant instanceof ");
        MethodDescriptor.writeJavaType(pw, thisClass);
        pw.print("))");
        pw.println(" { marshal=true; continue marshal; }");
        pw.println("\t\t\ttry {");
        Class<?>[] args = this.reflected_method.getParameterTypes();
        if (args.length == 1) {
            if (this.repo.getDescriptor(args[0]).copyInStub()) {
                pw.print("\t\t\t\targ0 = (");
                MethodDescriptor.writeJavaType(pw, args[0]);
                pw.println(")javax.rmi.CORBA.Util.copyObject(arg0, _orb());");
            }
        } else if (args.length > 1) {
            boolean[] copy = new boolean[args.length];
            int copyCount = 0;
            for (int i = 0; i < args.length; ++i) {
                TypeDescriptor td = this.repo.getDescriptor(args[i]);
                copy[i] = td.copyInStub();
                if (!copy[i]) continue;
                ++copyCount;
            }
            if (copyCount > 0) {
                int i;
                pw.println("\t\t\t\tObject[] args = new Object[" + copyCount + "];");
                int pos = 0;
                for (i = 0; i < args.length; ++i) {
                    if (!copy[i]) continue;
                    pw.println("\t\t\t\targs[" + pos++ + "] = arg" + i + ";");
                }
                pw.println("\t\t\t\targs=javax.rmi.CORBA.Util.copyObjects(args,_orb());");
                pos = 0;
                for (i = 0; i < args.length; ++i) {
                    if (!copy[i]) continue;
                    pw.print("\t\t\t\targ" + i + "=(");
                    MethodDescriptor.writeJavaType(pw, args[i]);
                    pw.println(")args[" + pos++ + "];");
                }
            }
        }
        Class<?> out = this.reflected_method.getReturnType();
        pw.print("\t\t\t\t");
        if (out != Void.TYPE) {
            MethodDescriptor.writeJavaType(pw, out);
            pw.print(" result = ");
        }
        pw.print("((");
        MethodDescriptor.writeJavaType(pw, thisClass);
        pw.print(")so.servant).");
        pw.print(this.java_name);
        pw.print("(");
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                pw.print(',');
            }
            pw.print("arg" + i);
        }
        pw.println(");");
        pw.print("\t\t\t\treturn ");
        if (out != Void.TYPE) {
            TypeDescriptor td = this.repo.getDescriptor(out);
            if (td.copyInStub()) {
                pw.print('(');
                MethodDescriptor.writeJavaType(pw, out);
                pw.print(')');
                pw.println("javax.rmi.CORBA.Util.copyObject (result, _orb());");
            } else {
                pw.println("result;");
            }
        } else {
            pw.println(";");
        }
        pw.println("\t\t\t} finally {");
        pw.println("\t\t\t\t_servant_postinvoke (so);");
        pw.println("\t\t\t}");
    }

    void addDependencies(Set classes) {
        TypeDescriptor desc = null;
        desc = this.repo.getDescriptor(this.reflected_method.getReturnType());
        desc.addDependencies(classes);
        Class<?>[] param = this.reflected_method.getParameterTypes();
        for (int i = 0; i < param.length; ++i) {
            desc = this.repo.getDescriptor(param[i]);
            desc.addDependencies(classes);
        }
        Class<?>[] ex = this.reflected_method.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            desc = this.repo.getDescriptor(ex[i]);
            desc.addDependencies(classes);
        }
    }

    boolean isRemoteOperation() {
        Class<?>[] ex = this.reflected_method.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (!REMOTE_EXCEPTION.isAssignableFrom(ex[i])) continue;
            return true;
        }
        return false;
    }
}

