/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JWKSet {
    private static final TraceComponent tc = Tr.register(JWKSet.class, null, null);
    private Map<String, Map<String, JWK>> pemJwksBySetId = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<JWK>> jwksBySetId = Collections.synchronizedMap(new HashMap());
    private final long Stale = 600000L;
    static final long serialVersionUID = -2046783669236162835L;

    public List<JWK> getJWKs() {
        return null;
    }

    synchronized void removeStaleEntries(Collection<JWK> collection) {
        long current = new Date().getTime();
        ArrayList<JWK> jwksToBeRemoved = new ArrayList<JWK>();
        for (JWK oldJwk : collection) {
            if (current - oldJwk.getCreated() <= 600000L) continue;
            jwksToBeRemoved.add(oldJwk);
        }
        for (JSONWebKey jSONWebKey : jwksToBeRemoved) {
            collection.remove(jSONWebKey);
        }
    }

    synchronized void removeStalePemEntries(Map<String, JWK> pemsForLocation) {
        long currentTime = new Date().getTime();
        ArrayList<String> pemJwksToRemove = new ArrayList<String>();
        for (Map.Entry<String, JWK> entry : pemsForLocation.entrySet()) {
            JWK oldJwk = entry.getValue();
            if (currentTime - oldJwk.getCreated() <= 600000L) continue;
            pemJwksToRemove.add(entry.getKey());
        }
        for (String pemKeyToRemove : pemJwksToRemove) {
            pemsForLocation.remove(pemKeyToRemove);
        }
    }

    private JSONWebKey getJWKByKidInCollection(String kid, Collection<JWK> jwkCollection) {
        if (kid == null) {
            if (jwkCollection.size() == 1) {
                return (JSONWebKey)jwkCollection.toArray()[0];
            }
            return null;
        }
        Iterator<JWK> it = jwkCollection.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!kid.equals(jwk.getKeyID())) continue;
            return jwk;
        }
        return null;
    }

    private JSONWebKey getJWKByx5tInCollection(String x5t, Collection<JWK> jwkCollection) {
        Iterator<JWK> it = jwkCollection.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!x5t.equals(jwk.getKeyX5t())) continue;
            return jwk;
        }
        return null;
    }

    private JSONWebKey getJWKByUseInCollection(String use, Collection<JWK> jwkCollection) {
        if (use == null) {
            return null;
        }
        JSONWebKey key = null;
        Iterator<JWK> it = jwkCollection.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            String thisKeyUse = jwk.getKeyUse();
            if (key != null && use.equals(thisKeyUse)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found more than one key matching the signature algorithm and use, so do not know which key to use", (Object[])new Object[0]);
                }
                return null;
            }
            if (!use.equals(thisKeyUse)) continue;
            key = jwk;
        }
        return key;
    }

    private JSONWebKey getPEMKey(String location, String keyTextOrKid) {
        Map<String, JWK> pemsForLocation;
        if (keyTextOrKid == null) {
            return null;
        }
        if (location == null) {
            location = keyTextOrKid;
        }
        if ((pemsForLocation = this.pemJwksBySetId.get(location)) != null) {
            return pemsForLocation.get(keyTextOrKid);
        }
        return null;
    }

    public PublicKey getPublicKeyBySetId(String setId) {
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && jwks.size() == 1) {
            JSONWebKey jwk = jwks.iterator().next();
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndKid(String setId, String kid) {
        JSONWebKey jwk;
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && (jwk = this.getJWKByKidInCollection(kid, jwks)) != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndx5t(String setId, String x5t) {
        JSONWebKey jwk;
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && (jwk = this.getJWKByx5tInCollection(x5t, jwks)) != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndUse(String setId, String use) {
        JSONWebKey jwk;
        PublicKey publicKey = null;
        Set<JWK> jwks = this.jwksBySetId.get(setId);
        if (jwks != null && (jwk = this.getJWKByUseInCollection(use, jwks)) != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public PublicKey getPublicKeyBySetIdAndKeyText(String setId, String keyText) {
        PublicKey publicKey = null;
        JSONWebKey jwk = this.getPEMKey(setId, keyText);
        if (jwk != null) {
            publicKey = jwk.getPublicKey();
        }
        return publicKey;
    }

    public void add(String setId, JWK jwk) {
        if (!this.jwksBySetId.containsKey(setId)) {
            this.jwksBySetId.put(setId, Collections.synchronizedSet(new HashSet()));
        } else {
            this.removeStaleEntries((Collection<JWK>)this.jwksBySetId.get(setId));
        }
        this.jwksBySetId.get(setId).add(jwk);
    }

    public void addPemKey(String location, String keyTextOrKid, JWK jwk) {
        Map<String, JWK> pemsForLocation;
        if (location == null) {
            location = keyTextOrKid;
        }
        if ((pemsForLocation = this.pemJwksBySetId.get(location)) == null) {
            pemsForLocation = new HashMap<String, JWK>();
        } else {
            this.removeStalePemEntries(pemsForLocation);
        }
        pemsForLocation.put(keyTextOrKid, jwk);
        this.pemJwksBySetId.put(location, pemsForLocation);
    }
}

