/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.security.authentication.tai.TAIUtil;
import com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl;
import com.ibm.ws.security.authentication.tai.internal.TAIConfigImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TAIServiceImpl
implements TAIService {
    private static final TraceComponent tc = Tr.register(TAIServiceImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.tai.internal.resources.TAIMessages");
    private static final String KEY_INTERCEPTOR_SERVICE = "interceptorService";
    private static final String KEY_ID = "id";
    private final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef = new ConcurrentServiceReferenceMap("interceptorService");
    private TAIConfigImpl taiConfig = null;
    private final Map<String, TrustAssociationInterceptor> invokeBeforeSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    private final Map<String, TrustAssociationInterceptor> invokeAfterSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    private final Set<String> orderedInterceptorIds = new TreeSet<String>();
    static final long serialVersionUID = -8290015320980371837L;

    protected synchronized void setInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.orderedInterceptorIds.add(id);
        this.interceptorServiceRef.putReference((Object)id, ref);
        this.initialize();
    }

    protected synchronized void unsetInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.orderedInterceptorIds.remove(id);
        this.interceptorServiceRef.removeReference((Object)id, ref);
        this.initialize();
    }

    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.interceptorServiceRef.activate(cc);
        this.modified(props);
    }

    protected synchronized void modified(Map<String, Object> props) {
        this.taiConfig = new TAIConfigImpl(props);
        this.initialize();
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.interceptorServiceRef.deactivate(cc);
        this.clearInvokeBeforeAndAfterSSO();
    }

    void initialize() {
        this.clearInvokeBeforeAndAfterSSO();
        if (this.interceptorServiceRef.isEmpty() && this.interceptorServiceRef.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no TAI config or enabled", (Object[])new Object[0]);
            }
            return;
        }
        TrustAssociationInterceptor tai = null;
        TAIUtil taiUtil = new TAIUtil();
        for (String interceptorId : this.orderedInterceptorIds) {
            Object itc = this.interceptorServiceRef.getService((Object)interceptorId);
            if (itc instanceof InterceptorConfigImpl) {
                InterceptorConfigImpl interceptor = (InterceptorConfigImpl)itc;
                tai = interceptor.getInterceptorInstance(this);
                if (interceptor.isInvokeBeforeSSO()) {
                    this.invokeBeforeSSOTais.put(interceptorId, tai);
                }
                if (!interceptor.isInvokeAfterSSO()) continue;
                this.invokeAfterSSOTais.put(interceptor.getId(), tai);
                continue;
            }
            if (!(itc instanceof TrustAssociationInterceptor)) continue;
            tai = (TrustAssociationInterceptor)itc;
            taiUtil.processTAIUserFeatureProps(this.interceptorServiceRef, interceptorId);
            if (taiUtil.isInvokeBeforeSSO()) {
                this.invokeBeforeSSOTais.put(interceptorId, tai);
            }
            if (!taiUtil.isInvokeAfterSSO()) continue;
            this.invokeAfterSSOTais.put(interceptorId, tai);
        }
    }

    @Override
    public Map<String, TrustAssociationInterceptor> getTais(boolean invokeBeforeSSO) {
        if (invokeBeforeSSO) {
            return this.invokeBeforeSSOTais;
        }
        return this.invokeAfterSSOTais;
    }

    @Override
    public boolean isInvokeForUnprotectedURI() {
        return this.taiConfig.isInvokeForUnprotectedURI();
    }

    @Override
    public boolean isInvokeForFormLogin() {
        return this.taiConfig.isInvokeForFormLogin();
    }

    @Override
    public boolean isFailOverToAppAuthType() {
        return this.taiConfig.isFailOverToAppAuthType();
    }

    private void clearInvokeBeforeAndAfterSSO() {
        this.invokeBeforeSSOTais.clear();
        this.invokeAfterSSOTais.clear();
    }

    private String getComponentId(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        if (id == null && (id = (String)ref.getProperty("component.name")) == null) {
            id = (String)ref.getProperty("component.id");
        }
        return id;
    }
}

