/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.interceptors.InterceptorMetaData;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.cpi.Persister;
import com.ibm.websphere.csi.EJBModuleConfigData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.EJBMethodInterface;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.metadata.OSGiEJBApplicationMetaData;
import com.ibm.ws.ejbcontainer.osgi.internal.metadata.OSGiEJBMethodMetaDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.metadata.OSGiEJBModuleMetaDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.metadata.WCCMMetaDataImpl;
import com.ibm.ws.ejbcontainer.runtime.AbstractEJBRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.injectionengine.osgi.util.Link;
import com.ibm.ws.injectionengine.osgi.util.OSGiJNDIEnvironmentRefBindingHelper;
import com.ibm.ws.javaee.dd.commonbnd.Interceptor;
import com.ibm.ws.javaee.dd.commonbnd.MessageDestination;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.commonext.Method;
import com.ibm.ws.javaee.dd.ejb.MessageDriven;
import com.ibm.ws.javaee.dd.ejbbnd.EJBJarBnd;
import com.ibm.ws.javaee.dd.ejbbnd.EnterpriseBean;
import com.ibm.ws.javaee.dd.ejbbnd.Interface;
import com.ibm.ws.javaee.dd.ejbbnd.Session;
import com.ibm.ws.javaee.dd.ejbext.BeanCache;
import com.ibm.ws.javaee.dd.ejbext.RunAsMode;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.metadata.ejb.EJBMDOrchestrator;
import com.ibm.ws.metadata.ejb.ModuleInitData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.wsspi.ejbcontainer.WSEJBHandlerResolver;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.EJBException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBMDOrchestratorImpl
extends EJBMDOrchestrator {
    private static final TraceComponent tc = Tr.register(EJBMDOrchestratorImpl.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
    private static final TraceComponent tcContainer = Tr.register((String)EJBMDOrchestratorImpl.class.getName(), EJBMDOrchestratorImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef;
    private static final String EJBLOCAL_BINDING_PREFIX = "ejblocal:";
    static final long serialVersionUID = 5915777333184165017L;

    public EJBMDOrchestratorImpl(AtomicServiceReference<ManagedObjectService> managedObjectServiceRef) {
        this.managedObjectServiceRef = managedObjectServiceRef;
    }

    @Override
    public void processEJBJarBindings(ModuleInitData mid, EJBModuleMetaDataImpl mmd) throws EJBConfigurationException {
        EJBJarBnd ejbJarBinding = this.getModuleInitDataImpl((ModuleInitData)mid).ejbJarBinding;
        if (ejbJarBinding != null) {
            this.processEJBBindings(mmd, ejbJarBinding);
            this.processMessageDestinationBindings(mmd, ejbJarBinding);
        }
        this.processMessageDestinationBindingDefault(mid, mmd);
        this.processActivationSpecBindingDefault(mmd);
    }

    private ModuleInitDataImpl getModuleInitDataImpl(ModuleInitData mid) {
        return (ModuleInitDataImpl)mid;
    }

    private void processEJBBindings(EJBModuleMetaDataImpl mmd, EJBJarBnd ejbJarBinding) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        HashSet<String> bindingsUsed = ContainerProperties.IgnoreDuplicateEJBBindings ? new HashSet<String>() : null;
        for (EnterpriseBean ejbBinding : ejbJarBinding.getEnterpriseBeans()) {
            String ejbName;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processing EJB binding", (Object[])new Object[]{ejbBinding});
            }
            if ((ejbName = ejbBinding.getName()) == null) {
                Tr.warning((TraceComponent)tcContainer, (String)"INCOMPLETE_EJB_BINDING_CNTR0142W", (Object[])new Object[]{""});
                continue;
            }
            if (bindingsUsed != null && !bindingsUsed.add(ejbName)) continue;
            BeanMetaData bmd = mmd.ivBeanMetaDatas.get(ejbName);
            if (ejbBinding instanceof Session) {
                if (bmd == null || !bmd.isSessionBean()) {
                    Tr.warning((TraceComponent)tcContainer, (String)"ORPHAN_BINDING_ENTRY_CNTR0169E", (Object[])new Object[]{ejbName, "session", mmd.ivName});
                    continue;
                }
                this.processSessionBeanBinding(bmd, (Session)ejbBinding);
                continue;
            }
            if (ejbBinding instanceof com.ibm.ws.javaee.dd.ejbbnd.MessageDriven) {
                if (bmd == null || !bmd.isMessageDrivenBean()) {
                    Tr.warning((TraceComponent)tcContainer, (String)"ORPHAN_BINDING_ENTRY_CNTR0169E", (Object[])new Object[]{ejbName, "message-driven", mmd.ivName});
                    continue;
                }
                this.processMessageDrivenBeanBinding(bmd, (com.ibm.ws.javaee.dd.ejbbnd.MessageDriven)ejbBinding);
                continue;
            }
            if (!isTraceOn || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"unknown binding: ", (Object[])new Object[]{ejbBinding, ejbBinding});
        }
    }

    private void processMessageDestinationBindingDefault(ModuleInitData mid, EJBModuleMetaDataImpl mmd) throws EJBException {
        if (mid.ivEJBJar != null) {
            for (com.ibm.ws.javaee.dd.ejb.EnterpriseBean eb : mid.ivEJBJar.getEnterpriseBeans()) {
                if (eb.getKindValue() != 2) continue;
                BeanMetaData bmd = mmd.ivBeanMetaDatas.get(eb.getName());
                if (bmd.ivMessageDestinationJndiName != null) continue;
                String bindingName = null;
                MessageDriven messageDriven = (MessageDriven)eb;
                String msgDrivenLink = messageDriven.getLink();
                if (msgDrivenLink != null) {
                    Link parsedLink = Link.parseMessageDestinationLink((String)mmd.getName(), (String)msgDrivenLink);
                    if (parsedLink.moduleURI != null) {
                        OSGiEJBApplicationMetaData ejbAMD = this.getOSGiApplicationMetaData(mmd);
                        EJBModuleMetaDataImpl linkedMMD = ejbAMD.getModuleMetaData(parsedLink.moduleURI);
                        if (linkedMMD != null) {
                            bindingName = linkedMMD.ivMessageDestinationBindingMap.get(parsedLink.name);
                        }
                    } else {
                        bindingName = mmd.ivMessageDestinationBindingMap.get(parsedLink.name);
                    }
                    if (bindingName == null) {
                        bindingName = parsedLink.name;
                    }
                }
                if (bindingName == null) continue;
                bmd.ivMessageDestinationJndiName = bindingName;
            }
        }
    }

    private void processActivationSpecBindingDefault(EJBModuleMetaDataImpl mmd) {
        for (BeanMetaData bmd : mmd.ivBeanMetaDatas.values()) {
            if (bmd.type != 7 || bmd.ivActivationSpecJndiName != null) continue;
            bmd.ivActivationSpecJndiName = this.getDefaultActivationSpecJndiName(bmd);
        }
    }

    private OSGiEJBApplicationMetaData getOSGiApplicationMetaData(EJBModuleMetaDataImpl mmd) {
        return (OSGiEJBApplicationMetaData)mmd.getEJBApplicationMetaData();
    }

    private OSGiEJBModuleMetaDataImpl getOSGiEJBModuleMetaDataImpl(EJBModuleMetaDataImpl mmd) {
        return (OSGiEJBModuleMetaDataImpl)mmd;
    }

    private void processMessageDrivenBeanBinding(BeanMetaData bmd, com.ibm.ws.javaee.dd.ejbbnd.MessageDriven mdbBinding) {
        if (mdbBinding.getJCAAdapter() != null) {
            bmd.ivActivationSpecJndiName = this.nullIfEmpty(mdbBinding.getJCAAdapter().getActivationSpecBindingName());
            bmd.ivActivationSpecAuthAlias = this.nullIfEmpty(mdbBinding.getJCAAdapter().getActivationSpecAuthAlias());
            bmd.ivMessageDestinationJndiName = this.nullIfEmpty(mdbBinding.getJCAAdapter().getDestinationBindingName());
        }
        if (mdbBinding.getListenerPort() != null) {
            bmd.ivMessageListenerPortName = mdbBinding.getListenerPort().getName();
        }
    }

    private String nullIfEmpty(String bindingName) {
        if (bindingName == null || bindingName.trim().isEmpty()) {
            return null;
        }
        return bindingName;
    }

    private String getDefaultActivationSpecJndiName(BeanMetaData bmd) {
        EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
        EJBApplicationMetaData amd = mmd.getEJBApplicationMetaData();
        String appName = amd.getLogicalName();
        StringBuilder sb = new StringBuilder();
        if (appName != null) {
            sb.append(appName).append('/');
        }
        sb.append(mmd.ivLogicalName).append('/');
        sb.append(bmd.enterpriseBeanName);
        return sb.toString();
    }

    private void processSessionBeanBinding(BeanMetaData bmd, Session sessionBinding) throws EJBException, EJBConfigurationException {
        List interfaceBindings;
        String remoteHomeBindingName;
        String localHomeBindingName;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String ejbName = bmd.enterpriseBeanName;
        EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
        String componentID = sessionBinding.getComponentID();
        if (componentID != null) {
            if (componentID.trim().length() == 0) {
                bmd.ivComponent_Id = null;
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". blank component-id binding."), (Object[])new Object[0]);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                bmd.ivComponent_Id = componentID.trim();
            }
        }
        if ((localHomeBindingName = sessionBinding.getLocalHomeBindingName()) != null) {
            bmd.localHomeJndiBindingName = localHomeBindingName.trim();
            if (localHomeBindingName.trim().length() == 0) {
                bmd.localHomeJndiBindingName = null;
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (!isTraceOn || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". blank local-home binding."), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((remoteHomeBindingName = sessionBinding.getRemoteHomeBindingName()) != null) {
            bmd.remoteHomeJndiBindingName = remoteHomeBindingName.trim();
            if (remoteHomeBindingName.trim().length() == 0) {
                bmd.remoteHomeJndiBindingName = null;
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (!isTraceOn || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". blank remote-home binding."), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (!(interfaceBindings = sessionBinding.getInterfaces()).isEmpty()) {
            bmd.businessInterfaceJndiBindingNames = new HashMap<String, String>();
            for (Interface interfaceBinding : interfaceBindings) {
                String oldInterfaceBindingName;
                String interfaceClassName;
                String interfaceBindingName = interfaceBinding.getBindingName();
                boolean isntBlank = true;
                if (interfaceBindingName.trim().length() == 0) {
                    isntBlank = false;
                    OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                    switch (onError) {
                        case WARN: {
                            Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                            break;
                        }
                        case FAIL: {
                            Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                            throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                        }
                        default: {
                            if (!isTraceOn || !tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". blank business interface binding."), (Object[])new Object[0]);
                        }
                    }
                }
                if ((interfaceClassName = interfaceBinding.getClassName()).equals("")) {
                    interfaceClassName = bmd.enterpriseBeanClassName;
                }
                if ((oldInterfaceBindingName = isntBlank ? bmd.businessInterfaceJndiBindingNames.put(interfaceClassName, interfaceBindingName) : null) == null) continue;
                Tr.error((TraceComponent)tcContainer, (String)"MULTIPLE_JNDI_BINDING_NAMES_CNTR0139E", (Object[])new Object[]{ejbName, mmd.ivName, interfaceClassName});
                throw new EJBException("The " + ejbName + " bean in the " + mmd.ivName + " module has multiple Java Naming and Directory Interface (JNDI) binding names specified for the " + interfaceClassName + " business interface.");
            }
        }
        boolean hasSpecificBinding = bmd.localHomeJndiBindingName != null || bmd.remoteHomeJndiBindingName != null || bmd.businessInterfaceJndiBindingNames != null;
        this.processSimpleBindingName(bmd, sessionBinding, hasSpecificBinding);
        this.validateEJBBindings(bmd);
    }

    private void processSimpleBindingName(BeanMetaData bmd, Session ejbBinding, boolean hasSpecificBinding) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String ejbName = bmd.enterpriseBeanName;
        EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
        String simpleJndiBindingName = ejbBinding.getSimpleBindingName();
        if (simpleJndiBindingName != null) {
            if (hasSpecificBinding) {
                Tr.error((TraceComponent)tcContainer, (String)"INVALID_JNDI_BINDING_COMBINATION_CNTR0130E", (Object[])new Object[]{ejbName, mmd.ivName});
                throw new EJBException("When a simple Java Naming and Directory Interface (JNDI) binding name is specified for a bean or home, specific JNDI bindings cannot be specified. The " + ejbName + " bean in the " + mmd.ivName + " module either must use a simple JNDI binding name or specific JNDI bindings, but not use both options.");
            }
            bmd.simpleJndiBindingName = simpleJndiBindingName.trim();
            if (simpleJndiBindingName.trim().length() == 0) {
                bmd.simpleJndiBindingName = null;
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{ejbName, mmd.ivName});
                        throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". blank simple binding."), (Object[])new Object[0]);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (simpleJndiBindingName.contains(":")) {
                bmd.simpleJndiBindingName = null;
                OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{ejbName, mmd.ivName, simpleJndiBindingName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{ejbName, mmd.ivName, simpleJndiBindingName});
                        throw new EJBException("The " + ejbName + " bean or home in the " + mmd.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (!isTraceOn || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + ejbName + "in " + mmd.ivName + ". namespace in simple binding."), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private void validateEJBBindings(BeanMetaData bmd) throws EJBConfigurationException {
        OnErrorUtil.OnError onError;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (bmd.ivComponent_Id != null && bmd.ivComponent_Id.contains(":")) {
            bmd.ivComponent_Id = null;
            onError = ContainerProperties.customBindingsOnErr;
            switch (onError) {
                case WARN: {
                    Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.ivComponent_Id});
                    break;
                }
                case FAIL: {
                    Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.ivComponent_Id});
                    throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                }
                default: {
                    if (!isTraceOn || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in component-id binding."), (Object[])new Object[0]);
                }
            }
        }
        if (bmd.businessInterfaceJndiBindingNames != null) {
            for (Map.Entry entry : bmd.businessInterfaceJndiBindingNames.entrySet()) {
                String[] remoteBusinessInterfaces;
                OnErrorUtil.OnError onError2;
                String bindingInterface = (String)entry.getKey();
                String bindingValue = (String)entry.getValue();
                boolean matchFound = false;
                String[] localBusinessInterfaces = bmd.ivBusinessLocalInterfaceClassNames;
                if (localBusinessInterfaces != null) {
                    block45: for (String localBusinessInterface : localBusinessInterfaces) {
                        if (!bindingInterface.equals(localBusinessInterface)) continue;
                        matchFound = true;
                        if (!bindingValue.startsWith(EJBLOCAL_BINDING_PREFIX)) {
                            Tr.error((TraceComponent)tcContainer, (String)"IMPROPER_LOCAL_JNDI_BINDING_PREFIX_CNTR0136E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                            throw new EJBConfigurationException("The specific Java Naming and Directory Interface (JNDI) binding name provided for a local bean does not begin with ejblocal:. The " + bindingValue + " binding name that is specified for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module does not begin with ejblocal:.");
                        }
                        String trimmedBindingValue = bindingValue.substring(EJBLOCAL_BINDING_PREFIX.length());
                        if (trimmedBindingValue.trim().length() == 0) {
                            bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                            OnErrorUtil.OnError onError22 = ContainerProperties.customBindingsOnErr;
                            switch (onError22) {
                                case WARN: {
                                    Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                    break;
                                }
                                case FAIL: {
                                    Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                    throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                                }
                                default: {
                                    if (!isTraceOn || !tc.isDebugEnabled()) continue block45;
                                    Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". blank local business interface binding."), (Object[])new Object[0]);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!trimmedBindingValue.contains(":")) continue;
                        bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                        onError2 = ContainerProperties.customBindingsOnErr;
                        switch (onError2) {
                            case WARN: {
                                Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                continue block45;
                            }
                            case FAIL: {
                                Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                            }
                            default: {
                                if (!isTraceOn || !tc.isDebugEnabled()) continue block45;
                                Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in local business interface binding."), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                if ((remoteBusinessInterfaces = bmd.ivBusinessRemoteInterfaceClassNames) != null) {
                    block46: for (String remoteBusinessInterface : remoteBusinessInterfaces) {
                        if (!bindingInterface.equals(remoteBusinessInterface)) continue;
                        matchFound = true;
                        if (bindingValue.startsWith(EJBLOCAL_BINDING_PREFIX)) {
                            Tr.error((TraceComponent)tcContainer, (String)"IMPROPER_REMOTE_JNDI_BINDING_PREFIX_CNTR0137E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                            throw new EJBConfigurationException("The specific Java Naming and Directory Interface (JNDI) binding name that is provided for a remote bean begins with ejblocal:.  The " + bindingValue + " remote binding name that is specified for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module cannot begin with ejblocal:.");
                        }
                        if (bindingValue.trim().length() == 0) {
                            bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                            onError2 = ContainerProperties.customBindingsOnErr;
                            switch (onError2) {
                                case WARN: {
                                    Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                    break;
                                }
                                case FAIL: {
                                    Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                    throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                                }
                                default: {
                                    if (!isTraceOn || !tc.isDebugEnabled()) continue block46;
                                    Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". blank remote business interface binding."), (Object[])new Object[0]);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!bindingValue.contains(":")) continue;
                        bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                        onError2 = ContainerProperties.customBindingsOnErr;
                        switch (onError2) {
                            case WARN: {
                                Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                continue block46;
                            }
                            case FAIL: {
                                Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                            }
                            default: {
                                if (!isTraceOn || !tc.isDebugEnabled()) continue block46;
                                Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in remote business interface binding."), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                if (bmd.ivLocalBean && bindingInterface.equals(bmd.enterpriseBeanClassName)) {
                    matchFound = true;
                    if (!bindingValue.startsWith(EJBLOCAL_BINDING_PREFIX)) {
                        Tr.error((TraceComponent)tcContainer, (String)"IMPROPER_LOCAL_JNDI_BINDING_PREFIX_CNTR0136E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                        throw new EJBConfigurationException("The specific Java Naming and Directory Interface (JNDI) binding name provided for a local bean does not begin with ejblocal:. The " + bindingValue + " binding name that is specified for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module does not begin with ejblocal:.");
                    }
                    String trimmedBindingValue = bindingValue.substring(EJBLOCAL_BINDING_PREFIX.length());
                    if (trimmedBindingValue.trim().length() == 0) {
                        bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                        OnErrorUtil.OnError onError3 = ContainerProperties.customBindingsOnErr;
                        switch (onError3) {
                            case WARN: {
                                Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                break;
                            }
                            case FAIL: {
                                Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                            }
                            default: {
                                if (!isTraceOn || !tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". blank in local interface binding."), (Object[])new Object[0]);
                            }
                        }
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                        throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    if (trimmedBindingValue.contains(":")) {
                        bmd.businessInterfaceJndiBindingNames.remove(bindingInterface);
                        OnErrorUtil.OnError onError4 = ContainerProperties.customBindingsOnErr;
                        switch (onError4) {
                            case WARN: {
                                Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                break;
                            }
                            case FAIL: {
                                Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingValue});
                                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                            }
                            default: {
                                if (!isTraceOn || !tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in local interface binding."), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                if (matchFound) continue;
                Tr.error((TraceComponent)tcContainer, (String)"JNDI_BINDING_HAS_NO_CORRESPONDING_BUSINESS_INTERFACE_CLASS_CNTR0140E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bindingInterface});
                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module has specified the [" + bindingInterface + "] business interface, which does not exist for a business interface Java Naming and Directory Interface (JNDI) binding.");
            }
        }
        if (bmd.localHomeJndiBindingName != null) {
            if (bmd.localHomeInterfaceClassName == null) {
                Tr.error((TraceComponent)tcContainer, (String)"JNDI_BINDING_HAS_NO_CORRESPONDING_HOME_INTERFACE_CLASS_CNTR0141E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module has specified a home Java Naming and Directory Interface (JNDI) binding. The binding does not have a matching home interface class.");
            }
            if (!bmd.localHomeJndiBindingName.startsWith(EJBLOCAL_BINDING_PREFIX)) {
                Tr.error((TraceComponent)tcContainer, (String)"IMPROPER_LOCAL_JNDI_BINDING_PREFIX_CNTR0136E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.localHomeJndiBindingName});
                throw new EJBConfigurationException("The specific Java Naming and Directory Interface (JNDI) binding name provided for a local home does not begin with ejblocal:. The " + bmd.localHomeJndiBindingName + " binding name that is specified for the home of " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module does not begin with ejblocal:.");
            }
            String trimmedBindingValue = bmd.localHomeJndiBindingName.substring(EJBLOCAL_BINDING_PREFIX.length());
            if (trimmedBindingValue.trim().length() == 0) {
                bmd.localHomeJndiBindingName = null;
                OnErrorUtil.OnError onError3 = ContainerProperties.customBindingsOnErr;
                switch (onError3) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                        throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". blank in local-home binding."), (Object[])new Object[0]);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (trimmedBindingValue.contains(":")) {
                bmd.localHomeJndiBindingName = null;
                OnErrorUtil.OnError onError4 = ContainerProperties.customBindingsOnErr;
                switch (onError4) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.localHomeJndiBindingName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_LOCAL_JNDI_BINDING_NAME_CNTR0340W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.localHomeJndiBindingName});
                        throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (!isTraceOn || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in local-home binding."), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (bmd.remoteHomeJndiBindingName != null) {
            if (bmd.homeInterfaceClassName == null) {
                Tr.error((TraceComponent)tcContainer, (String)"JNDI_BINDING_HAS_NO_CORRESPONDING_HOME_INTERFACE_CLASS_CNTR0141E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module has specified a home Java Naming and Directory Interface (JNDI) binding. The binding does not have a matching home interface class.");
            }
            if (bmd.remoteHomeJndiBindingName.startsWith(EJBLOCAL_BINDING_PREFIX)) {
                Tr.error((TraceComponent)tcContainer, (String)"IMPROPER_REMOTE_JNDI_BINDING_PREFIX_CNTR0137E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.remoteHomeJndiBindingName});
                throw new EJBConfigurationException("The specific Java Naming and Directory Interface (JNDI) binding name that is provided for a remote home begins with ejblocal:.  The " + bmd.remoteHomeJndiBindingName + " remote binding name that is specified for the home of " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module cannot begin with ejblocal:.");
            }
            if (bmd.remoteHomeJndiBindingName.trim().length() == 0) {
                bmd.remoteHomeJndiBindingName = null;
                onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"BLANK_JNDI_BINDING_NAME_CNTR0138E", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName});
                        throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a blank string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". blank in remote-home binding."), (Object[])new Object[0]);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (bmd.remoteHomeJndiBindingName.contains(":")) {
                bmd.remoteHomeJndiBindingName = null;
                onError = ContainerProperties.customBindingsOnErr;
                switch (onError) {
                    case WARN: {
                        Tr.warning((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.localHomeJndiBindingName});
                        break;
                    }
                    case FAIL: {
                        Tr.error((TraceComponent)tcContainer, (String)"NAMESPACE_IN_JNDI_BINDING_NAME_CNTR0339W", (Object[])new Object[]{bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd.localHomeJndiBindingName});
                        throw new EJBConfigurationException("The " + bmd.enterpriseBeanName + " bean or home in the " + bmd._moduleMetaData.ivName + " module contains a namespace in the string value for the Java Naming and Directory Interface (JNDI) binding name.");
                    }
                    default: {
                        if (!isTraceOn || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tcContainer, (String)("Ignoring custom binding configuration for" + bmd.enterpriseBeanName + "in " + bmd._moduleMetaData.ivName + ". namespace in remote-home binding."), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private void processMessageDestinationBindings(EJBModuleMetaDataImpl mmd, EJBJarBnd ejbJarBinding) {
        List mdBindings = ejbJarBinding.getMessageDestinations();
        if (!mdBindings.isEmpty()) {
            for (MessageDestination mdBinding : mdBindings) {
                String name = mdBinding.getName();
                String bindingName = mdBinding.getBindingName();
                mmd.ivMessageDestinationBindingMap.put(name, bindingName);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("message destination bindings = " + mmd.ivMessageDestinationBindingMap), (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected void setActivationLoadPolicy(BeanMetaData bmd) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        WCCMMetaDataImpl wccm = this.getWASWCCMMetaData(bmd);
        if (wccm.enterpriseBeanExtension != null) {
            BeanCache beanCache = wccm.enterpriseBeanExtension.getBeanCache();
            if (wccm.enterpriseBeanExtension instanceof com.ibm.ws.javaee.dd.ejbext.Session) {
                if (beanCache != null) {
                    BeanCache.ActivationPolicyTypeEnum activationPolicy = beanCache.getActivationPolicy();
                    if (!bmd.passivationCapable && activationPolicy != BeanCache.ActivationPolicyTypeEnum.ONCE) {
                        Tr.warning((TraceComponent)tcContainer, (String)"ACTIVATION_POLICY_IGNORED_NOT_PASSIVATION_CAPABLE_CNTR0332W", (Object[])new Object[]{activationPolicy, bmd.enterpriseBeanName, bmd._moduleMetaData.ivName, bmd._moduleMetaData.ivAppName});
                        activationPolicy = BeanCache.ActivationPolicyTypeEnum.ONCE;
                    }
                    switch (activationPolicy) {
                        case TRANSACTION: {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SessionExtension.getActivateAt is TRANSACTION", (Object[])new Object[0]);
                            }
                            bmd.sessionActivateTran = true;
                            bmd.sessionActivateSession = false;
                            bmd.activationPolicy = 2;
                            break;
                        }
                        case ACTIVITY_SESSION: {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SessionExtension.getActivateAt is ACTIVITY_SESSION", (Object[])new Object[0]);
                            }
                            bmd.sessionActivateTran = false;
                            bmd.sessionActivateSession = true;
                            bmd.activationPolicy = 1;
                            break;
                        }
                        case ONCE: {
                            if (bmd.ivSFSBFailover) {
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"SFSB failover enabled, overriding to TRANSACTION", (Object[])new Object[0]);
                                }
                                bmd.sessionActivateTran = true;
                                bmd.sessionActivateSession = false;
                                bmd.activationPolicy = 2;
                                break;
                            }
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SLSB or sfsb failover disabled, using ONCE", (Object[])new Object[0]);
                            }
                            bmd.sessionActivateTran = false;
                            bmd.sessionActivateSession = false;
                            bmd.activationPolicy = 0;
                        }
                    }
                } else {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Session.BeanCache is not set, so EJB container is using its default value.", (Object[])new Object[0]);
                    }
                    if (bmd.ivSFSBFailover) {
                        bmd.sessionActivateTran = true;
                        bmd.sessionActivateSession = false;
                        bmd.activationPolicy = 2;
                    } else {
                        bmd.sessionActivateTran = false;
                        bmd.sessionActivateSession = false;
                        bmd.activationPolicy = 0;
                    }
                }
            }
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"bmd.wccm.enterpriseBeanExtension is null, assigning default for activation policy", (Object[])new Object[0]);
            }
            if (bmd.type == 2 || bmd.type == 3 || bmd.type == 7 || bmd.type == 8) {
                bmd.sessionActivateTran = false;
                bmd.sessionActivateSession = false;
                bmd.activationPolicy = 0;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"defaulting SGLSB SLSB MB or MDB to ActivationPolicyTypeEnum.ONCE", (Object[])new Object[0]);
                }
            } else if (bmd.type == 4) {
                if (bmd.ivSFSBFailover) {
                    bmd.sessionActivateTran = true;
                    bmd.sessionActivateSession = false;
                    bmd.activationPolicy = 2;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"defaulting SFSB to ActivationPolicyTypeEnum.TRANSACTION since SFSB failover enabled.", (Object[])new Object[0]);
                    }
                } else {
                    bmd.sessionActivateTran = false;
                    bmd.sessionActivateSession = false;
                    bmd.activationPolicy = 0;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"defaulting SFSB to ActivationPolicyTypeEnum.ONCE", (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    protected void setConcurrencyControl(BeanMetaData bmd) {
    }

    @Override
    protected void checkPinPolicy(BeanMetaData bmd) {
    }

    @Override
    protected void getIsolationLevels(int[] isoLevels, int type, String[] methodNames, Class<?>[][] methodParamTypes, List<?> isoLevelList, com.ibm.ws.javaee.dd.ejb.EnterpriseBean enterpriseBean) {
    }

    @Override
    protected void getReadOnlyAttributes(boolean[] readOnlyAttrs, int type, String[] methodNames, Class<?>[][] methodParamTypes, List<?> accessIntentList, com.ibm.ws.javaee.dd.ejb.EnterpriseBean enterpriseBean) {
    }

    @Override
    public void processGeneralizations(EJBModuleConfigData moduleConfig, EJBModuleMetaDataImpl mmd) {
    }

    @Override
    protected String getFailoverInstanceId(EJBModuleMetaDataImpl mmd, SfFailoverCache sfDRSCache) {
        throw new UnsupportedOperationException("stateful failover not supported");
    }

    @Override
    protected boolean getSFSBFailover(EJBModuleMetaDataImpl mmd, EJSContainer container2) {
        throw new UnsupportedOperationException("stateful failover not supported");
    }

    @Override
    protected void processEJBExtensionsMetadata(BeanMetaData bmd) {
    }

    private ComponentNameSpaceConfiguration finishBMDInitForReferenceContextPrivileged(BeanMetaData bmd, String defaultCnrJndiName, WSEJBHandlerResolver wsHandlerResolver) throws ContainerException, EJBConfigurationException {
        return super.finishBMDInitForReferenceContext(bmd, defaultCnrJndiName, wsHandlerResolver);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public ComponentNameSpaceConfiguration finishBMDInitForReferenceContext(final BeanMetaData bmd, final String defaultCnrJndiName, final WSEJBHandlerResolver wsHandlerResolver) throws ContainerException, EJBConfigurationException {
        List runAsModes;
        ComponentNameSpaceConfiguration cnsc;
        try {
            cnsc = AccessController.doPrivileged(new PrivilegedExceptionAction<ComponentNameSpaceConfiguration>(){
                static final long serialVersionUID = 2758122207917734163L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ComponentNameSpaceConfiguration run() throws ContainerException, EJBConfigurationException {
                    return EJBMDOrchestratorImpl.this.finishBMDInitForReferenceContextPrivileged(bmd, defaultCnrJndiName, wsHandlerResolver);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBMDOrchestratorImpl$1", 1.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
                }
            });
        }
        catch (PrivilegedActionException paex) {
            Throwable cause = paex.getCause();
            if (cause instanceof ContainerException) {
                throw (ContainerException)cause;
            }
            if (cause instanceof EJBConfigurationException) {
                throw (EJBConfigurationException)cause;
            }
            throw new Error(cause);
        }
        WCCMMetaDataImpl wccm = this.getWASWCCMMetaData(bmd);
        if (wccm != null && wccm.enterpriseBeanExtension != null && !(runAsModes = wccm.enterpriseBeanExtension.getRunAsModes()).isEmpty()) {
            this.processRunAsExtension(bmd, runAsModes);
        }
        return cnsc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processReferenceContext(BeanMetaData bmd) throws InjectionException, EJBConfigurationException {
        if (this.getOSGiEJBModuleMetaDataImpl(bmd._moduleMetaData).isSystemModule()) {
            AbstractEJBRuntime runtime = (AbstractEJBRuntime)bmd.container.getEJBRuntime();
            try {
                runtime.finishBMDInitForReferenceContext(bmd);
            }
            catch (ContainerException containerException) {
                void e;
                FFDCFilter.processException((Throwable)containerException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBMDOrchestratorImpl", (String)"1181", (Object)this, (Object[])new Object[]{bmd});
                throw new InjectionException((Throwable)e);
            }
        } else {
            super.processReferenceContext(bmd);
        }
    }

    private void processRunAsExtension(BeanMetaData bmd, List<RunAsMode> runAsModes) {
        EJBMethodInterface[] mtypes = EJBMethodInterface.values();
        for (int j = 0; j < mtypes.length; ++j) {
            List<EJBMethodMetaData> ejbMMDs = bmd.getEJBMethodMetaData(mtypes[j]);
            if (ejbMMDs == null || ejbMMDs.size() <= 0) continue;
            int[] highestStyleOnMethod = new int[ejbMMDs.size()];
            for (RunAsMode ram : runAsModes) {
                for (Method ramMeth : ram.getMethods()) {
                    OSGiEJBMethodMetaDataImpl methodMD;
                    int i;
                    String meName = ramMeth.getName().trim();
                    Method.MethodTypeEnum meType = ramMeth.getType();
                    if (meName.equals("*")) {
                        if (meType == Method.MethodTypeEnum.UNSPECIFIED) {
                            for (i = 0; i < ejbMMDs.size(); ++i) {
                                methodMD = (OSGiEJBMethodMetaDataImpl)ejbMMDs.get(i);
                                if (highestStyleOnMethod[i] > 1) continue;
                                this.setRunAsExtension(methodMD, ram);
                                highestStyleOnMethod[i] = 1;
                            }
                            continue;
                        }
                        if (!this.methodTypeMatches(meType, mtypes[j])) continue;
                        for (i = 0; i < ejbMMDs.size(); ++i) {
                            methodMD = (OSGiEJBMethodMetaDataImpl)ejbMMDs.get(i);
                            if (highestStyleOnMethod[i] > 2) continue;
                            this.setRunAsExtension(methodMD, ram);
                            highestStyleOnMethod[i] = 2;
                        }
                        continue;
                    }
                    if (meType != Method.MethodTypeEnum.UNSPECIFIED && !this.methodTypeMatches(meType, mtypes[j])) continue;
                    for (i = 0; i < ejbMMDs.size(); ++i) {
                        methodMD = (OSGiEJBMethodMetaDataImpl)ejbMMDs.get(i);
                        if (!methodMD.getMethodName().equals(meName)) continue;
                        String meParams = ramMeth.getParams();
                        if (meParams == null) {
                            if (highestStyleOnMethod[i] > 3) continue;
                            this.setRunAsExtension(methodMD, ram);
                            highestStyleOnMethod[i] = 3;
                            continue;
                        }
                        if (!this.methodSignatureMatches(meParams, methodMD) || highestStyleOnMethod[i] > 4) continue;
                        this.setRunAsExtension(methodMD, ram);
                        highestStyleOnMethod[i] = 4;
                    }
                }
            }
        }
    }

    private boolean methodSignatureMatches(String runAsParams, OSGiEJBMethodMetaDataImpl methodMD) {
        StringTokenizer c;
        if (methodMD.getMethod() == null) {
            return false;
        }
        Class<?>[] ejbParams = methodMD.getMethod().getParameterTypes();
        if (ejbParams.length != (c = new StringTokenizer(runAsParams, " ,\n\r\t\f")).countTokens()) {
            return false;
        }
        for (int i = 0; i < ejbParams.length; ++i) {
            if (ejbParams[i].getName().equals(c.nextToken())) continue;
            return false;
        }
        return true;
    }

    private void setRunAsExtension(OSGiEJBMethodMetaDataImpl methodMD, RunAsMode ram) {
        switch (ram.getModeType()) {
            case SPECIFIED_IDENTITY: {
                String role = null;
                if (ram.getSpecifiedIdentity() != null && (role = ram.getSpecifiedIdentity().getRole()).trim().isEmpty()) {
                    role = null;
                }
                methodMD.setRunAs(role);
                return;
            }
            case CALLER_IDENTITY: {
                methodMD.setUseCallerPrincipal();
                return;
            }
            case SYSTEM_IDENTITY: {
                methodMD.setUseSystemPrincipal();
                return;
            }
        }
        throw new IllegalArgumentException(ram.getModeType().toString());
    }

    private boolean methodTypeMatches(Method.MethodTypeEnum extType, EJBMethodInterface intfType) {
        switch (extType) {
            case REMOTE: {
                return intfType == EJBMethodInterface.REMOTE;
            }
            case HOME: {
                return intfType == EJBMethodInterface.HOME;
            }
            case LOCAL: {
                return intfType == EJBMethodInterface.LOCAL || intfType == EJBMethodInterface.MESSAGE_ENDPOINT;
            }
            case LOCAL_HOME: {
                return intfType == EJBMethodInterface.LOCAL_HOME;
            }
            case SERVICE_ENDPOINT: {
                return intfType == EJBMethodInterface.SERVICE_ENDPOINT;
            }
        }
        throw new IllegalArgumentException(extType.toString());
    }

    @Override
    protected boolean processSessionExtensionTimeout(BeanMetaData bmd) {
        com.ibm.ws.javaee.dd.ejbext.Session sessExt;
        WCCMMetaDataImpl wccm = this.getWASWCCMMetaData(bmd);
        if (wccm.enterpriseBeanExtension instanceof com.ibm.ws.javaee.dd.ejbext.Session && (sessExt = (com.ibm.ws.javaee.dd.ejbext.Session)wccm.enterpriseBeanExtension).getTimeOut() != null) {
            bmd.sessionTimeout = sessExt.getTimeOut().getValue() * 1000;
            return true;
        }
        return false;
    }

    @Override
    protected void processSessionExtension(BeanMetaData bmd) {
    }

    @Override
    protected void processEntityExtension(BeanMetaData bmd) {
    }

    @Override
    protected void processZOSMetadata(BeanMetaData bmd) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ManagedObjectService getManagedObjectService() throws EJBConfigurationException {
        try {
            return (ManagedObjectService)this.managedObjectServiceRef.getServiceWithException();
        }
        catch (IllegalStateException illegalStateException) {
            void e;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBMDOrchestratorImpl", (String)"1337", (Object)this, (Object[])new Object[0]);
            throw new EJBConfigurationException((Throwable)e);
        }
    }

    @Override
    protected void populateBindings(BeanMetaData bmd, Map<JNDIEnvironmentRefType, Map<String, String>> allBindings, Map<String, String> envEntryValues, ResourceRefConfigList resRefList) throws EJBConfigurationException {
        Class<?>[] interceptorClasses;
        WCCMMetaDataImpl wccm = this.getWASWCCMMetaData(bmd);
        RefBindingsGroup beanBinding = wccm.refBindingsGroup;
        com.ibm.ws.javaee.dd.ejbext.EnterpriseBean ejbExtension = wccm.enterpriseBeanExtension;
        List resRefExts = ejbExtension == null ? null : ejbExtension.getResourceRefs();
        Map<String, Interceptor> interceptorBindings = wccm.interceptorBindings;
        OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(allBindings, envEntryValues, (ResourceRefConfigList)resRefList, (RefBindingsGroup)beanBinding, (List)resRefExts);
        InterceptorMetaData imd = bmd.ivInterceptorMetaData;
        if (imd != null && (interceptorClasses = imd.ivInterceptorClasses) != null && interceptorBindings != null) {
            for (Class<?> interceptorClass : interceptorClasses) {
                String interceptorClassName = interceptorClass.getName();
                Interceptor interceptorBnd = interceptorBindings.get(interceptorClassName);
                if (interceptorBnd == null) continue;
                OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(allBindings, envEntryValues, (ResourceRefConfigList)resRefList, (RefBindingsGroup)interceptorBnd, null);
            }
        }
    }

    @Override
    public Persister createCMP11Persister(BeanMetaData bmd, String defaultDataSourceJNDIName) throws ContainerException {
        return null;
    }

    private WCCMMetaDataImpl getWASWCCMMetaData(BeanMetaData bmd) {
        return (WCCMMetaDataImpl)bmd.wccm;
    }
}

