/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.api.jms.JmsRAFactoryFactory;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.api.jmsra.JmsraConstants;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnection;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionSynchronizationProvider;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaUserDetails;
import com.ibm.ws.sib.utils.PasswordSuppressingHashMap;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class JmsJcaManagedConnectionFactoryImpl
implements JmsJcaManagedConnectionFactory,
FFDCSelfIntrospectable,
ResourceAdapterAssociation {
    private transient PrintWriter _logWriter;
    private transient JmsRAFactoryFactory _jmsFactoryFactory;
    private Map _properties = new PasswordSuppressingHashMap();
    static final String CONN_FACTORY_TYPE = "javax.jms.ConnectionFactory";
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String CLASS_NAME = JmsJcaManagedConnectionFactoryImpl.class.getName();
    private static final long serialVersionUID = 8124956584686200082L;
    private static Map<String, Object> defaultJNDIProperties = new HashMap<String, Object>();
    String temporaryQueueNamePrefix;
    private ResourceAdapter _resourceAdapter;
    private static TraceComponent TRACE = SibTr.register(JmsJcaManagedConnectionFactoryImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");

    public JmsJcaManagedConnectionFactoryImpl() {
        this.setBusName("defaultBus");
        this.setClientID(JmsraConstants.DEFAULT_CLIENT_ID);
        this.setNonPersistentMapping(ApiJmsConstants.MAPPING_EXPRESS_NONPERSISTENT);
        this.setPersistentMapping(ApiJmsConstants.MAPPING_RELIABLE_PERSISTENT);
        this.setPassword(JmsraConstants.DEFAULT_PASSWORD);
        this.setUserName(JmsraConstants.DEFAULT_USER_NAME);
        this.setDurableSubscriptionHome("defaultME");
        this.setReadAhead("Default");
        this._properties.put("tempQueueNamePrefix", JmsraConstants.DEFAULT_TEMP_QUEUE_NAME_PREFIX);
        this._properties.put("tempTopicNamePrefix", JmsraConstants.DEFAULT_TEMP_TOPIC_NAME_PREFIX);
        this.setTarget(JmsraConstants.DEFAULT_TARGET);
        this.setTargetType("ME");
        this.setTargetSignificance("Required");
        this.setTargetTransportChain(JmsraConstants.DEFAULT_TARGET_TRANSPORT_CHAIN);
        this.setRemoteServerAddress(JmsraConstants.DEFAULT_PROVIDER_ENDPOINTS);
        this.setTargetTransport("BINDING_THEN_CLIENT");
        this.setConnectionProximity("Bus");
        this.setShareDurableSubscriptions("NeverShared");
        this.setShareDataSourceWithCMP(JmsraConstants.DEFAULT_SHARE_DATA_SOURCE_WITH_CMP);
        this.setSubscriptionProtocol("Unicast");
        this.setMulticastInterface("none");
        this.setProducerDoesNotModifyPayloadAfterSet("false");
        this.setConsumerDoesNotModifyPayloadAfterGet("false");
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)connectionManager);
        }
        JmsJcaConnectionFactoryImpl connectionFactory = new JmsJcaConnectionFactoryImpl(this, connectionManager);
        JmsRAFactoryFactory jmsRAFactory = this.getJmsRAFactoryFactory();
        ConnectionFactory jmsConnectionFactory = this.createJmsConnFactory(jmsRAFactory, connectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)jmsConnectionFactory);
        }
        return jmsConnectionFactory;
    }

    public final Object createConnectionFactory() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory");
        }
        JmsJcaConnectionFactoryImpl connectionFactory = new JmsJcaConnectionFactoryImpl(this);
        JmsRAFactoryFactory jmsRAFactory = this.getJmsRAFactoryFactory();
        ConnectionFactory jmsConnectionFactory = this.createJmsConnFactory(jmsRAFactory, connectionFactory, this);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)jmsConnectionFactory);
        }
        return jmsConnectionFactory;
    }

    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo requestInfo) throws ResourceException {
        JmsJcaManagedConnection managedConnection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)new Object[]{JmsJcaManagedConnection.subjectToString(subject), requestInfo});
        }
        JmsJcaConnectionRequestInfo jmsJcaRequestInfo = null;
        SICoreConnection requestCoreConnection = null;
        SICoreConnection coreConnection = null;
        if (requestInfo != null) {
            if (!(requestInfo instanceof JmsJcaConnectionRequestInfo)) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1022", new Object[]{"createManagedConnection", JmsJcaConnectionRequestInfo.class.getName(), requestInfo.getClass().getName()}, null));
            }
            jmsJcaRequestInfo = (JmsJcaConnectionRequestInfo)requestInfo;
            requestCoreConnection = jmsJcaRequestInfo.getSICoreConnection();
            if (requestCoreConnection != null) {
                try {
                    requestCoreConnection.getConnectionListeners();
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)TRACE, (String)"Connection Request Info core connection no longer available");
                    }
                    jmsJcaRequestInfo.setSICoreConnection(null);
                    requestCoreConnection = null;
                }
                catch (SIErrorException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)TRACE, (String)"Connection Request Info core connection no longer available");
                    }
                    jmsJcaRequestInfo.setSICoreConnection(null);
                    requestCoreConnection = null;
                }
            }
        }
        JmsJcaUserDetails userDetails = this.getUserDetails(subject, requestInfo);
        if (requestCoreConnection == null) {
            SICoreConnectionFactory coreConnectionFactory;
            if (!UTEHelperFactory.jmsTestEnvironmentEnabled) {
                try {
                    coreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_5, (Object)this);
                    throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1021", new Object[]{exception, "getSICoreConnectionFactory"}, null), (Throwable)exception);
                }
            } else {
                coreConnectionFactory = UTEHelperFactory.getHelperInstance().setupJmsTestEnvironment();
            }
            if (coreConnectionFactory == null) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SICORECONNECTION_ERROR_CWSJR1023", new Object[]{"createManagedConnection"}, null));
            }
            try {
                Map trmProperties = this.getTrmProperties();
                requestCoreConnection = userDetails == null ? coreConnectionFactory.createConnection(subject, trmProperties) : coreConnectionFactory.createConnection(userDetails.getUserName(), userDetails.getPassword(), trmProperties);
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_1, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_2, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
            }
            if (jmsJcaRequestInfo != null) {
                jmsJcaRequestInfo.setSICoreConnection(requestCoreConnection);
            }
            coreConnection = requestCoreConnection;
        } else {
            try {
                coreConnection = requestCoreConnection.cloneConnection();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_7, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)e));
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{e, "createManagedConnection"}, null), (Throwable)e);
            }
            catch (SIErrorException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_8, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)e));
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{e, "createManagedConnection"}, null), (Throwable)e);
            }
        }
        try {
            managedConnection = this.getShareDataSourceWithCMP() != null && this.getShareDataSourceWithCMP().booleanValue() ? new JmsJcaManagedConnectionSynchronizationProvider(this, coreConnection, userDetails, subject) : new JmsJcaManagedConnection(this, coreConnection, userDetails, subject);
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_3, (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1026", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)managedConnection);
        }
        return managedConnection;
    }

    public final ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo requestInfo) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"matchManagedConnections", (Object)new Object[]{connectionSet, JmsJcaManagedConnection.subjectToString(subject), requestInfo});
        }
        SICoreConnection coreConnection = requestInfo instanceof JmsJcaConnectionRequestInfo ? ((JmsJcaConnectionRequestInfo)requestInfo).getSICoreConnection() : null;
        JmsJcaUserDetails userDetails = this.getUserDetails(subject, requestInfo);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            if (userDetails != null) {
                SibTr.debug((TraceComponent)TRACE, (String)"Got a username and password");
            } else {
                SibTr.debug((TraceComponent)TRACE, (String)"Using subject");
            }
        }
        JmsJcaManagedConnection matchedConnection = null;
        for (Object object : connectionSet) {
            if (!(object instanceof JmsJcaManagedConnection)) continue;
            JmsJcaManagedConnection managedConnection = (JmsJcaManagedConnection)object;
            if (userDetails != null) {
                if (!managedConnection.match(userDetails, coreConnection)) continue;
                matchedConnection = managedConnection;
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)TRACE, (String)"Matched a connection against the subject username and password");
                break;
            }
            if (!managedConnection.match(subject, coreConnection)) continue;
            matchedConnection = managedConnection;
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break;
            SibTr.debug((TraceComponent)TRACE, (String)"Matched a connection against the subject");
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"matchManagedConnections", matchedConnection);
        }
        return matchedConnection;
    }

    public final void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public final PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public final int hashCode() {
        int hash = 11;
        hash = 23 * hash + (this.getBusName() == null ? 0 : this.getBusName().hashCode());
        hash = 23 * hash + (this.getClientID() == null ? 0 : this.getClientID().hashCode());
        hash = 23 * hash + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hash = 23 * hash + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hash = 23 * hash + (this.getNonPersistentMapping() == null ? 0 : this.getNonPersistentMapping().hashCode());
        hash = 23 * hash + (this.getPersistentMapping() == null ? 0 : this.getPersistentMapping().hashCode());
        hash = 23 * hash + (this.getDurableSubscriptionHome() == null ? 0 : this.getDurableSubscriptionHome().hashCode());
        hash = 23 * hash + (this.getReadAhead() == null ? 0 : this.getReadAhead().hashCode());
        hash = 23 * hash + (this.getTemporaryQueueNamePrefix() == null ? 0 : this.getTemporaryQueueNamePrefix().hashCode());
        hash = 23 * hash + (this.getTemporaryTopicNamePrefix() == null ? 0 : this.getTemporaryTopicNamePrefix().hashCode());
        hash = 23 * hash + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hash = 23 * hash + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        hash = 23 * hash + (this.getTargetSignificance() == null ? 0 : this.getTargetSignificance().hashCode());
        hash = 23 * hash + (this.getTargetTransportChain() == null ? 0 : this.getTargetTransportChain().hashCode());
        hash = 23 * hash + (this.getRemoteServerAddress() == null ? 0 : this.getRemoteServerAddress().hashCode());
        hash = 23 * hash + (this.getConnectionProximity() == null ? 0 : this.getConnectionProximity().hashCode());
        hash = 23 * hash + (this.getShareDataSourceWithCMP() == null ? 0 : this.getShareDataSourceWithCMP().hashCode());
        hash = 23 * hash + (this.getShareDurableSubscriptions() == null ? 0 : this.getShareDurableSubscriptions().hashCode());
        hash = 23 * hash + (this.getSubscriptionProtocol() == null ? 0 : this.getSubscriptionProtocol().hashCode());
        hash = 23 * hash + (this.getMulticastInterface() == null ? 0 : this.getMulticastInterface().hashCode());
        return hash;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JmsJcaManagedConnectionFactoryImpl)) {
            return false;
        }
        JmsJcaManagedConnectionFactoryImpl otherFact = (JmsJcaManagedConnectionFactoryImpl)other;
        if (this.getBusName() == null && otherFact.getBusName() != null) {
            return false;
        }
        if (this.getClientID() == null && otherFact.getClientID() != null) {
            return false;
        }
        if (this.getUserName() == null && otherFact.getUserName() != null) {
            return false;
        }
        if (this.getPassword() == null && otherFact.getPassword() != null) {
            return false;
        }
        if (this.getNonPersistentMapping() == null && otherFact.getNonPersistentMapping() != null) {
            return false;
        }
        if (this.getPersistentMapping() == null && otherFact.getPersistentMapping() != null) {
            return false;
        }
        if (this.getDurableSubscriptionHome() == null && otherFact.getDurableSubscriptionHome() != null) {
            return false;
        }
        if (this.getReadAhead() == null && otherFact.getReadAhead() != null) {
            return false;
        }
        if (this.getTemporaryQueueNamePrefix() == null && otherFact.getTemporaryQueueNamePrefix() != null) {
            return false;
        }
        if (this.getTemporaryTopicNamePrefix() == null && otherFact.getTemporaryTopicNamePrefix() != null) {
            return false;
        }
        if (this.getTarget() == null && otherFact.getTarget() != null) {
            return false;
        }
        if (this.getTargetType() == null && otherFact.getTargetType() != null) {
            return false;
        }
        if (this.getTargetSignificance() == null && otherFact.getTargetSignificance() != null) {
            return false;
        }
        if (this.getTargetTransportChain() == null && otherFact.getTargetTransportChain() != null) {
            return false;
        }
        if (this.getRemoteServerAddress() == null && otherFact.getRemoteServerAddress() != null) {
            return false;
        }
        if (this.getConnectionProximity() == null && otherFact.getConnectionProximity() != null) {
            return false;
        }
        if (this.getShareDataSourceWithCMP() == null && otherFact.getShareDataSourceWithCMP() != null) {
            return false;
        }
        if (this.getShareDurableSubscriptions() == null && otherFact.getShareDurableSubscriptions() != null) {
            return false;
        }
        if (this.getSubscriptionProtocol() == null && otherFact.getSubscriptionProtocol() != null) {
            return false;
        }
        if (this.getMulticastInterface() == null && otherFact.getMulticastInterface() != null) {
            return false;
        }
        boolean retVal = true;
        if (this.getBusName() != null && retVal) {
            retVal = this.getBusName().equals(otherFact.getBusName());
        }
        if (this.getClientID() != null && retVal) {
            retVal = this.getClientID().equals(otherFact.getClientID());
        }
        if (this.getUserName() != null && retVal) {
            retVal = this.getUserName().equals(otherFact.getUserName());
        }
        if (this.getPassword() != null && retVal) {
            retVal = this.getPassword().equals(otherFact.getPassword());
        }
        if (this.getNonPersistentMapping() != null && retVal) {
            retVal = this.getNonPersistentMapping().equals(otherFact.getNonPersistentMapping());
        }
        if (this.getPersistentMapping() != null && retVal) {
            retVal = this.getPersistentMapping().equals(otherFact.getPersistentMapping());
        }
        if (this.getDurableSubscriptionHome() != null && retVal) {
            retVal = this.getDurableSubscriptionHome().equals(otherFact.getDurableSubscriptionHome());
        }
        if (this.getReadAhead() != null && retVal) {
            retVal = this.getReadAhead().equals(otherFact.getReadAhead());
        }
        if (this.getTemporaryQueueNamePrefix() != null && retVal) {
            retVal = this.getTemporaryQueueNamePrefix().equals(otherFact.getTemporaryQueueNamePrefix());
        }
        if (this.getTemporaryTopicNamePrefix() != null && retVal) {
            retVal = this.getTemporaryTopicNamePrefix().equals(otherFact.getTemporaryTopicNamePrefix());
        }
        if (this.getTarget() != null && retVal) {
            retVal = this.getTarget().equals(otherFact.getTarget());
        }
        if (this.getTargetType() != null && retVal) {
            retVal = this.getTargetType().equals(otherFact.getTargetType());
        }
        if (this.getTargetSignificance() != null && retVal) {
            retVal = this.getTargetSignificance().equals(otherFact.getTargetSignificance());
        }
        if (this.getTargetTransportChain() != null && retVal) {
            retVal = this.getTargetTransportChain().equals(otherFact.getTargetTransportChain());
        }
        if (this.getRemoteServerAddress() != null && retVal) {
            retVal = this.getRemoteServerAddress().equals(otherFact.getRemoteServerAddress());
        }
        if (this.getConnectionProximity() != null && retVal) {
            retVal = this.getConnectionProximity().equals(otherFact.getConnectionProximity());
        }
        if (this.getShareDataSourceWithCMP() != null && retVal) {
            retVal = this.getShareDataSourceWithCMP().equals(otherFact.getShareDataSourceWithCMP());
        }
        if (this.getShareDurableSubscriptions() != null && retVal) {
            retVal = this.getShareDurableSubscriptions().equals(otherFact.getShareDurableSubscriptions());
        }
        if (this.getSubscriptionProtocol() != null && retVal) {
            retVal = this.getSubscriptionProtocol().equals(otherFact.getSubscriptionProtocol());
        }
        if (this.getMulticastInterface() != null && retVal) {
            retVal = this.getMulticastInterface().equals(otherFact.getMulticastInterface());
        }
        return retVal;
    }

    @Override
    public final void setClientID(String clientID) {
        this._properties.put("clientID", clientID);
    }

    @Override
    public final String getClientID() {
        return (String)this._properties.get("clientID");
    }

    @Override
    public final void setBusName(String busName) {
        this._properties.put("busName", busName);
    }

    @Override
    public final String getBusName() {
        return (String)this._properties.get("busName");
    }

    @Override
    public final void setPassword(String password) {
        this._properties.put("password", password);
    }

    @Override
    public final String getPassword() {
        return (String)this._properties.get("password");
    }

    @Override
    public final void setUserName(String userName) {
        this._properties.put("userName", userName);
    }

    @Override
    public final String getUserName() {
        return (String)this._properties.get("userName");
    }

    @Override
    public String getDurableSubscriptionHome() {
        return (String)this._properties.get("durableSubscriptionHome");
    }

    @Override
    public void setDurableSubscriptionHome(String durableSubscriptionHome) {
        this._properties.put("durableSubscriptionHome", durableSubscriptionHome);
    }

    @Override
    public String getReadAhead() {
        return (String)this._properties.get("readAhead");
    }

    @Override
    public void setReadAhead(String readAhead) {
        this._properties.put("readAhead", readAhead);
    }

    @Override
    public String getTemporaryQueueNamePrefix() {
        return (String)this._properties.get("tempQueueNamePrefix");
    }

    @Override
    public void setTemporaryQueueNamePrefix(String prefix) throws JMSException {
        this.temporaryQueueNamePrefix = prefix;
        this._properties.put("tempQueueNamePrefix", prefix);
        if (prefix != null && prefix.length() > 12) {
            JMSException exception = new JMSException(NLS.getFormattedMessage("DESTINATION_PREFIX_LONG_CWSJR1025", new Object[]{prefix}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw exception;
        }
    }

    @Override
    public String getTemporaryTopicNamePrefix() {
        return (String)this._properties.get("tempTopicNamePrefix");
    }

    @Override
    public void setTemporaryTopicNamePrefix(String prefix) throws JMSException {
        this._properties.put("tempTopicNamePrefix", prefix);
        if (prefix != null && prefix.length() > 12) {
            JMSException exception = new JMSException(NLS.getFormattedMessage("DESTINATION_PREFIX_LONG_CWSJR1029", new Object[]{prefix}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw exception;
        }
    }

    @Override
    public String getNonPersistentMapping() {
        return (String)this._properties.get("nonPersistentMapping");
    }

    @Override
    public void setNonPersistentMapping(String nonPersistentMapping) {
        this._properties.put("nonPersistentMapping", nonPersistentMapping);
    }

    @Override
    public String getPersistentMapping() {
        return (String)this._properties.get("persistentMapping");
    }

    @Override
    public void setPersistentMapping(String persistentMapping) {
        this._properties.put("persistentMapping", persistentMapping);
    }

    @Override
    public String getTarget() {
        return (String)this._properties.get("targetGroup");
    }

    @Override
    public void setTarget(String target) {
        this._properties.put("targetGroup", target);
    }

    @Override
    public String getTargetType() {
        return (String)this._properties.get("targetType");
    }

    @Override
    public void setTargetType(String targetType) {
        this._properties.put("targetType", targetType);
    }

    @Override
    public String getTargetSignificance() {
        return (String)this._properties.get("targetSignificance");
    }

    @Override
    public void setTargetSignificance(String targetSignificance) {
        this._properties.put("targetSignificance", targetSignificance);
    }

    @Override
    public String getTargetTransportChain() {
        return (String)this._properties.get("targetTransportChain");
    }

    @Override
    public void setTargetTransportChain(String targetTransportChain) {
        this._properties.put("targetTransportChain", targetTransportChain);
    }

    @Override
    public String getRemoteServerAddress() {
        return (String)this._properties.get("remoteServerAddress");
    }

    @Override
    public void setRemoteServerAddress(String remoteServerAddress) {
        this._properties.put("remoteServerAddress", remoteServerAddress);
    }

    @Override
    public String getTargetTransport() {
        return (String)this._properties.get("targetTransport");
    }

    @Override
    public void setTargetTransport(String targetTransport) {
        this._properties.put("targetTransport", targetTransport);
    }

    @Override
    public Boolean getShareDataSourceWithCMP() {
        return (Boolean)this._properties.get("shareDataSourceWithCMP");
    }

    @Override
    public void setShareDataSourceWithCMP(Boolean sharing) {
        this._properties.put("shareDataSourceWithCMP", sharing);
    }

    @Override
    public String getConnectionProximity() {
        return (String)this._properties.get("connectionProximity");
    }

    @Override
    public void setConnectionProximity(String connectionProximity) {
        this._properties.put("connectionProximity", connectionProximity);
    }

    @Override
    public String getShareDurableSubscriptions() {
        return (String)this._properties.get("shareDurableSubs");
    }

    @Override
    public void setShareDurableSubscriptions(String sharedDurSubs) {
        this._properties.put("shareDurableSubs", sharedDurSubs);
    }

    @Override
    public void setShareDurableSubscription(Boolean shareDurSubs) {
        if (shareDurSubs.booleanValue()) {
            this.setShareDurableSubscriptions("AlwaysShared");
        } else {
            this.setShareDurableSubscriptions("NeverShared");
        }
    }

    @Override
    public String getSubscriptionProtocol() {
        return (String)this._properties.get("subscriptionProtocol");
    }

    @Override
    public void setSubscriptionProtocol(String subscriptionProtocol) {
        this._properties.put("subscriptionProtocol", subscriptionProtocol);
    }

    @Override
    public String getMulticastInterface() {
        return (String)this._properties.get("multicastInterface");
    }

    @Override
    public void setMulticastInterface(String multicastInterface) {
        this._properties.put("multicastInterface", multicastInterface);
    }

    @Override
    public String getProducerDoesNotModifyPayloadAfterSet() {
        return (String)this._properties.get("producerDoesNotModifyPayloadAfterSet");
    }

    @Override
    public void setProducerDoesNotModifyPayloadAfterSet(String propertyValue) {
        this._properties.put("producerDoesNotModifyPayloadAfterSet", propertyValue);
    }

    @Override
    public String getConsumerDoesNotModifyPayloadAfterGet() {
        return (String)this._properties.get("consumerDoesNotModifyPayloadAfterGet");
    }

    @Override
    public void setConsumerDoesNotModifyPayloadAfterGet(String propertyValue) {
        this._properties.put("consumerDoesNotModifyPayloadAfterGet", propertyValue);
    }

    JmsJcaUserDetails getUserDetails(final Subject subject, ConnectionRequestInfo requestInfo) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getUserDetails", (Object)new Object[]{JmsJcaManagedConnection.subjectToString(subject), requestInfo});
        }
        JmsJcaUserDetails result = null;
        if (subject == null) {
            String userName = null;
            String password = null;
            if (requestInfo instanceof JmsJcaConnectionRequestInfo) {
                JmsJcaConnectionRequestInfo jmsJcaConnReq = (JmsJcaConnectionRequestInfo)requestInfo;
                result = jmsJcaConnReq.getUserDetails();
            }
            if (result == null) {
                userName = this.getUserName();
                password = this.getPassword();
                result = new JmsJcaUserDetails(userName, password);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Using default credentials from managed connection factory");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Using credentials passed by application");
            }
        } else {
            PasswordCredential credential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<PasswordCredential> credentialSet = subject.getPrivateCredentials(PasswordCredential.class);
                    for (PasswordCredential next : credentialSet) {
                        PasswordCredential subjectCredential;
                        if (!(next instanceof PasswordCredential) || !JmsJcaManagedConnectionFactoryImpl.this.equals((subjectCredential = next).getManagedConnectionFactory())) continue;
                        return subjectCredential;
                    }
                    return null;
                }
            });
            if (credential == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"No PasswordCredential in Subject - using Subject for authentication");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)"Using PasswordCredential from Subject");
                }
                result = new JmsJcaUserDetails(credential.getUserName(), String.valueOf(credential.getPassword()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled() && result != null) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Credential contains userName", (Object)result.getUserName());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getUserDetails", (Object)result);
        }
        return result;
    }

    Map getTrmProperties() {
        String trmMulticastInterface;
        String trmSubscriptionProtocol;
        String trmConnectionProximity;
        String trmTargetTransport;
        String trmProviderEndpoints;
        String trmTargetTransportChain;
        String trmTargetSignificance;
        String trmTargetType;
        String trmTarget;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTrmProperties");
        }
        HashMap<String, String> trmProperties = new HashMap<String, String>();
        String trmBusName = this.getBusName();
        if (trmBusName != null && !trmBusName.equals("")) {
            trmProperties.put("busName", trmBusName);
        }
        if ((trmTarget = this.getTarget()) != null && !trmTarget.equals("")) {
            trmProperties.put("targetGroup", trmTarget);
        }
        if ((trmTargetType = this.getTargetType()) != null && !trmTargetType.equals("")) {
            trmProperties.put("targetType", trmTargetType);
        }
        if ((trmTargetSignificance = this.getTargetSignificance()) != null && !trmTargetSignificance.equals("")) {
            trmProperties.put("targetSignificance", trmTargetSignificance);
        }
        if ((trmTargetTransportChain = this.getTargetTransportChain()) != null && !trmTargetTransportChain.equals("")) {
            trmProperties.put("targetTransportChain", trmTargetTransportChain);
        }
        if ((trmProviderEndpoints = this.getRemoteServerAddress()) != null && !trmProviderEndpoints.equals("")) {
            trmProperties.put("remoteServerAddress", trmProviderEndpoints);
        }
        if ((trmTargetTransport = this.getTargetTransport()) != null && !trmTargetTransport.equals("")) {
            trmProperties.put("targetTransport", trmTargetTransport);
        }
        if ((trmConnectionProximity = this.getConnectionProximity()) != null && !trmConnectionProximity.equals("")) {
            trmProperties.put("connectionProximity", trmConnectionProximity);
        }
        if ((trmSubscriptionProtocol = this.getSubscriptionProtocol()) != null && !trmSubscriptionProtocol.equals("")) {
            trmProperties.put("subscriptionProtocol", trmSubscriptionProtocol);
        }
        if ((trmMulticastInterface = this.getMulticastInterface()) != null && !trmMulticastInterface.equals("")) {
            trmProperties.put("multicastInterface", trmMulticastInterface);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTrmProperties", trmProperties);
        }
        return trmProperties;
    }

    private JmsRAFactoryFactory getJmsRAFactoryFactory() throws ResourceException {
        if (this._jmsFactoryFactory == null) {
            try {
                JmsFactoryFactory jmsFactory = JmsFactoryFactory.getInstance();
                if (!(jmsFactory instanceof JmsRAFactoryFactory)) {
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("JMS_CONNECTION_FAIL_CWSJR1024", new Object[]{"getJmsRAFactoryFactory", JmsRAFactoryFactory.class.getName(), jmsFactory == null ? "null" : jmsFactory.getClass().getName()}, null));
                }
                this._jmsFactoryFactory = (JmsRAFactoryFactory)((Object)jmsFactory);
            }
            catch (JMSException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getJmsRAFactoryFactory"), (String)FFDC_PROBE_5, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException((Throwable)exception);
            }
        }
        return this._jmsFactoryFactory;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" <logWriter=");
        sb.append(this._logWriter);
        sb.append("> <busName=");
        sb.append(this.getBusName());
        sb.append("> <clientID=");
        sb.append(this.getClientID());
        sb.append("> <userName=");
        sb.append(this.getUserName());
        sb.append("> <password=");
        sb.append(this.getPassword() == null ? null : "*****");
        sb.append("> <nonPersistentMapping=");
        sb.append(this.getNonPersistentMapping());
        sb.append("> <persistentMapping=");
        sb.append(this.getPersistentMapping());
        sb.append("> <durableSubscriptionHome=");
        sb.append(this.getDurableSubscriptionHome());
        sb.append("> <readAhead=");
        sb.append(this.getReadAhead());
        sb.append("> <temporaryQueueNamePrefix=");
        sb.append(this.getTemporaryQueueNamePrefix());
        sb.append("> <temporaryTopicNamePrefix=");
        sb.append(this.getTemporaryTopicNamePrefix());
        sb.append("> <target=");
        sb.append(this.getTarget());
        sb.append("> <targetSignificance=");
        sb.append(this.getTargetSignificance());
        sb.append("> <targetTransportChain=");
        sb.append(this.getTargetTransportChain());
        sb.append("> <targetType=");
        sb.append(this.getTargetType());
        sb.append("> <RemoteServerAddress=");
        sb.append(this.getRemoteServerAddress());
        sb.append("> <TargetTransport=");
        sb.append(this.getTargetTransport());
        sb.append("> <connectionProximity=");
        sb.append(this.getConnectionProximity());
        sb.append("> <shareDataSourceWithCMP=");
        sb.append(this.getShareDataSourceWithCMP());
        sb.append("> <shareDurableSubscriptions=");
        sb.append(this.getShareDurableSubscriptions());
        sb.append("> <cachedFactory=");
        sb.append(this._jmsFactoryFactory);
        sb.append("> <producerDoesNotModifyPayloadAfterSet=");
        sb.append(this.getProducerDoesNotModifyPayloadAfterSet());
        sb.append("> <consumerDoesNotModifyPayloadAfterGet=");
        sb.append(this.getConsumerDoesNotModifyPayloadAfterGet());
        sb.append(">]");
        return sb.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    String getConnectionType() {
        return CONN_FACTORY_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reference getReference() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getReference");
        }
        Reference reference = new Reference(this.getConnectionType(), this.getClass().getName(), null);
        Map map = this._properties;
        synchronized (map) {
            Map encodedMap = JmsJcaReferenceUtils.getInstance().getStringEncodedMap(this._properties, defaultJNDIProperties);
            for (Map.Entry entry : encodedMap.entrySet()) {
                String prefixedKey = (String)entry.getKey();
                String stringForm = (String)entry.getValue();
                reference.add(new StringRefAddr(prefixedKey, stringForm));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getReference", (Object)reference);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReference(Reference reference) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setReference", (Object)reference);
        }
        Map map = this._properties;
        synchronized (map) {
            this._properties = JmsJcaReferenceUtils.getInstance().getMapFromReference(reference, defaultJNDIProperties);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setReference");
        }
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws Exception {
        JmsConnectionFactory jmsConnectionFactory = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getObjectInstance", (Object)new Object[]{object, name, context, environment});
        }
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String clsName = reference.getClassName();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("class name is " + clsName));
            }
            if (CONN_FACTORY_TYPE.equals(clsName) || "javax.jms.QueueConnectionFactory".equals(clsName) || "javax.jms.TopicConnectionFactory".equals(clsName)) {
                try {
                    jmsConnectionFactory = (JmsConnectionFactory)this.createConnectionFactory();
                    jmsConnectionFactory.setReference(reference);
                }
                catch (ResourceException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "getObjectInstance"), (String)FFDC_PROBE_6, (Object)this);
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1027", new Object[]{exception, "getObjectInstance"}, null), (Throwable)exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getObjectInstance", jmsConnectionFactory);
        }
        return jmsConnectionFactory;
    }

    ConnectionFactory createJmsConnFactory(JmsRAFactoryFactory jmsFactory, JmsJcaConnectionFactoryImpl connFactory) {
        return jmsFactory.createConnectionFactory(connFactory);
    }

    ConnectionFactory createJmsConnFactory(JmsRAFactoryFactory jmsFactory, JmsJcaConnectionFactoryImpl connFactory, JmsJcaManagedConnectionFactory fact) {
        return jmsFactory.createConnectionFactory(connFactory, fact);
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getInvalidConnections", (Object)connectionSet);
        }
        HashSet<JmsJcaManagedConnection> invalidConnections = new HashSet<JmsJcaManagedConnection>();
        for (Object object : connectionSet) {
            JmsJcaManagedConnection potentialInvalidConnection;
            if (!(object instanceof JmsJcaManagedConnection) || (potentialInvalidConnection = (JmsJcaManagedConnection)object).isValid()) continue;
            invalidConnections.add(potentialInvalidConnection);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getInvalidConnections", invalidConnections);
        }
        return invalidConnections;
    }

    public ResourceAdapter getResourceAdapter() {
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this._resourceAdapter = resourceAdapter;
    }

    static {
        defaultJNDIProperties.put("producerDoesNotModifyPayloadAfterSet", "false");
        defaultJNDIProperties.put("consumerDoesNotModifyPayloadAfterGet", "false");
    }
}

