/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JaxWsConfigurationException;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JaxWsServiceConfiguration
extends AbstractServiceConfiguration {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsServiceConfiguration.class);
    private JaxWsImplementorInfo implInfo;
    private Map<Object, Class<?>> responseMethodClassCache;
    private Map<Object, Class<?>> requestMethodClassCache;
    private List<Method> responseMethodClassNotFoundCache;
    private List<Method> requestMethodClassNotFoundCache;
    private Map<Method, Annotation[][]> methodAnnotationCache;
    static final long serialVersionUID = -1743310671418569677L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JaxWsServiceConfiguration() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "<init>", new Object[0]);
        }
        this.responseMethodClassCache = new HashMap();
        this.requestMethodClassCache = new HashMap();
        this.responseMethodClassNotFoundCache = new ArrayList<Method>();
        this.requestMethodClassNotFoundCache = new ArrayList<Method>();
        this.methodAnnotationCache = new HashMap<Method, Annotation[][]>();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "setServiceFactory", new Object[]{serviceFactory});
        }
        super.setServiceFactory(serviceFactory);
        this.implInfo = ((JaxWsServiceFactoryBean)serviceFactory).getJaxWsImplementorInfo();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "setServiceFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getServiceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceName", new Object[0]);
        }
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceName", string);
            }
            return string;
        }
        String string = service.getLocalPart();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getServiceNamespace() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceNamespace", new Object[0]);
        }
        String ret = super.getServiceNamespace();
        if (ret != null) {
            String string = ret;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceNamespace", string);
            }
            return string;
        }
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceNamespace", string);
            }
            return string;
        }
        String string = service.getNamespaceURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getServiceNamespace", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getEndpointName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getEndpointName", new Object[0]);
        }
        QName qName = this.implInfo.getEndpointName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getEndpointName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getInterfaceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInterfaceName", new Object[0]);
        }
        QName qName = this.implInfo.getInterfaceName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInterfaceName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getWsdlURL() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWsdlURL", new Object[0]);
        }
        String wsdlLocation = this.implInfo.getWsdlLocation();
        if (wsdlLocation != null && wsdlLocation.length() > 0) {
            String string = wsdlLocation;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWsdlURL", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWsdlURL", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getOperationName(InterfaceInfo intf, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOperationName", new Object[]{intf, method});
        }
        method = this.getDeclaredMethod(method);
        WebMethod wm = method.getAnnotation(WebMethod.class);
        if (wm != null) {
            String name = wm.operationName();
            if (name.length() == 0) {
                name = method.getName();
            }
            QName qName = new QName(intf.getName().getNamespaceURI(), name);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOperationName", qName);
            }
            return qName;
        }
        QName qName = new QName(intf.getName().getNamespaceURI(), method.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOperationName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isWebMethod(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", new Object[]{method});
        }
        if (method == null || method.getReturnType().equals(Future.class) || method.getReturnType().equals(Response.class) || method.isSynthetic()) {
            Boolean bl = Boolean.FALSE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
            }
            return bl;
        }
        WebMethod wm = method.getAnnotation(WebMethod.class);
        Class<?> cls = method.getDeclaringClass();
        if (wm != null && wm.exclude()) {
            Boolean bl = Boolean.FALSE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
            }
            return bl;
        }
        if (wm != null && !wm.exclude() || cls.isInterface() && cls.isAssignableFrom(this.implInfo.getSEIClass())) {
            Boolean bl = Boolean.TRUE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
            }
            return bl;
        }
        if (method.getDeclaringClass().isInterface()) {
            Boolean bl = this.hasWebServiceAnnotation(method);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
            }
            return bl;
        }
        if (this.implInfo.getSEIClass() == null) {
            Boolean bl = this.hasWebServiceAnnotation(method) && !Modifier.isFinal(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
            }
            return bl;
        }
        Boolean bl = this.implInfo.getSEIClass().isAssignableFrom(method.getDeclaringClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWebMethod", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isOperation(Method method) {
        WebMethod wm;
        WebMethod wm2;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOperation", new Object[]{method});
        }
        if (Object.class.equals(method.getDeclaringClass())) {
            Boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOperation", bl);
            }
            return bl;
        }
        if (method.getDeclaringClass() == this.implInfo.getSEIClass() && (wm2 = method.getAnnotation(WebMethod.class)) != null && wm2.exclude()) {
            Message message = new Message("WEBMETHOD_EXCLUDE_NOT_ALLOWED", LOG, new Object[]{method.getName()});
            throw new JaxWsConfigurationException(message);
        }
        Class<?> implClz = this.implInfo.getImplementorClass();
        Method m = this.getDeclaredMethod(implClz, method);
        if (m != null && (wm = m.getAnnotation(WebMethod.class)) != null && wm.exclude()) {
            Boolean bl = Boolean.FALSE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOperation", bl);
            }
            return bl;
        }
        if (this.isWebMethod(m).booleanValue()) {
            Boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOperation", bl);
            }
            return bl;
        }
        Boolean bl = this.isWebMethod(this.getDeclaredMethod(method));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOperation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasWebServiceAnnotation(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "hasWebServiceAnnotation", new Object[]{method});
        }
        boolean bl = method.getDeclaringClass().getAnnotation(WebService.class) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "hasWebServiceAnnotation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Method getDeclaredMethod(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDeclaredMethod", new Object[]{method});
        }
        Method method2 = this.getDeclaredMethod(this.implInfo.getEndpointClass(), method);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method2 = method2;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDeclaredMethod", method2);
        }
        return method2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Method getDeclaredMethod(Class<?> endpointClass, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDeclaredMethod", new Object[]{endpointClass, method});
        }
        if (!method.getDeclaringClass().equals(endpointClass)) {
            try {
                method = endpointClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                Method method2 = this.isWebMethod(method) != false ? method : null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    method2 = method2;
                    LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDeclaredMethod", method2);
                }
                return method2;
            }
        }
        Method method3 = method;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method3 = method3;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDeclaredMethod", method3);
        }
        return method3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInPartName", new Object[]{op, method, paramNumber});
        }
        if (paramNumber < 0) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInPartName", qName);
            }
            return qName;
        }
        QName qName = this.getPartName(op, method, paramNumber, op.getInput(), "arg", true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInPartName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInParameterName", new Object[]{op, method, paramNumber});
        }
        if (paramNumber < 0) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInParameterName", qName);
            }
            return qName;
        }
        QName qName = this.getParameterName(op, method, paramNumber, op.getInput().size(), "arg", true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getInParameterName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getPartName(OperationInfo op, Method method, int paramNumber, MessageInfo mi, String prefix, boolean isIn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPartName", new Object[]{op, method, paramNumber, mi, prefix, isIn});
        }
        int partIndex = this.getPartIndex(method, paramNumber, isIn);
        method = this.getDeclaredMethod(method);
        WebParam param = this.getWebParam(method, paramNumber);
        String tns = mi.getName().getNamespaceURI();
        String local = null;
        if (param != null) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || this.isDocumentBare(method) || param.header()) {
                local = param.partName();
            }
            if (local == null || local.length() == 0) {
                local = param.name();
            }
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? this.getDefaultLocalName(op, method, paramNumber, partIndex, prefix) : this.getOperationName(op.getInterface(), method).getLocalPart();
        }
        QName qName = new QName(tns, local);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPartName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int getPartIndex(Method method, int paraNumber, boolean isIn) {
        int i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPartIndex", new Object[]{method, paraNumber, isIn});
        }
        int ret = 0;
        if (isIn && this.isInParam(method, paraNumber).booleanValue()) {
            for (i = 0; i < paraNumber; ++i) {
                if (!this.isInParam(method, i).booleanValue()) continue;
                ++ret;
            }
        }
        if (!isIn && this.isOutParam(method, paraNumber).booleanValue()) {
            if (!method.getReturnType().equals(Void.class)) {
                ++ret;
            }
            for (i = 0; i < paraNumber; ++i) {
                if (!this.isOutParam(method, i).booleanValue()) continue;
                ++ret;
            }
        }
        int n = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPartIndex", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getParameterName(OperationInfo op, Method method, int paramNumber, int curSize, String prefix, boolean input) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getParameterName", new Object[]{op, method, paramNumber, curSize, prefix, input});
        }
        int partIndex = this.getPartIndex(method, paramNumber, input);
        method = this.getDeclaredMethod(method);
        WebParam param = this.getWebParam(method, paramNumber);
        String tns = null;
        String local = null;
        if (param != null) {
            tns = param.targetNamespace();
            local = param.name();
        }
        if (tns == null || tns.length() == 0) {
            QName wrappername = null;
            wrappername = input ? this.getRequestWrapperName(op, method) : this.getResponseWrapperName(op, method);
            if (wrappername != null) {
                tns = wrappername.getNamespaceURI();
            }
        }
        if (tns == null || tns.length() == 0) {
            tns = op.getName().getNamespaceURI();
        }
        if (local == null || local.length() == 0) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method))) {
                local = this.getDefaultLocalName(op, method, paramNumber, partIndex, prefix);
            } else {
                local = this.getOperationName(op.getInterface(), method).getLocalPart();
                if (!input) {
                    local = local + "Response";
                }
            }
        }
        QName qName = new QName(tns, local);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getParameterName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getDefaultLocalName(OperationInfo op, Method method, int paramNumber, int partIndex, String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDefaultLocalName", new Object[]{op, method, paramNumber, partIndex, prefix});
        }
        String paramName = null;
        paramName = paramNumber != -1 ? prefix + partIndex : prefix;
        String string = paramName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getDefaultLocalName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private WebParam getWebParam(Method method, int parameter) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebParam", new Object[]{method, parameter});
        }
        Annotation[][] annotations = this.methodAnnotationCache.get(method);
        if (annotations == null) {
            annotations = method.getParameterAnnotations();
            this.methodAnnotationCache.put(method, annotations);
        }
        if (parameter >= annotations.length) {
            WebParam webParam = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                webParam = webParam;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebParam", webParam);
            }
            return webParam;
        }
        for (int i = 0; i < annotations[parameter].length; ++i) {
            Annotation annotation = annotations[parameter][i];
            if (!(annotation instanceof WebParam)) continue;
            WebParam webParam = (WebParam)annotation;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                webParam = webParam;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebParam", webParam);
            }
            return webParam;
        }
        WebParam webParam = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            webParam = webParam;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebParam", webParam);
        }
        return webParam;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRequestWrapperPartName(OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperPartName", new Object[]{op, method});
        }
        method = this.getDeclaredMethod(method);
        RequestWrapper rw = method.getAnnotation(RequestWrapper.class);
        if (rw != null) {
            String string = this.getWithReflection(RequestWrapper.class, rw, "partName");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperPartName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperPartName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getResponseWrapperPartName(OperationInfo op, Method method) {
        String pn;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperPartName", new Object[]{op, method});
        }
        method = this.getDeclaredMethod(method);
        WebResult webResult = this.getWebResult(method);
        ResponseWrapper rw = method.getAnnotation(ResponseWrapper.class);
        if (rw != null && (pn = this.getWithReflection(ResponseWrapper.class, rw, "partName")) != null) {
            String string = pn;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperPartName", string);
            }
            return string;
        }
        int countOut = 0;
        int countHeaders = 0;
        if (webResult != null && webResult.header()) {
            ++countHeaders;
        } else if (method.getReturnType() != Void.TYPE) {
            ++countOut;
        }
        for (int x = 0; x < method.getParameterTypes().length; ++x) {
            WebParam parm = this.getWebParam(method, x);
            if (parm == null) continue;
            if (parm.header()) {
                ++countHeaders;
            }
            if (parm.mode() == WebParam.Mode.IN) continue;
            ++countOut;
        }
        if (countHeaders > 0 && countOut == 0) {
            String string = "result";
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperPartName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperPartName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getFaultMessageName(OperationInfo op, Class<?> exClass, Class<?> beanClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultMessageName", new Object[]{op, exClass, beanClass});
        }
        WebFault f = exClass.getAnnotation(WebFault.class);
        if (f != null) {
            String string = this.getWithReflection(WebFault.class, f, "messageName");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultMessageName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultMessageName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> String getWithReflection(Class<T> cls, T obj, String name) {
        block4: {
            String string;
            block5: {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWithReflection", new Object[]{cls, obj, name});
                }
                try {
                    String s = cls.getMethod(name, new Class[0]).invoke(obj, new Object[0]).toString();
                    if (StringUtils.isEmpty((String)s)) break block4;
                    string = s;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWithReflection", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWithReflection", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        QName wrappername;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutParameterName", new Object[]{op, method, paramNumber});
        }
        method = this.getDeclaredMethod(method);
        if (paramNumber >= 0) {
            QName qName = this.getParameterName(op, method, paramNumber, op.getOutput().size(), "return", false);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutParameterName", qName);
            }
            return qName;
        }
        WebResult webResult = this.getWebResult(method);
        String tns = null;
        String local = null;
        if (webResult != null) {
            tns = webResult.targetNamespace();
            local = webResult.name();
        }
        if ((tns == null || tns.length() == 0) && (wrappername = this.getResponseWrapperName(op, method)) != null) {
            tns = wrappername.getNamespaceURI();
        }
        if (tns == null || tns.length() == 0) {
            tns = op.getName().getNamespaceURI();
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? this.getDefaultLocalName(op, method, paramNumber, op.getOutput().size(), "return") : this.getOperationName(op.getInterface(), method).getLocalPart() + "Response";
        }
        QName qName = new QName(tns, local);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutParameterName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutPartName", new Object[]{op, method, paramNumber});
        }
        method = this.getDeclaredMethod(method);
        if (paramNumber >= 0) {
            QName qName = this.getPartName(op, method, paramNumber, op.getOutput(), "return", false);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutPartName", qName);
            }
            return qName;
        }
        WebResult webResult = this.getWebResult(method);
        String tns = op.getOutput().getName().getNamespaceURI();
        String local = null;
        if (webResult != null) {
            if (Boolean.TRUE.equals(this.isRPC(method)) || this.isDocumentBare(method)) {
                local = webResult.partName();
            }
            if (local == null || local.length() == 0) {
                local = webResult.name();
            }
        }
        if (local == null || local.length() == 0) {
            local = Boolean.TRUE.equals(this.isRPC(method)) || !Boolean.FALSE.equals(this.isWrapped(method)) ? "return" : this.getOperationName(op.getInterface(), method).getLocalPart() + "Response";
        }
        QName qName = new QName(tns, local);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getOutPartName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isInParam(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isInParam", new Object[]{method, j});
        }
        if (j < 0) {
            Boolean bl = Boolean.FALSE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isInParam", bl);
            }
            return bl;
        }
        WebParam webParam = this.getWebParam(method = this.getDeclaredMethod(method), j);
        Boolean bl = webParam == null || webParam.mode().equals((Object)WebParam.Mode.IN) || webParam.mode().equals((Object)WebParam.Mode.INOUT);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isInParam", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private WebResult getWebResult(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebResult", new Object[]{method});
        }
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            webResult = webResult;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWebResult", webResult);
        }
        return webResult;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isOutParam(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOutParam", new Object[]{method, j});
        }
        method = this.getDeclaredMethod(method);
        if (j == -1) {
            Boolean bl = !method.getReturnType().equals(Void.TYPE);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOutParam", bl);
            }
            return bl;
        }
        WebParam webParam = this.getWebParam(method, j);
        if (webParam != null && (webParam.mode().equals((Object)WebParam.Mode.OUT) || webParam.mode().equals((Object)WebParam.Mode.INOUT))) {
            Boolean bl = Boolean.TRUE;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOutParam", bl);
            }
            return bl;
        }
        Boolean bl = method.getParameterTypes()[j] == Holder.class;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isOutParam", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getRequestWrapperName(OperationInfo op, Method method) {
        WebMethod meth;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperName", new Object[]{op, method});
        }
        Method m = this.getDeclaredMethod(method);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String nm = null;
        String lp = null;
        if (rw != null) {
            nm = rw.targetNamespace();
            lp = rw.localName();
        }
        if ((meth = m.getAnnotation(WebMethod.class)) != null && StringUtils.isEmpty((String)lp)) {
            lp = meth.operationName();
        }
        if (StringUtils.isEmpty((String)nm)) {
            nm = op.getName().getNamespaceURI();
        }
        if (!StringUtils.isEmpty((String)nm) && !StringUtils.isEmpty((String)lp)) {
            QName qName = new QName(nm, lp);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperName", qName);
            }
            return qName;
        }
        QName qName = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getResponseWrapperName(OperationInfo op, Method method) {
        WebMethod meth;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperName", new Object[]{op, method});
        }
        Method m = this.getDeclaredMethod(method);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String nm = null;
        String lp = null;
        if (rw != null) {
            nm = rw.targetNamespace();
            lp = rw.localName();
        }
        if ((meth = m.getAnnotation(WebMethod.class)) != null && StringUtils.isEmpty((String)lp) && !StringUtils.isEmpty((String)(lp = meth.operationName()))) {
            lp = lp + "Response";
        }
        if (StringUtils.isEmpty((String)nm)) {
            nm = op.getName().getNamespaceURI();
        }
        if (!StringUtils.isEmpty((String)nm) && !StringUtils.isEmpty((String)lp)) {
            QName qName = new QName(nm, lp);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperName", qName);
            }
            return qName;
        }
        QName qName = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getResponseWrapper(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", new Object[]{selected});
        }
        if (this.responseMethodClassNotFoundCache.contains(selected)) {
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", clazz);
            }
            return clazz;
        }
        Class<?> cachedClass = this.responseMethodClassCache.get(selected);
        if (cachedClass != null) {
            Class<?> clazz = cachedClass;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", clazz);
            }
            return clazz;
        }
        Method m = this.getDeclaredMethod(selected);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String clsName = "";
        clsName = rw == null ? JaxWsServiceConfiguration.getPackageName(selected) + ".jaxws." + StringUtils.capitalize((String)selected.getName()) + "Response" : rw.className();
        if (clsName.length() > 0) {
            Class clazz;
            block12: {
                cachedClass = this.responseMethodClassCache.get(clsName);
                if (cachedClass != null) {
                    this.responseMethodClassCache.put(selected, cachedClass);
                    Class<?> clazz2 = cachedClass;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        clazz2 = clazz2;
                        LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", clazz2);
                    }
                    return clazz2;
                }
                try {
                    Class r = ClassLoaderUtils.loadClass((String)clsName, this.implInfo.getEndpointClass());
                    this.responseMethodClassCache.put(clsName, r);
                    this.responseMethodClassCache.put(selected, r);
                    if (r.equals(m.getReturnType())) {
                        LOG.log(Level.WARNING, "INVALID_RESPONSE_WRAPPER", new Object[]{clsName, m.getReturnType().getName()});
                    }
                    clazz = r;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", clazz);
            }
            return clazz;
        }
        this.responseMethodClassNotFoundCache.add(selected);
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapper", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getResponseWrapperClassName(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperClassName", new Object[]{selected});
        }
        Method m = this.getDeclaredMethod(selected);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        String clsName = "";
        if (rw != null) {
            clsName = rw.className();
        }
        if (clsName.length() > 0) {
            String string = clsName;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperClassName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getResponseWrapperClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRequestWrapperClassName(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperClassName", new Object[]{selected});
        }
        Method m = this.getDeclaredMethod(selected);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String clsName = "";
        if (rw != null) {
            clsName = rw.className();
        }
        if (clsName.length() > 0) {
            String string = clsName;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperClassName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapperClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getRequestWrapper(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", new Object[]{selected});
        }
        if (this.requestMethodClassNotFoundCache.contains(selected)) {
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", clazz);
            }
            return clazz;
        }
        Class<?> cachedClass = this.requestMethodClassCache.get(selected);
        if (cachedClass != null) {
            Class<?> clazz = cachedClass;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", clazz);
            }
            return clazz;
        }
        Method m = this.getDeclaredMethod(selected);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        String clsName = "";
        clsName = rw == null ? JaxWsServiceConfiguration.getPackageName(selected) + ".jaxws." + StringUtils.capitalize((String)selected.getName()) : rw.className();
        if (clsName.length() > 0) {
            Class clazz;
            block12: {
                cachedClass = this.requestMethodClassCache.get(clsName);
                if (cachedClass != null) {
                    this.requestMethodClassCache.put(selected, cachedClass);
                    Class<?> clazz2 = cachedClass;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        clazz2 = clazz2;
                        LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", clazz2);
                    }
                    return clazz2;
                }
                try {
                    Class r = ClassLoaderUtils.loadClass((String)clsName, this.implInfo.getEndpointClass());
                    this.requestMethodClassCache.put(clsName, r);
                    this.requestMethodClassCache.put(selected, r);
                    if (m.getParameterTypes().length == 1 && r.equals(m.getParameterTypes()[0])) {
                        LOG.log(Level.WARNING, "INVALID_REQUEST_WRAPPER", new Object[]{clsName, m.getParameterTypes()[0].getName()});
                    }
                    clazz = r;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", clazz);
            }
            return clazz;
        }
        this.requestMethodClassNotFoundCache.add(selected);
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getRequestWrapper", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getPackageName(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPackageName", new Object[]{method});
        }
        String string = PackageUtils.getPackageName(method.getDeclaringClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getPackageName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getFaultName(InterfaceInfo service, OperationInfo o, Class<?> exClass, Class<?> beanClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultName", new Object[]{service, o, exClass, beanClass});
        }
        WebFault fault = exClass.getAnnotation(WebFault.class);
        if (fault != null) {
            String ns;
            String name = fault.name();
            if (name.length() == 0) {
                name = exClass.getSimpleName();
            }
            if ((ns = fault.targetNamespace()).length() == 0) {
                ns = service.getName().getNamespaceURI();
            }
            QName qName = new QName(ns, name);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultName", qName);
            }
            return qName;
        }
        QName qName = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getFaultName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isWrapped(Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", new Object[]{m});
        }
        if (this.getServiceFactory().getWrapped() != null) {
            Boolean bl = this.getServiceFactory().getWrapped();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", bl);
            }
            return bl;
        }
        SOAPBinding ann = (m = this.getDeclaredMethod(m)).getAnnotation(SOAPBinding.class);
        if (ann != null) {
            if (ann.style().equals((Object)SOAPBinding.Style.RPC)) {
                Message message = new Message("SOAPBinding_MESSAGE_RPC", LOG, new Object[]{m.getName()});
                throw new Fault((Throwable)((Object)new JaxWsConfigurationException(message)));
            }
            Boolean bl = !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", bl);
            }
            return bl;
        }
        Boolean bl = this.isWrapped();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isWrapped() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", new Object[0]);
        }
        SOAPBinding ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            Boolean bl = !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE) && !ann.style().equals((Object)SOAPBinding.Style.RPC);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", bl);
            }
            return bl;
        }
        Boolean bl = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapped", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isHeader(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isHeader", new Object[]{method, j});
        }
        method = this.getDeclaredMethod(method);
        if (j >= 0) {
            WebParam webParam = this.getWebParam(method, j);
            Boolean bl = webParam != null && webParam.header();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isHeader", bl);
            }
            return bl;
        }
        WebResult webResult = this.getWebResult(method);
        Boolean bl = webResult != null && webResult.header();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStyle() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getStyle", new Object[0]);
        }
        SOAPBinding ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            String string = ann.style().toString().toLowerCase();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getStyle", string);
            }
            return string;
        }
        String string = super.getStyle();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getStyle", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isDocumentBare(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isDocumentBare", new Object[]{method});
        }
        SOAPBinding ann = method.getAnnotation(SOAPBinding.class);
        if (ann != null) {
            boolean bl = ann.style().equals((Object)SOAPBinding.Style.DOCUMENT) && ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isDocumentBare", bl);
            }
            return bl;
        }
        ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            boolean bl = ann.style().equals((Object)SOAPBinding.Style.DOCUMENT) && ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isDocumentBare", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isDocumentBare", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isRPC(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isRPC", new Object[]{method});
        }
        SOAPBinding ann = method.getAnnotation(SOAPBinding.class);
        if (ann != null) {
            Boolean bl = ann.style().equals((Object)SOAPBinding.Style.RPC);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isRPC", bl);
            }
            return bl;
        }
        ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            Boolean bl = ann.style().equals((Object)SOAPBinding.Style.RPC);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isRPC", bl);
            }
            return bl;
        }
        Boolean bl = super.isRPC(method);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isRPC", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean hasOutMessage(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "hasOutMessage", new Object[]{method});
        }
        method = this.getDeclaredMethod(method);
        Boolean bl = !method.isAnnotationPresent(Oneway.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "hasOutMessage", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAction(OperationInfo op, Method method) {
        Action act;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getAction", new Object[]{op, method});
        }
        method = this.getDeclaredMethod(method);
        WebMethod wm = method.getAnnotation(WebMethod.class);
        String action = "";
        if (wm != null) {
            action = wm.action();
        }
        if (StringUtils.isEmpty((String)action) && (act = method.getAnnotation(Action.class)) != null) {
            action = act.input();
        }
        String string = action;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getAction", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isHolder(Class<?> cls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isHolder", new Object[]{cls, type});
        }
        Boolean bl = Holder.class.equals(cls);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isHolder", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Type getHolderType(Class<?> cls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getHolderType", new Object[]{cls, type});
        }
        if (cls.equals(Holder.class) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type type2 = paramType.getActualTypeArguments()[0];
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                type2 = type2;
                LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getHolderType", type2);
            }
            return type2;
        }
        Class<?> clazz = cls;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getHolderType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean isWrapperPartQualified(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapperPartQualified", new Object[]{mpi});
        }
        Annotation[] annotations = (Annotation[])mpi.getProperty("parameter.annotations");
        if (annotations != null) {
            for (Annotation an : annotations) {
                String tns = null;
                if (an instanceof WebParam) {
                    tns = ((WebParam)an).targetNamespace();
                } else if (an instanceof WebResult) {
                    tns = ((WebResult)an).targetNamespace();
                }
                if (tns == null || StringUtils.isEmpty((String)tns)) continue;
                Boolean bl = Boolean.TRUE;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapperPartQualified", bl);
                }
                return bl;
            }
        }
        Boolean bl = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "isWrapperPartQualified", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Long getWrapperPartMinOccurs(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWrapperPartMinOccurs", new Object[]{mpi});
        }
        Annotation[] a = (Annotation[])mpi.getProperty("parameter.annotations");
        if (a != null) {
            for (Annotation a2 : a) {
                XmlElement e;
                if (!(a2 instanceof XmlElement) || !(e = (XmlElement)a2).required()) continue;
                Long l = 1L;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    l = l;
                    LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWrapperPartMinOccurs", l);
                }
                return l;
            }
        }
        Long l = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("org.apache.cxf.jaxws.support.JaxWsServiceConfiguration", "getWrapperPartMinOccurs", l);
        }
        return l;
    }
}

