/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.internal;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidScopeException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.common.claims.UserClaimsRetrieverService;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.token.impl.WSOAuth20TokenHelper;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Authenticator;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.token.WSOAuth20Token;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20AuthenticatorImpl
implements OAuth20Authenticator {
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.resources.ProviderMsgs";
    private static final TraceComponent tc = Tr.register(OAuth20AuthenticatorImpl.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final String DEFAULT_GROUP_IDENTIFIER = "groupIds";
    private static final String Authorization_Header = "Authorization";
    static final long serialVersionUID = 3091596127897086152L;

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res) {
        return this.authenticate(req, res, null);
    }

    /*
     * WARNING - void declaration
     */
    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef) {
        boolean isOauthProtected = false;
        ProviderAuthenticationResult result = new ProviderAuthenticationResult(AuthResult.CONTINUE, 200);
        List<OAuth20Provider> providers = this.getProviders(req);
        if (providers != null && !providers.isEmpty()) {
            if (providers.size() == 1) {
                boolean oauthOnly;
                OAuth20Provider provider;
                block15: {
                    provider = providers.get(0);
                    String encoding = provider.getCharacterEncoding();
                    if (req.getCharacterEncoding() == null && encoding != null) {
                        try {
                            req.setCharacterEncoding(encoding);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            void e;
                            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.internal.OAuth20AuthenticatorImpl", (String)"83", (Object)this, (Object[])new Object[]{req, res, oidcServerConfigRef});
                            if (!tc.isWarningEnabled()) break block15;
                            Tr.warning((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }
                if (oauthOnly = provider.isOauthOnly()) {
                    if (!this.isTokenRequest(req)) {
                        isOauthProtected = true;
                    }
                } else if (this.isProtectedResourceRequest(req)) {
                    isOauthProtected = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no access token, falling back to available authentication.", (Object[])new Object[0]);
                }
                if (isOauthProtected) {
                    result = this.checkAccess(req, res, provider);
                }
            } else {
                result = new ProviderAuthenticationResult(AuthResult.FAILURE, 500);
                StringBuffer list = null;
                for (OAuth20Provider provider : providers) {
                    if (list == null) {
                        list = new StringBuffer(provider.getID());
                        continue;
                    }
                    list.append(", ").append(provider.getID());
                }
                Tr.error((TraceComponent)tc, (String)"security.oauth20.error.filter.multiple.matching", (Object[])new Object[]{list.toString()});
            }
        }
        return result;
    }

    private ProviderAuthenticationResult checkAccess(HttpServletRequest req, HttpServletResponse res, OAuth20Provider provider) {
        ProviderAuthenticationResult result = null;
        String access_token = this.getBearerAccessTokenToken(req);
        boolean isAppPasswordOrTokenRequest = false;
        if (access_token == null || access_token.trim().length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no OAuth token in the request.", (Object[])new Object[0]);
            }
            result = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        } else {
            OAuthResult oResult = provider.processResourceRequest(req);
            if (oResult.getStatus() == 1) {
                int responseCode = -1;
                responseCode = oResult.getCause() instanceof OAuth20InvalidScopeException ? 403 : 401;
                result = new ProviderAuthenticationResult(AuthResult.FAILURE, responseCode);
                String message = "Bearer realm=\"OAuth\",";
                message = message + " error=\"invalid_token\",";
                message = message + " error_description=\"Check access token\"";
                res.setHeader("WWW-Authenticate", message);
                if (tc.isDebugEnabled()) {
                    if (oResult.getCause() != null) {
                        Tr.debug((TraceComponent)tc, (String)("OAuth Token validation fails: " + oResult.getCause().getMessage()), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("OAuth Token with null cause! " + oResult), (Object[])new Object[0]);
                    }
                }
            } else {
                result = this.createResult(req, res, oResult, provider);
            }
        }
        if (AuthResult.FAILURE == result.getStatus() && this.isAppPasswordOrTokenRequest(req)) {
            result = new ProviderAuthenticationResult(AuthResult.CONTINUE, 200);
        }
        return result;
    }

    private boolean isAppPasswordOrTokenRequest(HttpServletRequest req) {
        if (req.getRequestURI() == null) {
            return false;
        }
        if (req.getRequestURI().endsWith("app-passwords") || req.getRequestURI().endsWith("app-tokens")) {
            return true;
        }
        String apw = "/app-passwords/";
        String atk = "/app-tokens/";
        return req.getRequestURI().contains("/app-passwords/") || req.getRequestURI().contains("/app-tokens/");
    }

    private ProviderAuthenticationResult createResult(HttpServletRequest req, HttpServletResponse res, OAuthResult oResult, OAuth20Provider provider) {
        Map<String, Object> claimsMap;
        List groups;
        UserClaims userClaims;
        Subject subject = new Subject();
        WSOAuth20Token token = WSOAuth20TokenHelper.createToken(req, res, oResult, provider.getID());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OAuth Token is " + token), (Object[])new Object[0]);
        }
        String cacheKey = token.getCacheKey();
        if (provider.isIncludeTokenInSubject()) {
            this.addToSubjectAsPrivateCredential(subject, token);
        }
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        customProperties.put("com.ibm.wsspi.security.cred.cacheKey", cacheKey);
        customProperties.put("OAuthProvider", provider.getID());
        String user_name = token.getUser();
        UserClaimsRetrieverService ucrService = ConfigUtils.getUserClaimsRetrieverService();
        if (ucrService != null && (userClaims = ucrService.getUserClaims(user_name, DEFAULT_GROUP_IDENTIFIER)) != null && (groups = (List)(claimsMap = userClaims.asMap()).get(DEFAULT_GROUP_IDENTIFIER)) != null && groups.size() > 0) {
            customProperties.put("com.ibm.wsspi.security.cred.groups", groups);
        }
        return new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, user_name, subject, customProperties, null);
    }

    private void addToSubjectAsPrivateCredential(final Subject subj, final Object token) {
        if (token != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 4526095989886869201L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    subj.getPrivateCredentials().add(token);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.internal.OAuth20AuthenticatorImpl$1", 1.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
                }
            });
        }
    }

    protected List<OAuth20Provider> getProviders(HttpServletRequest req) {
        return ProvidersService.getProvidersMatchingRequest(req);
    }

    private boolean isTokenRequest(HttpServletRequest req) {
        boolean isToken = false;
        if ("authorization_code".equals(req.getParameter("grant_type")) || "authorization_code".equals(req.getHeader("grant_type")) || "token".equals(req.getParameter("response_type")) || "token".equals(req.getHeader("response_type")) || "password".equals(req.getParameter("grant_type")) || "password".equals(req.getHeader("grant_type")) || "client_credentials".equals(req.getParameter("grant_type")) || "client_credentials".equals(req.getHeader("grant_type"))) {
            isToken = true;
        }
        return isToken;
    }

    private boolean isProtectedResourceRequest(HttpServletRequest req) {
        boolean isResourceReq = false;
        if (this.hasOAuthToken(req) && !this.isTokenRequest(req)) {
            isResourceReq = true;
        }
        return isResourceReq;
    }

    private boolean hasOAuthToken(HttpServletRequest req) {
        boolean hasToken = false;
        String hdrValue = this.getBearerAccessTokenToken(req);
        if (hdrValue != null && hdrValue.trim().length() != 0) {
            hasToken = true;
        }
        return hasToken;
    }

    private String getBearerAccessTokenToken(HttpServletRequest req) {
        String hdrValue = req.getHeader(Authorization_Header);
        if (hdrValue != null && hdrValue.startsWith("Bearer ")) {
            hdrValue = hdrValue.substring(7);
        } else {
            hdrValue = req.getHeader("access_token");
            if (hdrValue == null || hdrValue.trim().length() == 0) {
                hdrValue = req.getParameter("access_token");
            }
        }
        return hdrValue;
    }
}

