/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.platform;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.platform.LibertyPlatformService;
import com.ibm.ws.security.oauth20.platform.PlatformService;
import com.ibm.ws.security.oauth20.platform.TestPlatformService;
import com.ibm.ws.security.oauth20.platform.WASPlatformService;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PlatformServiceFactory {
    private static TraceComponent tc = Tr.register(PlatformServiceFactory.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static PlatformService platform = null;
    protected static final String WAS_CLASS = "com.ibm.websphere.cache.DistributedMap";
    protected static final String TEST_PROP = "OAUTH_UNIT_TEST";
    protected static final String LIBERTY_PROP = "server.config.dir";
    static final long serialVersionUID = -81250720747748055L;

    @ManualTrace
    public static PlatformService getPlatformService() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPlatformService", (Object[])new Object[0]);
        }
        if (platform == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking platform type", (Object[])new Object[0]);
            }
            if (PlatformServiceFactory.tryProp(TEST_PROP)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking platform type", (Object[])new Object[0]);
                }
                platform = new TestPlatformService();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"found prop OAUTH_UNIT_TEST", (Object[])new Object[0]);
                }
            } else if (PlatformServiceFactory.tryProp(LIBERTY_PROP)) {
                platform = new LibertyPlatformService();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"found prop server.config.dir", (Object[])new Object[0]);
                }
            } else if (PlatformServiceFactory.tryClass(WAS_CLASS)) {
                platform = new WASPlatformService();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"found class com.ibm.websphere.cache.DistributedMap", (Object[])new Object[0]);
                }
            } else {
                platform = new WASPlatformService();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"nothing found, default platform", (Object[])new Object[0]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Platform: " + platform.getClass().getName()), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPlatformService");
        }
        return platform;
    }

    private static boolean tryClass(String className) {
        try {
            Class.forName(className);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found class name", (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.oauth20.platform.PlatformServiceFactory", (String)"83", null, (Object[])new Object[]{className});
            return false;
        }
    }

    private static boolean tryProp(final String prop) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 816970640969779537L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(prop);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.platform.PlatformServiceFactory$1", 1.class, null, null);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"tryProp", (Object[])new Object[]{"value: " + value});
        }
        return value != null;
    }
}

