/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuth20TokenImpl
implements OAuth20Token,
Serializable {
    private static final long serialVersionUID = -276162556269542122L;
    String _uniqueId;
    String _componentId;
    String _type;
    String _subType;
    long _createdAt = 0L;
    int _lifetimeSeconds = 0;
    long _lastAccess = 0L;
    String _tokenString;
    String _clientId;
    String _username;
    String[] _scopes;
    String _redirectUri;
    String _stateId;
    String accessToken;
    String refreshToken;
    Map<String, String[]> _extensionProperties;
    private String _grantType = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OAuth20TokenImpl(String uniqueId, String componentId, String type, String subType, long createdAt, int lifetime, String tokenString, String clientId, String username, String[] scopes, String redirectUri, String stateId, Map<String, String[]> extensionProperties, String grantType) {
        this._uniqueId = uniqueId;
        this._componentId = componentId;
        this._type = type;
        this._subType = subType;
        this._createdAt = createdAt;
        this._lifetimeSeconds = lifetime;
        this._tokenString = tokenString;
        this._clientId = clientId;
        this._username = username;
        this._scopes = scopes;
        this._redirectUri = redirectUri;
        this._stateId = stateId;
        this._grantType = grantType;
        this._extensionProperties = extensionProperties;
    }

    public OAuth20TokenImpl(OAuth20Token tokenIn) {
        this._uniqueId = tokenIn.getId();
        this._componentId = tokenIn.getComponentId();
        this._type = tokenIn.getType();
        this._subType = tokenIn.getSubType();
        this._createdAt = tokenIn.getCreatedAt();
        this._lifetimeSeconds = tokenIn.getLifetimeSeconds();
        this._tokenString = tokenIn.getTokenString();
        this._clientId = tokenIn.getClientId();
        this._username = tokenIn.getUsername();
        this._scopes = tokenIn.getScope();
        this._redirectUri = tokenIn.getRedirectUri();
        this._stateId = tokenIn.getStateId();
        this._grantType = tokenIn.getGrantType();
        this._extensionProperties = tokenIn.getExtensionProperties();
    }

    public void setAccessTokenKey(String access) {
        this.accessToken = access;
    }

    public String getAccessTokenKey() {
        return this.accessToken;
    }

    public void setRefreshTokenKey(String refresh) {
        this.refreshToken = refresh;
    }

    public String getRefreshTokenKey() {
        return this.refreshToken;
    }

    @Override
    public String getId() {
        return this._uniqueId;
    }

    @Override
    public String getComponentId() {
        return this._componentId;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getSubType() {
        return this._subType;
    }

    @Override
    public long getCreatedAt() {
        return this._createdAt;
    }

    @Override
    public int getLifetimeSeconds() {
        return this._lifetimeSeconds;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String getTokenString() {
        return this._tokenString;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String[] getScope() {
        return this._scopes;
    }

    @Override
    public String getRedirectUri() {
        return this._redirectUri;
    }

    @Override
    public String getStateId() {
        return this._stateId;
    }

    @Override
    public String[] getExtensionPropertyNames() {
        Set<String> keys;
        String[] result = null;
        if (this._extensionProperties != null && this._extensionProperties.size() > 0 && (keys = this._extensionProperties.keySet()) != null) {
            result = keys.toArray(new String[keys.size()]);
        }
        return result;
    }

    @Override
    public String[] getExtensionProperty(String propertyName) {
        String[] result = null;
        if (this._extensionProperties != null && this._extensionProperties.size() > 0) {
            result = this._extensionProperties.get(propertyName);
        }
        return result;
    }

    @Override
    public String getGrantType() {
        return this._grantType;
    }

    @Override
    public Map<String, String[]> getExtensionProperties() {
        return this._extensionProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("_uniqueId: " + this._uniqueId);
        sb.append(" _componentId: " + this._componentId);
        sb.append(" _type: " + this._type);
        sb.append(" _subType: " + this._subType);
        sb.append(" _createdAt: " + this._createdAt);
        sb.append(" _lifetime: " + this._lifetimeSeconds);
        sb.append(" _tokenString: " + this._tokenString);
        sb.append(" _clientId: " + this._clientId);
        sb.append(" _username: " + this._username);
        sb.append(" _scopes: " + this.arrayToString(this._scopes));
        sb.append(" _redirectUri: " + this._redirectUri);
        sb.append(" _stateId: " + this._stateId);
        sb.append(" _grantType: " + this._grantType);
        sb.append(" _extensionProperties: " + JSONUtil.getJSONStrings(this._extensionProperties));
        sb.append("}");
        return sb.toString();
    }

    String arrayToString(String[] strs) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (strs != null && strs.length > 0) {
            for (int i = 0; i < strs.length; ++i) {
                sb.append(strs[i]);
                if (i >= strs.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getUsedFor() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:used_for");
        return buf == null ? null : buf[0];
    }

    @Override
    public String[] getUsedBy() {
        return this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:used_by");
    }

    @Override
    public String getAppName() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:app_name");
        return buf == null ? null : buf[0];
    }

    @Override
    public long getLastAccess() {
        return this._lastAccess;
    }

    @Override
    public void setLastAccess() {
        this._lastAccess = System.currentTimeMillis();
    }

    @Override
    public String getCodeChallenge() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:code_challenge");
        return buf == null ? null : buf[0];
    }

    @Override
    public String getCodeChallengeMethod() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:code_challenge_method");
        return buf == null ? null : buf[0];
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl", OAuth20TokenImpl.class, null, null);
    }
}

