/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ContentRange
implements Comparable<ContentRange> {
    protected final String _type;
    protected final Float _qValue;
    static final long serialVersionUID = -4974040821659520292L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getType() {
        return this._type;
    }

    public Float getQValue() {
        return this._qValue;
    }

    public ContentRange(String type, Float qValue) {
        if (type == null || type.length() == 0) {
            type = "*";
        }
        this._type = type.toLowerCase().trim();
        if (qValue == null) {
            this._qValue = new Float(1.0);
        } else {
            if (qValue.floatValue() < 0.0f || qValue.floatValue() > 1.0f) {
                throw new NumberFormatException("qValue cannot be less than '0' or greater than '1.0'");
            }
            this._qValue = qValue;
        }
    }

    protected static ContentRange[] parse(String value, RangeParseCallback cb) {
        ContentRange range;
        if (cb == null) {
            throw new IllegalArgumentException("RangeParseCallback must not be null");
        }
        ArrayList<ContentRange> ranges = new ArrayList<ContentRange>(5);
        if (value == null) {
            value = "";
        }
        if (value.length() == 0 && (range = cb.rangeParsed(null, null, null, null)) != null) {
            ranges.add(range);
        }
        StringTokenizer rangeTokenizer = new StringTokenizer(value, ",");
        while (rangeTokenizer.hasMoreTokens()) {
            ContentRange range2;
            StringTokenizer parmTokenizer = new StringTokenizer(rangeTokenizer.nextToken(), ";");
            if (parmTokenizer.countTokens() == 0) continue;
            String type = parmTokenizer.nextToken().toLowerCase().trim();
            Float qValue = null;
            HashMap<String, String[]> parameters = null;
            HashMap<String, String[]> extensions = null;
            int numTokens = parmTokenizer.countTokens();
            if (numTokens == 0) {
                ContentRange range3 = cb.rangeParsed(type, parameters, qValue, extensions);
                if (range3 == null) continue;
                ranges.add(range3);
                continue;
            }
            String nextToken = parmTokenizer.nextToken().toLowerCase();
            String[] parm = StringUtil.splitPair(nextToken, '=');
            if (parm[0].equalsIgnoreCase("q")) {
                qValue = new Float(parm[1]);
            } else {
                parameters = new HashMap<String, String[]>();
                parameters.put(parm[0].toLowerCase(), new String[]{parm[1].toLowerCase()});
                while (parmTokenizer.hasMoreTokens()) {
                    nextToken = parmTokenizer.nextToken().toLowerCase();
                    parm = StringUtil.splitPair(nextToken, '=');
                    if (parm[0].equalsIgnoreCase("q")) {
                        qValue = new Float(parm[1]);
                        break;
                    }
                    ContentRange.updateParmMap(parameters, parm);
                }
            }
            if (parmTokenizer.hasMoreTokens()) {
                extensions = new HashMap<String, String[]>();
                while (parmTokenizer.hasMoreTokens()) {
                    nextToken = parmTokenizer.nextToken().toLowerCase();
                    parm = StringUtil.splitPair(nextToken, '=');
                    ContentRange.updateParmMap(extensions, parm);
                }
            }
            if ((range2 = cb.rangeParsed(type, parameters, qValue, extensions)) == null) continue;
            ranges.add(range2);
        }
        cb.preSort(ranges);
        Collections.sort(ranges);
        cb.postSort(ranges);
        return ranges.toArray(new ContentRange[ranges.size()]);
    }

    private static void updateParmMap(Map<String, String[]> parmMap, String[] parm) {
        String name = parm[0].toLowerCase();
        String value = parm[1].toLowerCase();
        if (parmMap.containsKey(name)) {
            String[] values = parmMap.get(name);
            String[] newVals = (String[])Array.newInstance(String.class, values.length + 1);
            System.arraycopy(values, 0, newVals, 0, values.length);
            newVals[newVals.length - 1] = value;
            parmMap.put(name, newVals);
        } else {
            parmMap.put(name, new String[]{value});
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ContentRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ContentRange that = (ContentRange)o;
        return this._qValue.equals(that._qValue) && this._type.equalsIgnoreCase(that._type);
    }

    public int hashCode() {
        return this._type.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._type);
        if ((double)this._qValue.floatValue() != 1.0) {
            buf.append(String.format(";q=%s", this._qValue.toString()));
        }
        return buf.toString();
    }

    @Override
    public int compareTo(ContentRange that) {
        float rhs;
        if (that == null) {
            return 1;
        }
        float lhs = this._qValue.floatValue();
        if (lhs == (rhs = that._qValue.floatValue())) {
            String thisType = this._type;
            String thatType = that._type;
            if (thisType.equals(thatType)) {
                return 0;
            }
            if (thisType.equals("*")) {
                return 1;
            }
            if (thatType.equals("*")) {
                return -1;
            }
            return thisType.compareTo(thatType);
        }
        if (lhs < rhs) {
            return 1;
        }
        return -1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.util.ContentRange", ContentRange.class, null, null);
    }

    protected static interface RangeParseCallback {
        public ContentRange rangeParsed(String var1, HashMap<String, String[]> var2, Float var3, HashMap<String, String[]> var4);

        public void preSort(ArrayList<ContentRange> var1);

        public void postSort(ArrayList<ContentRange> var1);
    }
}

