/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.util;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.ExtendedTransactionManager;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.EventSemaphore;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxRecoveryAgentImpl;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.tx.jta.util.TxBundleTools;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.TMService;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeCallbackAgent;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.tx.UOWEventListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TxTMHelper
implements TMService,
UOWScopeCallbackAgent {
    private static final TraceComponent tc = Tr.register(TxTMHelper.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static TMService.TMStates _state = TMService.TMStates.INACTIVE;
    private static TxRecoveryAgentImpl _recoveryAgent;
    protected static final EventSemaphore _asyncRecoverySemaphore;
    protected static RuntimeException _resyncException;
    protected RecLogServiceImpl _recLogService;
    protected RecoveryDirector _recoveryDirector;
    private UOWEventListener _uowEventListener;
    protected boolean _recoverDBLogStarted = false;
    protected String _recoveryIdentity = null;
    protected String _recoveryGroup = null;
    private static boolean _xaResourceFactoryReady;
    private boolean _waitForRecovery = false;
    private boolean _tmsReady = false;
    private static boolean _requireRecoveryLogFactory;
    private static boolean _recoveryLogFactoryReady;
    private static RecoveryLogFactory _recoveryLogFactory;
    private static boolean _recoveryLogServiceReady;
    private static boolean _requireDataSourceActive;
    protected static BundleContext _bc;

    public static TMService.TMStates getState() {
        return _state;
    }

    public static void setState(TMService.TMStates state) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting state from " + _state + " to " + state));
        }
        _state = state;
    }

    public TxTMHelper() {
        TMHelper.setTMService((TMService)this);
    }

    protected TxTMHelper(boolean dummy) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NOT Adding shutdown hook");
        }
        TMHelper.setTMService((TMService)this);
    }

    protected void setConfigurationProvider(ConfigurationProvider p) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConfigurationProvider", (Object)p);
        }
        try {
            ConfigurationProviderManager.setConfigurationProvider((ConfigurationProvider)p);
            if (_state == TMService.TMStates.STOPPED) {
                this.start();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setConfigurationProvider", (String)"37", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConfigurationProvider");
        }
    }

    protected void unsetConfigurationProvider(ConfigurationProvider p) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetConfigurationProvider", (Object)p);
        }
        if (p != null && !p.isSQLRecoveryLog()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Logging to a filesytem, shutdown now");
            }
            try {
                this.shutdown();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.unsetConfigurationProvider", (String)"138", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetConfigurationProvider");
        }
    }

    protected void setXaResourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setXaResourceFactory", (Object)("ref " + ref));
        }
        _xaResourceFactoryReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setXaResourceFactory", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setXaResourceFactory");
        }
    }

    protected void unsetXaResourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetXaResourceFactory, ref " + ref));
        }
    }

    public void setRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setRecoveryLogFactory, factory: " + fac), (Object)this);
        }
        _recoveryLogFactory = fac;
        _recoveryLogFactoryReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setRecoveryLogFactory", (String)"206", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryLogFactory");
        }
    }

    public void unsetRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetRecoveryLogFactory, factory: " + fac), (Object)this);
        }
    }

    public void setRecoveryLogService(ServiceReference<RecLogServiceImpl> ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryLogService", ref);
        }
        _recoveryLogServiceReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setRecoveryLogService", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryLogService");
        }
    }

    public void unsetRecoveryLogService(ServiceReference<RecLogServiceImpl> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetRecoveryLogService", ref);
        }
    }

    public Object runAsSystem(PrivilegedExceptionAction a) throws PrivilegedActionException {
        return AccessController.doPrivileged(a);
    }

    public Object runAsSystemOrSpecified(PrivilegedExceptionAction a) throws PrivilegedActionException {
        return this.runAsSystem(a);
    }

    public boolean isProviderInstalled(String providerId) {
        return true;
    }

    public void asynchRecoveryProcessingComplete(Throwable t) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"asynchRecoveryProcessingComplete", (Object)t);
        }
    }

    public void start(boolean waitForRecovery) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object)waitForRecovery);
        }
        this.retrieveBundleContext();
        this._tmsReady = true;
        this._waitForRecovery = waitForRecovery;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.start", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecovery() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startRecovery");
        }
        if (!this._recoverDBLogStarted) {
            TxTMHelper txTMHelper = this;
            synchronized (txTMHelper) {
                TMHelper.setTMService((TMService)this);
                Tr.reinitializeTracer();
                ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
                if (cp != null && cp.isSQLRecoveryLog()) {
                    this._recoverDBLogStarted = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS set recoverDBLogStarted flag");
                    }
                }
                if (TxTMHelper.getState() != TMService.TMStates.INACTIVE && TxTMHelper.getState() != TMService.TMStates.STOPPED) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"start", (Object)"Already started");
                    }
                    return;
                }
                TxTMHelper.setResyncException(null);
                this._recLogService = new RecLogServiceImpl();
                this._recoveryDirector = RecoveryDirectorFactory.createRecoveryDirector();
                if (cp != null) {
                    this._recoveryIdentity = cp.getRecoveryIdentity();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RecoveryIdentity is ", (Object)this._recoveryIdentity);
                    }
                    this._recoveryGroup = cp.getRecoveryGroup();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"recoveryGroup is ", (Object)this._recoveryGroup);
                    }
                }
                boolean allowRecovery = true;
                if (cp == null) {
                    allowRecovery = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Configuration Provider is null");
                    }
                } else {
                    String sName = cp.getServerName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved server name " + sName));
                    }
                    if (sName == null || sName.isEmpty()) {
                        allowRecovery = false;
                    }
                }
                if (!allowRecovery) {
                    try {
                        this.shutdown();
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.start", (String)"279", (Object)this);
                    }
                    SystemException se = new SystemException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"start", (Object)((Object)se));
                    }
                    throw se;
                }
                if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                    this._recLogService.initialize(this._recoveryIdentity);
                } else {
                    String serverName = null;
                    if (cp != null) {
                        serverName = cp.getServerName();
                    }
                    this._recLogService.initialize(serverName);
                }
                TxRecoveryAgentImpl txAgent = this.createRecoveryAgent(this._recoveryDirector);
                if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                    this._recLogService.setPeerRecoverySupported(true);
                    txAgent.setPeerRecoverySupported(true);
                    TransactionImpl.setDisable2PCDefault(false);
                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Server with identity " + this._recoveryIdentity + " is monitoring its peers for Transaction Peer Recovery"));
                }
                if (this._recoveryGroup != null && !this._recoveryGroup.isEmpty()) {
                    txAgent.setRecoveryGroup(this._recoveryGroup);
                    this._recLogService.setRecoveryGroup(this._recoveryGroup);
                }
                TxTMHelper.setRecoveryAgent(txAgent);
                RecoveryManager._waitForRecovery = this._waitForRecovery;
                this._recLogService.startRecovery(_recoveryLogFactory);
                TxTMHelper.setState(TMService.TMStates.RECOVERING);
                if (this._waitForRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for completion of asynchronous recovery");
                    }
                    _asyncRecoverySemaphore.waitEvent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Asynchronous recovery is complete");
                    }
                    if (_resyncException != null) {
                        try {
                            this.shutdown();
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.start", (String)"137", (Object)this);
                        }
                        Throwable se = new SystemException().initCause((Throwable)_resyncException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"start", (Object)se);
                        }
                        throw (SystemException)se;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS and START processing is in progress");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startRecovery");
        }
    }

    private synchronized void shutdown(boolean explicit, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object)new Object[]{explicit, timeout});
        }
        if (_state != TMService.TMStates.STOPPED && _state != TMService.TMStates.INACTIVE) {
            TxTMHelper.setState(TMService.TMStates.STOPPING);
            if (timeout != 0) {
                int timeToWait = timeout;
                int timeSlept = 0;
                while (LocalTIDTable.getAllTransactions().length > 0) {
                    if (timeout < 0 || timeToWait-- > 0) {
                        try {
                            Thread.sleep(1000L);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Waited " + ++timeSlept + " seconds for transactions to finish"));
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Gave up waiting for transactions to finish after " + ++timeSlept + " seconds"));
                    break;
                }
            }
            _recoveryAgent.stop(false);
            this._recLogService.stop();
            ExtendedTransactionManager tm = TransactionManagerFactory.getTransactionManager();
            ((TranManagerSet)tm).cleanup();
            TxTMHelper.setRecoveryAgent(null);
            RecoveryDirectorFactory.reset();
            LocalTIDTable.clear();
            try {
                _asyncRecoverySemaphore.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TxTMHelper.setResyncException(null);
            _asyncRecoverySemaphore.clear();
            ConfigurationProviderManager.stop((boolean)true);
            TxTMHelper.setState(TMService.TMStates.STOPPED);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected static void setRecoveryAgent(TxRecoveryAgentImpl recoveryAgent) {
        _recoveryAgent = recoveryAgent;
    }

    public void shutdown(ConfigurationProvider cp) throws Exception {
        int shutdownDelay = cp != null ? cp.getDefaultMaximumShutdownDelay() : 0;
        this.shutdown(false, shutdownDelay);
    }

    public void shutdown() throws Exception {
        this.shutdown(ConfigurationProviderManager.getConfigurationProvider());
    }

    public void shutdown(int timeout) throws Exception {
        this.shutdown(true, timeout);
    }

    public void start() throws Exception {
        ConfigurationProvider cp;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        if (tc.isDebugEnabled()) {
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
        }
        this.start((cp = ConfigurationProviderManager.getConfigurationProvider()) != null && cp.isWaitForRecovery());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public static synchronized void resyncComplete(RuntimeException r) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resyncComplete", (Object)r);
        }
        if (_state == TMService.TMStates.RECOVERING) {
            TxTMHelper.setState(TMService.TMStates.ACTIVE);
        }
        TxTMHelper.setResyncException(r);
        _asyncRecoverySemaphore.post();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resyncComplete");
        }
    }

    protected static void setResyncException(RuntimeException r) {
        _resyncException = r;
    }

    public static boolean ready() {
        return _state == TMService.TMStates.ACTIVE || _state == TMService.TMStates.RECOVERING;
    }

    public void checkTMState() throws NotSupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTMState");
        }
        if (_state != TMService.TMStates.ACTIVE && _state != TMService.TMStates.RECOVERING) {
            if (_state == TMService.TMStates.INACTIVE) {
                try {
                    TMHelper.start();
                }
                catch (Exception e) {
                    NotSupportedException nse = new NotSupportedException();
                    nse.initCause((Throwable)e);
                    throw nse;
                }
            } else {
                if (_state == TMService.TMStates.STOPPING) {
                    throw new NotSupportedException("JTM is stopping");
                }
                if (_state == TMService.TMStates.STOPPED) {
                    throw new NotSupportedException("JTM is stopped");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTMState");
        }
    }

    @Override
    public void registerCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCallback", (Object)callback);
        }
        UserTransactionImpl.instance().registerCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    @Override
    public void unregisterCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterCallback", (Object)callback);
        }
        UserTransactionImpl.instance().unregisterCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterCallback");
        }
    }

    public void setUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUOWEventListener", (Object)el);
        }
        ((UOWCurrent)((Object)TranManagerSet.instance())).setUOWEventListener(el);
    }

    public void unsetUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetUOWEventListener", (Object)el);
        }
        ((UOWCurrent)((Object)TranManagerSet.instance())).unsetUOWEventListener(el);
    }

    protected TxRecoveryAgentImpl createRecoveryAgent(RecoveryDirector recoveryDirector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoveryAgent", (Object)recoveryDirector);
        }
        TxRecoveryAgentImpl txAgent = new TxRecoveryAgentImpl(recoveryDirector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoveryAgent", (Object)txAgent);
        }
        return txAgent;
    }

    protected void retrieveBundleContext() {
        BundleContext bc = TxBundleTools.getBundleContext();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("retrieveBundleContext, bc " + bc));
        }
        _bc = bc;
    }

    public static BundleContext getBundleContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getBundleContext, bc " + _bc));
        }
        return _bc;
    }

    private boolean ableToStartRecoveryNow() {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ableToStartRecoveryNow");
        }
        boolean recoverNow = false;
        ConfigurationProviderManager.start();
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Working with config provider: " + cp));
        }
        if (cp != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Need to coordinate: " + cp.needToCoordinateServices()));
        }
        if (cp != null && !cp.needToCoordinateServices()) {
            recoverNow = true;
        } else {
            if (cp != null && cp.isSQLRecoveryLog()) {
                _requireDataSourceActive = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_requireRecoveryLogFactory: " + _requireDataSourceActive + ", _waitForRecovery: " + this._waitForRecovery + ", _tmsReady: " + this._tmsReady + ", _recoveryLogServiceReady: " + _recoveryLogServiceReady + ", _recoveryLogFactoryReady: " + _recoveryLogFactoryReady));
            }
            if (!_requireDataSourceActive) {
                recoverNow = this._waitForRecovery ? this._tmsReady && _xaResourceFactoryReady && _recoveryLogServiceReady && _recoveryLogFactoryReady : this._tmsReady && _recoveryLogServiceReady;
            } else {
                boolean bl = recoverNow = this._tmsReady && _xaResourceFactoryReady && _recoveryLogServiceReady && _recoveryLogFactoryReady;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ableToStartRecoveryNow", (Object)recoverNow);
        }
        return recoverNow;
    }

    static {
        _asyncRecoverySemaphore = new EventSemaphore();
        _xaResourceFactoryReady = false;
        _requireRecoveryLogFactory = false;
        _recoveryLogFactoryReady = false;
        _recoveryLogFactory = null;
        _recoveryLogServiceReady = false;
        _requireDataSourceActive = false;
        _bc = null;
    }
}

