/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSAccessFile;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CoordinationLock {
    private static final TraceComponent tc;
    public static final int LOCK_SUCCESS = 1;
    public static final int LOCK_FAILURE = 2;
    public static final int LOCK_INTERRUPT = 4;
    static final int LOCKRETRYCOUNT = 0;
    static final int LOCKRETRYDELAY = 10000;
    static final int LOCKRETRYTIMES = 30;
    private static String RECOVERY_FILE_1_NAME;
    private static String RECOVERY_FILE_2_NAME;
    CoordinationLockHandle _handle1 = null;
    CoordinationLockHandle _handle2 = null;
    private String _lockDirectory;
    private boolean _lockFilesExist = false;
    private boolean _interrupted = false;
    static final long serialVersionUID = -7929697542457387982L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public CoordinationLock(String lockDirectory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CoordinationLock", (Object)lockDirectory);
        }
        this._lockDirectory = lockDirectory;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CoordinationLock", (Object)this);
        }
    }

    public int lock() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lock");
        }
        int result = 2;
        if (!this._lockFilesExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Confirming/Creating the lock files");
            }
            this._handle1 = this.ensureFileExists(RECOVERY_FILE_1_NAME);
            if (this._handle1 != null) {
                this._handle2 = this.ensureFileExists(RECOVERY_FILE_2_NAME);
                if (this._handle2 != null) {
                    this._lockFilesExist = true;
                } else {
                    Tr.error((TraceComponent)tc, (String)"CWRLS0004_RECOVERY_LOG_CREATE_FAILED", (Object)(this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME));
                    this._handle1 = null;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"CWRLS0004_RECOVERY_LOG_CREATE_FAILED", (Object)(this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Already Confirmed/Created the lock files");
        }
        if (this._lockFilesExist) {
            result = this.obtainLock(this._handle1);
            if (result == 1) {
                result = this.obtainLock(this._handle2);
                if (result != 1) {
                    if (result == 2) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0005_RECOVERY_LOG_LOCK_FAILED", (Object)(this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME));
                    }
                    this.releaseLock(this._handle1);
                }
            } else if (result == 2) {
                Tr.error((TraceComponent)tc, (String)"CWRLS0005_RECOVERY_LOG_LOCK_FAILED", (Object)(this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lock", (Object)new Integer(result));
        }
        return result;
    }

    public void unlock() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unlock");
        }
        if (this._handle2 != null) {
            this.releaseLock(this._handle2);
        }
        if (this._handle1 != null) {
            this.releaseLock(this._handle1);
        }
        this._handle2 = null;
        this._handle1 = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlock");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int obtainLock(CoordinationLockHandle handle) {
        int result;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"obtainLock", (Object)handle);
            }
            result = 2;
            try {
                final File file = new File(handle._directory, handle._fileName);
                try {
                    handle._raf = (RandomAccessFile)Configuration.getAccessController().doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = 6960738385652218796L;
                        private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                        public Object run() throws Exception {
                            if (tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)tc, (String)"run", (Object)this);
                            }
                            RLSAccessFile raf = RLSAccessFile.getRLSAccessFile(file);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"run");
                            }
                            return raf;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$1", 1.class, null, null);
                        }
                    });
                    handle._channel = handle._raf.getChannel();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    void exc;
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"243", (Object)this, (Object[])new Object[]{handle});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", (String)"253", (Object)this);
                    throw exc;
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"248", (Object)this, (Object[])new Object[]{handle});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", (String)"258", (Object)this);
                    throw exc;
                }
                boolean halt = false;
                int lockAttempt = 0;
                while (!halt) {
                    int l;
                    ++lockAttempt;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RLSHA: Lock attempt #" + lockAttempt + " on lock file " + handle));
                    }
                    handle._fileLock = handle._channel.tryLock();
                    if (handle._fileLock != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RLSHA: Obtained an exclusive access lock on lock file " + handle));
                        }
                        halt = true;
                        result = 1;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RLSHA: Unable to obtain an exclusive access lock on lock file " + handle));
                    }
                    if ((l = lockAttempt - 2) / 30 * 30 == l) {
                        Tr.warning((TraceComponent)tc, (String)"CWRLS0026_RECOVERY_LOG_LOCK_RETRY", (Object)file);
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Sleeping for 10000 ms before re-try");
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"292", (Object)this, (Object[])new Object[]{handle});
                    }
                    if (!this._interrupted) continue;
                    halt = true;
                    result = 4;
                    try {
                        handle._raf.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"308", (Object)this, (Object[])new Object[]{handle});
                    }
                }
            }
            catch (Exception file) {
                void exc;
                FFDCFilter.processException((Throwable)file, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"328", (Object)this, (Object[])new Object[]{handle});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("An unexpected exception has occured when trying to obtain the exclusive lock " + exc));
                }
                Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)exc);
                if (handle._raf == null) break block21;
                try {
                    handle._raf.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"340", (Object)this, (Object[])new Object[]{handle});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainLock", (Object)new Integer(result));
        }
        return result;
    }

    public void releaseLock(CoordinationLockHandle clh) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseLock", (Object)clh);
        }
        if (clh._fileLock != null) {
            try {
                clh._fileLock.release();
                clh._fileLock = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"368", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (clh._channel != null) {
            try {
                clh._channel.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"379", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (clh._raf != null) {
            try {
                clh._raf.close();
                clh._raf = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"391", (Object)this, (Object[])new Object[]{clh});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseLock");
        }
    }

    /*
     * WARNING - void declaration
     */
    public CoordinationLockHandle ensureFileExists(String lockFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ensureFileExists", (Object)lockFile);
        }
        CoordinationLockHandle clh = null;
        if (RLSUtils.createDirectoryTree(this._lockDirectory)) {
            final File file = new File(this._lockDirectory, lockFile);
            try {
                Configuration.getAccessController().doPrivileged(new PrivilegedExceptionAction(){
                    static final long serialVersionUID = -4329885356556756938L;
                    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                    public Object run() throws Exception {
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"run", (Object)this);
                        }
                        RandomAccessFile raf = new RandomAccessFile(file, "rw");
                        raf.close();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"run");
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$2", 2.class, null, null);
                    }
                });
                if (file.exists()) {
                    clh = new CoordinationLockHandle();
                    clh._fileName = lockFile;
                    clh._directory = this._lockDirectory;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                void exc;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"443", (Object)this, (Object[])new Object[]{lockFile});
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", (String)"418", (Object)this);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock", (String)"447", (Object)this, (Object[])new Object[]{lockFile});
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", (String)"422", (Object)this);
            }
            if (clh != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Lock file exists");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to create the lock file");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to create the lock directory");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ensureFileExists", clh);
        }
        return clh;
    }

    public synchronized void interrupt() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"interrupt");
        }
        this._interrupted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"interrupt");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock", CoordinationLock.class, null, null);
        tc = Tr.register(CoordinationLock.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        RECOVERY_FILE_1_NAME = "log1";
        RECOVERY_FILE_2_NAME = "log2";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class CoordinationLockHandle {
        RandomAccessFile _raf = null;
        FileChannel _channel = null;
        String _fileName = null;
        String _directory = null;
        FileLock _fileLock = null;
        static final long serialVersionUID = 1108483394700969916L;
        private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

        void raf(RandomAccessFile raf) {
            this._raf = raf;
        }

        public String toString() {
            return this._directory + File.separator + this._fileName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.CoordinationLock$CoordinationLockHandle", CoordinationLockHandle.class, null, null);
        }
    }
}

