/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.LogClosedException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HeartbeatLogManager {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private static TimeoutInfo _info;
    static final long serialVersionUID = -5828424141275836991L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void setTimeout(HeartbeatLog heartbeatLog, int peerLockTimeBetweenHeartbeats) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setTimeout", (Object)new Object[]{heartbeatLog, peerLockTimeBetweenHeartbeats});
        }
        HeartbeatLogManager.stopTimeout();
        _info = new TimeoutInfo(heartbeatLog, peerLockTimeBetweenHeartbeats);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"setTimeout", (Object)_info);
        }
    }

    public static void stopTimeout() {
        if (_info != null) {
            _info.cancelAlarm();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.HeartbeatLogManager", HeartbeatLogManager.class, null, null);
        tc = Tr.register(HeartbeatLogManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TimeoutInfo
    implements AlarmListener {
        protected HeartbeatLog _heartbeatLog;
        protected final int _duration;
        private Alarm _alarm;
        private boolean _isHeartbeating = true;
        private final AlarmManager _alarmManager = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager();
        static final long serialVersionUID = 5360803941916714480L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected TimeoutInfo(HeartbeatLog heartbeatLog, int duration) {
            if (tc.isEntryEnabled()) {
                Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"TimeoutInfo", (Object)new Object[]{heartbeatLog, duration});
            }
            this._duration = duration;
            this._heartbeatLog = heartbeatLog;
            if (this._heartbeatLog != null) {
                this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"alarm");
            }
            this._isHeartbeating = true;
            if (this._heartbeatLog != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Update the HADB timestamp");
                }
                try {
                    this._heartbeatLog.heartBeat();
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.HeartbeatLogManager$TimeoutInfo", (String)"91", (Object)this, (Object[])new Object[]{alarmContext});
                    this._isHeartbeating = false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"NULL heartbeatLog");
                }
                this._isHeartbeating = false;
            }
            TimeoutInfo timeoutInfo = this;
            synchronized (timeoutInfo) {
                if (this._heartbeatLog != null && this._isHeartbeating) {
                    this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"alarm");
            }
        }

        public synchronized void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"cancelAlarm", (Object)this._alarm);
            }
            this._isHeartbeating = false;
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"cancelAlarm");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.HeartbeatLogManager$TimeoutInfo", TimeoutInfo.class, null, null);
        }
    }
}

