/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.reactive.messaging.kafka.CommittingPartitionTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PartitionTrackerFactory {
    private KafkaAdapterFactory adapterFactory = null;
    private ScheduledExecutorService executor = null;
    private int commitBatchMaxElements = 500;
    private Duration commitBatchMaxInterval = Duration.ofMillis(500L);
    private boolean autoCommitEnabled = false;
    static final long serialVersionUID = -3191365533363881004L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setAdapterFactory(KafkaAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void setCommitBatchMaxElements(int commitBatchMaxElements) {
        this.commitBatchMaxElements = commitBatchMaxElements;
    }

    public void setCommitBatchMaxInterval(Duration commitBatchMaxInterval) {
        this.commitBatchMaxInterval = commitBatchMaxInterval;
    }

    public void setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
    }

    public PartitionTracker create(KafkaInput<?, ?> kafkaInput, TopicPartition partition, long initialCommittedOffset) {
        if (this.autoCommitEnabled) {
            return new PartitionTracker(partition);
        }
        return new CommittingPartitionTracker(partition, this.adapterFactory, kafkaInput, initialCommittedOffset, this.executor, this.commitBatchMaxElements, this.commitBatchMaxInterval);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTrackerFactory", PartitionTrackerFactory.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    }
}

