/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MPLockedMessageEnumeration;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPILockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JsMessageWrapper;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public final class JSLockedMessageEnumeration
extends AbstractLockedMessageEnumeration
implements MPLockedMessageEnumeration,
AlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(JSLockedMessageEnumeration.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumableKey consumerKey;
    private JSLocalConsumerPoint localConsumerPoint;

    JSLockedMessageEnumeration(JSLocalConsumerPoint localConsumerPoint, ConsumableKey consumerKey, MessageProcessor messageProcessor) {
        super(localConsumerPoint, messageProcessor);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JSLockedMessageEnumeration", (Object)new Object[]{localConsumerPoint, consumerKey, messageProcessor});
        }
        this.localConsumerPoint = localConsumerPoint;
        this.consumerKey = consumerKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JSLockedMessageEnumeration", (Object)this);
        }
    }

    @Override
    void removeMessageFromStore(JsMessageWrapper jsMsgWrapper, TransactionCommon transaction, boolean decrementActiveMessage) throws SIResourceException, SIIncorrectCallException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessageFromStore", (Object)new Object[]{jsMsgWrapper, transaction, decrementActiveMessage});
        }
        try {
            LocalTransaction localTransaction = null;
            SIMPMessage msg = (SIMPMessage)jsMsgWrapper;
            if (transaction == null) {
                if (!msg.isItemReference() && msg.getReportCOD() != null || msg.isRemoteGet()) {
                    localTransaction = this.txManager.createLocalTransaction(true);
                    transaction = localTransaction;
                } else {
                    transaction = this.localConsumerPoint.getAutoCommitTransaction();
                }
            } else if (msg.isRemoteGet() && transaction.isAutoCommit()) {
                localTransaction = this.txManager.createLocalTransaction(true);
                transaction = localTransaction;
            }
            if (!transaction.isAutoCommit()) {
                transaction.registerCallback((TransactionCallback)msg);
            }
            if (decrementActiveMessage && this.localConsumerPoint.isCountingActiveMessages()) {
                transaction.registerCallback((TransactionCallback)this.localConsumerPoint);
            }
            Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction(transaction);
            if (this.localConsumerPoint.getConsumerManager().getDestination().isOrdered()) {
                this.localConsumerPoint.getConsumerManager().setCurrentTransaction((TransactionCommon)msTran, this);
            }
            try {
                msg.remove(msTran, msg.getLockID());
            }
            catch (NotInMessageStore e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:232:1.8.1.10", e});
                SIMPMessageNotLockedException notLockedException = new SIMPMessageNotLockedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:240:1.8.1.10", e}, null), new SIMessageHandle[]{msg.getMessage().getMessageHandle()});
                notLockedException.initCause(e.getCause());
                if (localTransaction != null) {
                    localTransaction.commit();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessageFromStore", (Object)((Object)notLockedException));
                }
                throw notLockedException;
            }
            if (localTransaction != null) {
                localTransaction.commit();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration.removeMessageFromStore", (String)"1:265:1.8.1.10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:272:1.8.1.10", e});
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessageFromStore", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:283:1.8.1.10", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessageFromStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIBusMessage relockSavedMsg() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockSavedMsg", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        JsMessage siBusMsg = null;
        JSLockedMessageEnumeration jSLockedMessageEnumeration = this;
        synchronized (jSLockedMessageEnumeration) {
            SIMPMessage msg;
            boolean failedToGetMessage = false;
            if (this.currentUnlockedMessage != null && (msg = (SIMPMessage)this.currentUnlockedMessage.message) != null) {
                LockingCursor cursor = this.consumerKey.getGetCursor(msg);
                try {
                    if (msg.lockItemIfAvailable(cursor.getLockID())) {
                        msg.eventLocked();
                        siBusMsg = this.currentUnlockedMessage.getJsMessage();
                        this.messageAvailable = true;
                        this.currentUnlockedMessage = null;
                    } else {
                        failedToGetMessage = true;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration.relockSavedMsg", (String)"1:343:1.8.1.10", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    failedToGetMessage = true;
                }
                if (failedToGetMessage) {
                    msg = null;
                    this.removeMessage(this.currentUnlockedMessage);
                    this.currentUnlockedMessage = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockSavedMsg", siBusMsg);
        }
        return siBusMsg;
    }

    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        this.unlockCurrent(false);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCurrent(boolean redeliveryCountUnchanged) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{new Integer(this.hashCode()), this, new Boolean(redeliveryCountUnchanged)});
        }
        this.checkValidState("unlockCurrent");
        this.localConsumerPoint.checkNotClosed();
        SIMPMessageNotLockedException notLockedException = null;
        JSLockedMessageEnumeration jSLockedMessageEnumeration = this;
        synchronized (jSLockedMessageEnumeration) {
            this.checkCurrentMessageAvailable(null);
            if (this.localConsumerPoint.getConsumerManager().getDestination().isOrdered()) {
                this.unlockAll();
            } else if (this.currentMsg != null) {
                this.currentUnlockedMessage = this.currentMsg;
                if (this.currentMsg.isStored) {
                    SIMPMessage msg = (SIMPMessage)this.currentMsg.message;
                    try {
                        if (msg != null) {
                            msg.unlockMsg(msg.getLockID(), null, !redeliveryCountUnchanged);
                        }
                    }
                    catch (NotInMessageStore e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:445:1.8.1.10", e});
                        notLockedException = new SIMPMessageNotLockedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:453:1.8.1.10", e}, null), new SIMessageHandle[]{msg.getMessage().getMessageHandle()});
                        notLockedException.initCause(e.getCause());
                    }
                    catch (MessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration.unlockCurrent", (String)"1:465:1.8.1.10", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:472:1.8.1.10", e});
                        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)((Object)e));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:483:1.8.1.10", e}, null), (Throwable)e);
                    }
                }
            }
            this.localConsumerPoint.removeActiveMessages(1);
            if (notLockedException != null) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
                }
                throw notLockedException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
    }

    @Override
    protected void unlockMessage(JsMessageWrapper jsMsg, boolean bumpRedeliveryCount) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockMessage", (Object)new Object[]{jsMsg, bumpRedeliveryCount});
        }
        try {
            SIMPMessage msg = (SIMPMessage)jsMsg;
            if (msg != null) {
                try {
                    msg.unlockMsg(msg.getLockID(), null, bumpRedeliveryCount);
                }
                catch (NotInMessageStore e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration.unlockMessage", (String)"1:540:1.8.1.10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:547:1.8.1.10", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unlockMessage", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration", "1:558:1.8.1.10", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockMessage", (Object)this);
        }
    }

    @Override
    void handleSessionDroppedException(SISessionDroppedException e) {
    }

    @Override
    boolean isRMQ() {
        return false;
    }
}

