/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionLostException;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPLimitExceededException;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPRollbackException;
import com.ibm.ws.sib.processor.exceptions.SIMPSendAllowedException;
import com.ibm.ws.sib.processor.gd.ExpressTargetStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.GuaranteedTargetStream;
import com.ibm.ws.sib.processor.impl.AbstractInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.exceptions.RMQResourceException;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageProducer;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.List;

public class PtoPInputHandler
extends AbstractInputHandler {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(PtoPInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private final DestinationManager _destinationManager;
    private boolean _isLink = false;
    private String _linkName = null;
    private boolean _flushedForDeleteTarget = false;
    private AlarmListener _deleteFlushTarget = null;
    private JsDestinationAddress _linkBlockingDestination = null;

    public PtoPInputHandler(DestinationHandler destination, TargetProtocolItemStream targetProtocolItemStream) {
        super(destination, targetProtocolItemStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PtoPInputHandler", (Object)new Object[]{destination, targetProtocolItemStream});
        }
        this._destinationManager = this._messageProcessor.getDestinationManager();
        if (destination.isLink() && !destination.isMQLink()) {
            this._isLink = true;
            this._linkName = destination.getName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PtoPInputHandler", (Object)this);
        }
    }

    @Override
    public void handleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid});
        }
        JsDestinationAddress routingAddr = msg.getMessage().getRoutingDestination();
        boolean msgFRP = !msg.getMessage().isForwardRoutingPathEmpty();
        this.internalHandleMessage(msg, transaction, sourceMEUuid, routingAddr, null, msgFRP);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    @Override
    public void handleProducerMessage(MessageItem msg, TransactionCommon transaction, JsDestinationAddress inAddress, MessageProducer sender, boolean msgFRP) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleProducerMessage", (Object)new Object[]{msg, transaction, inAddress, sender, msgFRP});
        }
        this.internalHandleMessage(msg, transaction, this._messageProcessor.getMessagingEngineUuid(), inAddress, sender, msgFRP);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleProducerMessage");
        }
    }

    private void internalHandleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid, JsDestinationAddress inAddress, MessageProducer sender, boolean msgFRP) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalHandleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid, inAddress, sender, msgFRP});
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            this.traceSend(msg);
        }
        boolean lockedDestination = false;
        boolean forcePut = msg.isForcePut();
        super.handleMessage(msg);
        SIBUuid8 localMEUuid = this._messageProcessor.getMessagingEngineUuid();
        msg.setTransacted(!transaction.isAutoCommit());
        if (localMEUuid.equals((Object)sourceMEUuid)) {
            this.updateReverseRoutingPath(msg);
            List<SIDestinationAddress> frp = this.updateForwardRoutingPath(msg);
            boolean isPuttingToForeignBus = this._destination.isForeignBus();
            if (frp != null && !isPuttingToForeignBus) {
                this.handleFRPMessage(msg, transaction, sender, msgFRP);
            } else if (frp == null && this._destination.getDestinationType() == DestinationType.SERVICE) {
                this.handleUndeliverableMessage(this._destination, null, msg, 34, new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, transaction);
            } else {
                JsDestinationAddress inRoutingAddress;
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    msg.setDebugName(this._destination.getName());
                }
                if (msg.isFromRemoteBus() && this._messageProcessor.isBusSecure()) {
                    this.checkInboundAuthorisation(msg.getMessage());
                }
                boolean newSenderRoutingAddr = false;
                JsDestinationAddress routingAddr = null;
                SIBUuid8 fixedME = null;
                boolean fixToME = false;
                if (sender != null && sender.fixedMessagePoint() && !msgFRP && !this._destination.isTargetedAtLink()) {
                    fixToME = true;
                }
                if (inAddress != null) {
                    if (inAddress.getME() == null && inAddress.isLocalOnly() && !this._destination.isTargetedAtLink() && this._destination.hasLocal()) {
                        inAddress.setME(this._messageProcessor.getMessagingEngineUuid());
                    }
                    if (inAddress.getME() != null) {
                        fixedME = inAddress.getME();
                        fixToME = true;
                    }
                }
                if (msg.getMessage().isMediated() && (inRoutingAddress = msg.getMessage().getRoutingDestination()) != null && inRoutingAddress.getME() != null && this._destination.hasLocal()) {
                    fixedME = this._messageProcessor.getMessagingEngineUuid();
                    fixToME = true;
                }
                if (msgFRP || sender == null || !sender.isRoutingDestinationSet()) {
                    routingAddr = this._destination.getRoutingDestinationAddr(inAddress, fixToME);
                    if (fixedME != null) {
                        if (inAddress == null || !routingAddr.equals(inAddress)) {
                            routingAddr = SIMPUtils.createJsDestinationAddress(routingAddr.getDestinationName(), fixedME, routingAddr.getBusName());
                        } else {
                            routingAddr = inAddress;
                            routingAddr.setME(fixedME);
                        }
                    }
                    if (sender != null && !msgFRP) {
                        newSenderRoutingAddr = true;
                    }
                } else if (sender != null && sender.isRoutingDestinationSet() && (routingAddr = sender.getRoutingDestination()) != null && (fixedME = routingAddr.getME()) != null) {
                    fixToME = true;
                }
                try {
                    this.checkHandlerAvailable(fixedME);
                }
                catch (SIMPLimitExceededException e) {
                    if (forcePut) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Forcing msg put despite exception :" + (Object)((Object)e)));
                        }
                    } else {
                        if (!msg.isFromRemoteME()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)"SIMPLimitExceededException");
                            }
                            throw e;
                        }
                        if (msg.isFromRemoteBus()) {
                            if (msg.getReliability().compareTo((Object)Reliability.EXPRESS_NONPERSISTENT) > 0) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Message from remote bus rethrow exception: " + (Object)((Object)e)));
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                    SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)"SIMPLimitExceededException");
                                }
                                throw e;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Message dropped - it was only best effort");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage");
                            }
                            return;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Allowing remote message on to destination :" + (Object)((Object)e)));
                        }
                    }
                }
                catch (SIMPNotPossibleInCurrentConfigurationException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)"SIMPNotPossibleInCurrentConfigurationException");
                    }
                    throw e;
                }
                SIBUuid8 preferredME = null;
                if (msg.preferLocal() && this._destination.hasLocal()) {
                    preferredME = this._messageProcessor.getMessagingEngineUuid();
                }
                if (!msg.isFromRemoteME() && msg.isTransacted() && !msg.isToBeStoredAtSendTime()) {
                    if (fixToME && fixedME == null) {
                        OutputHandler outputHandler = this._destination.choosePtoPOutputHandler(null, preferredME, !msg.isFromRemoteME(), forcePut, null);
                        if (outputHandler == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)"SIMPNoLocalisationsException");
                            }
                            SIMPNoLocalisationsException e = new SIMPNoLocalisationsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_26", new Object[]{this._destination.getName()}, null));
                            e.setExceptionReason(26);
                            e.setExceptionInserts(new String[]{this._destination.getName()});
                            throw e;
                        }
                        if (inAddress == null || !routingAddr.equals(inAddress)) {
                            routingAddr = SIMPUtils.createJsDestinationAddress(routingAddr.getDestinationName(), outputHandler.getTargetMEUuid(), routingAddr.getBusName());
                        } else {
                            routingAddr = inAddress;
                            routingAddr.setME(outputHandler.getTargetMEUuid());
                        }
                    }
                    if (routingAddr != null || msg.getMessage().getRoutingDestination() != null) {
                        msg.getMessage().setRoutingDestination(routingAddr);
                    }
                    if (newSenderRoutingAddr) {
                        sender.setRoutingAddress(routingAddr);
                    }
                    this.registerMessage(msg, transaction);
                } else {
                    if (msg.getReportCOD() != null && this._destination instanceof BaseDestinationHandler) {
                        msg.registerMessageEventListener(11, (BaseDestinationHandler)this._destination);
                    }
                    LockManager reallocationLock = this._destination.getReallocationLockManager();
                    reallocationLock.lock();
                    lockedDestination = true;
                    try {
                        OutputHandler outputHandler = this._destination.choosePtoPOutputHandler(fixedME, preferredME, !msg.isFromRemoteME(), forcePut, null);
                        if (outputHandler == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)"SIMPNoLocalisationsException");
                            }
                            SIMPNoLocalisationsException e = new SIMPNoLocalisationsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_26", new Object[]{this._destination.getName()}, null));
                            e.setExceptionReason(26);
                            e.setExceptionInserts(new String[]{this._destination.getName()});
                            throw e;
                        }
                        if (fixToME && fixedME == null) {
                            if (inAddress == null || !routingAddr.equals(inAddress)) {
                                routingAddr = SIMPUtils.createJsDestinationAddress(routingAddr.getDestinationName(), outputHandler.getTargetMEUuid(), routingAddr.getBusName());
                            } else {
                                routingAddr = inAddress;
                                routingAddr.setME(outputHandler.getTargetMEUuid());
                            }
                        }
                        if (newSenderRoutingAddr) {
                            sender.setRoutingAddress(routingAddr);
                        }
                        if (routingAddr != null || msg.getMessage().getRoutingDestination() != null) {
                            msg.getMessage().setRoutingDestination(routingAddr);
                        }
                        msg.setStreamIsGuess(outputHandler.isWLMGuess());
                        boolean stored = false;
                        outputHandler.put(msg, transaction, null, stored);
                    }
                    catch (SIMPNoLocalisationsException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)((Object)e));
                        }
                        throw e;
                    }
                    catch (SIRollbackException e) {
                        SIMPRollbackException ee = new SIMPRollbackException(e.getMessage());
                        ee.setStackTrace(e.getStackTrace());
                        ee.setExceptionReason(901);
                        ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:804:1.323", SIMPUtils.getStackTrace(e)});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                        }
                        throw ee;
                    }
                    catch (SIConnectionLostException e) {
                        SIMPConnectionLostException ee = new SIMPConnectionLostException(e.getMessage());
                        ee.setStackTrace(e.getStackTrace());
                        ee.setExceptionReason(901);
                        ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:820:1.323", SIMPUtils.getStackTrace(e)});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                        }
                        throw ee;
                    }
                    catch (SIResourceException e) {
                        SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                        ee.setExceptionReason(901);
                        ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:836:1.323", SIMPUtils.getStackTrace(e)});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                        }
                        throw ee;
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.internalHandleMessage", (String)"1:848:1.323", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                        }
                        SIMPErrorException ee = new SIMPErrorException((Throwable)e);
                        ee.setExceptionReason(901);
                        ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:860:1.323", SIMPUtils.getStackTrace(e)});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                        }
                        throw ee;
                    }
                    finally {
                        if (lockedDestination) {
                            reallocationLock.unlock();
                            lockedDestination = false;
                        }
                    }
                }
            }
        } else {
            try {
                this.remoteToLocalPut(msg, sourceMEUuid);
            }
            catch (SIResourceException e) {
                SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:900:1.323", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                }
                throw ee;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage");
        }
    }

    private void updateReverseRoutingPath(MessageItem msg) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateReverseRoutingPath", (Object)new Object[]{this, msg});
        }
        boolean updatedRRP = false;
        JsDestinationAddress replyDest = this._destination.getReplyDestination();
        if (!(replyDest == null || msg.isFromRemoteME() && !msg.isFromRemoteBus() || msg.getMessage().isReverseRoutingPathEmpty())) {
            List replyPath = msg.getMessage().getReverseRoutingPath();
            replyPath.add(0, replyDest);
            msg.getMessage().setReverseRoutingPath(replyPath);
        }
        List rrp = null;
        if (!msg.getMessage().isReverseRoutingPathEmpty()) {
            rrp = msg.getMessage().getReverseRoutingPath();
        }
        if (rrp != null) {
            JsDestinationAddress dest = null;
            for (int i = 0; i < rrp.size(); ++i) {
                dest = (JsDestinationAddress)rrp.get(i);
                if (dest.getBusName() == null) {
                    dest.setBusName(this._messageProcessor.getMessagingEngineBus());
                    updatedRRP = true;
                    rrp.set(i, dest);
                }
                if (dest.getME() != null || !dest.isLocalOnly()) continue;
                try {
                    SIBUuid8 meUuid = null;
                    DestinationHandler reverseDestination = this._destinationManager.getDestination(dest, true);
                    if (reverseDestination != null) {
                        boolean localMessagePoint = false;
                        if (!reverseDestination.isTargetedAtLink() && reverseDestination.hasLocal()) {
                            localMessagePoint = true;
                        }
                        if (localMessagePoint) {
                            meUuid = this._messageProcessor.getMessagingEngineUuid();
                        }
                    }
                    JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
                    JsDestinationAddress newAddr = addressFactory.createJsDestinationAddress(dest.getDestinationName(), false, meUuid, dest.getBusName());
                    rrp.set(i, newAddr);
                    updatedRRP = true;
                    continue;
                }
                catch (SITemporaryDestinationNotFoundException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.debug((TraceComponent)tc, (String)"Destination not found - ignoring localOnly flag");
                }
            }
            if (updatedRRP) {
                msg.getMessage().setReverseRoutingPath(rrp);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateReverseRoutingPath", (Object)new Object[]{updatedRRP, rrp});
        }
    }

    private List<SIDestinationAddress> updateForwardRoutingPath(MessageItem msg) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateForwardRoutingPath", (Object)new Object[]{this, msg});
        }
        List frp = null;
        boolean updatedFRP = false;
        if (!msg.getMessage().isForwardRoutingPathEmpty()) {
            frp = msg.getMessage().getForwardRoutingPath();
        }
        if (frp != null) {
            JsDestinationAddress dest = null;
            for (int i = 0; i < frp.size(); ++i) {
                dest = (JsDestinationAddress)frp.get(i);
                if (dest.getME() != null || !dest.isLocalOnly()) continue;
                try {
                    SIBUuid8 meUuid = null;
                    DestinationHandler frpDestination = this._destinationManager.getDestination(dest, true);
                    boolean localMessagePoint = false;
                    if (!frpDestination.isTargetedAtLink() && frpDestination.hasLocal()) {
                        localMessagePoint = true;
                    }
                    if (localMessagePoint) {
                        meUuid = this._messageProcessor.getMessagingEngineUuid();
                    }
                    JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
                    JsDestinationAddress newAddr = addressFactory.createJsDestinationAddress(dest.getDestinationName(), false, meUuid, dest.getBusName());
                    frp.set(i, newAddr);
                    updatedFRP = true;
                    continue;
                }
                catch (SITemporaryDestinationNotFoundException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.debug((TraceComponent)tc, (String)"Destination not found - ignoring localOnly flag");
                }
            }
            if (updatedFRP) {
                msg.getMessage().setForwardRoutingPath(frp);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateForwardRoutingPath", (Object)new Object[]{updatedFRP, frp});
        }
        return frp;
    }

    private void checkInboundAuthorisation(JsMessage jsMsg) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkInboundAuthorisation", (Object)jsMsg);
        }
        if (!this._destination.isSystem()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Bus is secure prepare for access checks");
            }
            String discriminator = jsMsg.getDiscriminator();
            SecurityContext secContext = null;
            secContext = new SecurityContext(jsMsg, null, discriminator, this._messageProcessor.getAuthorisationUtils());
            this.checkDestinationAccess(this._destination, secContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkInboundAuthorisation");
        }
    }

    protected void remoteToLocalPut(MessageItem msgItem, SIBUuid8 sourceMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToLocalPut", (Object)new Object[]{msgItem, sourceMEUuid});
        }
        this._targetStreamManager.handleMessage(msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToLocalPut");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        if (event == 8) {
            try {
                this.eventPrecommitAdd((MessageItem)msg, tran);
            }
            catch (SIDiscriminatorSyntaxException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)("SIResourceException " + (Object)((Object)e)));
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void eventPrecommitAdd(MessageItem msg, TransactionCommon transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPrecommitAdd", (Object)new Object[]{msg, transaction});
        }
        if (!this._destination.isToBeDeleted()) {
            if (msg.isTransacted() && !msg.isToBeStoredAtSendTime()) {
                LockManager reallocationLock = this._destination.getReallocationLockManager();
                reallocationLock.lock();
                try {
                    OutputHandler handler;
                    SIBUuid8 fixedME = null;
                    JsDestinationAddress routingAddr = msg.getMessage().getRoutingDestination();
                    if (routingAddr != null) {
                        fixedME = routingAddr.getME();
                    }
                    SIBUuid8 preferredME = null;
                    if (msg.preferLocal() && this._destination.hasLocal()) {
                        preferredME = this._messageProcessor.getMessagingEngineUuid();
                    }
                    if ((handler = this._destination.choosePtoPOutputHandler(fixedME, preferredME, !msg.isFromRemoteME(), msg.isForcePut(), null)) == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("No suitable OutputHandler found for " + this._destination.getName() + " (" + fixedME + ")"));
                        }
                        this.handleUndeliverableMessage(this._destination, null, msg, 26, new String[]{this._destination.getName()}, transaction);
                    }
                    msg.setStreamIsGuess(handler.isWLMGuess());
                    handler.put(msg, transaction, null, true);
                }
                finally {
                    reallocationLock.unlock();
                }
            }
        } else {
            UndeliverableReturnCode rc;
            ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = (ExceptionDestinationHandlerImpl)this._messageProcessor.createExceptionDestinationHandler(null);
            msg.setStoreAtSendTime(true);
            String destName = this._destination.getName();
            if (this._destination.isLink()) {
                destName = ((LinkHandler)this._destination).getBusName();
            }
            if ((rc = exceptionDestinationHandlerImpl.handleUndeliverableMessage(msg, transaction, 32, new String[]{destName, this._messageProcessor.getMessagingEngineName()})) != UndeliverableReturnCode.OK && rc != UndeliverableReturnCode.DISCARD) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPrecommitAdd", (Object)"WsRuntimeException");
                }
                throw new WsRuntimeException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP0247", new Object[]{this._destination.getName(), rc}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPrecommitAdd");
        }
    }

    public void sendToME(ControlMessage cMsg, SIBUuid8 sourceMEUuid, SIBUuid8 busUuid, int priority) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToME");
        }
        SIBUuid8 routingMEUuid = null;
        if (this._isLink) {
            cMsg = this.addLinkProps(cMsg, busUuid);
            SIBUuid8 linkRoutingMEUuid = ((LinkHandler)this._destination).getRemoteMEUuid();
            if (linkRoutingMEUuid == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToME", (Object)"Can't get a link to reply on");
                }
                return;
            }
            routingMEUuid = linkRoutingMEUuid;
        } else {
            routingMEUuid = sourceMEUuid;
        }
        this._mpio.sendToMe(routingMEUuid, priority, (AbstractMessage)cMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToME");
        }
    }

    @Override
    public void sendAckMessage(SIBUuid8 sourceMEUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long ackPrefix, int priority, Reliability reliability, SIBUuid12 stream, boolean consolidate) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckMessage", (Object)new Long(ackPrefix));
        }
        ControlAck ackMsg = this.createControlAckMessage();
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)ackMsg, this._messageProcessor.getMessagingEngineUuid(), sourceMEUuid, stream, null, destUuid, ProtocolType.UNICASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        ackMsg.setPriority(priority);
        ackMsg.setReliability(reliability);
        ackMsg.setAckPrefix(ackPrefix);
        this.sendToME((ControlMessage)ackMsg, sourceMEUuid, busUuid, priority + 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckMessage");
        }
    }

    @Override
    public void sendNackMessage(SIBUuid8 sourceMEUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNackMessage", (Object)new Object[]{new Long(startTick), new Long(endTick)});
        }
        ControlNack nackMsg = this.createControlNackMessage();
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)nackMsg, this._messageProcessor.getMessagingEngineUuid(), sourceMEUuid, stream, null, destUuid, ProtocolType.UNICASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        nackMsg.setPriority(priority);
        nackMsg.setReliability(reliability);
        nackMsg.setStartTick(startTick);
        nackMsg.setEndTick(endTick);
        this.sendToME((ControlMessage)nackMsg, sourceMEUuid, busUuid, priority + 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessage ");
        }
    }

    private ControlAck createControlAckMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAckMessage");
        }
        ControlAck ackMsg = null;
        try {
            ackMsg = this._cmf.createNewControlAck();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.createControlAckMessage", (String)"1:1546:1.323", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1558:1.323", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1566:1.323", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage");
        }
        return ackMsg;
    }

    private ControlNack createControlNackMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNackMessage");
        }
        ControlNack nackMsg = null;
        try {
            nackMsg = this._cmf.createNewControlNack();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.createControlNackMessage", (String)"1:1604:1.323", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1616:1.323", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1624:1.323", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage");
        }
        return nackMsg;
    }

    protected ControlAreYouFlushed createControlAreYouFlushed() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAreYouFlushed");
        }
        ControlAreYouFlushed flushedqMsg = null;
        try {
            flushedqMsg = this._cmf.createNewControlAreYouFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.createControlAreYouFlushed", (String)"1:1661:1.323", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1672:1.323", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1680:1.323", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed");
        }
        return flushedqMsg;
    }

    protected ControlRequestFlush createControlRequestFlush() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlRequestFlush");
        }
        ControlRequestFlush rflushMsg = null;
        try {
            rflushMsg = this._cmf.createNewControlRequestFlush();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.createControlRequestFlush", (String)"1:1717:1.323", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1729:1.323", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:1737:1.323", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)rflushMsg);
        }
        return rflushMsg;
    }

    private ControlMessage addLinkProps(ControlMessage msg, SIBUuid8 busUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps");
        }
        msg.setRoutingDestination(null);
        msg.setGuaranteedCrossBusLinkName(this._linkName);
        msg.setGuaranteedCrossBusSourceBusUUID(busUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return msg;
    }

    private DestinationHandler handleFRPMessage(MessageItem msg, TransactionCommon tran, MessageProducer sender, boolean msgFRP) throws SINotAuthorizedException, SIMPNotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleFRPMessage", (Object)new Object[]{msg, tran, sender, msgFRP});
        }
        List frp = msg.getMessage().getForwardRoutingPath();
        JsDestinationAddress head = null;
        DestinationHandler frpDestination = null;
        DestinationHandler previousDestination = this._destination;
        do {
            head = (JsDestinationAddress)frp.get(0);
            String name = head.getDestinationName();
            String busName = head.getBusName();
            try {
                frpDestination = this._messageProcessor.getDestinationManager().getDestination(name, busName, false);
                if (this._messageProcessor.isBusSecure()) {
                    JsMessage jsMsg = msg.getMessage();
                    String discriminator = jsMsg.getDiscriminator();
                    SecurityContext secContext = new SecurityContext(jsMsg, null, discriminator, this._messageProcessor.getAuthorisationUtils());
                    this.checkDestinationAccess(frpDestination, secContext);
                }
                previousDestination = frpDestination;
                frp.remove(0);
            }
            catch (SIException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                if (e instanceof SINotAuthorizedException) {
                    SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{name, msg.getMessage().getSecurityUserid()}, null));
                    SIMPNotAuthorizedException ex = new SIMPNotAuthorizedException(e.getMessage());
                    ex.setExceptionReason(20);
                    ex.setExceptionInserts(new String[]{name, msg.getMessage().getSecurityUserid()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleFRPMessage", (Object)ex);
                    }
                    throw ex;
                }
                ExceptionDestinationHandlerImpl excDest = new ExceptionDestinationHandlerImpl(previousDestination);
                UndeliverableReturnCode rc = excDest.handleUndeliverableMessage(msg, tran, 37, new String[]{name, this._messageProcessor.getMessagingEngineName(), previousDestination.getName(), SIMPUtils.getStackTrace(e)});
                if (rc == UndeliverableReturnCode.ERROR || rc == UndeliverableReturnCode.BLOCK) {
                    SIMPNotPossibleInCurrentConfigurationException ee = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_23", new Object[]{name, rc, SIMPUtils.getStackTrace(e), this._destination.getName()}, null), (Throwable)e);
                    ee.setExceptionReason(23);
                    ee.setExceptionInserts(new String[]{name, rc.toString(), SIMPUtils.getStackTrace(e), this._destination.getName()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleFRPMessage", (Object)((Object)ee));
                    }
                    throw ee;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleFRPMessage");
                }
                return null;
            }
        } while (!previousDestination.isPubSub() && !frp.isEmpty() && !previousDestination.isForeign() && !previousDestination.isForeignBus());
        msg.getMessage().setForwardRoutingPath(frp);
        ProducerInputHandler handler = null;
        if (frpDestination != null) {
            ProtocolType type = ProtocolType.UNICASTINPUT;
            if (frpDestination.isPubSub()) {
                type = ProtocolType.PUBSUBINPUT;
            }
            handler = (ProducerInputHandler)frpDestination.getInputHandler(type, this._messageProcessor.getMessagingEngineUuid(), null);
        }
        if (handler != null) {
            try {
                JsMessage jsMsg = msg.getMessage();
                JsDestinationAddress outAddress = head;
                jsMsg.setRedeliveredCount(0);
                if (frpDestination.isAlias() || frpDestination.isForeign() || frpDestination.isForeignBus()) {
                    ProducerSessionImpl.setRFH2Allowed(jsMsg, frpDestination);
                }
                msg.incrementRedirectCount();
                if (msg.getRedirectCount() > this._messageProcessor.getCustomProperties().get_max_frp_depth()) {
                    SibTr.register(PtoPInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.websphere.sib.CWSIKMessages");
                    SibTr.error((TraceComponent)tc, (String)"DELIVERY_ERROR_SIRC_43", (Object)new Integer(msg.getRedirectCount()));
                    SibTr.register(PtoPInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
                    this.handleUndeliverableMessage(frpDestination, null, msg, 43, new String[]{frpDestination.getName()}, tran);
                } else {
                    handler.handleProducerMessage(msg, tran, outAddress, null, msgFRP);
                }
            }
            catch (SIMPNoLocalisationsException e) {
                this.handleUndeliverableMessage(frpDestination, null, msg, 26, new String[]{frpDestination.getName()}, tran);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.handleFRPMessage", (String)"1:2072:1.323", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"FRP message being put to exception destination", (Object)new Object[]{msg, e});
                }
                this.handleUndeliverableMessage(frpDestination, null, msg, 1, new String[]{frpDestination.getName()}, tran);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleFRPMessage");
        }
        return frpDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void deliverOrderedMessages(List msgList, GuaranteedTargetStream targetStream, int priority, Reliability reliability) throws SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)new Object[]{msgList, targetStream, new Integer(priority), reliability});
        }
        failingException /* !! */  = null;
        failingDestination = null;
        tran = this._targetBatchHandler.registerInBatch();
        messageAddCall = false;
        try {
            msgItem = null;
            msgItem = (MessageItem)msgList.get(msgList.size() - 1);
            endTick = msgItem.getMessage().getGuaranteedValueEndTick();
            if (targetStream.getDoubtHorizon() > endTick) {
                lastSuccessfulMsg = -1;
                lastSuccessfulEndTick = -1L;
                currentEndTick = -1L;
                for (i = 0; i < msgList.size(); ++i) {
                    resetRequired = true;
                    try {
                        msgItem = (MessageItem)msgList.get(i);
                        currentEndTick = msgItem.getMessage().getGuaranteedValueEndTick();
                        routingDestinationAddr = msgItem.getMessage().getRoutingDestination();
                        deletedTargetDestination = null;
                        sendToSystemExceptionDestination = false;
                        if (routingDestinationAddr != null) {
                            routingDestination = null;
                            linkHandler = this._isLink != false ? (LinkHandler)this._destination : null;
                            try {
                                if (this._isLink) {
                                    linkInboundUserid = ((LinkHandler)this._destination).getInboundUserid();
                                    if (linkInboundUserid != null) {
                                        if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)("Set link inbound userid: " + linkInboundUserid + ", into message"));
                                        }
                                        this._messageProcessor.getAccessChecker().setSecurityIDInMessage(linkInboundUserid, msgItem.getMessage());
                                    }
                                    msgItem.getMessage().setGuaranteedCrossBusLinkName(null);
                                    msgItem.getMessage().setGuaranteedCrossBusSourceBusUUID(null);
                                }
                                routingDestination = this._destinationManager.getDestination(routingDestinationAddr, this._isLink == false, true);
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)("Routing dest to " + routingDestination));
                                }
                                if (this._isLink) {
                                    msgItem.setPreferLocal(linkHandler.preferLocalTargetQueuePoint());
                                } else {
                                    msgItem.setPreferLocal(true);
                                }
                                if (this._isLink || !routingDestination.isToBeDeleted()) {
                                    inputHandler = (ProducerInputHandler)routingDestination.getInputHandler(ProtocolType.UNICASTINPUT, null, msgItem.getMessage());
                                    inputHandler.handleMessage(msgItem, tran, this._messageProcessor.getMessagingEngineUuid());
                                }
                                deletedTargetDestination = routingDestination.getName();
                                v0 = sendToSystemExceptionDestination = this._messageProcessor.discardMsgsAfterQueueDeletion() == false;
                                if (!TraceComponent.isAnyTracingEnabled() || !PtoPInputHandler.tc.isDebugEnabled()) ** GOTO lbl140
                                SibTr.debug((Object)this, (TraceComponent)PtoPInputHandler.tc, (String)("Message received from within bus for a deleted routing destination " + routingDestination + (sendToSystemExceptionDestination != false ? ". Exceptioning message" : ". Discarding message")));
                            }
                            catch (SITemporaryDestinationNotFoundException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !PtoPInputHandler.tc.isDebugEnabled()) ** GOTO lbl140
                                SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Discarding the message as Temporary destination not found");
                            }
                            catch (SIMPNoLocalisationsException e) {
                                failingException /* !! */  = e;
                                failingDestination = routingDestinationAddr;
                                this.handleUndeliverableMessage(routingDestination, linkHandler, msgItem, 26, new String[]{routingDestination.getName()}, tran);
                            }
                            catch (SIMPLimitExceededException e) {
                                failingException /* !! */  = e;
                                failingDestination = routingDestinationAddr;
                                this.handleUndeliverableMessage(null, linkHandler, msgItem, e.getExceptionReason(), e.getExceptionInserts(), tran);
                            }
                            catch (SIMPSendAllowedException e) {
                                if (this._isLink) {
                                    if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Putting message to exception destination as destination was send-disallowed");
                                        SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                    }
                                    failingException /* !! */  = e;
                                    failingDestination = routingDestinationAddr;
                                    this.handleUndeliverableMessage(routingDestination, linkHandler, msgItem, e.getExceptionReason(), e.getExceptionInserts(), tran);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Failing the message to keep retrying until the queue point becomes send-allowed");
                                }
                                SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                throw e;
                            }
                            catch (SINotPossibleInCurrentConfigurationException e) {
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Putting message to exception destination as destination not found");
                                    SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                }
                                failingException /* !! */  = e;
                                failingDestination = routingDestinationAddr;
                                this.handleUndeliverableMessage(routingDestination, linkHandler, msgItem, e.getExceptionReason(), e.getExceptionInserts(), tran);
                            }
                            catch (RMQResourceException e) {
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Putting message to exception destination as RMQ destination was not available");
                                    SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                }
                                failingException /* !! */  = e;
                                failingDestination = routingDestinationAddr;
                                this.handleUndeliverableMessage(routingDestination, linkHandler, msgItem, e.getExceptionReason(), e.getExceptionInserts(), tran);
                            }
                            catch (SIResourceException e) {
                                if (this._isLink) {
                                    if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Putting message to link exception destination");
                                        SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                    }
                                    failingException /* !! */  = e;
                                    failingDestination = routingDestinationAddr;
                                    this.handleUndeliverableMessage(null, linkHandler, msgItem, 26, new String[]{routingDestination.getName()}, tran);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)PtoPInputHandler.tc, (String)"Failing the message after Resource exception");
                                }
                                SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                throw e;
                            }
                        } else if (!this._isLink) {
                            try {
                                if (!this._destination.isToBeDeleted()) {
                                    inputHandler /* !! */  = null;
                                    inputHandler /* !! */  = this._destination.isPubSub() != false ? this._destination.getInputHandler() : this;
                                    inputHandler /* !! */ .handleMessage(msgItem, tran, this._messageProcessor.getMessagingEngineUuid());
                                }
                                deletedTargetDestination = this._destination.getName();
                                v1 = sendToSystemExceptionDestination = this._messageProcessor.discardMsgsAfterQueueDeletion() == false;
                                if (!TraceComponent.isAnyTracingEnabled() || !PtoPInputHandler.tc.isDebugEnabled()) ** GOTO lbl140
                                SibTr.debug((Object)this, (TraceComponent)PtoPInputHandler.tc, (String)("Message received from within bus for a deleted destination. " + (sendToSystemExceptionDestination != false ? "Exceptioning message" : "Discarding message")));
                            }
                            catch (SIMPNoLocalisationsException e) {
                                this.handleUndeliverableMessage(this._destination, null, msgItem, 26, new String[]{this._destination.getName()}, tran);
                            }
                            catch (SIMPSendAllowedException e) {
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEventEnabled()) {
                                    SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)e);
                                }
                                throw e;
                            }
                            catch (SIMPNotPossibleInCurrentConfigurationException e) {
                                this.handleUndeliverableMessage(this._destination, null, msgItem, 26, new String[]{this._destination.getName()}, tran);
                            }
                        } else {
                            e = new SIErrorException(PtoPInputHandler.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:2561:1.323"}, null));
                            failingException /* !! */  = e;
                            failingDestination = null;
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.deliverOrderedMessages", (String)"1:2570:1.323", (Object)this);
                            SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                            if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)e);
                            }
                            throw e;
                        }
lbl140:
                        // 16 sources

                        if (sendToSystemExceptionDestination && (rc = (exceptionDestinationHandlerImpl = (ExceptionDestinationHandlerImpl)this._messageProcessor.createExceptionDestinationHandler(null)).handleUndeliverableMessage(msgItem, tran, 32, new String[]{deletedTargetDestination, this._messageProcessor.getMessagingEngineName()})) != UndeliverableReturnCode.OK && rc != UndeliverableReturnCode.DISCARD) {
                            if (rc == UndeliverableReturnCode.BLOCK) {
                                e = new SIResourceException(PtoPInputHandler.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:2605:1.323", rc}, null));
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.deliverOrderedMessages", (String)"1:2608:1.323", (Object)this);
                                SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                                if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)e);
                                }
                                throw e;
                            }
                            e = new SIErrorException(PtoPInputHandler.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:2623:1.323", rc}, null));
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.deliverOrderedMessages", (String)"1:2626:1.323", (Object)this);
                            SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                            if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)e);
                            }
                            throw e;
                        }
                        lastSuccessfulMsg = i;
                        lastSuccessfulEndTick = currentEndTick;
                        resetRequired = false;
                        if (!resetRequired) continue;
                        targetStream.resetDoubtHorizon(currentEndTick, (Exception)failingException /* !! */ , failingDestination);
                        continue;
                    }
                    catch (SIResourceException e) {
                        targetStream.resetDoubtHorizon(currentEndTick, (Exception)failingException /* !! */ , failingDestination);
                        resetRequired = false;
                        break;
                    }
                    finally {
                        if (resetRequired) {
                            targetStream.resetDoubtHorizon(currentEndTick, (Exception)failingException /* !! */ , failingDestination);
                        }
                    }
                }
                if (lastSuccessfulMsg != -1) {
                    messageAddCall = true;
                    targetStream.setNextCompletedPrefix(lastSuccessfulEndTick);
                    try {
                        this._targetBatchHandler.messagesAdded(lastSuccessfulMsg + 1, targetStream);
                    }
                    catch (SIResourceException e) {
                        if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                        }
                    }
                }
            }
        }
        finally {
            block62: {
                if (!messageAddCall) {
                    try {
                        this._targetBatchHandler.messagesAdded(0);
                    }
                    catch (SIResourceException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !PtoPInputHandler.tc.isEventEnabled()) break block62;
                        SibTr.exception((TraceComponent)PtoPInputHandler.tc, (Exception)e);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && PtoPInputHandler.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)PtoPInputHandler.tc, (String)"deliverOrderedMessages", (Object)new Boolean(messageAddCall));
            }
        }
    }

    @Override
    public void deliverExpressMessage(MessageItem msgItem, ExpressTargetStream expressTargetStream) throws SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deliverExpressMessage", (Object)new Object[]{msgItem});
        }
        LocalTransaction siTran = this._txManager.createLocalTransaction(false);
        try {
            long endTick = msgItem.getMessage().getGuaranteedValueValueTick();
            JsDestinationAddress routingDestinationAddr = msgItem.getMessage().getRoutingDestination();
            if (routingDestinationAddr != null) {
                DestinationHandler routingDestination = null;
                try {
                    routingDestination = this._destinationManager.getDestination(routingDestinationAddr, false, true);
                    if (this._isLink) {
                        LinkHandler link = (LinkHandler)this._destination;
                        msgItem.setPreferLocal(link.preferLocalTargetQueuePoint());
                        String linkInboundUserid = ((LinkHandler)this._destination).getInboundUserid();
                        if (linkInboundUserid != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Set link inbound userid: " + linkInboundUserid + ", into message"));
                            }
                            this._messageProcessor.getAccessChecker().setSecurityIDInMessage(linkInboundUserid, msgItem.getMessage());
                        }
                    } else {
                        msgItem.setPreferLocal(true);
                    }
                    ProducerInputHandler inputHandler = (ProducerInputHandler)routingDestination.getInputHandler();
                    inputHandler.handleMessage(msgItem, (TransactionCommon)siTran, this._messageProcessor.getMessagingEngineUuid());
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.debug((TraceComponent)tc, (String)"Discarding the express message as it could not be from the targetStreamManager");
                    }
                }
            } else {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)this._destination.getLocalPtoPConsumerManager();
                consumerDispatcher.put(msgItem, (TransactionCommon)siTran, null, false);
            }
            expressTargetStream.setCompletedPrefix(endTick);
            siTran.commit();
        }
        catch (SIIncorrectCallException e) {
            this.handleRollback(siTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)e));
            }
            throw e;
        }
        catch (SIResourceException e) {
            this.handleRollback(siTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.deliverExpressMessage", (String)"1:2840:1.323", (Object)this);
            this.handleRollback(siTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage");
        }
    }

    @Override
    public void sendAreYouFlushedMessage(SIBUuid8 sourceMEUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)new Object[]{new Long(queryID), streamID});
        }
        ControlAreYouFlushed flushQuery = this.createControlAreYouFlushed();
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushQuery, this._messageProcessor.getMessagingEngineUuid(), sourceMEUuid, streamID, null, destUuid, ProtocolType.UNICASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        flushQuery.setPriority(11);
        flushQuery.setReliability(Reliability.ASSURED_PERSISTENT);
        flushQuery.setRequestID(queryID);
        this.sendToME((ControlMessage)flushQuery, sourceMEUuid, busUuid, 9);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushedMessage");
        }
    }

    @Override
    public void sendRequestFlushMessage(SIBUuid8 sourceMEUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID, boolean indoubtDiscard) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)new Object[]{new Long(queryID), streamID});
        }
        ControlRequestFlush flushRequest = this.createControlRequestFlush();
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushRequest, this._messageProcessor.getMessagingEngineUuid(), sourceMEUuid, streamID, null, destUuid, ProtocolType.UNICASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        flushRequest.setPriority(11);
        flushRequest.setReliability(Reliability.ASSURED_PERSISTENT);
        flushRequest.setRequestID(queryID);
        flushRequest.setIndoubtDiscard(indoubtDiscard);
        this.sendToME((ControlMessage)flushRequest, sourceMEUuid, busUuid, 9);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlushMessage");
        }
    }

    private void checkHandlerAvailable(SIBUuid8 fixedMEUuid) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIMPLimitExceededException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkHandlerAvailable", (Object)new Object[]{this, fixedMEUuid});
        }
        int reason = this._destination.checkPtoPOutputHandlers(fixedMEUuid, null);
        switch (reason) {
            case 1: {
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkHandlerAvailable", (Object)"Destination send disallowed");
                }
                SIMPSendAllowedException e = new SIMPSendAllowedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_24", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(24);
                e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
            case 3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkHandlerAvailable", (Object)"Destination reached high limit");
                }
                long destHighMsg = this._destination.getQHighMsgDepth();
                SibTr.info((TraceComponent)tc, (String)"NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0553", (Object)new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName(), destHighMsg});
                SIMPLimitExceededException e = new SIMPLimitExceededException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_25", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(25);
                e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
            case 0: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkHandlerAvailable", (Object)"SIMPNoLocalisationsException");
                }
                SIMPNoLocalisationsException e = new SIMPNoLocalisationsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_26", new Object[]{this._destination.getName()}, null));
                e.setExceptionReason(26);
                e.setExceptionInserts(new String[]{this._destination.getName()});
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkHandlerAvailable");
        }
    }

    private void handleUndeliverableMessage(DestinationHandler destinationHandler, LinkHandler linkHandler, SIMPMessage msg, int exceptionReason, String[] exceptionInserts, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{destinationHandler, linkHandler, msg, new Integer(exceptionReason), exceptionInserts, tran});
        }
        ExceptionDestinationHandlerImpl destExceptionDestination = null;
        ExceptionDestinationHandlerImpl linkExceptionDestination = null;
        if (destinationHandler == null) {
            if (linkHandler == null) {
                destExceptionDestination = new ExceptionDestinationHandlerImpl(null, this._messageProcessor);
            }
        } else {
            destExceptionDestination = new ExceptionDestinationHandlerImpl(destinationHandler);
        }
        UndeliverableReturnCode rc = UndeliverableReturnCode.OK;
        if (destExceptionDestination != null) {
            rc = destExceptionDestination.handleUndeliverableMessage(msg, tran, exceptionReason, exceptionInserts);
        }
        if ((destExceptionDestination == null || rc == UndeliverableReturnCode.BLOCK) && linkHandler != null) {
            linkExceptionDestination = new ExceptionDestinationHandlerImpl(linkHandler);
            rc = linkExceptionDestination.handleUndeliverableMessage(msg, tran, exceptionReason, exceptionInserts);
        }
        if (rc == UndeliverableReturnCode.BLOCK) {
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:3103:1.323", rc}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)((Object)e));
            }
            throw e;
        }
        if (rc == UndeliverableReturnCode.ERROR) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPInputHandler", "1:3124:1.323", rc}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.handleUndeliverableMessage", (String)"1:3131:1.323", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage");
        }
    }

    private int checkCanExceptionMessage(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkCanExceptionMessage", (Object)new Object[]{destinationHandler});
        }
        ExceptionDestinationHandlerImpl exceptionDestinationHandler = null;
        exceptionDestinationHandler = new ExceptionDestinationHandlerImpl(destinationHandler);
        int returnValue = exceptionDestinationHandler.checkCanExceptionMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkCanExceptionMessage", (Object)returnValue);
        }
        return returnValue;
    }

    private void checkDestinationAccess(DestinationHandler destination, SecurityContext secContext) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{destination, secContext});
        }
        if (!destination.checkDestinationAccess(secContext, OperationType.SEND)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this destination");
            }
            String userName = secContext.getUserName(true);
            String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{destination.getName(), userName}, null);
            this._messageProcessor.getAccessChecker().fireDestinationAccessNotAuthorizedEvent(destination.getName(), userName, OperationType.SEND, nlsMessage);
            SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nlsMessage);
            e.setExceptionReason(18);
            e.setExceptionInserts(new String[]{destination.getName(), secContext.getUserName(true)});
            throw e;
        }
        if (!destination.checkDiscriminatorAccess(secContext, OperationType.SEND)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this discriminator");
            }
            SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(true)}, null));
            SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(true)}, null));
            e.setExceptionReason(20);
            e.setExceptionInserts(new String[]{destination.getName(), secContext.getDiscriminator(), secContext.getUserName(true)});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess");
        }
    }

    private void traceSend(MessageItem message) {
        if (message.getMessage().isApiMessage()) {
            String text = null;
            text = "PRODUCER_SEND_CWSJU0054";
            String apiMsgId = null;
            String correlationId = null;
            if (message.getMessage() instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)message.getMessage()).getApiMessageId();
                correlationId = ((JsApiMessage)message.getMessage()).getCorrelationId();
            } else {
                if (message.getMessage().getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(message.getMessage().getApiMessageIdAsBytes());
                }
                if (message.getMessage().getCorrelationIdAsBytes() != null) {
                    correlationId = new String(message.getMessage().getCorrelationIdAsBytes());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(text, new Object[]{apiMsgId, message.getMessage().getSystemMessageId(), correlationId, this._destination.getName()}, null));
            }
        }
    }

    @Override
    public String toString() {
        return "PtoPInputHandler to Destination " + this._destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDelete() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDelete");
        }
        PtoPInputHandler ptoPInputHandler = this;
        synchronized (ptoPInputHandler) {
            if (this._flushedForDeleteTarget) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)new Boolean(true));
                }
                return true;
            }
            if (this._deleteFlushTarget != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)new Boolean(false));
                }
                return false;
            }
            if (this._targetStreamManager.isEmpty()) {
                this._flushedForDeleteTarget = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)new Boolean(true));
                }
                return true;
            }
            this._deleteFlushTarget = new AlarmListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void alarm(Object al) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)al);
                    }
                    PtoPInputHandler ptIH = (PtoPInputHandler)al;
                    if (ptIH._targetStreamManager.isEmpty()) {
                        PtoPInputHandler ptoPInputHandler = ptIH;
                        synchronized (ptoPInputHandler) {
                            ptIH._flushedForDeleteTarget = true;
                            ptIH._deleteFlushTarget = null;
                        }
                        ptIH._messageProcessor.getDestinationManager().startAsynchDeletion();
                    } else {
                        block10: {
                            try {
                                ptIH._targetStreamManager.queryUnflushedStreams();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    SibTr.event((TraceComponent)tc, (String)("Querying target for PtoP flush on destination: " + PtoPInputHandler.this._destination.getName()));
                                }
                                ptIH._messageProcessor.getAlarmManager().create(3000L, this, ptIH);
                            }
                            catch (SIResourceException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.alarm", (String)"1:3423:1.323", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                                SibTr.event((TraceComponent)tc, (String)"Target flushed cancelled by SIResourceException");
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"alarm");
                        }
                    }
                }
            };
            this._targetStreamManager.queryUnflushedStreams();
            this._messageProcessor.getAlarmManager().create(3000L, this._deleteFlushTarget, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)new Boolean(false));
        }
        return false;
    }

    @Override
    public int checkAbleToAcceptMessage(JsDestinationAddress routingDestinationAddr) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkAbleToAcceptMessage", (Object)routingDestinationAddr);
        }
        int blockingReason = 1;
        if (this._isLink) {
            blockingReason = 0;
            if (routingDestinationAddr != null) {
                String destName = routingDestinationAddr.getDestinationName();
                if (destName.startsWith("_Q") || destName.startsWith("_T") || destName.startsWith("_P")) {
                    blockingReason = 1;
                } else {
                    boolean checkedTarget;
                    block15: {
                        checkedTarget = false;
                        try {
                            blockingReason = this.checkTargetAbleToAcceptOrExceptionMessage(routingDestinationAddr);
                            checkedTarget = true;
                        }
                        catch (SIMPNotPossibleInCurrentConfigurationException e) {
                            checkedTarget = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                        }
                        catch (SIException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.checkAbleToAcceptMessage", (String)"1:3527:1.323", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                    if (blockingReason != 1) {
                        int linkBlockingReason = this.checkLinkAbleToExceptionMessage();
                        if (linkBlockingReason == 1) {
                            blockingReason = 1;
                        } else if (!checkedTarget) {
                            blockingReason = linkBlockingReason;
                        }
                    }
                    if (blockingReason != 1) {
                        this._linkBlockingDestination = routingDestinationAddr;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAbleToAcceptMessage", (Object)blockingReason);
        }
        return blockingReason;
    }

    private int checkTargetAbleToAcceptOrExceptionMessage(JsDestinationAddress targetDestinationAddr) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        int linkBlockingReason;
        SIBUuid8 targetDestinationMEUuid;
        DestinationHandler targetDestination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkTargetAbleToAcceptOrExceptionMessage", (Object)targetDestinationAddr);
        }
        int blockingReason = 0;
        if (targetDestinationAddr != null && (blockingReason = (targetDestination = this._messageProcessor.getDestinationManager().getDestination(targetDestinationAddr, false)).checkCanAcceptMessage(targetDestinationMEUuid = targetDestinationAddr.getME(), null)) != 1 && (linkBlockingReason = this.checkCanExceptionMessage(targetDestination)) == 1) {
            blockingReason = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkTargetAbleToAcceptOrExceptionMessage", (Object)blockingReason);
        }
        return blockingReason;
    }

    private int checkLinkAbleToExceptionMessage() throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkLinkAbleToExceptionMessage");
        }
        int blockingReason = 0;
        blockingReason = this.checkCanExceptionMessage(this._destination);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkLinkAbleToExceptionMessage", (Object)blockingReason);
        }
        return blockingReason;
    }

    @Override
    public int checkStillBlocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStillBlocked");
        }
        int blockingReason = 0;
        if (!this._isLink) {
            blockingReason = 1;
        } else {
            boolean checkedTarget = false;
            try {
                blockingReason = this.checkTargetAbleToAcceptOrExceptionMessage(this._linkBlockingDestination);
                checkedTarget = true;
            }
            catch (SIMPNotPossibleInCurrentConfigurationException e) {
                checkedTarget = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.checkStillBlocked", (String)"1:3720:1.323", (Object)this);
            }
            try {
                if (blockingReason != 1) {
                    int linkBlockingReason = this.checkLinkAbleToExceptionMessage();
                    if (linkBlockingReason == 1) {
                        blockingReason = 1;
                    } else if (!checkedTarget) {
                        blockingReason = linkBlockingReason;
                    }
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPInputHandler.checkStillBlocked", (String)"1:3745:1.323", (Object)this);
            }
            if (blockingReason == 1) {
                this._linkBlockingDestination = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStillBlocked", (Object)new Integer(blockingReason));
        }
        return blockingReason;
    }

    @Override
    public void reportUnresolvedGap(String sourceMEUuid, long gap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportUnresolvedGap", (Object)new Object[]{sourceMEUuid, new Long(gap)});
        }
        if (this._isLink) {
            SibTr.info((TraceComponent)tc, (String)"UNRESOLVED_GAP_IN_LINK_TRANSMITTER_CWSIP0790", (Object)new Object[]{new Long(gap).toString(), ((LinkHandler)this._destination).getBusName(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
        } else {
            SibTr.info((TraceComponent)tc, (String)"UNRESOLVED_GAP_IN_DESTINATION_TRANSMITTER_CWSIP0792", (Object)new Object[]{new Long(gap).toString(), this._destination.getName(), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportUnresolvedGap");
        }
    }

    @Override
    public void reportResolvedGap(String sourceMEUuid, long filledGap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportResolvedGap", (Object)new Object[]{sourceMEUuid, new Long(filledGap)});
        }
        if (this._isLink) {
            SibTr.info((TraceComponent)tc, (String)"RESOLVED_GAP_IN_LINK_TRANSMITTER_CWSIP0791", (Object)new Object[]{new Long(filledGap).toString(), ((LinkHandler)this._destination).getBusName(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
        } else {
            SibTr.info((TraceComponent)tc, (String)"RESOLVED_GAP_IN_DESTINATION_TRANSMITTER_CWSIP0793", (Object)new Object[]{new Long(filledGap).toString(), this._destination.getName(), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportResolvedGap");
        }
    }

    @Override
    public void reportRepeatedMessages(String sourceMEUuid, int percent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportRepeatedMessages", (Object)new Object[]{sourceMEUuid, new Integer(percent)});
        }
        if (this._isLink) {
            SibTr.info((TraceComponent)tc, (String)"REPEATED_MESSAGE_THRESHOLD_REACHED_ON_LINK_CWSIP0794", (Object)new Object[]{new Integer(percent), ((LinkHandler)this._destination).getBusName(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
        } else {
            SibTr.info((TraceComponent)tc, (String)"REPEATED_MESSAGE_THRESHOLD_REACHED_ON_DESTINATION_CWSIP0795", (Object)new Object[]{new Integer(percent), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName(), this._destination.getName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportRepeatedMessages");
        }
    }

    @Override
    public long sendNackMessageWithReturnValue(SIBUuid8 source, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 streamID) throws SIResourceException {
        return 0L;
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }
}

