/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class SQLHADBRetry {
    private static final TraceComponent tc = Tr.register(SQLHADBRetry.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private Throwable _nonTransientException = null;

    public boolean retryAndReport(SQLMultiScopeRecoveryLog recoveryLog, DataSource dataSource, String serverName, SQLException currentSqlEx, boolean batchSQLOperation, int transientRetryAttempts, int transientRetrySleepTime, boolean sqlTransientErrorHandlingEnabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryAndReport ", (Object)new Object[]{recoveryLog, dataSource, serverName, currentSqlEx, batchSQLOperation, transientRetryAttempts, transientRetrySleepTime, sqlTransientErrorHandlingEnabled});
        }
        boolean failAndReport = true;
        if (currentSqlEx != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set the exception that will be reported: " + currentSqlEx + " error handling variable: " + sqlTransientErrorHandlingEnabled));
            }
            this._nonTransientException = currentSqlEx;
            if (sqlTransientErrorHandlingEnabled) {
                failAndReport = this.retryAfterSQLException(recoveryLog, dataSource, currentSqlEx, batchSQLOperation, transientRetryAttempts, transientRetrySleepTime);
            }
        }
        if (failAndReport) {
            Tr.debug((TraceComponent)tc, (String)("Cannot recover from SQLException when " + this.getOperationDescription() + " for server " + serverName + " Exception: " + this._nonTransientException));
        } else {
            Tr.debug((TraceComponent)tc, (String)("Have recovered from SQLException when " + this.getOperationDescription() + " server " + serverName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryAndReport", (Object)(!failAndReport ? 1 : 0));
        }
        return !failAndReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryAfterSQLException(SQLMultiScopeRecoveryLog recoveryLog, DataSource dataSource, SQLException sqlex, boolean batchSQLOperation, int transientRetryAttempts, int transientRetrySleepTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryAfterSQLException ", (Object)new Object[]{recoveryLog, dataSource, sqlex, batchSQLOperation, transientRetryAttempts, transientRetrySleepTime});
        }
        boolean shouldRetry = true;
        boolean failAndReport = false;
        int operationRetries = 0;
        int initialIsolation = 0;
        Connection conn = null;
        while (shouldRetry && !failAndReport) {
            if (operationRetries < transientRetryAttempts) {
                if (batchSQLOperation) {
                    initialIsolation = 4;
                }
                shouldRetry = recoveryLog.isSQLErrorTransient(sqlex);
                ++operationRetries;
                if (shouldRetry) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + dataSource + ", attempt number: " + operationRetries));
                    }
                    if (dataSource != null) {
                        try {
                            conn = dataSource.getConnection();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Acquired connection in Database retry scenario");
                            }
                            if (batchSQLOperation) {
                                initialIsolation = recoveryLog.prepareConnectionForBatch(conn);
                            }
                            this.retryCode(conn);
                            if (batchSQLOperation) {
                                conn.commit();
                            }
                            shouldRetry = false;
                            continue;
                        }
                        catch (SQLException sqlex2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("reset the sqlex to " + sqlex2));
                            }
                            sqlex = sqlex2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("sleeping for " + transientRetrySleepTime + " millisecs"));
                            }
                            try {
                                Thread.sleep(transientRetrySleepTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        catch (Throwable exc) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Failed got exception: " + exc));
                            }
                            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)(" " + ste));
                            }
                            failAndReport = true;
                            this._nonTransientException = exc;
                            continue;
                        }
                        finally {
                            if (conn != null) {
                                block44: {
                                    if (!batchSQLOperation) continue;
                                    if (shouldRetry) {
                                        try {
                                            conn.rollback();
                                        }
                                        catch (Throwable exc) {
                                            if (!tc.isDebugEnabled()) break block44;
                                            Tr.debug((TraceComponent)tc, (String)("Rollback Failed, when handling SQLException, got exception: " + exc));
                                        }
                                    }
                                }
                                try {
                                    recoveryLog.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("Close Failed, when handling SQLException, got exception: " + exc));
                                }
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"Connection was NULL");
                            continue;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"NULL DataSource reference");
                    }
                    failAndReport = true;
                    continue;
                }
                failAndReport = true;
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exceeded number of retry attempts");
            }
            failAndReport = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryAfterSQLException", (Object)failAndReport);
        }
        return failAndReport;
    }

    public void setNonTransientException(Throwable nonTransientException) {
        this._nonTransientException = nonTransientException;
    }

    public Throwable getNonTransientException() {
        return this._nonTransientException;
    }

    public abstract void retryCode(Connection var1) throws SQLException, Exception;

    public abstract String getOperationDescription();
}

