/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.version.Version;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class Headers {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    public static final String PROTOCOL_HEADERS_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HTTP_HEADERS_SETCOOKIE = "Set-Cookie";
    private static final String ADD_HEADERS_PROPERTY = "org.apache.cxf.http.add-headers";
    private static final Logger LOG = LogUtils.getL7dLogger(Headers.class);
    private final Message message;
    private final Map<String, List<String>> headers;
    static final long serialVersionUID = 3432876820513166769L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Headers(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "<init>", new Object[]{message});
        }
        this.message = message;
        this.headers = Headers.getSetProtocolHeaders(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeSessionCookies(Map<String, Cookie> sessionCookies) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "writeSessionCookies", new Object[]{sessionCookies});
        }
        List<Object> cookies = null;
        for (String s : this.headers.keySet()) {
            if (!"Cookie".equalsIgnoreCase(s)) continue;
            cookies = this.headers.remove(s);
            break;
        }
        cookies = cookies == null ? new ArrayList() : new ArrayList(cookies);
        this.headers.put("Cookie", cookies);
        for (Cookie c : sessionCookies.values()) {
            cookies.add(c.requestCookieHeader());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "writeSessionCookies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFromClientPolicy(HTTPClientPolicy policy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setFromClientPolicy", new Object[]{policy});
        }
        if (policy == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromClientPolicy");
            }
            return;
        }
        if (policy.isSetCacheControl()) {
            this.headers.put("Cache-Control", Headers.createMutableList(policy.getCacheControl()));
        }
        if (policy.isSetHost()) {
            this.headers.put("Host", Headers.createMutableList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            this.headers.put("Connection", Headers.createMutableList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            this.headers.put("Accept", Headers.createMutableList(policy.getAccept()));
        } else if (!this.headers.containsKey("Accept")) {
            this.headers.put("Accept", Headers.createMutableList("*/*"));
        }
        if (policy.isSetAcceptEncoding()) {
            this.headers.put("Accept-Encoding", Headers.createMutableList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            this.headers.put("Accept-Language", Headers.createMutableList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            this.message.put((Object)"Content-Type", (Object)policy.getContentType());
        }
        if (policy.isSetCookie()) {
            this.headers.put("Cookie", Headers.createMutableList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            this.headers.put("BrowserType", Headers.createMutableList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            this.headers.put("Referer", Headers.createMutableList(policy.getReferer()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromClientPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFromServerPolicy(HTTPServerPolicy policy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setFromServerPolicy", new Object[]{policy});
        }
        if (policy.isSetCacheControl()) {
            this.headers.put("Cache-Control", Headers.createMutableList(policy.getCacheControl()));
        }
        if (policy.isSetContentLocation()) {
            this.headers.put("Content-Location", Headers.createMutableList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            this.headers.put("Content-Encoding", Headers.createMutableList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            this.headers.put("Content-Type", Headers.createMutableList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            this.headers.put("Server", Headers.createMutableList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            this.headers.put("Connection", Headers.createMutableList("close"));
        } else if (policy.isSetKeepAliveParameters()) {
            this.headers.put("Keep-Alive", Headers.createMutableList(policy.getKeepAliveParameters()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromServerPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAuthorizationHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "removeAuthorizationHeaders", new Object[0]);
        }
        this.headers.remove("Authorization");
        this.headers.remove("Proxy-Authorization");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "removeAuthorizationHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAuthorization(String authorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setAuthorization", new Object[]{authorization});
        }
        this.headers.put("Authorization", Headers.createMutableList(authorization));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProxyAuthorization(String authorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setProxyAuthorization", new Object[]{authorization});
        }
        this.headers.put("Proxy-Authorization", Headers.createMutableList(authorization));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setProxyAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Map<String, List<String>> getSetProtocolHeaders(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getSetProtocolHeaders", new Object[]{message});
        }
        TreeMap<String, List<String>> headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (null == headers) {
            headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        } else if (headers instanceof HashMap) {
            TreeMap<String, List<String>> headers2 = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            headers2.putAll(headers);
            message.put((Object)Message.PROTOCOL_HEADERS, headers2);
            headers = headers2;
        }
        TreeMap<String, List<String>> treeMap = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            treeMap = treeMap;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getSetProtocolHeaders", treeMap);
        }
        return treeMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFromConnection(HttpURLConnection connection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "readFromConnection", new Object[]{connection});
        }
        Map<String, List<String>> origHeaders = connection.getHeaderFields();
        this.headers.clear();
        for (String key : connection.getHeaderFields().keySet()) {
            if (key == null) continue;
            this.headers.put(HttpHeaderHelper.getHeaderKey((String)key), origHeaders.get(key));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "readFromConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<String> createMutableList(String val) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "createMutableList", new Object[]{val});
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(val));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "createMutableList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void logProtocolHeaders(Level level) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "logProtocolHeaders", new Object[]{level});
        }
        for (String header : this.headers.keySet()) {
            List<String> headerList = this.headers.get(header);
            for (String value : headerList) {
                LOG.log(level, header + ": " + value);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "logProtocolHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProtocolHeadersInConnection(HttpURLConnection connection) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setProtocolHeadersInConnection", new Object[]{connection});
        }
        String ct = this.determineContentType();
        connection.setRequestProperty("Content-Type", ct);
        this.transferProtocolHeadersToURLConnection(connection);
        this.logProtocolHeaders(Level.FINE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setProtocolHeadersInConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String determineContentType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "determineContentType", new Object[0]);
        }
        String ct = (String)this.message.get((Object)"Content-Type");
        String enc = (String)this.message.get((Object)Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        String string = ct;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "determineContentType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void transferProtocolHeadersToURLConnection(URLConnection connection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "transferProtocolHeadersToURLConnection", new Object[]{connection});
        }
        boolean addHeaders = MessageUtils.isTrue((Object)this.message.getContextualProperty(ADD_HEADERS_PROPERTY));
        for (String header : this.headers.keySet()) {
            List<String> headerList = this.headers.get(header);
            if ("Content-Type".equalsIgnoreCase(header)) continue;
            if (addHeaders || "Cookie".equalsIgnoreCase(header)) {
                for (String s : headerList) {
                    connection.addRequestProperty("Cookie", s);
                }
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                b.append(headerList.get(i));
                if (i + 1 >= headerList.size()) continue;
                b.append(',');
            }
            connection.setRequestProperty(header, b.toString());
        }
        if (connection.getRequestProperty("User-Agent") == null) {
            connection.addRequestProperty("User-Agent", Version.getCompleteVersionString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "transferProtocolHeadersToURLConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void copyFromRequest(HttpServletRequest req) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "copyFromRequest", new Object[]{req});
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            String mappedName = HttpHeaderHelper.getHeaderKey((String)fname);
            if (this.headers.containsKey(mappedName)) {
                values = this.headers.get(mappedName);
            } else {
                values = new ArrayList();
                this.headers.put(mappedName, values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
        if (!this.headers.containsKey("Content-Type")) {
            this.headers.put("Content-Type", Collections.singletonList(req.getContentType()));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Request Headers: " + this.headers.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "copyFromRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getContentTypeFromMessage() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", new Object[0]);
        }
        String ct = (String)this.message.get((Object)"Content-Type");
        String enc = (String)this.message.get((Object)Message.ENCODING);
        if (null != ct && null != enc && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
            String string = ct + "; charset=" + enc;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", string);
            }
            return string;
        }
        String string = ct;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseBodyAvailable() {
        block7: {
            boolean bl;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", new Object[0]);
            }
            List<String> ctLen = this.headers.get("Content-Length");
            if (ctLen == null || ctLen.size() != 1) {
                boolean bl2 = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl2 = bl2;
                    LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl2);
                }
                return bl2;
            }
            try {
                if (Integer.parseInt(ctLen.get(0)) != 0) break block7;
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void copyToResponse(HttpServletResponse response) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "copyToResponse", new Object[]{response});
        }
        String contentType = this.getContentTypeFromMessage();
        if (!this.headers.containsKey("Content-Type") && contentType != null && this.isResponseBodyAvailable()) {
            response.setContentType(contentType);
        }
        boolean addHeaders = MessageUtils.isTrue((Object)this.message.getContextualProperty(ADD_HEADERS_PROPERTY));
        for (String header : this.headers.keySet()) {
            List<String> headerList = this.headers.get(header);
            if (addHeaders || HTTP_HEADERS_SETCOOKIE.equals(header)) {
                for (int i = 0; i < headerList.size(); ++i) {
                    response.addHeader(header, headerList.get(i).toString());
                }
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                sb.append((Object)headerList.get(i));
                if (i + 1 >= headerList.size()) continue;
                sb.append(',');
            }
            response.addHeader(header, sb.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "copyToResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void removeContentType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "removeContentType", new Object[0]);
        }
        if (this.headers.containsKey(PROTOCOL_HEADERS_CONTENT_TYPE)) {
            this.headers.remove(PROTOCOL_HEADERS_CONTENT_TYPE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "removeContentType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAuthorization() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getAuthorization", new Object[0]);
        }
        if (this.headers.containsKey("Authorization")) {
            List<String> authorizationLines = this.headers.get("Authorization");
            String string = authorizationLines.get(0);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "getAuthorization", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getAuthorization", string);
        }
        return string;
    }
}

