/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.converters.PriorityConverter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserConverter<T>
extends PriorityConverter {
    private static final TraceComponent tc = Tr.register(UserConverter.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final Converter<T> converter;
    static final long serialVersionUID = -3250628998480167955L;

    @Trivial
    public static <K> UserConverter<K> newInstance(Converter<K> converter) {
        return UserConverter.newInstance(UserConverter.getType(converter), converter);
    }

    @Trivial
    public static <K> UserConverter<K> newInstance(Type type, Converter<K> converter) {
        return UserConverter.newInstance(type, UserConverter.getPriority(converter), converter);
    }

    @Trivial
    public static <K> UserConverter<K> newInstance(Type type, int priority, Converter<K> converter) {
        return new UserConverter<K>(type, priority, converter);
    }

    protected UserConverter(Type type, int priority, Converter<T> converter) {
        super(type, priority);
        this.converter = converter;
    }

    public T convert(String value) {
        return (T)this.converter.convert(value);
    }

    @Trivial
    private static int getPriority(Converter<?> converter) {
        int value = 100;
        Priority[] priorities = (Priority[])converter.getClass().getDeclaredAnnotationsByType(Priority.class);
        if (priorities != null && priorities.length > 0) {
            Priority priority = priorities[0];
            value = priority.value();
        }
        return value;
    }

    @Trivial
    private static Type getType(Converter<?> converter) {
        Type[] itypes;
        Type type = null;
        for (Type itype : itypes = converter.getClass().getGenericInterfaces()) {
            ParameterizedType ptype = (ParameterizedType)itype;
            if (ptype.getRawType() != Converter.class) continue;
            Type[] atypes = ptype.getActualTypeArguments();
            if (atypes.length == 1) {
                type = atypes[0];
                break;
            }
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.conversion.type.CWMCG0009E", (Object[])new Object[]{converter.getClass().getName()}));
        }
        if (type == null) {
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.conversion.type.CWMCG0009E", (Object[])new Object[]{converter.getClass().getName()}));
        }
        return type;
    }

    @Override
    public String toString() {
        return "User Converter for type " + this.getType() + "(" + this.getPriority() + ")";
    }
}

