/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DataWriterImpl<T>
extends JAXBDataBase
implements DataWriter<T> {
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    private final JAXBDataBinding databinding;
    static final long serialVersionUID = -3756972645280271111L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataWriterImpl(JAXBDataBinding binding) {
        super(binding.getContext());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", new Object[]{binding});
        }
        this.databinding = binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(Object obj, T output) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "write", new Object[]{obj, output});
        }
        this.write(obj, null, output);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller createMarshaller(Object elValue, MessagePartInfo part) {
        Marshaller marshaller;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "createMarshaller", new Object[]{elValue, part});
        }
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            marshaller = this.databinding.getJAXBMarshaller();
            if (Boolean.FALSE.equals(marshaller.getProperty("jaxb.fragment")) && marshaller.getAttachmentMarshaller() == null) {
                Map nspref;
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
                marshaller.setListener(this.databinding.getMarshallerListener());
                if (this.databinding.getValidationEventHandler() != null) {
                    marshaller.setEventHandler(this.databinding.getValidationEventHandler());
                }
                if ((nspref = this.databinding.getDeclaredNamespaceMappings()) != null) {
                    JAXBUtils.setNamespaceWrapper((Map)nspref, (Marshaller)marshaller);
                }
                if (this.databinding.getMarshallerProperties() != null) {
                    for (Map.Entry<String, Object> propEntry : this.databinding.getMarshallerProperties().entrySet()) {
                        try {
                            marshaller.setProperty(propEntry.getKey(), propEntry.getValue());
                        }
                        catch (PropertyException pe) {
                            LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                        }
                    }
                }
            }
            marshaller.setSchema(this.schema);
            AttachmentMarshaller atmarsh = this.getAttachmentMarshaller();
            marshaller.setAttachmentMarshaller(atmarsh);
            if (this.schema != null && atmarsh instanceof JAXBAttachmentMarshaller) {
                marshaller.setEventHandler((ValidationEventHandler)new MtomValidationHandler(marshaller.getEventHandler(), (JAXBAttachmentMarshaller)atmarsh));
            }
        }
        catch (JAXBException ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, new Object[]{marshalEx.getLinkedException().getMessage()});
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        Marshaller marshaller2 = marshaller;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            marshaller2 = marshaller2;
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "createMarshaller", marshaller2);
        }
        return marshaller2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(Object obj, MessagePartInfo part, T output) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "write", new Object[]{obj, part, output});
        }
        boolean honorJaxbAnnotation = this.honorJAXBAnnotations(part);
        if (part != null && !part.isElement() && part.getTypeClass() != null) {
            honorJaxbAnnotation = true;
        }
        Marshaller marshaller = null;
        if (obj != null || !(part.getXmlSchema() instanceof XmlSchemaElement)) {
            if (obj instanceof Exception && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
                marshaller = this.createMarshaller(obj, part);
                JAXBEncoderDecoder.marshallException(marshaller, (Exception)obj, part, output);
            } else {
                Annotation[] anns = this.getJAXBAnnotation(part);
                if (!honorJaxbAnnotation || anns.length == 0) {
                    marshaller = this.createMarshaller(obj, part);
                    JAXBEncoderDecoder.marshall(marshaller, obj, part, output);
                } else if (honorJaxbAnnotation && anns.length > 0) {
                    JAXBEncoderDecoder.marshalWithBridge(part.getConcreteName(), part.getTypeClass(), anns, this.databinding.getContextClasses(), obj, output, this.getAttachmentMarshaller());
                }
            }
        } else if (this.needToRender(obj, part)) {
            marshaller = this.createMarshaller(obj, part);
            JAXBEncoderDecoder.marshallNullElement(marshaller, output, part);
        }
        this.databinding.releaseJAXBMarshaller(marshaller);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean needToRender(Object obj, MessagePartInfo part) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", new Object[]{obj, part});
        }
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            boolean bl = element.isNillable() && element.getMinOccurs() > 0L;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", bl);
        }
        return bl;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class MtomValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        JAXBAttachmentMarshaller marshaller;
        static final long serialVersionUID = -1810125226130444397L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MtomValidationHandler(ValidationEventHandler v, JAXBAttachmentMarshaller m) {
            this.origHandler = v;
            this.marshaller = m;
        }

        public boolean handleEvent(ValidationEvent event) {
            String msg = event.getMessage();
            if (msg.startsWith("cvc-type.3.1.2: ") && msg.contains(this.marshaller.getLastMTOMElementName().getLocalPart())) {
                return true;
            }
            if (this.origHandler != null) {
                return this.origHandler.handleEvent(event);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.io.DataWriterImpl$MtomValidationHandler", MtomValidationHandler.class, null, null);
        }
    }
}

