/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.SameSiteCookie;
import com.ibm.ws.session.SessionCookieConfigImpl;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.SessionTrackingMode;

public class SessionManagerConfig
implements Cloneable {
    private boolean usingWebContainerSM = true;
    private boolean useContextRootForSessionCookiePath = false;
    private boolean usingMemory = false;
    private boolean usingDatabase = false;
    private boolean usingJCache = false;
    private boolean usingMemToMem = false;
    private boolean enableUrlProtocolSwitchRewriting = false;
    public static final String dcookieName = "SSLJSESSION";
    public static String sipSessionCookieName = "ibmappid";
    private int inMemorySize = 1000;
    private boolean enableOverflow = true;
    private long sessionInvalidationTime = 30L;
    private boolean integrateSec = false;
    private boolean throwSecurityExceptionOnGetSessionFalse = true;
    private boolean invalidateOnUnauthorizedSessionRequestException = false;
    private boolean allowSerializedSessionAccess = false;
    private int serializedSessionAccessMaxWaitTime = 0;
    private boolean accessSessionOnTimeout = true;
    private String JNDIDataSourceName = "jdbc/sample";
    private String sessionDBID = null;
    private String sessionDBPWD = null;
    private int rowSize = 4;
    private String tableSpaceName = null;
    private boolean usingMultirow = false;
    private Object drsSettings;
    private boolean enableEOSWrite = false;
    private boolean enableManualWrite = false;
    private boolean enableTimeBasedWrite = false;
    private long mPropertyWriterInterval = 120L;
    private boolean writeAllProperties = false;
    private boolean writeGetAndSetAttributes;
    private boolean scheduledInvalidation = false;
    private int firstHour = 0;
    private int secondHour = 0;
    static boolean is_zOS = false;
    static String serverId = null;
    static String cloneId = null;
    private String sacKey = "DEFAULT_SAC_KEY";
    private static char cloneSeparator = (char)58;
    private boolean debugSessionCrossover = false;
    private static boolean cloneIdPropertySet = false;
    private static boolean expectedCloneIdsPropertySet = false;
    private static String expectedCloneIds = null;
    private static boolean idReuse = false;
    private long reaperPollInterval = -1L;
    private static boolean turnOffCacheId = false;
    private static boolean turnOffCloneId = false;
    private static boolean noAffinitySwitchBack = false;
    private static int maxSessionIdentifierLength = 1024;
    private String sessUrlRewritePrefix = ";jsessionid=";
    private String tableNameValue = null;
    private boolean checkRecentlyInvalidList = true;
    private boolean modifyActiveCountOnInvalidatedSession = true;
    private boolean useOracleBlob = false;
    private boolean usingCustomSchemaName = false;
    private boolean trackGCCount = false;
    private static boolean hideSessionValues = true;
    private static boolean hideSessionValuesPropertySet = false;
    private static boolean doRemoteInvalidations = true;
    private boolean zosBaseServerReplication = false;
    private static boolean servlet21SessionCompat = false;
    private static int cacheIdLength = 4;
    private static int sessionIDLength = 23;
    protected EnumSet<SessionTrackingMode> trackingModes = EnumSet.noneOf(SessionTrackingMode.class);
    private final String privateSessionCookieName = "JSESSIONID";
    private final String privateSessionCookieComment = "";
    private final String privateSessionCookieDomain = "";
    private final int privateSessionCookieMaxAge = -1;
    private final String privateSessionCookiePath = "/";
    private final boolean privateSessionCookieSecure = false;
    private final boolean privateSessionCookieHttpOnly = true;
    protected SessionCookieConfigImpl cookieConfig;
    private int SIPConvergedHttpPort;
    private int SIPConvergedHttpsPort;
    private String SIPConvergedHostName;
    private boolean optimizeCacheIdIncrements;
    private static boolean alwaysEncodeURL = false;
    private static boolean checkSessionCookieNameOnEncodeURL = false;
    private boolean onlyCheckInCacheDuringPreInvoke;
    private static boolean enableHotFailover = true;
    private int forceSessionInvalidationMultiple;
    private boolean persistSessionAfterPassivation;
    private static boolean usingApplicationSessionsAndInvalidateAll = false;
    private static boolean usingApplicationSessionsAlwaysRetrieve = false;
    private boolean forceSessionIdLengthCheck;
    private boolean securityUserIgnoreCase;
    private boolean sessionTableSkipIndexCreation;
    private boolean checkSessionNewOnIsValidRequest;
    private int delayInvalidationAlarmDuringServerStartup;
    private boolean useSeparateSessionInvalidatorThreadPool;
    private int connectionRetryCount;
    private SameSiteCookie sessionCookieSameSite;

    protected String getDefaultSessionCookieName() {
        return "JSESSIONID";
    }

    public final SessionCookieConfigImpl getSessionCookieConfig() {
        return this.cookieConfig;
    }

    public static final boolean is_zOS() {
        return is_zOS;
    }

    public static final void set_is_zOS(boolean b) {
        is_zOS = b;
    }

    public void setEffectiveTrackingModes(EnumSet<SessionTrackingMode> effective) {
        this.trackingModes = effective != null ? EnumSet.copyOf(effective) : EnumSet.noneOf(SessionTrackingMode.class);
    }

    public EnumSet<SessionTrackingMode> getSessionTrackingMode() {
        return this.trackingModes;
    }

    public static final String getServerId() {
        return serverId;
    }

    public static final void setServerId(String s) {
        serverId = s;
    }

    public static final String getCloneId() {
        return cloneId;
    }

    public static final void setCloneId(String s) {
        cloneId = s;
    }

    public final boolean isUseContextRootForSessionCookiePath() {
        return this.useContextRootForSessionCookiePath;
    }

    public final void setUseContextRootForSessionCookiePath(boolean useContextRootForSessionCookiePath) {
        this.useContextRootForSessionCookiePath = useContextRootForSessionCookiePath;
    }

    public SessionManagerConfig() {
        this.trackingModes.add(SessionTrackingMode.COOKIE);
        this.privateSessionCookieName = "JSESSIONID";
        this.privateSessionCookieComment = "";
        this.privateSessionCookieDomain = "";
        this.privateSessionCookieMaxAge = -1;
        this.privateSessionCookiePath = "/";
        this.privateSessionCookieSecure = false;
        this.privateSessionCookieHttpOnly = true;
        this.cookieConfig = new SessionCookieConfigImpl("JSESSIONID", "", "/", "", -1, true, false);
        this.SIPConvergedHttpPort = 80;
        this.SIPConvergedHttpsPort = 443;
        this.SIPConvergedHostName = "localhost";
        this.optimizeCacheIdIncrements = false;
        this.onlyCheckInCacheDuringPreInvoke = false;
        this.forceSessionInvalidationMultiple = 3;
        this.persistSessionAfterPassivation = false;
        this.forceSessionIdLengthCheck = false;
        this.securityUserIgnoreCase = false;
        this.sessionTableSkipIndexCreation = false;
        this.checkSessionNewOnIsValidRequest = true;
        this.delayInvalidationAlarmDuringServerStartup = 5;
        this.useSeparateSessionInvalidatorThreadPool = true;
        this.connectionRetryCount = 2;
    }

    public final boolean isUsingWebContainerSM() {
        return this.usingWebContainerSM;
    }

    public final void setUsingWebContainerSM(boolean b) {
        this.usingWebContainerSM = b;
    }

    public final boolean isUsingMemory() {
        return this.usingMemory;
    }

    public final void setUsingMemory(boolean val) {
        this.usingMemory = val;
    }

    public final boolean isUsingDatabase() {
        return this.usingDatabase;
    }

    public final void setUsingDatabase(boolean val) {
        this.usingDatabase = val;
    }

    public final boolean isUsingJCache() {
        return this.usingJCache;
    }

    public final void setUsingJCache(boolean val) {
        this.usingJCache = val;
    }

    public final boolean isUsingMemtoMem() {
        return this.usingMemToMem;
    }

    public final void setUsingMemtoMem(boolean val) {
        this.usingMemToMem = val;
    }

    public final void setPersistenceMode(String s) {
        if ("None".equalsIgnoreCase(s)) {
            this.setUsingMemory(true);
        } else if ("DATABASE".equalsIgnoreCase(s)) {
            this.setUsingDatabase(true);
        } else if ("JCACHE".equalsIgnoreCase(s)) {
            this.setUsingJCache(true);
        } else {
            this.setUsingMemory(true);
        }
    }

    public final boolean useSSLId() {
        return this.trackingModes.contains(SessionTrackingMode.SSL);
    }

    public final void setUseSLLId(boolean b) {
        if (b) {
            this.trackingModes.add(SessionTrackingMode.SSL);
        } else {
            this.trackingModes.remove(SessionTrackingMode.SSL);
        }
    }

    public final boolean getEnableUrlRewriting() {
        return this.trackingModes.contains(SessionTrackingMode.URL);
    }

    public final void setEnableUrlRewriting(boolean enable) {
        if (enable) {
            this.trackingModes.add(SessionTrackingMode.URL);
        } else {
            this.trackingModes.remove(SessionTrackingMode.URL);
        }
    }

    public final boolean getEnableUrlProtocolSwitchRewriting() {
        return this.enableUrlProtocolSwitchRewriting;
    }

    public final void setEnableUrlProtocolSwitchRewriting(boolean b) {
        this.enableUrlProtocolSwitchRewriting = b;
    }

    public final boolean getEnableCookies() {
        return this.trackingModes.contains(SessionTrackingMode.COOKIE);
    }

    public final void setEnableCookies(boolean b) {
        if (b) {
            this.trackingModes.add(SessionTrackingMode.COOKIE);
        } else {
            this.trackingModes.remove(SessionTrackingMode.COOKIE);
        }
    }

    public final String getSessionCookieName() {
        return this.cookieConfig.getName();
    }

    public final void setSessionCookieName(String s) {
        boolean externalCall = false;
        this.cookieConfig.setName(s, false);
    }

    public final String getSessionCookieComment() {
        return this.cookieConfig.getComment();
    }

    public final void setSessionCookieComment(String s) {
        boolean externalCall = false;
        this.cookieConfig.setComment(s, false);
    }

    public final String getSessionCookieDomain() {
        return this.cookieConfig.getDomain();
    }

    public final void setSessionCookieDomain(String s) {
        boolean externalCall = false;
        this.cookieConfig.setDomain(s, false);
    }

    public final int getSessionCookieMaxAge() {
        return this.cookieConfig.getMaxAge();
    }

    public final void setSessionCookieMaxAge(int i) {
        boolean externalCall = false;
        this.cookieConfig.setMaxAge(i, false);
    }

    public final String getSessionCookiePath() {
        return this.cookieConfig.getPath();
    }

    public final void setSessionCookiePath(String s) {
        boolean externalCall = false;
        this.cookieConfig.setPath(s, false);
    }

    public final boolean getSessionCookieSecure() {
        return this.cookieConfig.isSecure();
    }

    public final void setSessionCookieSecure(boolean b) {
        boolean externalCall = false;
        this.cookieConfig.setSecure(b, false);
    }

    public static final String getSipSessionCookieName() {
        return sipSessionCookieName;
    }

    public static final void setSipSessionCookieName(String s) {
        sipSessionCookieName = s;
    }

    public final int getInMemorySize() {
        return this.inMemorySize;
    }

    public final void setInMemorySize(int i) {
        this.inMemorySize = i;
    }

    public final boolean getEnableOverflow() {
        return this.enableOverflow;
    }

    public final void setEnableOverflow(boolean b) {
        this.enableOverflow = b;
    }

    public final long getSessionInvalidationTime() {
        return this.sessionInvalidationTime;
    }

    public final void setSessionInvalidationTime(long t) {
        this.sessionInvalidationTime = t;
    }

    public final boolean getIntegrateSecurity() {
        return this.integrateSec;
    }

    public final void setIntegrateSecurity(boolean sec) {
        this.integrateSec = sec;
    }

    public final boolean getThrowSecurityExceptionOnGetSessionFalse() {
        return this.throwSecurityExceptionOnGetSessionFalse;
    }

    public final void setThrowSecurityExceptionOnGetSessionFalse(boolean throwEx) {
        this.throwSecurityExceptionOnGetSessionFalse = throwEx;
    }

    public final boolean getInvalidateOnUnauthorizedSessionRequestException() {
        return this.invalidateOnUnauthorizedSessionRequestException;
    }

    public final void setInvalidateOnUnauthorizedSessionRequestException(boolean invalidateOnEx) {
        this.invalidateOnUnauthorizedSessionRequestException = invalidateOnEx;
    }

    public final boolean getAllowSerializedSessionAccess() {
        return this.allowSerializedSessionAccess;
    }

    public final void setAllowSerializedSessionAccess(boolean b) {
        this.allowSerializedSessionAccess = b;
    }

    public final int getSerializedSessionAccessMaxWaitTime() {
        return this.serializedSessionAccessMaxWaitTime;
    }

    public final void setSerializedSessionAccessMaxWaitTime(int i) {
        this.serializedSessionAccessMaxWaitTime = i;
    }

    public final boolean getAccessSessionOnTimeout() {
        return this.accessSessionOnTimeout;
    }

    public final void setAccessSessionOnTimeout(boolean b) {
        this.accessSessionOnTimeout = b;
    }

    public final boolean getModifyActiveCountOnInvalidatedSession() {
        return this.modifyActiveCountOnInvalidatedSession;
    }

    public final void setModifyActiveCountOnInvalidatedSession(boolean b) {
        this.modifyActiveCountOnInvalidatedSession = b;
    }

    public final String getJNDIDataSourceName() {
        return this.JNDIDataSourceName;
    }

    public final void setJNDIDataSourceName(String name) {
        this.JNDIDataSourceName = name;
    }

    public final String getSessionDBID() {
        return this.sessionDBID;
    }

    public final void setSessionDBID(String s) {
        this.sessionDBID = s;
    }

    public final String getSessionDBPWD() {
        return this.sessionDBPWD;
    }

    public final void setSessionDBPWD(String s) {
        this.sessionDBPWD = s;
    }

    public final int getRowSize() {
        return this.rowSize;
    }

    public final void setRowSize(int size) {
        this.rowSize = size;
    }

    public final String getTableSpaceName() {
        return this.tableSpaceName;
    }

    public final void setTableSpaceName(String name) {
        this.tableSpaceName = name;
    }

    public final boolean isUsingMultirow() {
        return this.usingMultirow;
    }

    public final void setUsingMultirow(boolean b) {
        this.usingMultirow = b;
    }

    public final Object getDRSSettings() {
        return this.drsSettings;
    }

    public final void setDRSSettings(Object drss) {
        this.drsSettings = drss;
    }

    public final boolean getEnableEOSWrite() {
        return this.enableEOSWrite;
    }

    public final void setEnableEOSWrite(boolean b) {
        this.enableEOSWrite = b;
    }

    public final boolean getEnableManualWrite() {
        return this.enableManualWrite;
    }

    public final void setEnableManualWrite(boolean b) {
        this.enableManualWrite = b;
    }

    public final boolean getEnableTimeBasedWrite() {
        return this.enableTimeBasedWrite;
    }

    public final void setEnableTimeBasedWrite(boolean b) {
        this.enableTimeBasedWrite = b;
    }

    public final long getPropertyWriterInterval() {
        return this.mPropertyWriterInterval;
    }

    public final void setPropertyWriterInterval(long time) {
        this.mPropertyWriterInterval = time;
    }

    public final boolean writeAllProperties() {
        return this.writeAllProperties;
    }

    public final void setwriteAllProperties() {
        this.writeAllProperties = true;
    }

    public final boolean writeGetAndSetAttributes() {
        return this.writeGetAndSetAttributes;
    }

    final void setWriteGetAndSetAttributes() {
        this.writeGetAndSetAttributes = true;
    }

    public final boolean getScheduledInvalidation() {
        return this.scheduledInvalidation;
    }

    public final void setScheduledInvalidation(boolean b) {
        this.scheduledInvalidation = b;
    }

    public final int getInvalTime1() {
        return this.firstHour;
    }

    public final void setFirstHour(int time) {
        this.firstHour = time;
    }

    public final int getInvalTime2() {
        return this.secondHour;
    }

    public final void setSecondHour(int time) {
        this.secondHour = time;
    }

    public final void setSessionAffinityContextKey(String key) {
        this.sacKey = key;
    }

    public final String getSessionAffinityContextKey() {
        return this.sacKey;
    }

    public static final char getCloneSeparator() {
        return cloneSeparator;
    }

    public static final void setCloneSeparator(char c) {
        cloneSeparator = c;
    }

    public final boolean isDebugSessionCrossover() {
        return this.debugSessionCrossover;
    }

    public final void setDebugSessionCrossover(boolean b) {
        this.debugSessionCrossover = b;
    }

    public static final boolean isCloneIdPropertySet() {
        return cloneIdPropertySet;
    }

    public static final void setCloneIdPropertySet(boolean b) {
        cloneIdPropertySet = b;
    }

    public static final boolean isIdReuse() {
        return idReuse;
    }

    public static final void setIdReuse(boolean b) {
        idReuse = b;
    }

    public final long getInvalidationCheckInterval() {
        return this.reaperPollInterval;
    }

    public final long getReaperPollInterval() {
        return this.reaperPollInterval;
    }

    public final void setReaperPollInterval(long l) {
        this.reaperPollInterval = l;
    }

    public static final boolean isTurnOffCacheId() {
        return turnOffCacheId;
    }

    public static final void setTurnOffCacheId(boolean b) {
        turnOffCacheId = b;
    }

    public static final boolean isTurnOffCloneId() {
        return turnOffCloneId;
    }

    public static final void setTurnOffCloneId(boolean b) {
        turnOffCloneId = b;
    }

    public static final boolean isNoAffinitySwitchBack() {
        return noAffinitySwitchBack;
    }

    public static final void setNoAffinitySwitchBack(boolean b) {
        noAffinitySwitchBack = b;
    }

    public static final int getMaxSessionIdentifierLength() {
        return maxSessionIdentifierLength;
    }

    public static final void setMaxSessionIdentifierLength(int i) {
        maxSessionIdentifierLength = i;
    }

    public final String getSessUrlRewritePrefix() {
        return this.sessUrlRewritePrefix;
    }

    public final void setSessUrlRewritePrefix(String s) {
        this.sessUrlRewritePrefix = s;
    }

    public final String getTableNameValue() {
        return this.tableNameValue;
    }

    public final void setTableNameValue(String s) {
        this.tableNameValue = s;
    }

    public final boolean getCheckRecentlyInvalidList() {
        return this.checkRecentlyInvalidList;
    }

    public final void setCheckRecentlyInvalidList(boolean b) {
        this.checkRecentlyInvalidList = b;
    }

    public final boolean isUseOracleBlob() {
        return this.useOracleBlob;
    }

    public final void setUseOracleBlob(boolean b) {
        this.useOracleBlob = b;
    }

    public final boolean isSessionTableSkipIndexCreation() {
        return this.sessionTableSkipIndexCreation;
    }

    public final void setSessionTableSkipIndexCreation(boolean b) {
        this.sessionTableSkipIndexCreation = b;
    }

    public final boolean checkSessionNewOnIsValidRequest() {
        return this.checkSessionNewOnIsValidRequest;
    }

    public final void setCheckSessionNewOnIsValidRequest(boolean b) {
        this.checkSessionNewOnIsValidRequest = b;
    }

    public final boolean isUsingCustomSchemaName() {
        return this.usingCustomSchemaName;
    }

    public final void setUsingCustomSchemaName(boolean b) {
        this.usingCustomSchemaName = b;
    }

    public final boolean isTrackGCCount() {
        return this.trackGCCount;
    }

    public final void setTrackGCCount(boolean b) {
        this.trackGCCount = b;
    }

    public static final boolean isHideSessionValues() {
        return hideSessionValues;
    }

    public static final void setHideSessionValues(boolean b) {
        hideSessionValues = b;
    }

    public static final boolean isHideSessionValuesPropertySet() {
        return hideSessionValuesPropertySet;
    }

    public static final void setHideSessionValuesPropertySet(boolean b) {
        hideSessionValuesPropertySet = b;
    }

    public static final boolean isDoRemoteInvalidations() {
        return doRemoteInvalidations;
    }

    public static final void setDoRemoteInvalidations(boolean b) {
        doRemoteInvalidations = b;
    }

    public final boolean isZosBaseServerReplicationEnabled() {
        return this.zosBaseServerReplication;
    }

    public final void setZosBaseServerReplicationEnabled(boolean b) {
        this.zosBaseServerReplication = b;
    }

    public static final boolean getServlet21SessionCompatibility() {
        return servlet21SessionCompat;
    }

    public static final void setServlet21SessionCompatibility(boolean b) {
        servlet21SessionCompat = b;
    }

    public static final int getCacheIdLength() {
        return cacheIdLength;
    }

    public static final void setCacheIdLength(int i) {
        cacheIdLength = i;
    }

    public static final int getSessionIDLength() {
        return sessionIDLength;
    }

    public static final void setSessionIDLength(int i) {
        sessionIDLength = i;
    }

    public static final boolean isAlwaysEncodeURL() {
        return alwaysEncodeURL;
    }

    public static final void setAlwaysEncodeURL(boolean b) {
        alwaysEncodeURL = b;
    }

    public static final boolean checkSessionCookieNameOnEncodeURL() {
        return checkSessionCookieNameOnEncodeURL;
    }

    public static final void setCheckSessionCookieNameOnEncodeURL(boolean b) {
        checkSessionCookieNameOnEncodeURL = b;
    }

    public final boolean getOptimizeCacheIdIncrements() {
        return this.optimizeCacheIdIncrements;
    }

    public final void setOptimizeCacheIdIncrements(boolean b) {
        this.optimizeCacheIdIncrements = b;
    }

    public final boolean getOnlyCheckInCacheDuringPreInvoke() {
        return this.onlyCheckInCacheDuringPreInvoke;
    }

    public final void setOnlyCheckInCacheDuringPreInvoke(boolean b) {
        this.onlyCheckInCacheDuringPreInvoke = b;
    }

    public static final boolean isEnableHotFailover() {
        return enableHotFailover;
    }

    public static final void setEnableHotFailover(boolean b) {
        enableHotFailover = b;
    }

    public int getForceSessionInvalidationMultiple() {
        return this.forceSessionInvalidationMultiple;
    }

    public void setForceSessionInvalidationMultiple(int i) {
        this.forceSessionInvalidationMultiple = i;
    }

    public boolean getPersistSessionAfterPassivation() {
        return this.persistSessionAfterPassivation;
    }

    public void setPersistSessionAfterPassivation(boolean b) {
        this.persistSessionAfterPassivation = b;
    }

    public static boolean getUsingApplicationSessionsAndInvalidateAll() {
        return usingApplicationSessionsAndInvalidateAll;
    }

    public static void setUsingApplicationSessionsAndInvalidateAll(boolean b) {
        usingApplicationSessionsAndInvalidateAll = b;
    }

    public static boolean getUsingApplicationSessionsAlwaysRetrieve() {
        return usingApplicationSessionsAlwaysRetrieve;
    }

    public static void setUsingApplicationSessionsAlwaysRetrieve(boolean b) {
        usingApplicationSessionsAlwaysRetrieve = b;
    }

    public boolean getForceSessionIdLengthCheck() {
        return this.forceSessionIdLengthCheck;
    }

    public void setForceSessionIdLengthCheck(boolean b) {
        this.forceSessionIdLengthCheck = b;
    }

    public boolean getSecurityUserIgnoreCase() {
        return this.securityUserIgnoreCase;
    }

    public void setSecurityUserIgnoreCase(boolean b) {
        this.securityUserIgnoreCase = b;
    }

    public int getDelayForInvalidationAlarmDuringServerStartup() {
        return this.delayInvalidationAlarmDuringServerStartup;
    }

    public void setDelayForInvalidationAlarmDuringServerStartup(int delay) {
        this.delayInvalidationAlarmDuringServerStartup = delay;
    }

    public boolean getUseSeparateSessionInvalidatorThreadPool() {
        return this.useSeparateSessionInvalidatorThreadPool;
    }

    public void setUseSeparateSessionInvalidatorThreadPool(boolean switched) {
        this.useSeparateSessionInvalidatorThreadPool = switched;
    }

    public static final void setExpectedCloneIdsPropertySet(boolean b) {
        expectedCloneIdsPropertySet = b;
    }

    public static final boolean isExpectedCloneIdsPropertySet() {
        return expectedCloneIdsPropertySet;
    }

    public static final void setExpectedCloneIds(String cloneIds) {
        expectedCloneIds = cloneIds;
    }

    public static final String getExpectedCloneIds() {
        return expectedCloneIds;
    }

    public int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    public void setConnectionRetryCount(int i) {
        this.connectionRetryCount = i;
    }

    public void printSessionManagerConfigForDebug(Logger logger) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            StringBuffer msg = new StringBuffer();
            msg.append("usingWebContainerSM=").append(this.usingWebContainerSM).append("\n");
            msg.append("usingMemory=").append(this.usingMemory).append("\n");
            msg.append("usingDatabase=").append(this.usingDatabase).append("\n");
            msg.append("usingJCache=").append(this.usingJCache).append("\n");
            msg.append("usingMemToMem=").append(this.usingMemToMem).append("\n");
            msg.append("enableSSLTracking=").append(this.useSSLId()).append("\n");
            msg.append("enableUrlRewriting=").append(this.getEnableUrlRewriting()).append("\n");
            msg.append("enableUrlProtocolSwitchRewriting=").append(this.enableUrlProtocolSwitchRewriting).append("\n");
            msg.append("enableCookies=").append(this.getEnableCookies()).append("\n");
            msg.append("sessionCookieName=").append(this.getSessionCookieName()).append("\n");
            msg.append("sessionCookieDomain=").append(this.getSessionCookieDomain()).append("\n");
            msg.append("sessionCookieMaxAge=").append(this.getSessionCookieMaxAge()).append("\n");
            msg.append("sessionCookiePath=").append(this.getSessionCookiePath()).append("\n");
            msg.append("sessionCookieSecure=").append(this.getSessionCookieSecure()).append("\n");
            msg.append("sessionCookieSameSite=").append(this.getSessionCookieSameSite().getSameSiteCookieValue()).append("\n");
            msg.append("inMemorySize=").append(this.inMemorySize).append("\n");
            msg.append("enableOverflow=").append(this.enableOverflow).append("\n");
            msg.append("sessionInvalidationTime=").append(this.sessionInvalidationTime).append("\n");
            msg.append("integrateSec=").append(this.integrateSec).append("\n");
            msg.append("is_zOS=").append(is_zOS).append("\n");
            msg.append("cloneID=").append(cloneId).append("\n");
            msg.append("cloneSeparator=").append(cloneSeparator).append("\n");
            logger.logp(Level.FINE, "SessionManagerConfig", "printSessionManagerConfigForDebug", msg.toString());
        }
    }

    public SessionManagerConfig clone() throws CloneNotSupportedException {
        SessionManagerConfig tempSMC = (SessionManagerConfig)super.clone();
        tempSMC.setClonedCookieConfig(this.cookieConfig.clone());
        tempSMC.setClonedTrackingModes(this.trackingModes);
        return tempSMC;
    }

    public void setClonedCookieConfig(SessionCookieConfigImpl scci) {
        this.cookieConfig = scci;
    }

    public void setClonedTrackingModes(EnumSet<SessionTrackingMode> stm) {
        if (stm != null) {
            this.trackingModes = EnumSet.copyOf(stm);
        }
    }

    public final boolean getSessionCookieHttpOnly() {
        return this.cookieConfig.isHttpOnly();
    }

    public final void setSessionCookieHttpOnly(boolean b) {
        boolean externalCall = false;
        this.cookieConfig.setHttpOnly(b, false);
    }

    public final SameSiteCookie getSessionCookieSameSite() {
        return this.sessionCookieSameSite;
    }

    public final void setSessionCookieSameSite(SameSiteCookie sameSite) {
        this.sessionCookieSameSite = sameSite;
    }

    public void updateCookieInfo(SessionCookieConfigImpl scc) {
        if (scc != null) {
            if (scc.getComment() != null) {
                this.setSessionCookieComment(scc.getComment());
            }
            if (scc.getDomain() != null) {
                this.setSessionCookieDomain(scc.getDomain());
            }
            if (scc.isMaxAgeSet()) {
                this.setSessionCookieMaxAge(scc.getMaxAge());
            }
            if (scc.getName() != null) {
                this.setSessionCookieName(scc.getName());
            }
            if (scc.getPath() != null) {
                this.setSessionCookiePath(scc.getPath());
            }
            if (scc.isHttpOnlySet()) {
                this.setSessionCookieHttpOnly(scc.isHttpOnly());
            }
            if (scc.isSecureSet()) {
                this.setSessionCookieSecure(scc.isSecure());
            }
        }
    }

    public void updateTrackingMode(EnumSet<SessionTrackingMode> modes) {
        this.trackingModes = modes;
    }

    public String getSIPConvergedHostName() {
        return this.SIPConvergedHostName;
    }

    public void setSIPConvergedHostName(String convergedHostName) {
        this.SIPConvergedHostName = convergedHostName;
    }

    public int getSIPConvergedHttpPort() {
        return this.SIPConvergedHttpPort;
    }

    public void setSIPConvergedHttpPort(int convergedHttpPort) {
        this.SIPConvergedHttpPort = convergedHttpPort;
    }

    public int getSIPConvergedHttpsPort() {
        return this.SIPConvergedHttpsPort;
    }

    public void setSIPConvergedHttpsPort(int convergedHttpsPort) {
        this.SIPConvergedHttpsPort = convergedHttpsPort;
    }
}

