/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap.context;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.ldap.context.SSLUtilImpl;
import com.ibm.ws.security.wim.adapter.ldap.context.TimedDirContext;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.wim.exception.EntityAlreadyExistsException;
import com.ibm.wsspi.security.wim.exception.EntityHasDescendantsException;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InvalidInitPropertyException;
import com.ibm.wsspi.security.wim.exception.OperationNotSupportedException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextManager {
    private static final int DEFAULT_INIT_POOL_SIZE = 1;
    private static final int DEFAULT_MAX_POOL_SIZE = 0;
    private static final int DEFAULT_POOL_TIME_OUT = 0;
    private static final int DEFAULT_POOL_WAIT_TIME = 3000;
    private static final int DEFAULT_PREF_POOL_SIZE = 3;
    private static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static final long DEFAULT_READ_TIMEOUT = 60000L;
    private static final String ENVKEY_ACTIVE_URL = "_ACTIVE_URL_";
    private static final String ENVKEY_URL_LIST = "_URL_LIST_";
    private static final int LDAP_CONNECT_TIMEOUT_TRACE = 1000;
    private static final String LDAP_ENV_PROP_ATTRIBUTES_BINARY = "java.naming.ldap.attributes.binary";
    private static final String LDAP_ENV_PROP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String LDAP_ENV_PROP_FACTORY_SOCKET = "java.naming.ldap.factory.socket";
    private static final String LDAP_ENV_PROP_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final AtomicLong LDAP_STATS_TIMER = new AtomicLong(0L);
    private static final String LDAP_SUN_SPI = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_URL_PREFIX = "ldap://";
    private static final String LDAP_URL_SSL_PREFIX = "ldaps://";
    private static final AtomicInteger QUICK_LDAP_BIND = new AtomicInteger(0);
    private static final TraceComponent tc = Tr.register(ContextManager.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    private static final int URLTYPE_SEQUENCE = 1;
    private static final int URLTYPE_SINGLE = 0;
    private static final String WAS_SSL_SOCKET_FACTORY = "com.ibm.ws.ssl.protocol.LibertySSLSocketFactory";
    private String iBinaryAttributeNames;
    private String iBindDN;
    private SerializableProtectedString iBindPassword;
    private final Control[] iConnCtls = null;
    private Long iConnectTimeout;
    private boolean iContextPoolEnabled = true;
    private List<TimedDirContext> iContexts = null;
    private Hashtable<String, Object> iEnvironment = null;
    private final List<HostPort> iFailoverServers = new ArrayList<HostPort>();
    private int iInitPoolSize = 1;
    private long iLastQueryTime = System.currentTimeMillis() / 1000L;
    private int iLiveContexts = 0;
    private final Object iLock = new Object(){
        static final long serialVersionUID = -3208219748235743201L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager$1", 1.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
        }
    };
    private int iMaxPoolSize = 0;
    private long iPoolCreateTimestampMillisec = 0L;
    private long iPoolCreateTimestampSeconds = 0L;
    private long iPoolTimeOut = 0L;
    private long iPoolWaitTime = 3000L;
    private int iPrefPoolSize = 3;
    private HostPort iPrimaryServer;
    private long iQueryInterval = 900L;
    private Long iReadTimeout;
    private String iReferral = "ignore";
    private boolean iReturnToPrimary = false;
    private String iSSLAlias = null;
    private boolean iSSLEnabled;
    private boolean iWriteToSecondary = false;
    static final long serialVersionUID = -7718373633716467484L;

    public void addFailoverServer(String hostname, int port) {
        this.iFailoverServers.add(new HostPort(hostname, port));
    }

    public void checkWritePermission(TimedDirContext ctx) throws OperationNotSupportedException {
        if (!this.iWriteToSecondary) {
            String providerURL = this.getProviderURL(ctx);
            if (!this.getPrimaryURL().equalsIgnoreCase(providerURL)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"WRITE_TO_SECONDARY_SERVERS_NOT_ALLOWED", (Object[])WIMMessageHelper.generateMsgParms((Object)providerURL));
                throw new OperationNotSupportedException("WRITE_TO_SECONDARY_SERVERS_NOT_ALLOWED", msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={NamingException.class})
    private TimedDirContext checkPrimaryServer(TimedDirContext ctx, String currentURL, long currentTimeSeconds) throws WIMSystemException {
        String METHODNAME = "checkPrimaryServer";
        if (this.iReturnToPrimary && currentTimeSeconds - this.iLastQueryTime > this.iQueryInterval) {
            try {
                String primaryURL = this.getPrimaryURL();
                if (!primaryURL.equalsIgnoreCase(currentURL)) {
                    boolean primaryOK;
                    block19: {
                        Hashtable<String, Object> env = this.getEnvironment(0, primaryURL);
                        primaryOK = false;
                        try {
                            TimedDirContext testCtx;
                            block18: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Ping primary server '" + primaryURL + "'..."), (Object[])new Object[0]);
                                }
                                testCtx = this.createDirContext(env);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Ping primary server '" + primaryURL + "': success"), (Object[])new Object[0]);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
                                }
                                primaryOK = true;
                                if (ctx != null) {
                                    TimedDirContext tempCtx = ctx;
                                    try {
                                        tempCtx.close();
                                    }
                                    catch (NamingException e) {
                                        if (!tc.isDebugEnabled()) break block18;
                                        Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                                    }
                                }
                            }
                            ctx = testCtx;
                        }
                        catch (NamingException e) {
                            if (tc.isInfoEnabled()) {
                                Tr.info((TraceComponent)tc, (String)"CANNOT_CONNECT_TO_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)primaryURL));
                            }
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Ping primary server '" + primaryURL + "': fail"), (Object[])new Object[0]);
                        }
                    }
                    if (primaryOK && this.iContextPoolEnabled) {
                        Object object = this.iLock;
                        synchronized (object) {
                            if (!this.getActiveURL().equalsIgnoreCase(primaryURL)) {
                                this.createContextPool(this.iLiveContexts - 1, primaryURL);
                                ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                            }
                        }
                    }
                }
                this.iLastQueryTime = currentTimeSeconds;
            }
            catch (NamingException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        return ctx;
    }

    @FFDCIgnore(value={NamingException.class})
    private void closeContextPool(List<TimedDirContext> contexts) {
        String METHODNAME = "closeContextPool";
        if (contexts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeContextPool Context pool being closed by " + Thread.currentThread() + ", Context pool size=" + contexts.size()), (Object[])new Object[0]);
            }
            for (int i = 0; i < contexts.size(); ++i) {
                TimedDirContext context = contexts.get(i);
                try {
                    context.close();
                    --this.iLiveContexts;
                    continue;
                }
                catch (NamingException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("closeContextPool Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createContextPool(Integer poolSize, String providerURL) throws NamingException {
        String METHODNAME = "createContextPool";
        if (providerURL == null) {
            providerURL = this.getPrimaryURL();
        }
        if (poolSize == null) {
            poolSize = 1;
        }
        if (this.iContextPoolEnabled) {
            long currentTimeMillisec = System.currentTimeMillis();
            long currentTimeSeconds = ContextManager.roundToSeconds(currentTimeMillisec);
            if (currentTimeMillisec - this.iPoolCreateTimestampMillisec > 1000L) {
                Vector<TimedDirContext> contexts = new Vector<TimedDirContext>(poolSize);
                Hashtable<String, Object> env = this.getEnvironment(1, providerURL);
                String currentURL = null;
                try {
                    for (int i = 0; i < poolSize; ++i) {
                        TimedDirContext ctx = this.createDirContext(env, currentTimeSeconds);
                        currentURL = this.getProviderURL(ctx);
                        if (!providerURL.equalsIgnoreCase(currentURL)) {
                            env = this.getEnvironment(1, currentURL);
                            providerURL = currentURL;
                        }
                        contexts.add(ctx);
                    }
                }
                catch (NamingException i) {
                    void e;
                    FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"399", (Object)this, (Object[])new Object[]{poolSize, providerURL});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createContextPool Context Pool creation FAILED for " + Thread.currentThread() + ", iLiveContext=" + this.iLiveContexts), (Object[])new Object[]{e});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createContextPool Cleanup contexts in temp pool: " + contexts.size()), (Object[])new Object[0]);
                    }
                    for (int j = 0; j < contexts.size(); ++j) {
                        try {
                            TimedDirContext ctx = (TimedDirContext)contexts.get(j);
                            ctx.close();
                            continue;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"410", (Object)this, (Object[])new Object[]{poolSize, providerURL});
                        }
                    }
                    throw e;
                }
                this.iLiveContexts += poolSize.intValue();
                this.setActiveURL(providerURL);
                List<TimedDirContext> oldCtxs = this.iContexts;
                this.iContexts = contexts;
                this.iPoolCreateTimestampSeconds = currentTimeSeconds;
                this.iPoolCreateTimestampMillisec = currentTimeMillisec;
                this.closeContextPool(oldCtxs);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createContextPool Active Provider URL: " + this.getActiveURL()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("createContextPool ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[]{", iPoolCreateTimestampSeconds=" + this.iPoolCreateTimestampSeconds});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createContextPool Pool has already been purged within past second... skipping purge", (Object[])new Object[0]);
            }
        } else {
            this.setActiveURL(providerURL);
        }
    }

    private TimedDirContext createDirContext(Hashtable<String, Object> env) throws NamingException {
        return this.createDirContext(env, ContextManager.roundToSeconds(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private TimedDirContext createDirContext(Hashtable<String, Object> env, long createTimestamp) throws NamingException {
        Object o = env.get("java.naming.security.credentials");
        if (o instanceof ProtectedString) {
            ProtectedString sps = (ProtectedString)env.get("java.naming.security.credentials");
            String password = sps == null ? "" : new String(sps.getChars());
            String decodedPassword = PasswordUtil.passwordDecode((String)password.trim());
            env.put("java.naming.security.credentials", decodedPassword);
        }
        SSLUtilImpl sslUtil = new SSLUtilImpl();
        Properties currentSSLProps = sslUtil.getSSLPropertiesOnThread();
        try {
            TimedDirContext timedDirContext;
            if (this.iSSLAlias != null) {
                try {
                    sslUtil.setSSLAlias(this.iSSLAlias, env);
                }
                catch (Exception decodedPassword) {
                    void ssle;
                    FFDCFilter.processException((Throwable)decodedPassword, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"478", (Object)this, (Object[])new Object[]{env, createTimestamp});
                    throw new NamingException(ssle.getMessage());
                }
            }
            ClassLoader origCL = ContextManager.getContextClassLoader();
            ContextManager.setContextClassLoader(this.getClass());
            try {
                TimedDirContext ctx = new TimedDirContext(env, this.getConnectionRequestControls(), createTimestamp);
                String newURL = this.getProviderURL(ctx);
                if (!this.iContextPoolEnabled && !newURL.equalsIgnoreCase(this.getActiveURL())) {
                    this.setActiveURL(newURL);
                }
                timedDirContext = ctx;
            }
            catch (Throwable throwable) {
                ContextManager.setContextClassLoader(origCL);
                throw throwable;
            }
            ContextManager.setContextClassLoader(origCL);
            return timedDirContext;
        }
        finally {
            sslUtil.setSSLPropertiesOnThread(currentSSLProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NamingException.class})
    public TimedDirContext createDirContext(String principal, byte[] credential) throws NamingException {
        String METHODNAME = "createDirContext(String, byte[])";
        String activeURL = this.getActiveURL();
        Hashtable<String, Object> environment = this.getEnvironment(0, activeURL);
        environment.put("java.naming.security.principal", principal);
        environment.put("java.naming.security.credentials", credential);
        SSLUtilImpl sslUtil = new SSLUtilImpl();
        Properties currentSSLProps = sslUtil.getSSLPropertiesOnThread();
        try {
            TimedDirContext timedDirContext;
            if (this.iSSLAlias != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"createDirContext(String, byte[]) Use WAS SSL Configuration.", (Object[])new Object[0]);
                    }
                    sslUtil.setSSLAlias(this.iSSLAlias, environment);
                }
                catch (Exception exception) {
                    void ssle;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"531", (Object)this, (Object[])new Object[]{principal, credential});
                    throw new NamingException(ssle.getMessage());
                }
            }
            ClassLoader origCL = ContextManager.getContextClassLoader();
            ContextManager.setContextClassLoader(this.getClass());
            try {
                TimedDirContext ctx = null;
                try {
                    ctx = new TimedDirContext(environment, this.getConnectionRequestControls(), ContextManager.roundToSeconds(System.currentTimeMillis()));
                }
                catch (NamingException e) {
                    if (!ContextManager.isConnectionException(e)) {
                        throw e;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Encountered an exception while creating a context: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    environment = this.getEnvironment(1, this.getNextURL(activeURL));
                    environment.put("java.naming.security.principal", principal);
                    environment.put("java.naming.security.credentials", credential);
                    ctx = new TimedDirContext(environment, this.getConnectionRequestControls(), ContextManager.roundToSeconds(System.currentTimeMillis()));
                    String newURL = this.getProviderURL(ctx);
                    long creationTimeMillisec = System.currentTimeMillis();
                    Object object = this.iLock;
                    synchronized (object) {
                        if (creationTimeMillisec > this.iPoolCreateTimestampMillisec) {
                            this.createContextPool(this.iLiveContexts, newURL);
                            ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                        }
                    }
                }
                timedDirContext = ctx;
            }
            catch (Throwable throwable) {
                ContextManager.setContextClassLoader(origCL);
                throw throwable;
            }
            ContextManager.setContextClassLoader(origCL);
            return timedDirContext;
        }
        finally {
            sslUtil.setSSLPropertiesOnThread(currentSSLProps);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DirContext createSubcontext(String name, Attributes attrs) throws OperationNotSupportedException, WIMSystemException, EntityAlreadyExistsException, EntityNotFoundException {
        DirContext dirContext;
        block14: {
            String METHODNAME = "createSubcontext";
            dirContext = null;
            TimedDirContext ctx = this.getDirContext();
            this.checkWritePermission(ctx);
            try {
                try {
                    long startTime = System.currentTimeMillis();
                    dirContext = ctx.createSubcontext(new LdapName(name), attrs);
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime > 1000L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("createSubcontext **LDAPConnect time: " + (endTime - startTime) + " ms, lock held " + Thread.holdsLock(this.iLock) + ", principal=" + name), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                    this.handleBindStat(endTime - startTime);
                }
                catch (NamingException startTime) {
                    void e;
                    FFDCFilter.processException((Throwable)startTime, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"607", (Object)this, (Object[])new Object[]{name, attrs});
                    if (!ContextManager.isConnectionException((NamingException)e)) {
                        throw e;
                    }
                    ctx = this.reCreateDirContext(ctx, e.toString());
                    long startTime2 = System.currentTimeMillis();
                    dirContext = ctx.createSubcontext(new LdapName(name), attrs);
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime2 > 1000L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("createSubcontext **LDAPConnect time: " + (endTime - startTime2) + " ms, lock held " + Thread.holdsLock(this.iLock) + ", principal=" + name), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                    this.handleBindStat(endTime - startTime2);
                }
            }
            catch (NameAlreadyBoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"623", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_ALREADY_EXIST", (Object[])WIMMessageHelper.generateMsgParms((Object)name));
                throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", msg, (Throwable)e);
            }
            catch (NameNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"626", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"PARENT_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new EntityNotFoundException("PARENT_NOT_FOUND", msg, (Throwable)e);
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"629", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
            finally {
                this.releaseDirContext(ctx);
            }
        }
        return dirContext;
    }

    /*
     * WARNING - void declaration
     */
    public void destroySubcontext(String name) throws EntityHasDescendantsException, EntityNotFoundException, WIMSystemException {
        TimedDirContext ctx = this.getDirContext();
        try {
            try {
                ctx.destroySubcontext(new LdapName(name));
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"652", (Object)this, (Object[])new Object[]{name});
                if (!ContextManager.isConnectionException((NamingException)e)) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                ctx.destroySubcontext(new LdapName(name));
            }
        }
        catch (ContextNotEmptyException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"659", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_HAS_DESCENDENTS", (Object[])WIMMessageHelper.generateMsgParms((Object)name));
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", msg, (Throwable)e);
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"662", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"665", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.releaseDirContext(ctx);
        }
    }

    private static String formatIPv6Addr(String host) {
        if (host == null) {
            return null;
        }
        return "[" + host + "]";
    }

    @Trivial
    private String getActiveURL() {
        return (String)this.iEnvironment.get(ENVKEY_ACTIVE_URL);
    }

    private Control[] getConnectionRequestControls() {
        return this.iConnCtls;
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -8324954484656988933L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager$2", 2.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class, NamingException.class})
    public TimedDirContext getDirContext() throws WIMSystemException {
        String METHODNAME = "getDirContext";
        TimedDirContext ctx = null;
        long currentTimeSeconds = ContextManager.roundToSeconds(System.currentTimeMillis());
        if (this.iContextPoolEnabled) {
            do {
                Object object = this.iLock;
                synchronized (object) {
                    if (this.iContexts == null) {
                        try {
                            this.createContextPool(this.iInitPoolSize, null);
                        }
                        catch (NamingException e) {
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                        }
                    }
                    if (this.iContexts.size() > 0) {
                        ctx = this.iContexts.remove(this.iContexts.size() - 1);
                    } else {
                        if (this.iLiveContexts >= this.iMaxPoolSize && this.iMaxPoolSize != 0) {
                            try {
                                this.iLock.wait(this.iPoolWaitTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                        ++this.iLiveContexts;
                    }
                }
                TimedDirContext oldCtx = null;
                if (ctx != null) {
                    if (this.iPoolTimeOut > 0L && currentTimeSeconds - ctx.getPoolTimestamp() > this.iPoolTimeOut) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getDirContext ContextPool: context is time out. currentTime=" + currentTimeSeconds + ", createTime=" + ctx.getPoolTimestamp() + ", iPoolTimeOut=" + this.iPoolTimeOut), (Object[])new Object[0]);
                        }
                        oldCtx = ctx;
                        ctx = null;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getDirContext ContextPool: no free context, create a new one...", (Object[])new Object[0]);
                }
                if ((ctx = this.checkPrimaryServer(ctx, this.getActiveURL(), currentTimeSeconds)) == null) {
                    try {
                        ctx = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                    }
                    catch (NamingException e) {
                        --this.iLiveContexts;
                        String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                        throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                    }
                }
                if (oldCtx == null) continue;
                try {
                    oldCtx.close();
                }
                catch (NamingException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getDirContext Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                }
            } while (ctx == null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDirContext ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size() + ", currentTime=" + currentTimeSeconds + ", createTime=" + ctx.getPoolTimestamp()), (Object[])new Object[0]);
            }
        } else {
            try {
                ctx = this.checkPrimaryServer(null, this.getActiveURL(), currentTimeSeconds);
                if (ctx == null) {
                    ctx = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
                    }
                }
            }
            catch (NamingException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        return ctx;
    }

    private Hashtable<String, Object> getEnvironment(int type, String startingURL) {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.iEnvironment);
        List urlList = (List)env.remove(ENVKEY_URL_LIST);
        int numURLs = urlList.size();
        int startingURLIndex = this.getURLIndex(startingURL, urlList);
        String ldapUrl = null;
        for (int i = startingURLIndex; i < startingURLIndex + numURLs; ++i) {
            ldapUrl = i > startingURLIndex ? ldapUrl + " " + (String)urlList.get(i % numURLs) : (String)urlList.get(i % numURLs);
            if (type == 0) break;
        }
        env.put("java.naming.provider.url", ldapUrl);
        env.remove(ENVKEY_ACTIVE_URL);
        return env;
    }

    @Trivial
    private List<String> getEnvURLList() {
        return (List)this.iEnvironment.get(ENVKEY_URL_LIST);
    }

    @Trivial
    private String getNextURL(String currentURL) {
        List<String> urlList = this.getEnvURLList();
        int urlIndex = this.getURLIndex(currentURL, urlList);
        return urlList.get((urlIndex + 1) % urlList.size());
    }

    @Trivial
    private String getPrimaryURL() {
        return this.getEnvURLList().get(0);
    }

    @Trivial
    @FFDCIgnore(value={NamingException.class})
    private String getProviderURL(TimedDirContext ctx) {
        try {
            return (String)ctx.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getProviderURL", (Object[])new Object[]{e.toString(true)});
            }
            return "(null)";
        }
    }

    private int getURLIndex(String url, List<String> urlList) {
        int urlIndex = 0;
        int numURLs = urlList.size();
        if (url != null) {
            for (int i = 0; i < numURLs; ++i) {
                if (!urlList.get(i).equalsIgnoreCase(url)) continue;
                urlIndex = i;
                break;
            }
        }
        return urlIndex;
    }

    private void handleBindStat(long elapsedTime) {
        long lastUpdated;
        long now;
        String METHODNAME = "handleBindStat(long)";
        if (elapsedTime < 1000L) {
            QUICK_LDAP_BIND.getAndIncrement();
        }
        if ((now = System.currentTimeMillis()) - LDAP_STATS_TIMER.get() > 1800000L && now - (lastUpdated = LDAP_STATS_TIMER.getAndSet(now)) > 1800000L && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " **LDAPBindStat: " + QUICK_LDAP_BIND.get() + " binds took less then " + 1000 + " ms"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public InitializeResult initialize() throws WIMApplicationException {
        ArrayList<String> urlList;
        block18: {
            String METHODNAME = "initialize";
            this.iEnvironment = new Hashtable();
            this.iEnvironment.put("java.naming.factory.initial", LDAP_SUN_SPI);
            String urlPrefix = null;
            if (this.iSSLEnabled) {
                this.iEnvironment.put(LDAP_ENV_PROP_FACTORY_SOCKET, WAS_SSL_SOCKET_FACTORY);
                this.iEnvironment.put("java.naming.security.protocol", "ssl");
                urlPrefix = LDAP_URL_SSL_PREFIX;
            } else {
                urlPrefix = LDAP_URL_PREFIX;
            }
            urlList = new ArrayList<String>();
            if (this.iPrimaryServer == null || this.iPrimaryServer.hostname == null || this.iPrimaryServer.hostname.trim().isEmpty()) {
                return InitializeResult.MISSING_PRIMARY_SERVER;
            }
            String mainHost = this.iPrimaryServer.hostname;
            int mainPort = this.iPrimaryServer.port;
            urlList.add(urlPrefix + mainHost.trim() + ":" + mainPort);
            for (HostPort failoverServer : this.iFailoverServers) {
                String ldapHost = failoverServer.hostname;
                if (ldapHost == null || ldapHost.trim().isEmpty()) continue;
                if (!(ldapHost.startsWith("[") && ldapHost.endsWith("]") || !ContextManager.isIPv6Addr(ldapHost))) {
                    ldapHost = ContextManager.formatIPv6Addr(ldapHost);
                }
                if (failoverServer.port == null) continue;
                urlList.add(urlPrefix + ldapHost.trim() + ":" + failoverServer.port);
            }
            if (urlList != null && urlList.size() > 0) {
                String url = (String)urlList.get(0);
                this.iEnvironment.put(ENVKEY_URL_LIST, urlList);
                this.iEnvironment.put(ENVKEY_ACTIVE_URL, url);
                this.iEnvironment.put("java.naming.provider.url", url);
            }
            if (this.iBindDN != null && !this.iBindDN.isEmpty()) {
                this.iEnvironment.put("java.naming.security.principal", this.iBindDN);
                SerializableProtectedString sps = this.iBindPassword;
                String password = sps == null ? "" : new String(sps.getChars());
                String decodedPassword = PasswordUtil.passwordDecode((String)password.trim());
                if (decodedPassword == null || decodedPassword.length() == 0) {
                    return InitializeResult.MISSING_PASSWORD;
                }
                this.iEnvironment.put("java.naming.security.credentials", new ProtectedString(decodedPassword.toCharArray()));
            }
            if (this.iConnectTimeout != null) {
                this.iEnvironment.put(LDAP_ENV_PROP_CONNECT_TIMEOUT, this.iConnectTimeout.toString());
            } else {
                this.iEnvironment.put(LDAP_ENV_PROP_CONNECT_TIMEOUT, String.valueOf(60000L));
            }
            if (this.iReadTimeout != null) {
                this.iEnvironment.put(LDAP_ENV_PROP_READ_TIMEOUT, this.iReadTimeout.toString());
            } else {
                this.iEnvironment.put(LDAP_ENV_PROP_READ_TIMEOUT, String.valueOf(60000L));
            }
            this.iEnvironment.put("java.naming.referral", this.iReferral);
            if (this.iBinaryAttributeNames != null && this.iBinaryAttributeNames.length() > 0) {
                this.iEnvironment.put(LDAP_ENV_PROP_ATTRIBUTES_BINARY, this.iBinaryAttributeNames);
            }
            try {
                this.createContextPool(this.iInitPoolSize, null);
            }
            catch (NamingException sps) {
                void e;
                FFDCFilter.processException((Throwable)sps, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"1105", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug((TraceComponent)tc, (String)("initialize Can not create context pool: " + e.toString(true)), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("\nLDAP Server(s): ").append(urlList).append("\n");
            strBuf.append("\tBind DN: ").append(this.iBindDN).append("\n");
            strBuf.append("\tReferral: ").append(this.iReferral).append("\n");
            strBuf.append("\tBinary Attributes: ").append(this.iBinaryAttributeNames).append("\n");
            if (this.iContextPoolEnabled) {
                strBuf.append("\nContext Pool is enabled: ").append("\n");
                strBuf.append("\tInitPoolSize: ").append(this.iInitPoolSize).append("\n");
                strBuf.append("\tMaxPoolSize: ").append(this.iMaxPoolSize).append("\n");
                strBuf.append("\tPrefPoolSize: ").append(this.iPrefPoolSize).append("\n");
                strBuf.append("\tPoolTimeOut: ").append(this.iPoolTimeOut).append("\n");
                strBuf.append("\tPoolWaitTime: ").append(this.iPoolWaitTime);
            } else {
                strBuf.append("\nContext Pool is disabled");
            }
            Tr.debug((TraceComponent)tc, (String)("initialize" + strBuf.toString()), (Object[])new Object[0]);
        }
        return InitializeResult.SUCCESS;
    }

    public static boolean isConnectionException(NamingException e) {
        return e instanceof CommunicationException || e instanceof ServiceUnavailableException;
    }

    private static boolean isIPv6Addr(String host) {
        if (host != null) {
            if (host.contains("[") && host.contains("]")) {
                host = host.substring(host.indexOf("[") + 1, host.indexOf("]"));
            }
            host = host.toLowerCase();
            Pattern p1 = Pattern.compile("^(?:(?:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9](?::|$)){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))$");
            Pattern p2 = Pattern.compile("^(\\d{1,3}\\.){3}\\d{1,3}$");
            Matcher m1 = p1.matcher(host);
            boolean b1 = m1.matches();
            Matcher m2 = p2.matcher(host);
            boolean b2 = !m2.matches();
            return b1 && b2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TimedDirContext reCreateDirContext(TimedDirContext oldCtx, String errorMessage) throws WIMSystemException {
        String METHODNAME = "DirContext reCreateDirContext(String errorMessage)";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DirContext reCreateDirContext(String errorMessage) Communication exception occurs: " + errorMessage + " Creating a new connection."), (Object[])new Object[0]);
        }
        try {
            TimedDirContext ctx;
            Long oldCreateTimeStampSeconds = oldCtx.getCreateTimestamp();
            if (oldCreateTimeStampSeconds < this.iPoolCreateTimestampSeconds) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DirContext reCreateDirContext(String errorMessage) Pool refreshed, skip to getDirContext. oldCreateTimeStamp: " + oldCreateTimeStampSeconds + " iPoolCreateTimestampSeconds:" + this.iPoolCreateTimestampSeconds), (Object[])new Object[0]);
                }
                ctx = this.getDirContext();
            } else {
                String oldURL = this.getProviderURL(oldCtx);
                ctx = this.createDirContext(this.getEnvironment(1, this.getNextURL(oldURL)));
                String newURL = this.getProviderURL(ctx);
                Object object = this.iLock;
                synchronized (object) {
                    if (oldCtx.getCreateTimestamp() >= this.iPoolCreateTimestampSeconds) {
                        this.createContextPool(this.iLiveContexts - 1, newURL);
                        ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                    }
                }
            }
            oldCtx.close();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
            }
            return ctx;
        }
        catch (NamingException oldCreateTimeStampSeconds) {
            void e;
            FFDCFilter.processException((Throwable)oldCreateTimeStampSeconds, (String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager", (String)"1220", (Object)this, (Object[])new Object[]{oldCtx, errorMessage});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={NamingException.class})
    public void releaseDirContext(TimedDirContext ctx) throws WIMSystemException {
        String METHODNAME = "releaseDirContext";
        if (this.iContextPoolEnabled) {
            Object object = this.iLock;
            synchronized (object) {
                if (this.iContexts.size() >= this.iPrefPoolSize || this.iMaxPoolSize != 0 && this.iLiveContexts > this.iMaxPoolSize || ctx.getCreateTimestamp() < this.iPoolCreateTimestampSeconds || !this.getProviderURL(ctx).equalsIgnoreCase(this.getActiveURL())) {
                    try {
                        --this.iLiveContexts;
                        ctx.close();
                    }
                    catch (NamingException e) {
                        String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                        throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"releaseDirContext Context is discarded.", (Object[])new Object[0]);
                    }
                } else {
                    if (this.iContexts != null && this.iContexts.size() > 0 && this.iContexts.contains(ctx)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("releaseDirContext Context already present in Context pool. No need to add it again to context pool.  ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
                        }
                    } else {
                        if (this.iContexts != null) {
                            this.iContexts.add(ctx);
                        }
                        if (this.iPoolTimeOut > 0L) {
                            ctx.setPoolTimeStamp(ContextManager.roundToSeconds(System.currentTimeMillis()));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("releaseDirContext Before Notifying the waiting threads and Context is back to pool.  ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
                        }
                    }
                    this.iLock.notifyAll();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"releaseDirContext Context is back to pool.", (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releaseDirContext ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
            }
        } else {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
    }

    private static long roundToSeconds(long timeInMilliseconds) {
        long returnInSeconds = timeInMilliseconds / 1000L;
        if (timeInMilliseconds % 1000L > 499L) {
            ++returnInSeconds;
        }
        return returnInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void setActiveURL(String activeURL) {
        Object object = this.iLock;
        synchronized (object) {
            this.iEnvironment.put(ENVKEY_ACTIVE_URL, activeURL);
        }
    }

    public void setBinaryAttributeNames(String binaryAttributeNames) {
        this.iBinaryAttributeNames = binaryAttributeNames;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.iConnectTimeout = connectTimeout;
    }

    private static void setContextClassLoader(final Class<?> clazz) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 1517388992439898390L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager$3", 3.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 4003056503640165517L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.adapter.ldap.context.ContextManager$4", 4.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
            }
        });
    }

    public void setContextPool(boolean enableContextPool, Integer initPoolSize, Integer prefPoolSize, Integer maxPoolSize, Long poolTimeOut, Long poolWaitTime) throws InvalidInitPropertyException {
        String METHODNAME = "setContextPool";
        this.iContextPoolEnabled = enableContextPool;
        if (this.iContextPoolEnabled) {
            this.iInitPoolSize = initPoolSize == null ? 1 : initPoolSize;
            this.iMaxPoolSize = maxPoolSize == null ? 0 : maxPoolSize;
            this.iPrefPoolSize = prefPoolSize == null ? 3 : prefPoolSize;
            this.iPoolTimeOut = poolTimeOut == null ? 0L : poolTimeOut;
            long l = this.iPoolWaitTime = poolWaitTime == null ? 3000L : poolWaitTime;
            if (this.iMaxPoolSize != 0 && this.iMaxPoolSize < this.iInitPoolSize) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"INIT_POOL_SIZE_TOO_BIG", (Object[])WIMMessageHelper.generateMsgParms((Object)this.iInitPoolSize, (Object)this.iMaxPoolSize));
                throw new InvalidInitPropertyException("INIT_POOL_SIZE_TOO_BIG", msg);
            }
            if (this.iMaxPoolSize != 0 && this.iPrefPoolSize != 0 && this.iMaxPoolSize < this.iPrefPoolSize) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"PREF_POOL_SIZE_TOO_BIG", (Object[])WIMMessageHelper.generateMsgParms((Object)this.iInitPoolSize, (Object)this.iMaxPoolSize));
                throw new InvalidInitPropertyException("PREF_POOL_SIZE_TOO_BIG", msg);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setContextPool Context Pool is disabled.", (Object[])new Object[0]);
        }
    }

    public void setPrimaryServer(String hostname, int port) {
        this.iPrimaryServer = new HostPort(hostname, port);
    }

    public void setQueryInterval(long queryInterval) {
        this.iQueryInterval = queryInterval;
    }

    public void setReadTimeout(Long readTimeout) {
        this.iReadTimeout = readTimeout;
    }

    public void setReferral(String referral) {
        this.iReferral = referral;
    }

    public void setReturnToPrimary(boolean returnToPrimary) {
        this.iReturnToPrimary = returnToPrimary;
    }

    public void setSimpleCredentials(String bindDn, SerializableProtectedString bindPassword) {
        this.iBindDN = bindDn;
        this.iBindPassword = bindPassword;
    }

    public void setSSLAlias(String sslAlias) {
        this.iSSLAlias = sslAlias;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.iSSLEnabled = sslEnabled;
    }

    public void setWriteToSecondary(boolean writeToSecondary) {
        this.iWriteToSecondary = writeToSecondary;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ContextManager {");
        sb.append("iBindDN=").append(this.iBindDN);
        sb.append(", iBindPassword=").append(this.iBindPassword);
        sb.append(", iSSLAlias=").append(this.iSSLAlias);
        sb.append(", iSSLEnabled=").append(this.iSSLEnabled);
        sb.append(", iConnectTimeout=").append(this.iConnectTimeout);
        sb.append(", iReadTimeout=").append(this.iReadTimeout);
        sb.append(", iPrimaryServer=").append(this.iPrimaryServer);
        sb.append(", iFailoverServers=").append(this.iFailoverServers);
        sb.append(", iContextPoolEnabled=").append(this.iContextPoolEnabled);
        sb.append(", iInitPoolSize=").append(this.iInitPoolSize);
        sb.append(", iPrefPoolSize=").append(this.iPrefPoolSize);
        sb.append(", iMaxPoolSize=").append(this.iMaxPoolSize);
        sb.append(", iPoolTimeOut=").append(this.iPoolTimeOut);
        sb.append(", iPoolWaitTime=").append(this.iPoolWaitTime);
        sb.append(", iWriteToSecondary=").append(this.iWriteToSecondary);
        sb.append(", iQueryInterval=").append(this.iQueryInterval);
        sb.append(", iReturnToPrimary=").append(this.iReturnToPrimary);
        sb.append(", iReferral=").append(this.iReferral);
        sb.append(", iBinaryAttributeNames=").append(this.iBinaryAttributeNames);
        sb.append("}");
        return sb.toString();
    }

    @Trivial
    public static enum InitializeResult {
        MISSING_PASSWORD,
        MISSING_PRIMARY_SERVER,
        SUCCESS;

    }

    @Trivial
    private class HostPort {
        final String hostname;
        final Integer port;

        HostPort(String hostname, Integer port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }
    }
}

