/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DeferrableScheduledExecutorImpl
implements ScheduledExecutorService {
    static final long PERIOD_MILLISECONDS;
    private ScheduledExecutorService executor;
    static final long serialVersionUID = 117550544710569826L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static long roundUpDelay(long delay, TimeUnit unit, long now) {
        long target;
        if (delay < 0L) {
            delay = 0L;
        }
        if ((target = now + unit.toMillis(delay)) < now) {
            return delay;
        }
        long remainder = target % PERIOD_MILLISECONDS;
        if (remainder == 0L) {
            return delay;
        }
        long extra = PERIOD_MILLISECONDS - remainder;
        long newDelay = delay + unit.convert(extra, TimeUnit.MILLISECONDS);
        if (newDelay < delay) {
            return delay;
        }
        return newDelay;
    }

    private static long roundUpDelay(long delay, TimeUnit unit) {
        return DeferrableScheduledExecutorImpl.roundUpDelay(delay, unit, System.currentTimeMillis());
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void unsetExecutor(ScheduledExecutorService executor) {
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, DeferrableScheduledExecutorImpl.roundUpDelay(delay, unit), unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, DeferrableScheduledExecutorImpl.roundUpDelay(delay, unit), unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, DeferrableScheduledExecutorImpl.roundUpDelay(initialDelay, unit), DeferrableScheduledExecutorImpl.roundUpDelay(period, unit, 0L), unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, DeferrableScheduledExecutorImpl.roundUpDelay(initialDelay, unit), delay, unit);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.DeferrableScheduledExecutorImpl", DeferrableScheduledExecutorImpl.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        PERIOD_MILLISECONDS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.SECONDS);
    }
}

