/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.mp.ContextualBiConsumer;
import com.ibm.ws.concurrent.mp.ContextualBiFunction;
import com.ibm.ws.concurrent.mp.ContextualCallable;
import com.ibm.ws.concurrent.mp.ContextualConsumer;
import com.ibm.ws.concurrent.mp.ContextualExecutor;
import com.ibm.ws.concurrent.mp.ContextualFunction;
import com.ibm.ws.concurrent.mp.ContextualRunnable;
import com.ibm.ws.concurrent.mp.ContextualSupplier;
import com.ibm.ws.concurrent.mp.ManagedCompletableFuture;
import com.ibm.ws.concurrent.mp.ManagedCompletionStage;
import com.ibm.ws.concurrent.mp.UnusableExecutor;
import com.ibm.ws.concurrent.service.AbstractContextService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.concurrent.ContextService;
import org.eclipse.microprofile.context.ThreadContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.context.service", configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceFactory.class, ContextService.class, ThreadContext.class, WSContextService.class, ApplicationRecycleComponent.class}, property={"creates.objectClass=javax.enterprise.concurrent.ContextService", "creates.objectClass=org.eclipse.microprofile.context.ThreadContext"})
public class ContextServiceImpl
extends AbstractContextService
implements ThreadContext {
    private static final TraceComponent tc = Tr.register(ContextServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    static final long serialVersionUID = 469764038213639364L;

    @Trivial
    @Activate
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        if (callable instanceof ContextualCallable) {
            throw new IllegalArgumentException(ContextualCallable.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualCallable<R>(contextDescriptor, callable);
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        if (consumer instanceof ContextualBiConsumer) {
            throw new IllegalArgumentException(ContextualBiConsumer.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualBiConsumer<T, U>(contextDescriptor, consumer);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        if (consumer instanceof ContextualConsumer) {
            throw new IllegalArgumentException(ContextualConsumer.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualConsumer<T>(contextDescriptor, consumer);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        if (function instanceof ContextualBiFunction) {
            throw new IllegalArgumentException(ContextualBiFunction.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualBiFunction<T, U, R>(contextDescriptor, function);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        if (function instanceof ContextualFunction) {
            throw new IllegalArgumentException(ContextualFunction.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualFunction<T, R>(contextDescriptor, function);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        if (runnable instanceof ContextualRunnable) {
            throw new IllegalArgumentException(ContextualRunnable.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualRunnable(contextDescriptor, runnable);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        if (supplier instanceof ContextualSupplier) {
            throw new IllegalArgumentException(ContextualSupplier.class.getSimpleName());
        }
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualSupplier<R>(contextDescriptor, supplier);
    }

    @Trivial
    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        if (instance instanceof ContextualAction) {
            throw new IllegalArgumentException(instance.getClass().getSimpleName());
        }
        return super.createContextualProxy(instance, (Class[])interfaces);
    }

    @Trivial
    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        if (instance instanceof ContextualAction) {
            throw new IllegalArgumentException(instance.getClass().getSimpleName());
        }
        return super.createContextualProxy(instance, executionProperties, (Class[])interfaces);
    }

    @Trivial
    public <T> T createContextualProxy(T instance, Class<T> intf) {
        if (instance instanceof ContextualAction) {
            throw new IllegalArgumentException(instance.getClass().getSimpleName());
        }
        return (T)super.createContextualProxy(instance, intf);
    }

    @Trivial
    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        if (instance instanceof ContextualAction) {
            throw new IllegalArgumentException(instance.getClass().getSimpleName());
        }
        return (T)super.createContextualProxy(instance, executionProperties, intf);
    }

    public Executor currentContextExecutor() {
        ThreadContextDescriptor contextDescriptor = this.captureThreadContext(Collections.emptyMap(), new Map[0]);
        return new ContextualExecutor(contextDescriptor);
    }

    @Trivial
    @Deactivate
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Trivial
    @Modified
    protected void modified(ComponentContext context) {
        super.modified(context);
    }

    @Trivial
    @Reference(name="baseInstance", service=ContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(id=unbound)")
    protected void setBaseInstance(ServiceReference<ContextService> ref) {
        super.setBaseInstance(ref);
    }

    @Trivial
    @Reference(name="threadContextManager", service=WSContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, target="(component.name=com.ibm.ws.context.manager)")
    protected void setThreadContextManager(WSContextService svc) {
        super.setThreadContextManager(svc);
    }

    @Trivial
    protected void unsetBaseInstance(ServiceReference<ContextService> ref) {
        super.unsetBaseInstance(ref);
    }

    @Trivial
    protected void unsetThreadContextManager(WSContextService svc) {
        super.unsetThreadContextManager(svc);
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> stage) {
        UnusableExecutor executor = new UnusableExecutor((WSContextService)this);
        ManagedCompletableFuture newCompletableFuture = ManagedCompletableFuture.JAVA8 ? new ManagedCompletableFuture(new CompletableFuture(), executor, null) : new ManagedCompletableFuture(executor, null);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newCompletableFuture.complete(result);
            } else {
                newCompletableFuture.completeExceptionally((Throwable)failure);
            }
        });
        return newCompletableFuture;
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage) {
        UnusableExecutor executor = new UnusableExecutor((WSContextService)this);
        ManagedCompletionStage newStage = ManagedCompletableFuture.JAVA8 ? new ManagedCompletionStage(new CompletableFuture(), executor, null) : new ManagedCompletionStage(executor);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newStage.super_complete(result);
            } else {
                newStage.super_completeExceptionally((Throwable)failure);
            }
        });
        return newStage;
    }
}

