/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.util.Arrays;

public final class HexConverter {
    private static final char[] NYBBLE_TO_HEX_CHAR = "0123456789abcdef".toCharArray();
    private static final byte[] HEX_CHAR_TO_NYBBLE = new byte[103];

    private static char[] octetsToAsciiChars(byte[] oct, int count) {
        assert (count <= oct.length);
        char[] result = new char[count * 2];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            result[pos++] = NYBBLE_TO_HEX_CHAR[oct[i] >> 4 & 0xF];
            result[pos++] = NYBBLE_TO_HEX_CHAR[oct[i] >> 0 & 0xF];
        }
        return result;
    }

    public static String octetsToAscii(byte[] oct, int count) {
        return new String(HexConverter.octetsToAsciiChars(oct, count));
    }

    public static byte[] asciiToOctets(String str, int offset) {
        int slen = str.length() - offset;
        if ((slen & 1) != 0) {
            return null;
        }
        byte[] oct = new byte[slen / 2];
        try {
            int j = offset;
            for (int i = 0; i < oct.length; ++i) {
                char highChar = str.charAt(j++);
                char lowChar = str.charAt(j++);
                byte high = HEX_CHAR_TO_NYBBLE[highChar];
                if (high < 0) {
                    return null;
                }
                byte low = HEX_CHAR_TO_NYBBLE[lowChar];
                if (low < 0) {
                    return null;
                }
                oct[i] = (byte)(high << 4 | low);
            }
            return oct;
        }
        catch (ArrayIndexOutOfBoundsException swallowed) {
            return null;
        }
    }

    public static byte[] asciiToOctets(String str) {
        return HexConverter.asciiToOctets(str, 0);
    }

    static {
        Arrays.fill(HEX_CHAR_TO_NYBBLE, (byte)-1);
        for (int i = 0; i < NYBBLE_TO_HEX_CHAR.length; i = (int)((byte)(i + 1))) {
            char c = NYBBLE_TO_HEX_CHAR[i];
            HexConverter.HEX_CHAR_TO_NYBBLE[c] = i;
            HexConverter.HEX_CHAR_TO_NYBBLE[Character.toUpperCase((char)c)] = i;
        }
    }
}

