/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.yoko.util.Cache;
import org.apache.yoko.util.Factory;
import org.apache.yoko.util.Fifa;
import org.apache.yoko.util.KeyedFactory;
import org.apache.yoko.util.Reference;
import org.apache.yoko.util.concurrent.ConcurrentFifo;
import org.apache.yoko.util.concurrent.CountedEntry;

public class ReferenceCountedCache<K, V>
implements Cache<K, V> {
    private final ConcurrentMap<K, CountedEntry<K, V>> map = new ConcurrentHashMap<K, CountedEntry<K, V>>();
    private final Fifa<CountedEntry<K, V>> idleEntries = new ConcurrentFifo<CountedEntry<K, V>>();
    private volatile int threshold;
    private volatile int sweep;
    private final Cache.Cleaner<V> cleaner;
    private final ReferenceQueue<Reference<V>> gcQueue;

    public ReferenceCountedCache(Cache.Cleaner<V> cleaner, int threshold, int sweep) {
        this.threshold = threshold;
        this.sweep = sweep;
        this.cleaner = cleaner;
        this.gcQueue = new ReferenceQueue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int idleCount() {
        return this.idleEntries.size();
    }

    @Override
    public Reference<V> get(K key) {
        CountedEntry entry = (CountedEntry)this.map.get(key);
        if (entry == null) {
            return null;
        }
        return this.track(entry.obtain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference<V> getOrCreate(K key, KeyedFactory<K, V> valueFactory) {
        CountedEntry<K, V> entry;
        CountedEntry.ValueReference result;
        do {
            CountedEntry<K, V> newEntry;
            if ((entry = (CountedEntry<K, V>)this.map.get(key)) != null || (entry = this.map.putIfAbsent(key, newEntry = new CountedEntry<K, V>(key, this.idleEntries))) != null) continue;
            Object value = null;
            try {
                value = valueFactory.create(key);
                CountedEntry.ValueReference valueReference = this.track(newEntry.setValue(value));
                return valueReference;
            }
            finally {
                if (value == null) {
                    newEntry.abort();
                    this.map.remove(key, newEntry);
                }
            }
        } while ((result = entry.obtain()) == null);
        return this.track(result);
    }

    protected CountedEntry.ValueReference track(CountedEntry.ValueReference ref) {
        return ref;
    }

    @Override
    public final Reference<V> getOrCreate(K key, final Factory<V> factory) {
        return this.getOrCreate(key, new KeyedFactory<K, V>(){

            @Override
            public V create(K key) {
                return factory.create();
            }
        });
    }

    @Override
    public void remove(Reference<V> ref) {
        this.remove(((CountedEntry.ValueReference)ref).invalidateAndGetEntry());
    }

    @Override
    public boolean remove(K key, V value) {
        if (key == null) {
            return false;
        }
        CountedEntry entry = (CountedEntry)this.map.get(key);
        try (CountedEntry.ValueReference ref = entry.obtain();){
            if (ref == null) {
                boolean bl = false;
                return bl;
            }
            if (ref.get() != value) {
                boolean bl = false;
                return bl;
            }
            this.remove(ref);
            boolean bl = true;
            return bl;
        }
    }

    protected void remove(CountedEntry<K, V> entry) {
        if (entry != null) {
            this.map.remove(entry.key, entry);
        }
    }

    @Override
    public int clean() {
        CountedEntry<K, V> e;
        if (this.size() <= this.threshold) {
            return 0;
        }
        int removed = 0;
        while (removed < this.sweep && (e = this.idleEntries.peek()) != null) {
            V clearedValue = e.clear();
            if (clearedValue == null) continue;
            if (!this.map.remove(e.key, e)) {
                throw new IllegalStateException("Entry already removed");
            }
            this.cleaner.clean(clearedValue);
            ++removed;
        }
        return removed;
    }

    @Override
    public Map<K, V> snapshot() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.map.entrySet()) {
            try {
                CountedEntry.ValueReference ref = ((CountedEntry)entry.getValue()).obtain();
                Throwable throwable = null;
                try {
                    result.put(entry.getKey(), ref.get());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref == null) continue;
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ref.close();
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return result;
    }
}

