/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.AsyncListenerEntry;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompleteRunnable
implements Runnable {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.CompleteRunnable";
    private IExtendedRequest iExtendedRequest;
    private AsyncContextImpl asyncContextImpl;
    private SRTServletRequestThreadData requestDataOnCompleteRequestThread;

    public CompleteRunnable(IExtendedRequest extendedRequest, AsyncContextImpl asyncContextImpl) {
        this.iExtendedRequest = extendedRequest;
        this.asyncContextImpl = asyncContextImpl;
        this.requestDataOnCompleteRequestThread = new SRTServletRequestThreadData();
        this.requestDataOnCompleteRequestThread.init(SRTServletRequestThreadData.getInstance());
    }

    @Override
    public void run() {
        WebContainerRequestState reqState;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "run", this);
        }
        if ((reqState = WebContainerRequestState.getInstance(false)) != null) {
            reqState.init();
        }
        SRTServletRequestThreadData.getInstance().init(this.requestDataOnCompleteRequestThread);
        try {
            this.invokeOnComplete();
        }
        catch (Exception e) {
            logger.logp(Level.FINE, CLASS_NAME, "run", "There was an exception during onComplete: " + e.getMessage());
        }
        finally {
            this.iExtendedRequest.closeResponseOutput();
            this.asyncContextImpl.setComplete(true);
            if (!this.asyncContextImpl.transferContext()) {
                this.asyncContextImpl.notifyITransferContextCompleteState();
            }
            this.asyncContextImpl.invalidate();
            WebContainer.getWebContainer().decrementNumRequests();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.exiting(CLASS_NAME, "run", this);
            }
        }
    }

    protected void invokeOnComplete() {
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - this.asyncContextImpl.getStartTime();
        List<AsyncListenerEntry> list = this.asyncContextImpl.getAsyncListenerEntryList();
        if (list != null) {
            if (this.asyncContextImpl.registerPostEventAsyncListeners()) {
                list = this.asyncContextImpl.getAsyncListenerEntryList();
            }
            for (AsyncListenerEntry entry : list) {
                entry.invokeOnComplete(elapsedTime);
            }
        }
    }
}

