/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class TransportURIResolver
extends ExtendedURIResolver {
    private static final Set<String> DEFAULT_URI_RESOLVER_HANDLES = new HashSet<String>();
    private static final Logger LOG = LogUtils.getL7dLogger(TransportURIResolver.class);
    protected Bus bus;
    static final long serialVersionUID = -2533474349570805568L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TransportURIResolver(Bus b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.TransportURIResolver", "<init>", new Object[]{b});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.TransportURIResolver", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputSource resolve(String curUri, String baseUri) throws ConnectException, SocketTimeoutException {
        URI base;
        InputSource is;
        block18: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.TransportURIResolver", "resolve", new Object[]{curUri, baseUri});
            }
            LOG.log(Level.FINE, "Enter resolve: curUri: " + curUri + " and baseUri: " + baseUri);
            curUri = curUri.replace(" ", "%20");
            is = null;
            try {
                if (baseUri == null) {
                    base = new URI(curUri);
                } else {
                    base = new URI(baseUri);
                    base = base.resolve(curUri);
                }
            }
            catch (URISyntaxException use) {
                LOG.log(Level.FINE, "Ignoring URISyntaxException: " + use);
                base = null;
            }
            try {
                if (base == null || DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme())) {
                    is = super.resolve(curUri, baseUri);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Ignoring Exception 1: " + ex);
            }
            if (is == null && base != null && base.getScheme() != null && !DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme())) {
                InputSource inputSource;
                block19: {
                    try {
                        ConduitInitiatorManager mgr = this.bus.getExtension(ConduitInitiatorManager.class);
                        ConduitInitiator ci = null;
                        if ("http".equals(base.getScheme()) || "https".equals(base.getScheme())) {
                            ci = mgr.getConduitInitiator("http://cxf.apache.org/transports/http");
                        }
                        if (ci == null) {
                            ci = mgr.getConduitInitiatorForUri(base.toString());
                        }
                        if (ci == null) break block18;
                        EndpointInfo info = new EndpointInfo();
                        info.setName(new QName("http://cxf.apache.org", "TransportURIResolver"));
                        info.setAddress(base.toString());
                        final Conduit c = ci.getConduit(info);
                        MessageImpl message = new MessageImpl();
                        ExchangeImpl exch = new ExchangeImpl();
                        message.setExchange(exch);
                        message.put("org.apache.cxf.request.method", "GET");
                        c.setMessageObserver(new MessageObserver(){
                            static final long serialVersionUID = -1710647116118351565L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public void onMessage(Message message) {
                                LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
                                try {
                                    IOUtils.copy(message.getContent(InputStream.class), bout);
                                    message.getExchange().put(InputStream.class, bout.createInputStream());
                                    c.close(message);
                                }
                                catch (IOException e) {
                                    LOG.log(Level.FINE, "Ignoring IOException: " + e);
                                }
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.TransportURIResolver$1", 1.class, null, null);
                            }
                        });
                        c.prepare(message);
                        c.close(message);
                        InputStream ins = exch.get(InputStream.class);
                        this.resourceOpened.addElement(ins);
                        InputSource src = new InputSource(ins);
                        String u = (String)message.get("http.retransmit.url");
                        if (u == null) {
                            u = base.toString();
                        }
                        src.setPublicId(u);
                        src.setSystemId(u);
                        this.lastestImportUri = u;
                        this.currentResolver.unresolve();
                        inputSource = src;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block19;
                    }
                    catch (ConnectException ce1) {
                        LOG.log(Level.FINE, "Throwing ConnectException: " + ce1);
                        throw ce1;
                    }
                    catch (SocketTimeoutException se1) {
                        LOG.log(Level.FINE, "Throwing SocketTimeoutException: " + se1);
                        throw se1;
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Ignoring Exception 2: " + e);
                    }
                    inputSource = inputSource;
                    LOG.exiting("org.apache.cxf.transport.TransportURIResolver", "resolve", inputSource);
                }
                return inputSource;
            }
        }
        if (!(is != null || base != null && base.getScheme() != null && DEFAULT_URI_RESOLVER_HANDLES.contains(base.getScheme()))) {
            is = super.resolve(curUri, baseUri);
        }
        InputSource inputSource = is;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inputSource = inputSource;
            LOG.exiting("org.apache.cxf.transport.TransportURIResolver", "resolve", inputSource);
        }
        return inputSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        DEFAULT_URI_RESOLVER_HANDLES.add("file");
        DEFAULT_URI_RESOLVER_HANDLES.add("classpath");
        DEFAULT_URI_RESOLVER_HANDLES.add("wsjar");
        DEFAULT_URI_RESOLVER_HANDLES.add("jar");
        DEFAULT_URI_RESOLVER_HANDLES.add("zip");
    }
}

